/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AdHocRouteWorkgroupRequest {
    private final String name;
    private final String namespaceCode;
    private final String action;

    public AdHocRouteWorkgroupRequest(@JsonProperty("name") final String name,
                                      @JsonProperty("namespaceCode") final String namespaceCode,
                                      @JsonProperty("action") final String action
    ) {
        Validate.isTrue(StringUtils.isNotBlank(name), "name must be supplied");
        Validate.isTrue(StringUtils.isNotBlank(namespaceCode), "namespaceCode must be supplied");
        Validate.isTrue(StringUtils.isNotBlank(action), "action must be supplied");
        this.name = name;
        this.namespaceCode = namespaceCode;
        this.action = action;
    }

    public String getName() {
        return name;
    }

    public String getNamespaceCode() {
        return namespaceCode;
    }

    public String getAction() {
        return action;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final AdHocRouteWorkgroupRequest that = (AdHocRouteWorkgroupRequest) o;
        return name.equals(that.name) && namespaceCode.equals(namespaceCode) && action.equals(that.action);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, namespaceCode, action);
    }
}
