/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentRequest {
    private final String description;
    private final String explanation;
    private final String orgDocNumber;
    private final AdHocRoutingRequest adHocRoutingRequest;

    public DocumentRequest(
            @JsonProperty("description") final String description,
            @JsonProperty("explanation") final String explanation,
            @JsonProperty("orgDocNumber") final String orgDocNumber,
            @JsonProperty("adHocRouting") final AdHocRoutingRequest adHocRoutingRequest
    ) {
        this.description = description;
        this.explanation = explanation;
        this.orgDocNumber = orgDocNumber;
        this.adHocRoutingRequest = adHocRoutingRequest;
    }

    public String getDescription() {
        return description;
    }

    public String getExplanation() {
        return explanation;
    }

    public String getOrgDocNumber() {
        return orgDocNumber;
    }

    public AdHocRoutingRequest getAdHocRoutingRequest() {
        return adHocRoutingRequest;
    }
}
