/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.dataaccess.impl;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.fp.businessobject.FiscalYearFunctionControl;
import org.kuali.kfs.fp.businessobject.FunctionControlCode;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.batch.dataaccess.BudgetConstructionHumanResourcesPayrollInterfaceDao;
import org.kuali.kfs.module.bc.batch.dataaccess.GenesisDao;
import org.kuali.kfs.module.bc.batch.dataaccess.impl.BudgetConstructionBatchHelperDaoOjb;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAdministrativePost;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.CalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.CalculatedSalaryFoundationTrackerOverride;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class GenesisDaoOjb
extends BudgetConstructionBatchHelperDaoOjb
implements GenesisDao {
    private FiscalYearFunctionControl fiscalYearFunctionControl;
    private FunctionControlCode functionControlCode;
    private static Logger LOG = Logger.getLogger(GenesisDaoOjb.class);
    public static final Long DEFAULT_VERSION_NUMBER = new Long(1L);
    public static final Integer MAXIMUM_ORGANIZATION_TREE_DEPTH = new Integer(1000);
    private DocumentService documentService;
    private WorkflowDocumentService workflowDocumentService;
    private DateTimeService dateTimeService;
    private DocumentDao documentDao;
    private KualiModuleService kualiModuleService;
    private BudgetConstructionHumanResourcesPayrollInterfaceDao budgetConstructionHumanResourcesPayrollInterfaceDao;
    protected HashSet<String> currentBCHeaderKeys = new HashSet(1);
    protected HashMap<String, String[]> CSFTrackerKeys = new HashMap(1);
    protected Long documentsToCreateinNTS = new Long(0L);
    protected Long documentsSkippedinNTS = new Long(0L);
    protected Long documentsCreatedinNTS = new Long(0L);
    protected Long documentsCSFCreatedinNTS = new Long(0L);
    protected Long documentsGLCreatedinNTS = new Long(0L);
    protected Long proxyCandidatesReadinTS = new Long(0L);
    protected Long proxyBCHeadersCreatedinTS = new Long(0L);
    protected HashMap<String, BudgetConstructionAccountReports> acctRptsToMap = new HashMap(1);
    protected HashMap<String, BudgetConstructionOrganizationReports> orgRptsToMap = new HashMap(1);
    protected HashMap<String, BudgetConstructionAccountOrganizationHierarchy> acctOrgHierMap = new HashMap(1);
    private BudgetConstructionHeader budgetConstructionHeader;
    protected String rootChart;
    protected String rootOrganization;
    protected Integer nHeadersBackToZero = 0;
    protected Integer nHeadersSwitchingLevels = 0;
    protected HashMap<String, PendingBudgetConstructionGeneralLedger> pBGLFromGL = new HashMap(1);
    protected HashMap<String, String> documentNumberFromBCHdr = new HashMap(1);
    protected HashMap<String, Integer> skippedPBGLKeys = new HashMap();
    protected Integer sqlChartOfAccountsCode = 0;
    protected Integer sqlAccountNumber = 1;
    protected Integer sqlSubAccountNumber = 2;
    protected Integer sqlObjectCode = 3;
    protected Integer sqlSubObjectCode = 4;
    protected Integer sqlBalanceTypeCode = 5;
    protected Integer sqlObjectTypeCode = 6;
    protected Integer sqlAccountLineAnnualBalanceAmount = 7;
    protected Integer sqlBeginningBalanceLineAmount = 8;
    protected Integer nGLHeadersAdded = new Integer(0);
    protected Integer nGLRowsAdded = new Integer(0);
    protected Integer nGLRowsUpdated = new Integer(0);
    protected Integer nCurrentPBGLRows = new Integer(0);
    protected Integer nGLBBRowsZeroNet = new Integer(0);
    protected Integer nGLBBRowsRead = new Integer(0);
    protected Integer nGLRowsMatchingPBGL = new Integer(0);
    protected Integer nGLBBKeysRead = new Integer(0);
    protected Integer nGLBBRowsSkipped = new Integer(0);
    protected HashMap<String, String[]> baseYearInactiveObjects = new HashMap(1);
    protected HashMap<String, String[]> gLBBObjects = new HashMap(1);
    protected Integer nInactiveBBObjectCodes = new Integer(0);
    protected HashMap<String, BudgetConstructionCalculatedSalaryFoundationTracker> bCSF = new HashMap(1);
    protected HashMap<String, String> bcHdrDocNumbers = new HashMap(1);
    protected HashSet<String> currentPBGLKeys = new HashSet(1);
    protected HashMap<String, String> detailedPositionObjectTypes = new HashMap(1);
    protected HashSet<String> csfOverrideKeys = new HashSet(1);
    protected HashMap<String, roundMechanism> keysNeedingRounding = new HashMap(1);
    protected HashMap<String, Integer> positionNormalWorkMonths = new HashMap(1);
    protected Integer CSFRowsRead = new Integer(0);
    protected Integer CSFRowsVacant = new Integer(0);
    protected Integer CSFVacantsConsolidated = new Integer(0);
    protected Integer CSFOverrideDeletesRead = new Integer(0);
    protected Integer CSFOverrideRead = new Integer(0);
    protected Integer CSFOverrideVacant = new Integer(0);
    protected Integer CSFForBCSF = new Integer(0);
    protected Integer CSFCurrentGLRows = new Integer(0);
    protected Integer CSFCurrentBCAFRows = new Integer(0);
    protected Integer CSFBCSFRowsMatchingGL = new Integer(0);
    protected Integer CSFBCSFRowsMatchingBCAF = new Integer(0);
    protected Integer CSFNewGLRows = new Integer(0);
    protected Integer CSFNewBCAFRows = new Integer(0);
    protected Integer CSFBCAFRowsMarkedDeleted = new Integer(0);
    protected Integer CSFBCAFRowsMissing = new Integer(0);
    protected Integer CSFBadObjectsSkipped = new Integer(0);
    protected String notOnLeave;
    protected KualiInteger rqstAmount;
    protected BigDecimal pctTime;
    protected BigDecimal FTE;
    protected static final MathContext compareContext = new MathContext(2, RoundingMode.HALF_UP);
    protected KualiDecimal shavePennies;

    public GenesisDaoOjb() {
        this.notOnLeave = new String(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode);
        this.rqstAmount = new KualiInteger(0L);
        this.pctTime = new BigDecimal(0);
        this.FTE = new BigDecimal(0);
        this.shavePennies = new KualiDecimal(100);
    }

    @Override
    public final Map<String, String> getBudgetConstructionControlFlags(Integer universityFiscalYear) {
        HashMap<String, String> controlFlags = new HashMap<String, String>();
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        String[] queryAttr = new String[]{"financialSystemFunctionControlCode", "financialSystemFunctionActiveIndicator"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(FiscalYearFunctionControl.class, queryAttr, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            String[] mapValues = (String[])((Object[])Results.next());
            controlFlags.put(mapValues[0], mapValues[1]);
        }
        return controlFlags;
    }

    @Override
    public boolean getBudgetConstructionControlFlag(Integer universityFiscalYear, String FlagID) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        criteriaID.addEqualTo("financialSystemFunctionControlCode", (Object)FlagID);
        String[] queryAttr = new String[]{"financialSystemFunctionActiveIndicator"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(FiscalYearFunctionControl.class, queryAttr, criteriaID, true);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        Boolean result = (Boolean)((Object[])Results.next())[0];
        return result;
    }

    @Override
    public Integer fiscalYearFromToday() {
        Integer currentFiscalYear = new Integer(0);
        Date lookUpDate = this.dateTimeService.getCurrentSqlDateMidnight();
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityDate", (Object)lookUpDate);
        String[] attrb = new String[]{"universityFiscalYear"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(UniversityDate.class, attrb, criteriaID);
        Iterator resultRow = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        if (resultRow.hasNext()) {
            currentFiscalYear = ((Number)((Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)resultRow))[0]).intValue();
        }
        LOG.debug((Object)String.format("\nreturned from fiscalYearFromToday: %d", currentFiscalYear));
        return currentFiscalYear;
    }

    @Override
    public void setControlFlagsAtTheStartOfGenesis(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        this.getPersistenceBrokerTemplate().clearCache();
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryID = new QueryByCriteria(FiscalYearFunctionControl.class, criteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryID);
        this.getPersistenceBrokerTemplate().clearCache();
        criteriaID = QueryByCriteria.CRITERIA_SELECT_ALL;
        String[] attrQ = new String[]{"financialSystemFunctionControlCode", "financialSystemFunctionDefaultIndicator"};
        ReportQueryByCriteria rptQueryID = new ReportQueryByCriteria(FunctionControlCode.class, attrQ, criteriaID);
        Integer sqlFunctionControlCode = 0;
        Integer sqlFunctionActiveIndicator = 1;
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rptQueryID);
        while (Results.hasNext()) {
            FiscalYearFunctionControl SLF = new FiscalYearFunctionControl();
            Object[] resultFields = (Object[])Results.next();
            String flagTag = (String)resultFields[sqlFunctionControlCode];
            boolean flagDefault = (Boolean)resultFields[sqlFunctionActiveIndicator];
            SLF.setUniversityFiscalYear(RequestYear);
            LOG.debug((Object)"\nfiscal year has been set");
            SLF.setFinancialSystemFunctionControlCode(flagTag);
            LOG.debug((Object)"\nfunction code has been set");
            SLF.setVersionNumber(DEFAULT_VERSION_NUMBER);
            LOG.debug((Object)String.format("\nversion number set to %d", SLF.getVersionNumber()));
            if (flagTag.equals("BCGENE")) {
                SLF.setFinancialSystemFunctionActiveIndicator(true);
            } else {
                SLF.setFinancialSystemFunctionActiveIndicator(flagDefault);
            }
            LOG.debug((Object)"\nabout to store the result");
            this.getPersistenceBrokerTemplate().store((Object)SLF);
        }
    }

    @Override
    public void setControlFlagsAtTheEndOfGenesis(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        this.resetExistingFlags(BaseYear, BCConstants.CURRENT_FSCL_YR_CTRL_FLAGS);
        this.resetExistingFlags(RequestYear, BCConstants.NEXT_FSCL_YR_CTRL_FLAGS_AFTER_GENESIS);
    }

    public void resetExistingFlags(Integer Year, HashMap<String, String> configValues) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)Year);
        QueryByCriteria queryID = new QueryByCriteria(FiscalYearFunctionControl.class, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            LOG.debug((Object)"\nbefore call to next() and cast");
            FiscalYearFunctionControl SLF = (FiscalYearFunctionControl)Results.next();
            LOG.debug((Object)"\nafter call to next()");
            String mapKey = SLF.getFinancialSystemFunctionControlCode();
            String newValue = configValues.get(mapKey);
            SLF.setFinancialSystemFunctionActiveIndicator(newValue.equals("Y"));
            LOG.debug((Object)"\nabout to store the result");
            this.getPersistenceBrokerTemplate().store((Object)SLF);
            LOG.debug((Object)"\nafter store");
        }
    }

    @Override
    public void clearDBForGenesis(Integer BaseYear) {
        this.clearBudgetConstructionAdministrativePost();
        this.clearBudgetConstructionIntendedIncumbent();
        this.clearBothYearsBCSF(BaseYear);
        this.clearBothYearsBudgetConstructionAppointmentFundingReason(BaseYear);
        this.clearBothYearsPendingApptFunding(BaseYear);
        this.clearBothYearsBCPosition(BaseYear);
        this.clearBothYearsPBGL(BaseYear);
        this.clearBothYearsHeaders(BaseYear);
    }

    protected void clearBudgetConstructionAdministrativePost() {
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionAdministrativePost.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBaseYearBudgetConstructionAppointmentFundingReason(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addColumnEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionAppointmentFundingReason.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBothYearsBudgetConstructionAppointmentFundingReason(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addBetween((Object)"universityFiscalYear", (Object)BaseYear, (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionAppointmentFundingReason.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBudgetConstructionAppointmentFundingReason() {
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionAppointmentFundingReason.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearRequestYearBudgetConstructionAppointmentFundingReason(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionAppointmentFundingReason.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBaseYearBCSF(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addColumnEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionCalculatedSalaryFoundationTracker.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBothYearsBCSF(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addBetween((Object)"universityFiscalYear", (Object)BaseYear, (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionCalculatedSalaryFoundationTracker.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBCSF() {
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionCalculatedSalaryFoundationTracker.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBudgetConstructionIntendedIncumbent() {
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionIntendedIncumbent.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBaseYearBCPosition(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addColumnEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionPosition.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBothYearsBCPosition(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addBetween((Object)"universityFiscalYear", (Object)BaseYear, (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionPosition.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBCPosition() {
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionPosition.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearRequestYearBCPosition(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionPosition.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearRequestYearBCSF(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionCalculatedSalaryFoundationTracker.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBaseYearHeaders(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionHeader.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBothYearsHeaders(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addBetween((Object)"universityFiscalYear", (Object)BaseYear, (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionHeader.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearHeaders() {
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionHeader.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBaseYearPBGL(Integer BaseYear) {
        Criteria mnCriteriaID = new Criteria();
        mnCriteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria mnQueryID = new QueryByCriteria(BudgetConstructionMonthly.class, mnCriteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)mnQueryID);
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria queryID = new QueryByCriteria(PendingBudgetConstructionGeneralLedger.class, criteriaID);
        LOG.debug((Object)String.format("delete PBGL started at %tT for %d", this.dateTimeService.getCurrentDate(), BaseYear));
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryID);
        LOG.debug((Object)String.format("delete PBGL ended at %tT", this.dateTimeService.getCurrentDate()));
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBothYearsPBGL(Integer BaseYear) {
        this.clearBaseYearPBGL(BaseYear);
        this.clearRequestYearPBGL(BaseYear);
    }

    protected void clearPBGL() {
        QueryByCriteria mnQueryId = new QueryByCriteria(BudgetConstructionMonthly.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)mnQueryId);
        QueryByCriteria queryId = new QueryByCriteria(PendingBudgetConstructionGeneralLedger.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearRequestYearPBGL(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria mnCriteriaID = new Criteria();
        mnCriteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria mnQueryID = new QueryByCriteria(BudgetConstructionMonthly.class, mnCriteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)mnQueryID);
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryID = new QueryByCriteria(PendingBudgetConstructionGeneralLedger.class, criteriaID);
        LOG.debug((Object)String.format("\ndelete PBGL started at %tT for %d", this.dateTimeService.getCurrentDate(), RequestYear));
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryID);
        LOG.debug((Object)String.format("\ndelete PBGL ended at %tT", this.dateTimeService.getCurrentDate()));
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBaseYearPendingApptFunding(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addColumnEqualTo("universityFiscalYear", (Object)BaseYear);
        QueryByCriteria queryId = new QueryByCriteria(PendingBudgetConstructionAppointmentFunding.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearBothYearsPendingApptFunding(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addBetween((Object)"universityFiscalYear", (Object)BaseYear, (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(PendingBudgetConstructionAppointmentFunding.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearPendingApptFunding() {
        QueryByCriteria queryId = new QueryByCriteria(PendingBudgetConstructionAppointmentFunding.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void clearRequestYearPendingApptFunding(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(PendingBudgetConstructionAppointmentFunding.class, criteriaId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void createNewDocumentsCleanUp() {
        this.currentBCHeaderKeys.clear();
        this.CSFTrackerKeys.clear();
    }

    @Override
    public void createNewBCDocumentsFromGLCSF(Integer BaseYear, boolean GLUpdatesAllowed, boolean CSFUpdatesAllowed) {
        if (!GLUpdatesAllowed && !CSFUpdatesAllowed) {
            return;
        }
        this.setUpCurrentBCHeaderKeys(BaseYear);
        Integer RequestYear = BaseYear + 1;
        this.getCurrentBCHeaderKeys(BaseYear);
        if (GLUpdatesAllowed) {
            this.getAndStoreCurrentGLBCHeaderCandidates(BaseYear);
        }
        if (CSFUpdatesAllowed) {
            this.setUpCSFHashStructures(BaseYear);
            this.getCSFCandidateDocumentKeys(BaseYear);
            this.getCSFOverrideDeletedKeys(BaseYear);
            this.getCSFOverrideCandidateDocumentKeys(BaseYear);
            this.getAndStoreCurrentCSFBCHeaderCandidates(BaseYear);
        }
        this.createNewDocumentsCleanUp();
    }

    protected void getAndStoreCurrentCSFBCHeaderCandidates(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        for (Map.Entry<String, String[]> newCSFDocs : this.CSFTrackerKeys.entrySet()) {
            BudgetConstructionDocument newBCHdr;
            this.proxyCandidatesReadinTS = this.proxyCandidatesReadinTS + 1L;
            String[] Results = newCSFDocs.getValue();
            try {
                newBCHdr = (BudgetConstructionDocument)this.documentService.getNewDocument("BC");
            }
            catch (WorkflowException wex) {
                LOG.warn((Object)String.format("\nskipping creation of document for CSF key: %s %s %s \n(%s)\n", Results[0], Results[1], Results[2], wex.getMessage()));
                wex.printStackTrace();
                this.documentsSkippedinNTS = this.documentsSkippedinNTS + 1L;
                continue;
            }
            newBCHdr.setUniversityFiscalYear(RequestYear);
            newBCHdr.setChartOfAccountsCode(Results[0]);
            newBCHdr.setAccountNumber(Results[1]);
            newBCHdr.setSubAccountNumber(Results[2]);
            try {
                this.storeANewBCDocument(newBCHdr);
            }
            catch (WorkflowException wex) {
                LOG.warn((Object)String.format("\nskipping creation of document for CSF key: %s %s %s \n(%s)\n", newBCHdr.getChartOfAccounts(), newBCHdr.getAccountNumber(), newBCHdr.getSubAccountNumber(), wex.getMessage()));
                wex.printStackTrace();
                this.documentsSkippedinNTS = this.documentsSkippedinNTS + 1L;
                continue;
            }
            this.documentsCSFCreatedinNTS = this.documentsCSFCreatedinNTS + 1L;
            this.documentsCreatedinNTS = this.documentsCreatedinNTS + 1L;
        }
    }

    protected void getAndStoreCurrentGLBCHeaderCandidates(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaId.addEqualTo("balanceTypeCode", (Object)"BB");
        String newAttr = "FIN_BEG_BAL_LN_AMT+ACLN_ANNL_BAL_AMT";
        criteriaId.addNotEqualTo((Object)newAttr, (Object)0);
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(Balance.class, queryAttr, criteriaId, true);
        Iterator RowsReturned = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryId);
        while (RowsReturned.hasNext()) {
            BudgetConstructionDocument newBCHdr;
            this.proxyCandidatesReadinTS = this.proxyCandidatesReadinTS + 1L;
            Object[] Results = (Object[])RowsReturned.next();
            String testKey = (String)Results[0] + (String)Results[1] + (String)Results[2];
            if (this.currentBCHeaderKeys.contains(testKey)) continue;
            try {
                newBCHdr = (BudgetConstructionDocument)this.documentService.getNewDocument("BC");
            }
            catch (WorkflowException wex) {
                LOG.warn((Object)String.format("\nskipping creation of document for GL key: %s %s %s \n(%s)\n", (String)Results[0], (String)Results[1], (String)Results[2], wex.getMessage()));
                wex.printStackTrace();
                this.documentsSkippedinNTS = this.documentsSkippedinNTS + 1L;
                continue;
            }
            newBCHdr.setUniversityFiscalYear(RequestYear);
            newBCHdr.setChartOfAccountsCode((String)Results[0]);
            newBCHdr.setAccountNumber((String)Results[1]);
            newBCHdr.setSubAccountNumber((String)Results[2]);
            try {
                this.storeANewBCDocument(newBCHdr);
            }
            catch (WorkflowException wex) {
                LOG.warn((Object)String.format("\nskipping creation of document for GL key: %s %s %s \n(%s)\n", newBCHdr.getChartOfAccounts(), newBCHdr.getAccountNumber(), newBCHdr.getSubAccountNumber(), wex.getMessage()));
                wex.printStackTrace();
                this.documentsSkippedinNTS = this.documentsSkippedinNTS + 1L;
                continue;
            }
            this.documentsGLCreatedinNTS = this.documentsGLCreatedinNTS + 1L;
            this.documentsCreatedinNTS = this.documentsCreatedinNTS + 1L;
            this.currentBCHeaderKeys.add(testKey);
        }
    }

    public void getCSFCandidateDocumentKeys(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaId.addEqualTo("csfDeleteCode", (Object)"-");
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(CalculatedSalaryFoundationTracker.class, queryAttr, criteriaId, true);
        Iterator rowsReturned = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryId);
        while (rowsReturned.hasNext()) {
            Object[] returnedRow = (Object[])rowsReturned.next();
            String testKey = (String)returnedRow[0] + (String)returnedRow[1] + (String)returnedRow[2];
            if (this.currentBCHeaderKeys.contains(testKey)) continue;
            String[] valueCSF = new String[]{(String)returnedRow[0], (String)returnedRow[1], (String)returnedRow[2]};
            this.CSFTrackerKeys.put(testKey, valueCSF);
        }
    }

    public void getCSFOverrideCandidateDocumentKeys(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaId.addEqualTo("csfDeleteCode", (Object)"-");
        criteriaId.addEqualTo("active", (Object)true);
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(CalculatedSalaryFoundationTrackerOverride.class, queryAttr, criteriaId, true);
        Iterator rowsReturned = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryId);
        while (rowsReturned.hasNext()) {
            Object[] returnedRow = (Object[])rowsReturned.next();
            String testKey = (String)returnedRow[0] + (String)returnedRow[1] + (String)returnedRow[2];
            if (this.currentBCHeaderKeys.contains(testKey)) continue;
            String[] valueCSF = new String[]{(String)returnedRow[0], (String)returnedRow[1], (String)returnedRow[2]};
            this.CSFTrackerKeys.put(testKey, valueCSF);
        }
    }

    public void getCSFOverrideDeletedKeys(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaId.addNotEqualTo((Object)"csfDeleteCode", (Object)"-");
        criteriaId.addEqualTo("active", (Object)true);
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(CalculatedSalaryFoundationTrackerOverride.class, queryAttr, criteriaId, true);
        Iterator rowsReturned = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryId);
        while (rowsReturned.hasNext()) {
            Object[] returnedRow = (Object[])rowsReturned.next();
            String testKey = (String)returnedRow[0] + (String)returnedRow[1] + (String)returnedRow[2];
            if (this.currentBCHeaderKeys.contains(testKey) || !this.CSFTrackerKeys.containsKey(testKey)) continue;
            this.CSFTrackerKeys.remove(testKey);
        }
    }

    protected void getCurrentBCHeaderKeys(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)RequestYear);
        String[] selectList = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(BudgetConstructionHeader.class, selectList, criteriaId);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryId);
        while (Results.hasNext()) {
            Object[] returnedRow = (Object[])Results.next();
            this.currentBCHeaderKeys.add((String)returnedRow[0] + (String)returnedRow[1] + (String)returnedRow[2]);
        }
    }

    public void setUpCSFHashStructures(Integer BaseYear) {
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaId.addEqualTo("csfDeleteCode", (Object)"-");
        String[] propertyString = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        this.CSFTrackerKeys = new HashMap(this.hashObjectSize(CalculatedSalaryFoundationTracker.class, criteriaId, propertyString));
    }

    public void setUpCurrentBCHeaderKeys(Integer BaseYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("balanceTypeCode", (Object)"BB");
        String[] propertyString = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber"};
        this.currentBCHeaderKeys = new HashSet(this.hashObjectSize(Balance.class, criteriaID, propertyString));
    }

    public void storeANewBCDocument(BudgetConstructionDocument newBCHdr) throws WorkflowException {
        newBCHdr.setOrganizationLevelChartOfAccountsCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_CHART_OF_ACCOUNTS_CODE);
        newBCHdr.setOrganizationLevelOrganizationCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_ORGANIZATION_CODE);
        newBCHdr.setOrganizationLevelCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_CODE);
        newBCHdr.setBudgetTransactionLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
        newBCHdr.setBudgetLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
        newBCHdr.setVersionNumber(DEFAULT_VERSION_NUMBER);
        FinancialSystemDocumentHeader kualiDocumentHeader = newBCHdr.getFinancialSystemDocumentHeader();
        newBCHdr.setDocumentNumber(newBCHdr.getDocumentHeader().getDocumentNumber());
        kualiDocumentHeader.setOrganizationDocumentNumber(newBCHdr.getUniversityFiscalYear().toString());
        kualiDocumentHeader.setFinancialDocumentStatusCode("?");
        kualiDocumentHeader.setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        kualiDocumentHeader.setDocumentDescription(String.format("%s %d %s %s", "Budget Construction", newBCHdr.getUniversityFiscalYear(), newBCHdr.getChartOfAccountsCode(), newBCHdr.getAccountNumber()));
        kualiDocumentHeader.setExplanation("Budget Construction");
        this.documentService.routeDocument((Document)newBCHdr, "created by Genesis", new ArrayList());
    }

    @Override
    public void createChartForNextBudgetCycle() {
        this.getPersistenceBrokerTemplate().clearCache();
        Criteria criteriaID = QueryByCriteria.CRITERIA_SELECT_ALL;
        QueryByCriteria killAcctQuery = new QueryByCriteria(BudgetConstructionAccountReports.class);
        killAcctQuery.setCriteria(criteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)killAcctQuery);
        QueryByCriteria killOrgQuery = new QueryByCriteria(BudgetConstructionOrganizationReports.class);
        killOrgQuery.setCriteria(criteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)killOrgQuery);
        this.getPersistenceBrokerTemplate().clearCache();
        this.buildNewOrganizationReportsTo();
        this.buildNewAccountReportsTo();
    }

    protected void buildNewAccountReportsTo() {
        Integer sqlChartOfAccountsCode = 0;
        Integer sqlAccountNumber = 1;
        Integer sqlReportsToChartofAccountsCode = 0;
        Integer sqlOrganizationCode = 2;
        Long accountsAdded = new Long(0L);
        Criteria criteriaID = new Criteria();
        criteriaID = QueryByCriteria.CRITERIA_SELECT_ALL;
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "organizationCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(Account.class, queryAttr, criteriaID, true);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            Object[] ReturnList = (Object[])Results.next();
            BudgetConstructionAccountReports acctRpts = new BudgetConstructionAccountReports();
            acctRpts.setChartOfAccountsCode((String)ReturnList[sqlChartOfAccountsCode]);
            acctRpts.setAccountNumber((String)ReturnList[sqlAccountNumber]);
            acctRpts.setReportsToChartOfAccountsCode((String)ReturnList[sqlReportsToChartofAccountsCode]);
            acctRpts.setReportsToOrganizationCode((String)ReturnList[sqlOrganizationCode]);
            acctRpts.setVersionNumber(DEFAULT_VERSION_NUMBER);
            this.getPersistenceBrokerTemplate().store((Object)acctRpts);
            accountsAdded = accountsAdded + 1L;
        }
        LOG.info((Object)String.format("\nAccount reporting lines added to budget construction %d", accountsAdded));
    }

    protected void buildNewOrganizationReportsTo() {
        Integer sqlChartOfAccountsCode = 0;
        Integer sqlOrganizationCode = 1;
        Integer sqlReportsToChartOfAccountsCode = 2;
        Integer sqlReportsToOrganizationCode = 3;
        Integer sqlResponsibilityCenterCode = 4;
        Long organizationsAdded = new Long(0L);
        Criteria criteriaID = new Criteria();
        criteriaID = QueryByCriteria.CRITERIA_SELECT_ALL;
        String[] queryAttr = new String[]{"chartOfAccountsCode", "organizationCode", "reportsToChartOfAccountsCode", "reportsToOrganizationCode", "responsibilityCenterCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(Organization.class, queryAttr, criteriaID, true);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            Object[] ReturnList = (Object[])Results.next();
            BudgetConstructionOrganizationReports orgRpts = new BudgetConstructionOrganizationReports();
            orgRpts.setChartOfAccountsCode((String)ReturnList[sqlChartOfAccountsCode]);
            orgRpts.setOrganizationCode((String)ReturnList[sqlOrganizationCode]);
            orgRpts.setReportsToChartOfAccountsCode((String)ReturnList[sqlReportsToChartOfAccountsCode]);
            orgRpts.setReportsToOrganizationCode((String)ReturnList[sqlReportsToOrganizationCode]);
            orgRpts.setResponsibilityCenterCode((String)ReturnList[sqlResponsibilityCenterCode]);
            orgRpts.setVersionNumber(DEFAULT_VERSION_NUMBER);
            this.getPersistenceBrokerTemplate().store((Object)orgRpts);
            organizationsAdded = organizationsAdded + 1L;
        }
        LOG.info((Object)String.format("\nOrganization reporting lines added to budget construction %d", organizationsAdded));
    }

    protected void organizationHierarchyCleanUp() {
        this.acctRptsToMap.clear();
        this.orgRptsToMap.clear();
        this.acctOrgHierMap.clear();
    }

    @Override
    public void rebuildOrganizationHierarchy(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        this.getPersistenceBrokerTemplate().clearCache();
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria killOrgHierQuery = new QueryByCriteria(BudgetConstructionAccountOrganizationHierarchy.class, criteriaID);
        killOrgHierQuery.setCriteria(criteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)killOrgHierQuery);
        this.getPersistenceBrokerTemplate().clearCache();
        String[] rootNode = ((OrganizationService)SpringContext.getBean(OrganizationService.class)).getRootOrganizationCode();
        this.rootChart = rootNode[0];
        this.rootOrganization = rootNode[1];
        this.readAcctReportsTo();
        this.readOrgReportsTo();
        criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        this.acctOrgHierMap = new HashMap(this.hashObjectSize(BudgetConstructionAccountOrganizationHierarchy.class, criteriaID) * BCConstants.AVERAGE_REPORTING_TREE_SIZE);
        QueryByCriteria queryID = new QueryByCriteria(BudgetConstructionHeader.class, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            BudgetConstructionHeader extantBCHdr = (BudgetConstructionHeader)((Object)Results.next());
            this.buildAcctOrgHierFromAcctRpts(this.acctRptsToMap.get(this.getAcctRptsToKeyFromBCHdr(extantBCHdr)), RequestYear);
            this.updateBudgetConstructionHeaderAsNeeded(extantBCHdr);
        }
        this.organizationHierarchyCleanUp();
    }

    @Override
    public Map verifyAccountsAreAccessible(Integer requestFiscalYear) {
        HashMap<String, String[]> returnMap = new HashMap<String, String[]>();
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)requestFiscalYear);
        String[] selectList = new String[]{"chartOfAccountsCode", "accountNumber", "budgetConstructionAccountReports.reportsToOrganizationCode"};
        ReportQueryByCriteria missingBCAccounts = new ReportQueryByCriteria(BudgetConstructionHeader.class, criteriaId);
        missingBCAccounts.setAttributes(selectList);
        missingBCAccounts.setPathOuterJoin("budgetConstructionAccountReports");
        Iterator returnedRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)missingBCAccounts);
        while (returnedRows.hasNext()) {
            Object[] returnedFields = (Object[])returnedRows.next();
            if (returnedFields[2] != null) continue;
            String chart = (String)returnedFields[0];
            String account = (String)returnedFields[1];
            String[] chartAccount = new String[]{chart, account};
            returnMap.put(chart + account, chartAccount);
        }
        return returnMap;
    }

    protected void buildAcctOrgHierFromAcctRpts(BudgetConstructionAccountReports acctRpts, Integer RequestYear) {
        String orgKey;
        if (acctRpts == null) {
            return;
        }
        String inKey = this.getOrgHierarchyKeyFromAcctRpts(acctRpts);
        if (this.acctOrgHierMap.get(inKey) != null) {
            return;
        }
        Integer orgLevel = 1;
        BudgetConstructionAccountOrganizationHierarchy acctOrgHier = new BudgetConstructionAccountOrganizationHierarchy();
        acctOrgHier.setUniversityFiscalYear(RequestYear);
        acctOrgHier.setChartOfAccountsCode(acctRpts.getChartOfAccountsCode());
        acctOrgHier.setAccountNumber(acctRpts.getAccountNumber());
        acctOrgHier.setOrganizationLevelCode(orgLevel);
        acctOrgHier.setVersionNumber(DEFAULT_VERSION_NUMBER);
        acctOrgHier.setOrganizationChartOfAccountsCode(acctRpts.getReportsToChartOfAccountsCode());
        acctOrgHier.setOrganizationCode(acctRpts.getReportsToOrganizationCode());
        this.getPersistenceBrokerTemplate().store((Object)acctOrgHier);
        String mapKey = this.getOrgHierarchyKey(acctOrgHier);
        this.acctOrgHierMap.put(mapKey, acctOrgHier);
        while (orgLevel < MAXIMUM_ORGANIZATION_TREE_DEPTH && !this.noNewMapEntryNeeded(this.orgRptsToMap.get(orgKey = this.getOrgRptsToKeyFromAcctOrgHier(acctOrgHier)))) {
            orgLevel = orgLevel + 1;
            BudgetConstructionOrganizationReports orgRpts = this.orgRptsToMap.get(orgKey);
            acctOrgHier = new BudgetConstructionAccountOrganizationHierarchy();
            acctOrgHier.setUniversityFiscalYear(RequestYear);
            acctOrgHier.setChartOfAccountsCode(acctRpts.getChartOfAccountsCode());
            acctOrgHier.setAccountNumber(acctRpts.getAccountNumber());
            acctOrgHier.setOrganizationLevelCode(orgLevel);
            acctOrgHier.setVersionNumber(DEFAULT_VERSION_NUMBER);
            acctOrgHier.setOrganizationChartOfAccountsCode(orgRpts.getReportsToChartOfAccountsCode());
            acctOrgHier.setOrganizationCode(orgRpts.getReportsToOrganizationCode());
            this.getPersistenceBrokerTemplate().store((Object)acctOrgHier);
            mapKey = this.getOrgHierarchyKey(acctOrgHier);
            this.acctOrgHierMap.put(mapKey, acctOrgHier);
        }
        if (orgLevel >= MAXIMUM_ORGANIZATION_TREE_DEPTH) {
            LOG.warn((Object)String.format("\n%s/%s reports to more than %d organizations", acctRpts.getChartOfAccountsCode(), acctRpts.getAccountNumber(), MAXIMUM_ORGANIZATION_TREE_DEPTH));
        }
    }

    protected String getAcctRptsToKey(BudgetConstructionAccountReports acctRpts) {
        String TestKey = new String();
        TestKey = acctRpts.getChartOfAccountsCode() + acctRpts.getAccountNumber();
        return TestKey;
    }

    protected String getAcctRptsToKeyFromBCHdr(BudgetConstructionHeader bCHdr) {
        String TestKey = new String();
        TestKey = bCHdr.getChartOfAccountsCode() + bCHdr.getAccountNumber();
        return TestKey;
    }

    protected String getOrgHierarchyKey(BudgetConstructionAccountOrganizationHierarchy orgHier) {
        String TestKey = new String();
        TestKey = orgHier.getChartOfAccountsCode() + orgHier.getAccountNumber() + orgHier.getOrganizationChartOfAccountsCode() + orgHier.getOrganizationCode();
        return TestKey;
    }

    protected String getOrgHierarchyKeyFromAcctRpts(BudgetConstructionAccountReports acctRpts) {
        String TestKey = new String();
        TestKey = acctRpts.getChartOfAccountsCode() + acctRpts.getAccountNumber() + acctRpts.getReportsToChartOfAccountsCode() + acctRpts.getReportsToOrganizationCode();
        return TestKey;
    }

    protected String getOrgHierarchyKeyFromBCHeader(BudgetConstructionHeader bCHdr) {
        String TestKey = new String();
        TestKey = bCHdr.getChartOfAccountsCode() + bCHdr.getAccountNumber() + bCHdr.getOrganizationLevelChartOfAccountsCode() + bCHdr.getOrganizationLevelOrganizationCode();
        return TestKey;
    }

    protected String getOrgRptsToKey(BudgetConstructionOrganizationReports orgRpts) {
        String TestKey = new String();
        TestKey = orgRpts.getChartOfAccountsCode() + orgRpts.getOrganizationCode();
        return TestKey;
    }

    protected String getOrgRptsToKeyFromAcctOrgHier(BudgetConstructionAccountOrganizationHierarchy acctOrgHier) {
        String TestKey = new String();
        TestKey = acctOrgHier.getOrganizationChartOfAccountsCode() + acctOrgHier.getOrganizationCode();
        return TestKey;
    }

    protected boolean noNewMapEntryNeeded(BudgetConstructionOrganizationReports orgRpts) {
        String thisChart = orgRpts.getChartOfAccountsCode();
        String thisOrg = orgRpts.getOrganizationCode();
        if (thisChart.compareTo(this.rootChart) == 0 && thisOrg.compareTo(this.rootOrganization) == 0) {
            return true;
        }
        String rptsToChart = orgRpts.getReportsToChartOfAccountsCode();
        if (rptsToChart.length() == 0) {
            LOG.warn((Object)String.format("\n(%s, %s) reports to a null chart", thisChart, thisOrg));
            return true;
        }
        String rptsToOrg = orgRpts.getReportsToOrganizationCode();
        if (rptsToOrg.length() == 0) {
            LOG.warn((Object)String.format("\n(%s, %s) reports to a null organization", thisChart, thisOrg));
            return true;
        }
        if (thisChart.compareTo(rptsToChart) == 0 && thisOrg.compareTo(rptsToOrg) == 0) {
            LOG.warn((Object)String.format("\n(%s,%s) reports to itself and is not the root", thisChart, thisOrg));
            return true;
        }
        return false;
    }

    protected void readAcctReportsTo() {
        Integer sqlChartOfAccountsCode = 0;
        Integer sqlAccountNumber = 1;
        Integer sqlReportsToChartofAccountsCode = 2;
        Integer sqlOrganizationCode = 3;
        Criteria criteriaID = ReportQueryByCriteria.CRITERIA_SELECT_ALL;
        this.acctRptsToMap = new HashMap(this.hashObjectSize(BudgetConstructionAccountReports.class, criteriaID));
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "reportsToChartOfAccountsCode", "reportsToOrganizationCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(BudgetConstructionAccountReports.class, queryAttr, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            Object[] ReturnList = (Object[])Results.next();
            BudgetConstructionAccountReports acctRpts = new BudgetConstructionAccountReports();
            acctRpts.setChartOfAccountsCode((String)ReturnList[sqlChartOfAccountsCode]);
            acctRpts.setAccountNumber((String)ReturnList[sqlAccountNumber]);
            acctRpts.setReportsToChartOfAccountsCode((String)ReturnList[sqlReportsToChartofAccountsCode]);
            acctRpts.setReportsToOrganizationCode((String)ReturnList[sqlOrganizationCode]);
            String TestKey = this.getAcctRptsToKey(acctRpts);
            this.acctRptsToMap.put(TestKey, acctRpts);
        }
        LOG.info((Object)"\nAccount Reports To for Organization Hierarchy:");
        LOG.info((Object)String.format("\nNumber of account-reports-to rows: %d", this.acctRptsToMap.size()));
    }

    protected void readOrgReportsTo() {
        Integer sqlChartOfAccountsCode = 0;
        Integer sqlOrganizationCode = 1;
        Integer sqlReportsToChartofAccountsCode = 2;
        Integer sqlReportsToOrganizationCode = 3;
        Criteria criteriaID = ReportQueryByCriteria.CRITERIA_SELECT_ALL;
        this.orgRptsToMap = new HashMap(this.hashObjectSize(BudgetConstructionOrganizationReports.class, criteriaID));
        String[] queryAttr = new String[]{"chartOfAccountsCode", "organizationCode", "reportsToChartOfAccountsCode", "reportsToOrganizationCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(BudgetConstructionOrganizationReports.class, queryAttr, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            Object[] ReturnList = (Object[])Results.next();
            BudgetConstructionOrganizationReports orgRpts = new BudgetConstructionOrganizationReports();
            orgRpts.setChartOfAccountsCode((String)ReturnList[sqlChartOfAccountsCode]);
            orgRpts.setOrganizationCode((String)ReturnList[sqlOrganizationCode]);
            orgRpts.setReportsToChartOfAccountsCode((String)ReturnList[sqlReportsToChartofAccountsCode]);
            orgRpts.setReportsToOrganizationCode((String)ReturnList[sqlReportsToOrganizationCode]);
            String TestKey = this.getOrgRptsToKey(orgRpts);
            this.orgRptsToMap.put(TestKey, orgRpts);
        }
        LOG.info((Object)"\nOrganization Reports To for Organization Hierarchy:");
        LOG.info((Object)String.format("\nNumber of organization-reports-to rows: %d", this.orgRptsToMap.size()));
    }

    protected void updateBudgetConstructionHeaderAsNeeded(BudgetConstructionHeader bCHdr) {
        Integer levelFromHeader;
        if (bCHdr.getOrganizationLevelCode().equals(BCConstants.INITIAL_ORGANIZATION_LEVEL_CODE)) {
            return;
        }
        String mapKey = this.getOrgHierarchyKeyFromBCHeader(bCHdr);
        BudgetConstructionAccountOrganizationHierarchy acctOrgHier = this.acctOrgHierMap.get(mapKey);
        if (acctOrgHier == null) {
            this.nHeadersBackToZero = this.nHeadersBackToZero + 1;
            bCHdr.setOrganizationLevelChartOfAccountsCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_CHART_OF_ACCOUNTS_CODE);
            bCHdr.setOrganizationLevelOrganizationCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_ORGANIZATION_CODE);
            bCHdr.setOrganizationLevelCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_CODE);
            this.getPersistenceBrokerTemplate().store((Object)bCHdr);
            return;
        }
        Integer levelFromHierarchy = acctOrgHier.getOrganizationLevelCode();
        if (!levelFromHierarchy.equals(levelFromHeader = bCHdr.getOrganizationLevelCode())) {
            bCHdr.setOrganizationLevelCode(levelFromHierarchy);
            this.getPersistenceBrokerTemplate().store((Object)bCHdr);
            this.nHeadersSwitchingLevels = this.nHeadersSwitchingLevels + 1;
        }
    }

    protected void pBGLCleanUp() {
        this.pBGLFromGL.clear();
        this.documentNumberFromBCHdr.clear();
    }

    @Override
    public void clearHangingBCLocks(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        Criteria lockID = new Criteria();
        Criteria tranLockID = new Criteria();
        if (BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS == null) {
            lockID.addNotNull("budgetLockUserIdentifier");
            tranLockID.addNotNull("budgetTransactionLockUserIdentifier");
        } else {
            lockID.addNotEqualTo((Object)"budgetLockUserIdentifier", (Object)BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
            tranLockID.addNotEqualTo((Object)"budgetTransactionLockUserIdentifier", (Object)BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
        }
        lockID.addOrCriteria(tranLockID);
        criteriaID.addAndCriteria(lockID);
        QueryByCriteria queryID = new QueryByCriteria(BudgetConstructionHeader.class, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            BudgetConstructionHeader lockedDocuments = (BudgetConstructionHeader)((Object)Results.next());
            lockedDocuments.setBudgetLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
            lockedDocuments.setBudgetTransactionLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
            this.getPersistenceBrokerTemplate().store((Object)lockedDocuments);
        }
        this.clearHangingPositionLocks(RequestYear);
        QueryByCriteria queryId = new QueryByCriteria(BudgetConstructionFundingLock.class, QueryByCriteria.CRITERIA_SELECT_ALL);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryId);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    @Override
    public void initialLoadToPBGL(Integer BaseYear) {
        this.readBCHeaderForDocNumber(BaseYear);
        this.readGLForPBGL(BaseYear, true);
        this.addNewGLRowsToPBGL(BaseYear);
        this.writeFinalDiagnosticCounts();
        this.pBGLCleanUp();
    }

    @Override
    public void updateToPBGL(Integer BaseYear) {
        this.readBCHeaderForDocNumber(BaseYear);
        this.readGLForPBGL(BaseYear, false);
        this.updateCurrentPBGL(BaseYear);
        this.addNewGLRowsToPBGL(BaseYear);
        this.writeFinalDiagnosticCounts();
        this.pBGLCleanUp();
    }

    protected void clearHangingPositionLocks(Integer RequestYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        Criteria lockID = new Criteria();
        if (BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS == null) {
            lockID.addNotNull("positionLockUserIdentifier");
        } else {
            lockID.addNotEqualTo((Object)"positionLockUserIdentifier", (Object)BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
        }
        criteriaID.addAndCriteria(lockID);
        QueryByCriteria queryID = new QueryByCriteria(BudgetConstructionPosition.class, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            BudgetConstructionPosition lockedPositions = (BudgetConstructionPosition)Results.next();
            lockedPositions.setPositionLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
            this.getPersistenceBrokerTemplate().store((Object)lockedPositions);
        }
    }

    protected void info() {
        block2: {
            Object toPrint;
            if (!LOG.isEnabledFor((Priority)Level.INFO)) {
                return;
            }
            Iterator<Map.Entry<String, Object>> iterator = this.documentNumberFromBCHdr.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> bcHeaderRows = iterator.next();
                toPrint = bcHeaderRows.getValue();
                LOG.info((Object)String.format("\n\nA sample document number %s\n", toPrint));
            }
            if (!(iterator = this.pBGLFromGL.entrySet().iterator()).hasNext()) break block2;
            Map.Entry<String, Object> pBGLRows = iterator.next();
            toPrint = (PendingBudgetConstructionGeneralLedger)((Object)pBGLRows.getValue());
            LOG.info((Object)"\n\nA sample PBGL row\n");
            LOG.info((Object)String.format("\nDocument Number = %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getDocumentNumber()));
            LOG.info((Object)String.format("\nUniversity Fiscal Year = %d", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getUniversityFiscalYear()));
            LOG.info((Object)String.format("\nChart: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getChartOfAccountsCode()));
            LOG.info((Object)String.format("\nAccount: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getAccountNumber()));
            LOG.info((Object)String.format("\nSub Account: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getSubAccountNumber()));
            LOG.info((Object)String.format("\nObject Code: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialObjectCode()));
            LOG.info((Object)String.format("\nSubobject Code: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialSubObjectCode()));
            LOG.info((Object)String.format("\nBalance Type: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialBalanceTypeCode()));
            LOG.info((Object)String.format("\nObject Type: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialObjectTypeCode()));
            LOG.info((Object)String.format("\nBase Amount: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialBeginningBalanceLineAmount().toString()));
            LOG.info((Object)String.format("\nRequest Amount: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getAccountLineAnnualBalanceAmount().toString()));
            LOG.info((Object)String.format("\nVersion Number: %d", toPrint.getVersionNumber()));
        }
    }

    protected void debug() {
        block2: {
            Object toPrint;
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) {
                return;
            }
            Iterator<Map.Entry<String, Object>> iterator = this.documentNumberFromBCHdr.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> bcHeaderRows = iterator.next();
                toPrint = bcHeaderRows.getValue();
                LOG.debug((Object)String.format("\n\nA sample document number %s\n", toPrint));
            }
            if (!(iterator = this.pBGLFromGL.entrySet().iterator()).hasNext()) break block2;
            Map.Entry<String, Object> pBGLRows = iterator.next();
            toPrint = (PendingBudgetConstructionGeneralLedger)((Object)pBGLRows.getValue());
            LOG.debug((Object)"\n\nA sample PBGL row\n");
            LOG.debug((Object)String.format("\nDocument Number = %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getDocumentNumber()));
            LOG.debug((Object)String.format("\nUniversity Fiscal Year = %d", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getUniversityFiscalYear()));
            LOG.debug((Object)String.format("\nChart: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getChartOfAccountsCode()));
            LOG.debug((Object)String.format("\nAccount: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getAccountNumber()));
            LOG.debug((Object)String.format("\nSub Account: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getSubAccountNumber()));
            LOG.debug((Object)String.format("\nObject Code: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialObjectCode()));
            LOG.debug((Object)String.format("\nSubobject Code: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialSubObjectCode()));
            LOG.debug((Object)String.format("\nBalance Type: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialBalanceTypeCode()));
            LOG.debug((Object)String.format("\nObject Type: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialObjectTypeCode()));
            LOG.debug((Object)String.format("\nBase Amount: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getFinancialBeginningBalanceLineAmount().toString()));
            LOG.debug((Object)String.format("\nRequest Amount: %s", ((PendingBudgetConstructionGeneralLedger)((Object)toPrint)).getAccountLineAnnualBalanceAmount().toString()));
            LOG.debug((Object)String.format("\nVersion Number: %d", toPrint.getVersionNumber()));
        }
    }

    protected void addNewGLRowsToPBGL(Integer BaseYear) {
        for (Map.Entry<String, PendingBudgetConstructionGeneralLedger> newPBGLRows : this.pBGLFromGL.entrySet()) {
            PendingBudgetConstructionGeneralLedger rowToAdd = newPBGLRows.getValue();
            if (rowToAdd.getFinancialBeginningBalanceLineAmount().isZero()) {
                this.nGLBBRowsZeroNet = this.nGLBBRowsZeroNet + 1;
                continue;
            }
            this.nGLRowsAdded = this.nGLRowsAdded + 1;
            this.getPersistenceBrokerTemplate().store((Object)rowToAdd);
        }
    }

    protected String buildGLTestKeyFromPBGL(PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger) {
        String PBGLTestKey = new String();
        PBGLTestKey = pendingBudgetConstructionGeneralLedger.getChartOfAccountsCode() + pendingBudgetConstructionGeneralLedger.getAccountNumber() + pendingBudgetConstructionGeneralLedger.getSubAccountNumber() + pendingBudgetConstructionGeneralLedger.getFinancialObjectCode() + pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode() + pendingBudgetConstructionGeneralLedger.getFinancialBalanceTypeCode() + pendingBudgetConstructionGeneralLedger.getFinancialObjectTypeCode();
        return PBGLTestKey;
    }

    protected String buildGLTestKeyFromSQLResults(Object[] sqlResult) {
        String GLTestKey = new String();
        GLTestKey = (String)sqlResult[this.sqlChartOfAccountsCode] + (String)sqlResult[this.sqlAccountNumber] + (String)sqlResult[this.sqlSubAccountNumber] + (String)sqlResult[this.sqlObjectCode] + (String)sqlResult[this.sqlSubObjectCode] + (String)sqlResult[this.sqlBalanceTypeCode] + (String)sqlResult[this.sqlObjectTypeCode];
        return GLTestKey;
    }

    public String buildHeaderTestKeyFromPBGL(PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger) {
        String headerBCTestKey = new String();
        headerBCTestKey = pendingBudgetConstructionGeneralLedger.getChartOfAccountsCode() + pendingBudgetConstructionGeneralLedger.getAccountNumber() + pendingBudgetConstructionGeneralLedger.getSubAccountNumber();
        return headerBCTestKey;
    }

    protected String buildHeaderTestKeyFromSQLResults(Object[] sqlResult) {
        String headerBCTestKey = new String();
        headerBCTestKey = (String)sqlResult[this.sqlChartOfAccountsCode] + (String)sqlResult[this.sqlAccountNumber] + (String)sqlResult[this.sqlSubAccountNumber];
        return headerBCTestKey;
    }

    protected PendingBudgetConstructionGeneralLedger newPBGLBusinessObject(Integer RequestYear, Object[] sqlResult) {
        PendingBudgetConstructionGeneralLedger PBGLObj = new PendingBudgetConstructionGeneralLedger();
        PBGLObj.setUniversityFiscalYear(RequestYear);
        PBGLObj.setChartOfAccountsCode((String)sqlResult[this.sqlChartOfAccountsCode]);
        PBGLObj.setAccountNumber((String)sqlResult[this.sqlAccountNumber]);
        PBGLObj.setSubAccountNumber((String)sqlResult[this.sqlSubAccountNumber]);
        PBGLObj.setFinancialObjectCode((String)sqlResult[this.sqlObjectCode]);
        PBGLObj.setFinancialSubObjectCode((String)sqlResult[this.sqlSubObjectCode]);
        PBGLObj.setFinancialBalanceTypeCode((String)sqlResult[this.sqlBalanceTypeCode]);
        PBGLObj.setFinancialObjectTypeCode((String)sqlResult[this.sqlObjectTypeCode]);
        KualiDecimal BaseAmount = (KualiDecimal)sqlResult[this.sqlBeginningBalanceLineAmount];
        BaseAmount = (KualiDecimal)BaseAmount.add((AbstractKualiDecimal)((KualiDecimal)sqlResult[this.sqlAccountLineAnnualBalanceAmount]));
        KualiInteger DollarBaseAmount = new KualiInteger(BaseAmount.bigDecimalValue());
        PBGLObj.setFinancialBeginningBalanceLineAmount(DollarBaseAmount);
        PBGLObj.setAccountLineAnnualBalanceAmount(KualiInteger.ZERO);
        PBGLObj.setVersionNumber(DEFAULT_VERSION_NUMBER);
        return PBGLObj;
    }

    protected void readBCHeaderForDocNumber(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Long documentsRead = new Long(0L);
        Criteria criteriaId = new Criteria();
        criteriaId.addEqualTo("universityFiscalYear", (Object)RequestYear);
        this.documentNumberFromBCHdr = new HashMap(this.hashObjectSize(BudgetConstructionHeader.class, criteriaId));
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber", "documentNumber"};
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(BudgetConstructionHeader.class, queryAttr, criteriaId);
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryId);
        while (Results.hasNext()) {
            Object[] rowReturned = (Object[])Results.next();
            String hashKey = (String)rowReturned[0] + (String)rowReturned[1] + (String)rowReturned[2];
            this.documentNumberFromBCHdr.put(hashKey, (String)rowReturned[3]);
            documentsRead = documentsRead + 1L;
        }
        LOG.info((Object)String.format("\nBC Headers read = %d", documentsRead));
    }

    protected void readGLForPBGL(Integer BaseYear, boolean excludeZeroNetAmounts) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("balanceTypeCode", (Object)"BB");
        this.pBGLFromGL = new HashMap(this.hashObjectSize(Balance.class, criteriaID));
        String[] queryAttr = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber", "objectCode", "subObjectCode", "balanceTypeCode", "objectTypeCode", "accountLineAnnualBalanceAmount", "beginningBalanceLineAmount"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(Balance.class, queryAttr, criteriaID, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\nGL Query started: " + String.format("%tT", this.dateTimeService.getCurrentDate())));
        }
        Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\nGL Query finished: " + String.format("%tT", this.dateTimeService.getCurrentDate())));
        }
        while (Results.hasNext()) {
            Object[] ReturnList = (Object[])Results.next();
            LOG.debug((Object)String.format("\nfields returned = %d\n", ReturnList.length));
            LOG.debug((Object)String.format("\nvalue in last field = %s\n", ReturnList[this.sqlBeginningBalanceLineAmount].toString()));
            KualiDecimal BaseAmount = (KualiDecimal)ReturnList[this.sqlBeginningBalanceLineAmount];
            BaseAmount = (KualiDecimal)BaseAmount.add((AbstractKualiDecimal)((KualiDecimal)ReturnList[this.sqlAccountLineAnnualBalanceAmount]));
            String HeaderTestKey = this.buildHeaderTestKeyFromSQLResults(ReturnList);
            String documentNumberForKey = this.documentNumberFromBCHdr.get(HeaderTestKey);
            if (documentNumberForKey == null) {
                if (BaseAmount.isZero()) {
                    this.nGLBBRowsRead = this.nGLBBRowsRead + 1;
                    this.nGLBBRowsZeroNet = this.nGLBBRowsZeroNet + 1;
                    continue;
                }
                this.recordSkippedKeys(HeaderTestKey);
                continue;
            }
            if (excludeZeroNetAmounts && BaseAmount.isZero()) {
                this.nGLBBRowsRead = this.nGLBBRowsRead + 1;
                this.nGLBBRowsZeroNet = this.nGLBBRowsZeroNet + 1;
                continue;
            }
            String GLTestKey = this.buildGLTestKeyFromSQLResults(ReturnList);
            this.pBGLFromGL.put(GLTestKey, this.newPBGLBusinessObject(RequestYear, ReturnList));
            this.pBGLFromGL.get(GLTestKey).setDocumentNumber(documentNumberForKey);
        }
        LOG.info((Object)("\nHash maps built: " + String.format("%tT", this.dateTimeService.getCurrentDate())));
        this.info();
        this.nGLBBKeysRead = this.documentNumberFromBCHdr.size();
        this.nGLBBRowsRead = this.pBGLFromGL.size() + this.nGLBBRowsRead;
    }

    protected void recordSkippedKeys(String badGLKey) {
        this.nGLBBRowsSkipped = this.nGLBBRowsSkipped + 1;
        if (this.skippedPBGLKeys.get(badGLKey) == null) {
            this.skippedPBGLKeys.put(badGLKey, new Integer(1));
        } else {
            Integer rowCount = this.skippedPBGLKeys.get(badGLKey) + 1;
            this.skippedPBGLKeys.put(badGLKey, rowCount);
        }
    }

    protected void updateBaseBudgetAmount(PendingBudgetConstructionGeneralLedger currentPBGLInstance) {
        String TestKey = this.buildGLTestKeyFromPBGL(currentPBGLInstance);
        if (!this.pBGLFromGL.containsKey(TestKey)) {
            return;
        }
        PendingBudgetConstructionGeneralLedger matchFromGL = this.pBGLFromGL.get(TestKey);
        KualiInteger baseFromCurrentGL = matchFromGL.getFinancialBeginningBalanceLineAmount();
        KualiInteger baseFromPBGL = currentPBGLInstance.getFinancialBeginningBalanceLineAmount();
        this.pBGLFromGL.remove(TestKey);
        if (baseFromCurrentGL.equals((Object)baseFromPBGL)) {
            this.nGLRowsMatchingPBGL = this.nGLRowsMatchingPBGL + 1;
            return;
        }
        this.nGLRowsUpdated = this.nGLRowsUpdated + 1;
        currentPBGLInstance.setFinancialBeginningBalanceLineAmount(baseFromCurrentGL);
        this.getPersistenceBrokerTemplate().store((Object)currentPBGLInstance);
    }

    protected void updateCurrentPBGL(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryID = new QueryByCriteria(PendingBudgetConstructionGeneralLedger.class, criteriaID);
        Iterator Results = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (Results.hasNext()) {
            this.nCurrentPBGLRows = this.nCurrentPBGLRows + 1;
            PendingBudgetConstructionGeneralLedger currentPBGLInstance = (PendingBudgetConstructionGeneralLedger)((Object)Results.next());
            this.updateBaseBudgetAmount(currentPBGLInstance);
        }
    }

    protected void writeFinalDiagnosticCounts() {
        LOG.info((Object)String.format("\n\nGeneral Ledger Run Statistics\n\n", new Object[0]));
        LOG.info((Object)String.format("\nGeneral Ledger BB Keys read: %d", this.nGLBBKeysRead));
        LOG.info((Object)String.format("\nGeneral Ledger BB Rows read: %d", this.nGLBBRowsRead));
        LOG.info((Object)String.format("\nExisting Pending General Ledger rows: %d", this.nCurrentPBGLRows));
        LOG.info((Object)String.format("\nof these...", new Object[0]));
        LOG.info((Object)String.format("\nnew PBGL rows written: %d", this.nGLRowsAdded));
        LOG.info((Object)String.format("\ncurrent PBGL amounts updated: %d", this.nGLRowsUpdated));
        LOG.info((Object)String.format("\ncurrent PBGL rows already matching a GL row: %d", this.nGLRowsMatchingPBGL));
        LOG.info((Object)String.format("\nGL rows with zero net amounts (skipped) %d\n", this.nGLBBRowsZeroNet));
        LOG.info((Object)String.format("\nGL account/subaccount keys skipped: %d", this.nGLBBRowsSkipped));
        if (!this.skippedPBGLKeys.isEmpty()) {
            for (Map.Entry<String, Integer> skippedRows : this.skippedPBGLKeys.entrySet()) {
                LOG.info((Object)String.format("\nGL key %s with %d rows skipped--no document header", skippedRows.getKey(), skippedRows.getValue()));
            }
        }
        LOG.info((Object)String.format("\n\nend of General Ledger run statics", new Object[0]));
    }

    protected void objectClassRICleanUp() {
        this.baseYearInactiveObjects.clear();
        this.gLBBObjects.clear();
    }

    @Override
    public void ensureObjectClassRIForBudget(Integer BaseYear) {
        this.readBaseYearInactiveObjects(BaseYear);
        if (this.baseYearInactiveObjects.isEmpty()) {
            LOG.info((Object)String.format("\nInactive Object Codes in BC GL: %d", this.nInactiveBBObjectCodes));
            return;
        }
        this.readAndFilterGLBBObjects(BaseYear);
        if (this.gLBBObjects.isEmpty()) {
            LOG.info((Object)String.format("\nInactive Object Codes in BC GL: %d", this.nInactiveBBObjectCodes));
            return;
        }
        this.addRIObjectClassesForBB(BaseYear);
        LOG.info((Object)String.format("\nInactive Object Codes in BC GL: %d", this.nInactiveBBObjectCodes));
        this.objectClassRICleanUp();
    }

    protected void addRIObjectClassesForBB(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        for (Map.Entry<String, String[]> problemObjectCodes : this.gLBBObjects.entrySet()) {
            String problemObject;
            String problemChart = problemObjectCodes.getValue()[0];
            if (this.isObjectInRequestYear(BaseYear, problemChart, problemObject = problemObjectCodes.getValue()[1])) continue;
            Criteria criteriaID = new Criteria();
            criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
            criteriaID.addColumnEqualTo("chartOfAccountsCode", (Object)problemChart);
            criteriaID.addEqualTo("financialObjectCode", (Object)problemObject);
            ReportQueryByCriteria queryID = new ReportQueryByCriteria(ObjectCode.class, criteriaID);
            Iterator Results = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
            if (!Results.hasNext()) {
                LOG.warn((Object)String.format("could not find BB object (%s, %s) in %d", problemChart, problemObject, BaseYear));
                continue;
            }
            ObjectCode baseYearObject = (ObjectCode)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)Results);
            baseYearObject.setUniversityFiscalYear(RequestYear);
            baseYearObject.setActive(false);
            this.getPersistenceBrokerTemplate().store((Object)baseYearObject);
        }
    }

    protected boolean isObjectInRequestYear(Integer BaseYear, String Chart2, String ObjectCode2) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        criteriaID.addEqualTo("chartOfAccountsCode", (Object)Chart2);
        criteriaID.addEqualTo("financialObjectCode", (Object)ObjectCode2);
        QueryByCriteria queryID = new QueryByCriteria(ObjectCode.class, criteriaID);
        Integer result = this.getPersistenceBrokerTemplate().getCount((Query)queryID);
        return !result.equals(0);
    }

    protected void readBaseYearInactiveObjects(Integer BaseYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("active", (Object)false);
        this.baseYearInactiveObjects = new HashMap(this.hashObjectSize(ObjectCode.class, criteriaID));
        String[] queryAttr = new String[]{"chartOfAccountsCode", "financialObjectCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(ObjectCode.class, queryAttr, criteriaID);
        Iterator result = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (result.hasNext()) {
            Object[] resultRow = (Object[])result.next();
            String[] hashMapValue = new String[]{(String)resultRow[0], (String)resultRow[1]};
            String hashMapKey = hashMapValue[0] + hashMapValue[1];
            this.baseYearInactiveObjects.put(hashMapKey, hashMapValue);
        }
    }

    protected void readAndFilterGLBBObjects(Integer BaseYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("balanceTypeCode", (Object)"BB");
        this.gLBBObjects = new HashMap(this.hashObjectSize(Balance.class, criteriaID));
        String[] queryAttr = new String[]{"chartOfAccountsCode", "objectCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(Balance.class, queryAttr, criteriaID, true);
        Iterator result = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (result.hasNext()) {
            Object[] resultRow = (Object[])result.next();
            String[] hashMapValue = new String[]{(String)resultRow[0], (String)resultRow[1]};
            String hashMapKey = hashMapValue[0] + hashMapValue[1];
            if (this.baseYearInactiveObjects.get(hashMapKey) == null) continue;
            this.gLBBObjects.put(hashMapKey, hashMapValue);
            this.nInactiveBBObjectCodes = this.nInactiveBBObjectCodes + 1;
        }
    }

    protected void buildAppointmentFundingCleanUp() {
        this.bCSF.clear();
        this.bcHdrDocNumbers.clear();
        this.currentPBGLKeys.clear();
        this.detailedPositionObjectTypes.clear();
        this.csfOverrideKeys.clear();
        this.keysNeedingRounding.clear();
        this.positionNormalWorkMonths.clear();
    }

    @Override
    public void buildAppointmentFundingAndBCSF(Integer BaseYear) {
        this.clearBCCSF(BaseYear);
        this.clearBCCSF(BaseYear + 1);
        this.setUpCSFOverrideKeys(BaseYear);
        this.setUpBCSFMap(BaseYear);
        this.setUpKeysNeedingRounding(BaseYear);
        this.readCSFOverride(BaseYear);
        this.readCSF(BaseYear);
        this.CSFForBCSF = this.bCSF.size();
        this.adjustCSFRounding();
        this.readExistingAppointmentFunding(BaseYear);
        if (this.bCSF.size() == 0) {
            this.CSFDiagnostics();
            this.buildAppointmentFundingCleanUp();
            return;
        }
        this.setUpbcHdrDocNumbers(BaseYear);
        this.setUpCurrentPBGLKeys(BaseYear);
        this.setUpPositionNormalWorkMonths(BaseYear);
        this.readAndWriteBCSFAndNewAppointmentFundingAndNewPBGL(BaseYear);
        this.CSFDiagnostics();
        this.buildAppointmentFundingCleanUp();
    }

    protected void addToExistingBCSFVacant(CalculatedSalaryFoundationTrackerOverride csf, String csfKey) {
        BudgetConstructionCalculatedSalaryFoundationTracker nowBCSF = this.bCSF.get(csfKey);
        KualiInteger roundedAmount = new KualiInteger(csf.getCsfAmount(), RoundingMode.valueOf(4));
        nowBCSF.setCsfAmount(nowBCSF.getCsfAmount().add(roundedAmount));
        BigDecimal pctTime = nowBCSF.getCsfTimePercent();
        pctTime = pctTime.add(csf.getCsfTimePercent());
        if ((double)pctTime.floatValue() > 100.0) {
            pctTime = new BigDecimal(100.0);
        }
        nowBCSF.setCsfTimePercent(pctTime);
        BigDecimal csfFTE = nowBCSF.getCsfFullTimeEmploymentQuantity();
        csfFTE = csfFTE.add(csf.getCsfFullTimeEmploymentQuantity());
        if ((double)csfFTE.floatValue() > 1.0) {
            csfFTE = new BigDecimal(1.0);
        }
        nowBCSF.setCsfFullTimeEmploymentQuantity(csfFTE);
        this.CSFVacantsConsolidated = this.CSFVacantsConsolidated + 1;
    }

    protected void addToExistingBCSFVacant(CalculatedSalaryFoundationTracker csf, String csfKey) {
        BudgetConstructionCalculatedSalaryFoundationTracker nowBCSF = this.bCSF.get(csfKey);
        KualiInteger roundedAmount = new KualiInteger(csf.getCsfAmount(), RoundingMode.valueOf(4));
        nowBCSF.setCsfAmount(nowBCSF.getCsfAmount().add(roundedAmount));
        BigDecimal pctTime = nowBCSF.getCsfTimePercent();
        pctTime = pctTime.add(csf.getCsfTimePercent());
        if ((double)pctTime.floatValue() > 100.0) {
            pctTime = new BigDecimal(100.0);
        }
        nowBCSF.setCsfTimePercent(pctTime);
        BigDecimal csfFTE = nowBCSF.getCsfFullTimeEmploymentQuantity();
        csfFTE = csfFTE.add(csf.getCsfFullTimeEmploymentQuantity());
        if ((double)csfFTE.floatValue() > 1.0) {
            csfFTE = new BigDecimal(1.0);
        }
        nowBCSF.setCsfFullTimeEmploymentQuantity(csfFTE);
        this.CSFVacantsConsolidated = this.CSFVacantsConsolidated + 1;
    }

    protected void adjustCSFRounding() {
        for (Map.Entry<String, roundMechanism> roundMap : this.keysNeedingRounding.entrySet()) {
            roundMechanism rx = roundMap.getValue();
            rx.fixRoundErrors();
        }
        this.keysNeedingRounding.clear();
    }

    protected void buildAndStoreBCSFfromCSF(CalculatedSalaryFoundationTrackerOverride csf, String csfKey) {
        boolean vacantLine = this.isVacantLine(csf);
        BudgetConstructionCalculatedSalaryFoundationTracker csfBC = new BudgetConstructionCalculatedSalaryFoundationTracker();
        csfBC.setUniversityFiscalYear(csf.getUniversityFiscalYear() + 1);
        csfBC.setChartOfAccountsCode(csf.getChartOfAccountsCode());
        csfBC.setAccountNumber(csf.getAccountNumber());
        csfBC.setSubAccountNumber(csf.getSubAccountNumber());
        csfBC.setFinancialObjectCode(csf.getFinancialObjectCode());
        csfBC.setFinancialSubObjectCode(csf.getFinancialSubObjectCode());
        csfBC.setPositionNumber(csf.getPositionNumber());
        csfBC.setEmplid(vacantLine ? "VACANT" : csf.getEmplid());
        csfBC.setCsfFullTimeEmploymentQuantity(csf.getCsfFullTimeEmploymentQuantity());
        csfBC.setCsfTimePercent(csf.getCsfTimePercent());
        csfBC.setCsfFundingStatusCode(csf.getCsfFundingStatusCode());
        if (!vacantLine) {
            this.bCSF.put(csfKey, csfBC);
            roundMechanism rX = this.keysNeedingRounding.get(csf.getEmplid());
            rX.addNewBCSF(csfBC, csf.getCsfAmount());
        } else {
            csfBC.setCsfAmount(new KualiInteger(csf.getCsfAmount(), RoundingMode.valueOf(4)));
            this.bCSF.put(csfKey, csfBC);
        }
    }

    protected void buildAndStoreBCSFfromCSF(CalculatedSalaryFoundationTracker csf, String csfKey) {
        boolean vacantLine = this.isVacantLine(csf);
        BudgetConstructionCalculatedSalaryFoundationTracker csfBC = new BudgetConstructionCalculatedSalaryFoundationTracker();
        csfBC.setUniversityFiscalYear(csf.getUniversityFiscalYear() + 1);
        csfBC.setChartOfAccountsCode(csf.getChartOfAccountsCode());
        csfBC.setAccountNumber(csf.getAccountNumber());
        csfBC.setSubAccountNumber(csf.getSubAccountNumber());
        csfBC.setFinancialObjectCode(csf.getFinancialObjectCode());
        csfBC.setFinancialSubObjectCode(csf.getFinancialSubObjectCode());
        csfBC.setPositionNumber(csf.getPositionNumber());
        csfBC.setEmplid(vacantLine ? "VACANT" : csf.getEmplid());
        csfBC.setCsfFullTimeEmploymentQuantity(csf.getCsfFullTimeEmploymentQuantity());
        csfBC.setCsfTimePercent(csf.getCsfTimePercent());
        csfBC.setCsfFundingStatusCode(csf.getCsfFundingStatusCode());
        if (!vacantLine) {
            this.bCSF.put(csfKey, csfBC);
            roundMechanism rX = this.keysNeedingRounding.get(csf.getEmplid());
            rX.addNewBCSF(csfBC, csf.getCsfAmount());
        } else {
            csfBC.setCsfAmount(new KualiInteger(csf.getCsfAmount(), RoundingMode.valueOf(4)));
            this.bCSF.put(csfKey, csfBC);
        }
    }

    protected void buildAppointemntFundingFromBCSF(BudgetConstructionCalculatedSalaryFoundationTracker bcsf) {
        String positionNumber = bcsf.getPositionNumber();
        Integer normalWorkMonths = this.positionNormalWorkMonths.containsKey(positionNumber) ? this.positionNormalWorkMonths.get(positionNumber) : Integer.valueOf(12);
        KualiInteger defaultAmount = KualiInteger.ZERO;
        BigDecimal defaultFractions = new BigDecimal(0);
        PendingBudgetConstructionAppointmentFunding bcaf = new PendingBudgetConstructionAppointmentFunding();
        bcaf.setUniversityFiscalYear(bcsf.getUniversityFiscalYear());
        bcaf.setChartOfAccountsCode(bcsf.getChartOfAccountsCode());
        bcaf.setAccountNumber(bcsf.getAccountNumber());
        bcaf.setSubAccountNumber(bcsf.getSubAccountNumber());
        bcaf.setFinancialObjectCode(bcsf.getFinancialObjectCode());
        bcaf.setFinancialSubObjectCode(bcsf.getFinancialSubObjectCode());
        bcaf.setEmplid(bcsf.getEmplid());
        bcaf.setPositionNumber(positionNumber);
        bcaf.setAppointmentRequestedFteQuantity(bcsf.getCsfFullTimeEmploymentQuantity());
        bcaf.setAppointmentRequestedTimePercent(bcsf.getCsfTimePercent());
        bcaf.setAppointmentFundingDurationCode(this.notOnLeave);
        bcaf.setAppointmentRequestedCsfAmount(defaultAmount);
        bcaf.setAppointmentRequestedCsfFteQuantity(defaultFractions);
        bcaf.setAppointmentRequestedCsfTimePercent(defaultFractions);
        bcaf.setAppointmentTotalIntendedAmount(defaultAmount);
        bcaf.setAppointmentTotalIntendedFteQuantity(defaultFractions);
        bcaf.setAppointmentRequestedAmount(this.rqstAmount);
        bcaf.setAppointmentRequestedPayRate(defaultFractions);
        bcaf.setAppointmentFundingMonth(normalWorkMonths);
        bcaf.setAppointmentFundingDeleteIndicator(false);
        bcaf.setPositionObjectChangeIndicator(false);
        bcaf.setPositionSalaryChangeIndicator(false);
        this.getPersistenceBrokerTemplate().store((Object)bcaf);
        this.getPersistenceBrokerTemplate().store((Object)bcsf);
    }

    protected String buildAppointmentFundingKey(PendingBudgetConstructionAppointmentFunding bcaf) {
        return bcaf.getEmplid() + bcaf.getPositionNumber() + bcaf.getAccountNumber() + bcaf.getChartOfAccountsCode() + bcaf.getSubAccountNumber() + bcaf.getFinancialObjectCode() + bcaf.getFinancialSubObjectCode();
    }

    protected String buildCSFKey(CalculatedSalaryFoundationTrackerOverride csf) {
        return csf.getEmplid() + csf.getPositionNumber() + csf.getAccountNumber() + csf.getChartOfAccountsCode() + csf.getSubAccountNumber() + csf.getFinancialObjectCode() + csf.getFinancialSubObjectCode();
    }

    protected String buildCSFKey(CalculatedSalaryFoundationTracker csf) {
        return csf.getEmplid() + csf.getPositionNumber() + csf.getAccountNumber() + csf.getChartOfAccountsCode() + csf.getSubAccountNumber() + csf.getFinancialObjectCode() + csf.getFinancialSubObjectCode();
    }

    protected String buildDocKeyFromBCSF(BudgetConstructionCalculatedSalaryFoundationTracker bcsf) {
        return bcsf.getChartOfAccountsCode() + bcsf.getAccountNumber() + bcsf.getSubAccountNumber();
    }

    protected boolean buildPBGLFromBCSFAndStore(BudgetConstructionCalculatedSalaryFoundationTracker bcsf) {
        String testKey = this.buildPBGLKey(bcsf);
        if (this.currentPBGLKeys.contains(testKey)) {
            return true;
        }
        String objectType = this.detailedPositionObjectTypes.get(bcsf.getChartOfAccountsCode() + bcsf.getFinancialObjectCode());
        if (objectType == null) {
            LOG.warn((Object)String.format("\nthis row has an object class which does not support detailed positions (skipped):\nposition: %s, EMPLID: %s, accounting string =(%s,%s,%s,%s,%s", bcsf.getPositionNumber(), bcsf.getEmplid(), bcsf.getChartOfAccountsCode(), bcsf.getAccountNumber(), bcsf.getSubAccountNumber(), bcsf.getFinancialObjectCode(), bcsf.getFinancialSubObjectCode()));
            this.CSFBadObjectsSkipped = this.CSFBadObjectsSkipped + 1;
            return false;
        }
        this.currentPBGLKeys.add(testKey);
        String docKey = this.buildDocKeyFromBCSF(bcsf);
        PendingBudgetConstructionGeneralLedger pbGL = new PendingBudgetConstructionGeneralLedger();
        pbGL.setDocumentNumber(this.bcHdrDocNumbers.get(docKey));
        pbGL.setUniversityFiscalYear(bcsf.getUniversityFiscalYear());
        pbGL.setChartOfAccountsCode(bcsf.getChartOfAccountsCode());
        pbGL.setAccountNumber(bcsf.getAccountNumber());
        pbGL.setSubAccountNumber(bcsf.getSubAccountNumber());
        pbGL.setFinancialObjectCode(bcsf.getFinancialObjectCode());
        pbGL.setFinancialSubObjectCode(bcsf.getFinancialSubObjectCode());
        pbGL.setFinancialBalanceTypeCode("BB");
        pbGL.setFinancialObjectTypeCode(objectType);
        pbGL.setAccountLineAnnualBalanceAmount(KualiInteger.ZERO);
        pbGL.setFinancialBeginningBalanceLineAmount(KualiInteger.ZERO);
        this.getPersistenceBrokerTemplate().store((Object)pbGL);
        this.CSFNewGLRows = this.CSFNewGLRows + 1;
        return true;
    }

    protected String buildPBGLKey(BudgetConstructionCalculatedSalaryFoundationTracker bcsf) {
        return bcsf.getAccountNumber() + bcsf.getFinancialObjectCode() + bcsf.getChartOfAccountsCode() + bcsf.getSubAccountNumber() + bcsf.getFinancialSubObjectCode();
    }

    protected String buildPBGLKey(PendingBudgetConstructionGeneralLedger pbgl) {
        return pbgl.getAccountNumber() + pbgl.getFinancialObjectCode() + pbgl.getChartOfAccountsCode() + pbgl.getSubAccountNumber() + pbgl.getFinancialSubObjectCode();
    }

    protected String buildVacantCSFKey(CalculatedSalaryFoundationTrackerOverride csf) {
        boolean vacantLine = this.isVacantLine(csf);
        return (vacantLine ? "VACANT" : csf.getEmplid()) + csf.getPositionNumber() + csf.getAccountNumber() + csf.getChartOfAccountsCode() + csf.getSubAccountNumber() + csf.getFinancialObjectCode() + csf.getFinancialSubObjectCode();
    }

    protected String buildVacantCSFKey(CalculatedSalaryFoundationTracker csf) {
        boolean vacantLine = this.isVacantLine(csf);
        return (vacantLine ? "VACANT" : csf.getEmplid()) + csf.getPositionNumber() + csf.getAccountNumber() + csf.getChartOfAccountsCode() + csf.getSubAccountNumber() + csf.getFinancialObjectCode() + csf.getFinancialSubObjectCode();
    }

    protected void clearBCCSF(Integer FiscalYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)FiscalYear);
        QueryByCriteria queryID = new QueryByCriteria(BudgetConstructionCalculatedSalaryFoundationTracker.class, criteriaID);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)queryID);
        this.getPersistenceBrokerTemplate().clearCache();
    }

    protected void CSFDiagnostics() {
        LOG.info((Object)String.format("\n\nResults of building BC CSF", new Object[0]));
        LOG.info((Object)String.format("\nCSF override active rows %d", this.CSFOverrideRead));
        LOG.info((Object)String.format("\nCSF override deletes     %d", this.CSFOverrideDeletesRead));
        LOG.info((Object)String.format("\nCSF rows read            %d", this.CSFRowsRead));
        LOG.info((Object)String.format("\n\nCSF overrides vacant    %d", this.CSFOverrideVacant));
        LOG.info((Object)String.format("\nCSF vacant               %d", this.CSFRowsVacant));
        LOG.info((Object)String.format("\nCSF vacants consolidated %d", this.CSFVacantsConsolidated));
        LOG.info((Object)String.format("\n\nBudgetConstruction CSF rows %d", this.CSFForBCSF));
        LOG.info((Object)String.format("\n\nCurrent PBGL rows with position object classes %d", this.CSFCurrentGLRows));
        LOG.info((Object)String.format("\nNew PBGL rows created from CSF %d", this.CSFNewGLRows));
        LOG.info((Object)String.format("\nCSF rows skipped: bad obj code %d", this.CSFBadObjectsSkipped));
        LOG.info((Object)String.format("\n\nCurrent appt funding rows      %d", this.CSFCurrentBCAFRows));
        LOG.info((Object)String.format("\nNew appt funding rows from CSF   %d", this.CSFNewBCAFRows));
        LOG.info((Object)String.format("\nAppt funding rows not in BCSF    %d", this.CSFBCAFRowsMissing));
        LOG.info((Object)String.format("\nAppt funding rows marked deleted %d", this.CSFBCAFRowsMarkedDeleted));
        LOG.info((Object)String.format("\n\nend of BC CSF build statistics", new Object[0]));
    }

    protected ArrayList<String> findPositionRequiredObjectCodes(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        ArrayList<String> objectCodesWithIndividualPositions = new ArrayList<String>(10);
        HashMap<String, Constable> laborObjectCodeMap = new HashMap<String, Constable>();
        laborObjectCodeMap.put("universityFiscalYear", RequestYear);
        laborObjectCodeMap.put("detailPositionRequiredIndicator", Boolean.valueOf(true));
        laborObjectCodeMap.put("active", Boolean.valueOf(true));
        List laborLedgerObjects = this.kualiModuleService.getResponsibleModuleService(LaborLedgerObject.class).getExternalizableBusinessObjectsList(LaborLedgerObject.class, laborObjectCodeMap);
        for (LaborLedgerObject laborObject : laborLedgerObjects) {
            objectCodesWithIndividualPositions.add(laborObject.getFinancialObjectCode());
        }
        return objectCodesWithIndividualPositions;
    }

    protected boolean isVacantLine(CalculatedSalaryFoundationTracker csf) {
        return csf.getCsfFundingStatusCode().equals(BCConstants.csfFundingStatusFlag.VACANT.getFlagValue()) || csf.getCsfFundingStatusCode().equals(BCConstants.csfFundingStatusFlag.UNFUNDED.getFlagValue());
    }

    protected boolean isVacantLine(CalculatedSalaryFoundationTrackerOverride csf) {
        return csf.getCsfFundingStatusCode().equals(BCConstants.csfFundingStatusFlag.VACANT.getFlagValue()) || csf.getCsfFundingStatusCode().equals(BCConstants.csfFundingStatusFlag.UNFUNDED.getFlagValue());
    }

    protected void readAndWriteBCSFAndNewAppointmentFundingAndNewPBGL(Integer BaseYear) {
        this.CSFNewBCAFRows = this.bCSF.size();
        for (Map.Entry<String, BudgetConstructionCalculatedSalaryFoundationTracker> orphanBCSF : this.bCSF.entrySet()) {
            BudgetConstructionCalculatedSalaryFoundationTracker bcsf = orphanBCSF.getValue();
            if (!this.buildPBGLFromBCSFAndStore(bcsf)) continue;
            this.buildAppointemntFundingFromBCSF(bcsf);
        }
    }

    protected void readCSF(Integer BaseYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("csfDeleteCode", (Object)"-");
        QueryByCriteria queryID = new QueryByCriteria(CalculatedSalaryFoundationTracker.class, criteriaID);
        Iterator csfResultSet = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (csfResultSet.hasNext()) {
            CalculatedSalaryFoundationTracker csfRow = (CalculatedSalaryFoundationTracker)((Object)csfResultSet.next());
            this.CSFRowsRead = this.CSFRowsRead + 1;
            this.CSFRowsVacant = this.CSFRowsVacant + (this.isVacantLine(csfRow) ? 1 : 0);
            String testKey = this.buildCSFKey(csfRow);
            if (this.csfOverrideKeys.contains(testKey)) continue;
            testKey = this.buildVacantCSFKey(csfRow);
            if (this.isVacantLine(csfRow) && this.bCSF.containsKey(testKey)) {
                this.addToExistingBCSFVacant(csfRow, testKey);
                continue;
            }
            this.buildAndStoreBCSFfromCSF(csfRow, testKey);
        }
        this.csfOverrideKeys.clear();
    }

    protected void readCSFOverride(Integer BaseYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("csfDeleteCode", (Object)"-");
        criteriaID.addEqualTo("active", (Object)true);
        QueryByCriteria queryID = new QueryByCriteria(CalculatedSalaryFoundationTrackerOverride.class, criteriaID);
        Iterator csfResultSet = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (csfResultSet.hasNext()) {
            CalculatedSalaryFoundationTrackerOverride csfRow = (CalculatedSalaryFoundationTrackerOverride)((Object)csfResultSet.next());
            this.CSFOverrideRead = this.CSFOverrideRead + 1;
            this.CSFOverrideVacant = this.CSFOverrideVacant + (this.isVacantLine(csfRow) ? 1 : 0);
            String testKey = this.buildVacantCSFKey(csfRow);
            if (this.isVacantLine(csfRow) && this.bCSF.containsKey(testKey)) {
                this.addToExistingBCSFVacant(csfRow, testKey);
                continue;
            }
            this.buildAndStoreBCSFfromCSF(csfRow, testKey);
        }
    }

    protected void readExistingAppointmentFunding(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        QueryByCriteria queryID = new QueryByCriteria(PendingBudgetConstructionAppointmentFunding.class, criteriaID);
        Iterator bcafResults = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (bcafResults.hasNext()) {
            this.CSFCurrentBCAFRows = this.CSFCurrentBCAFRows + 1;
            PendingBudgetConstructionAppointmentFunding bcaf = (PendingBudgetConstructionAppointmentFunding)((Object)bcafResults.next());
            String testKey = this.buildAppointmentFundingKey(bcaf);
            if (this.bCSF.containsKey(testKey)) {
                BudgetConstructionCalculatedSalaryFoundationTracker bCSFRow = this.bCSF.get(testKey);
                this.getPersistenceBrokerTemplate().store((Object)bCSFRow);
                this.bCSF.remove(testKey);
                continue;
            }
            this.untouchedAppointmentFunding(bcaf);
        }
    }

    protected void setUpBCSFMap(Integer BaseYear) {
        Integer bCSFSize = new Integer(0);
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("csfDeleteCode", (Object)"-");
        criteriaID.addEqualTo("active", (Object)true);
        Criteria criteriaIDCSF = new Criteria();
        criteriaIDCSF.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaIDCSF.addEqualTo("csfDeleteCode", (Object)"-");
        bCSFSize = this.hashObjectSize(CalculatedSalaryFoundationTrackerOverride.class, criteriaID) + this.hashObjectSize(CalculatedSalaryFoundationTracker.class, criteriaIDCSF);
        this.bCSF = new HashMap(bCSFSize);
    }

    protected void setUpbcHdrDocNumbers(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        this.bcHdrDocNumbers = new HashMap(this.hashObjectSize(BudgetConstructionHeader.class, criteriaID));
        String[] headerList = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber", "documentNumber"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(BudgetConstructionHeader.class, headerList, criteriaID);
        Iterator headerRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (headerRows.hasNext()) {
            Object[] headerRow = (Object[])headerRows.next();
            String testKey = (String)headerRow[0] + (String)headerRow[1] + (String)headerRow[2];
            this.bcHdrDocNumbers.put(testKey, (String)headerRow[3]);
        }
    }

    protected void setUpCSFOverrideKeys(Integer BaseYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("active", (Object)true);
        Criteria deleteCriteria = new Criteria();
        deleteCriteria.addNotEqualTo((Object)"csfDeleteCode", (Object)"-");
        Criteria vacantCriteria = new Criteria();
        vacantCriteria.addEqualTo("csfFundingStatusCode", (Object)BCConstants.csfFundingStatusFlag.VACANT.getFlagValue());
        deleteCriteria.addOrCriteria(vacantCriteria);
        criteriaID.addAndCriteria(deleteCriteria);
        this.csfOverrideKeys = new HashSet(this.hashObjectSize(CalculatedSalaryFoundationTrackerOverride.class, criteriaID));
        QueryByCriteria qry = new QueryByCriteria(CalculatedSalaryFoundationTrackerOverride.class, criteriaID);
        Iterator csfOvrd = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)qry);
        while (csfOvrd.hasNext()) {
            CalculatedSalaryFoundationTrackerOverride csfOvrdRow = (CalculatedSalaryFoundationTrackerOverride)((Object)csfOvrd.next());
            this.csfOverrideKeys.add(this.buildCSFKey(csfOvrdRow));
            this.CSFOverrideDeletesRead = this.CSFOverrideDeletesRead + (csfOvrdRow.getCsfDeleteCode().equals("-") ? 0 : 1);
        }
    }

    protected void setUpCurrentPBGLKeys(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        criteriaID.addIn("financialObjectCode", this.findPositionRequiredObjectCodes(BaseYear));
        this.currentPBGLKeys = new HashSet(this.hashObjectSize(PendingBudgetConstructionGeneralLedger.class, criteriaID));
        this.detailedPositionObjectTypes = new HashMap(this.hashObjectSize(ObjectCode.class, criteriaID));
        int counter = 0;
        QueryByCriteria pbGLQuery = new QueryByCriteria(PendingBudgetConstructionGeneralLedger.class, criteriaID);
        Iterator pbGLObjects = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)pbGLQuery);
        while (pbGLObjects.hasNext()) {
            PendingBudgetConstructionGeneralLedger pbGLRow = (PendingBudgetConstructionGeneralLedger)((Object)pbGLObjects.next());
            String testKey = this.buildPBGLKey(pbGLRow);
            this.currentPBGLKeys.add(testKey);
            ++counter;
        }
        this.CSFCurrentGLRows = new Integer(counter);
        String[] objectTypeSelectList = new String[]{"chartOfAccountsCode", "financialObjectCode", "financialObjectTypeCode"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(ObjectCode.class, objectTypeSelectList, criteriaID);
        Iterator objectTypeRowReturned = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (objectTypeRowReturned.hasNext()) {
            Object[] objectRow = (Object[])objectTypeRowReturned.next();
            String keyString = (String)objectRow[0] + (String)objectRow[1];
            String valueString = (String)objectRow[2];
            this.detailedPositionObjectTypes.put(keyString, valueString);
        }
    }

    protected void setUpKeysNeedingRounding(Integer BaseYear) {
        Integer emplidCSFOvrdCount = new Integer(0);
        Integer emplidCSFCount = new Integer(0);
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("csfDeleteCode", (Object)"-");
        criteriaID.addEqualTo("universityFiscalYear", (Object)BaseYear);
        criteriaID.addEqualTo("active", (Object)true);
        Criteria criteriaIDCSF = new Criteria();
        criteriaIDCSF.addEqualTo("csfDeleteCode", (Object)"-");
        criteriaIDCSF.addEqualTo("universityFiscalYear", (Object)BaseYear);
        this.keysNeedingRounding = new HashMap(this.hashObjectSize(CalculatedSalaryFoundationTrackerOverride.class, criteriaID, "emplid") + this.hashObjectSize(CalculatedSalaryFoundationTracker.class, criteriaIDCSF, "emplid"));
        String[] columnList = new String[]{"emplid"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(CalculatedSalaryFoundationTrackerOverride.class, columnList, criteriaID, true);
        Iterator emplidOvrd = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (emplidOvrd.hasNext()) {
            String newKey = (String)((Object[])emplidOvrd.next())[0];
            this.keysNeedingRounding.put(newKey, new roundMechanism());
        }
        LOG.info((Object)String.format("\nEMPLID's from CSF override: %d", this.keysNeedingRounding.size()));
        queryID = new ReportQueryByCriteria(CalculatedSalaryFoundationTracker.class, columnList, criteriaIDCSF, true);
        Iterator emplidIter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (emplidIter.hasNext()) {
            String newKey = (String)((Object[])emplidIter.next())[0];
            if (this.keysNeedingRounding.containsKey(newKey)) continue;
            this.keysNeedingRounding.put(newKey, new roundMechanism());
        }
        LOG.info((Object)String.format("\nEMPLID total for BCSF: %d", this.keysNeedingRounding.size()));
    }

    protected void setUpPositionNormalWorkMonths(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)RequestYear);
        this.positionNormalWorkMonths = new HashMap(this.hashObjectSize(BudgetConstructionPosition.class, criteriaID));
        String[] fieldList = new String[]{"positionNumber", "iuNormalWorkMonths"};
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(BudgetConstructionPosition.class, fieldList, criteriaID);
        Iterator positionRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (positionRows.hasNext()) {
            Object[] positionRow = (Object[])positionRows.next();
            this.positionNormalWorkMonths.put((String)positionRow[0], ((Number)positionRow[1]).intValue());
        }
    }

    protected void untouchedAppointmentFunding(PendingBudgetConstructionAppointmentFunding bcaf) {
        this.CSFBCAFRowsMissing = this.CSFBCAFRowsMissing + 1;
        if (bcaf.getAppointmentRequestedAmount().compareTo(this.rqstAmount) != 0 || bcaf.getAppointmentFundingDurationCode().compareTo(this.notOnLeave) != 0 || bcaf.isAppointmentFundingDeleteIndicator()) {
            return;
        }
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)(bcaf.getUniversityFiscalYear() - 1));
        criteriaID.addEqualTo("chartOfAccountsCode", (Object)bcaf.getChartOfAccountsCode());
        criteriaID.addEqualTo("accountNumber", (Object)bcaf.getAccountNumber());
        criteriaID.addEqualTo("subAccountNumber", (Object)bcaf.getSubAccountNumber());
        criteriaID.addEqualTo("financialObjectCode", (Object)bcaf.getFinancialObjectCode());
        criteriaID.addEqualTo("financialSubObjectCode", (Object)bcaf.getFinancialSubObjectCode());
        criteriaID.addEqualTo("positionNumber", (Object)bcaf.getPositionNumber());
        if (bcaf.getEmplid().equals("VACANT")) {
            Criteria flagCriteria = new Criteria();
            flagCriteria.addEqualTo("csfFundingStatusCode", (Object)BCConstants.csfFundingStatusFlag.VACANT.getFlagValue());
            Criteria vacantCriteria = new Criteria();
            vacantCriteria.addEqualTo("csfFundingStatusCode", (Object)BCConstants.csfFundingStatusFlag.UNFUNDED.getFlagValue());
            flagCriteria.addOrCriteria(vacantCriteria);
            criteriaID.addAndCriteria(flagCriteria);
        } else {
            criteriaID.addEqualTo("emplid", (Object)bcaf.getEmplid());
        }
        QueryByCriteria queryID = new QueryByCriteria(CalculatedSalaryFoundationTracker.class, criteriaID);
        Iterator resultSet = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        if (!resultSet.hasNext()) {
            return;
        }
        CalculatedSalaryFoundationTracker resultCSF = (CalculatedSalaryFoundationTracker)((Object)resultSet.next());
        if (this.untouchedFTEPercentTimeCheck(bcaf, resultCSF)) {
            bcaf.setAppointmentRequestedFteQuantity(this.FTE);
            bcaf.setAppointmentRequestedTimePercent(this.pctTime);
            bcaf.setAppointmentFundingDeleteIndicator(true);
            this.getPersistenceBrokerTemplate().store((Object)bcaf);
            this.CSFBCAFRowsMarkedDeleted = this.CSFBCAFRowsMarkedDeleted + 1;
        }
        TransactionalServiceUtils.exhaustIterator((Iterator)resultSet);
    }

    protected boolean untouchedFTEPercentTimeCheck(PendingBudgetConstructionAppointmentFunding bcaf, CalculatedSalaryFoundationTracker resultCSF) {
        BigDecimal BCAFFTE;
        BigDecimal CSFFTE = resultCSF.getCsfFullTimeEmploymentQuantity().round(compareContext);
        boolean FTEOK = CSFFTE.compareTo(BCAFFTE = bcaf.getAppointmentRequestedFteQuantity().round(compareContext)) == 0;
        BigDecimal CSFPctTime = resultCSF.getCsfTimePercent().round(compareContext);
        BigDecimal BCAFPctTime = bcaf.getAppointmentRequestedTimePercent().round(compareContext);
        boolean PctTimeOK = CSFPctTime.compareTo(BCAFPctTime) == 0;
        String bcafPosition = bcaf.getPositionNumber();
        return FTEOK && PctTimeOK;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBudgetConstructionHumanResourcesPayrollInterfaceDao(BudgetConstructionHumanResourcesPayrollInterfaceDao budgetConstructionHumanResourcesPayrollInterfaceDao) {
        this.budgetConstructionHumanResourcesPayrollInterfaceDao = budgetConstructionHumanResourcesPayrollInterfaceDao;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    protected class roundMechanism {
        private KualiDecimal diffAmount = new KualiDecimal(0);
        private ArrayList<BudgetConstructionCalculatedSalaryFoundationTracker> candidateBCSFRows = new ArrayList(10);

        protected roundMechanism() {
        }

        public void addNewBCSF(BudgetConstructionCalculatedSalaryFoundationTracker bCSF, KualiDecimal amountFromCSFToSet) {
            KualiInteger wholeDollarsCSFAmount = new KualiInteger(amountFromCSFToSet, RoundingMode.FLOOR);
            bCSF.setCsfAmount(wholeDollarsCSFAmount);
            KualiDecimal penniesFromCSFAmount = amountFromCSFToSet;
            penniesFromCSFAmount = (KualiDecimal)penniesFromCSFAmount.subtract((AbstractKualiDecimal)wholeDollarsCSFAmount.kualiDecimalValue());
            if (wholeDollarsCSFAmount.isNegative()) {
                return;
            }
            this.diffAmount = (KualiDecimal)this.diffAmount.add((AbstractKualiDecimal)penniesFromCSFAmount);
            this.candidateBCSFRows.add(bCSF);
        }

        public void fixRoundErrors() {
            if (!this.diffAmount.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                return;
            }
            KualiDecimal adjustAmount = new KualiDecimal(1);
            if (((KualiDecimal)((KualiDecimal)this.diffAmount.multiply((AbstractKualiDecimal)GenesisDaoOjb.this.shavePennies)).mod((AbstractKualiDecimal)GenesisDaoOjb.this.shavePennies)).isGreaterEqual((AbstractKualiDecimal)new KualiDecimal(50))) {
                this.diffAmount = (KualiDecimal)this.diffAmount.add((AbstractKualiDecimal)adjustAmount);
            }
            if (this.diffAmount.isLessThan((AbstractKualiDecimal)adjustAmount)) {
                return;
            }
            for (BudgetConstructionCalculatedSalaryFoundationTracker rCSF : this.candidateBCSFRows) {
                KualiInteger fixBCSFAmount = rCSF.getCsfAmount();
                rCSF.setCsfAmount(fixBCSFAmount.add(new KualiInteger((long)adjustAmount.intValue())));
                this.diffAmount = (KualiDecimal)this.diffAmount.subtract((AbstractKualiDecimal)adjustAmount);
                if (!this.diffAmount.isLessThan((AbstractKualiDecimal)adjustAmount)) continue;
                break;
            }
        }
    }
}

