/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.dataaccess.impl;

import java.util.ArrayList;

public class SQLForStep {
    private int[] insertionPoints = new int[0];
    private StringBuilder sqlBuilder;

    public SQLForStep(StringBuilder sqlBuilder) {
        this.sqlBuilder = new StringBuilder(sqlBuilder);
    }

    public SQLForStep(StringBuilder sqlBuilder, ArrayList<Integer> insertionPoints) {
        this.sqlBuilder = new StringBuilder(sqlBuilder);
        int pointCount = insertionPoints.size();
        this.insertionPoints = new int[pointCount];
        for (int idx = 0; idx < pointCount; ++idx) {
            this.insertionPoints[idx] = insertionPoints.get(idx);
        }
    }

    public String getSQL(ArrayList<String> parameterToInsert) {
        if (parameterToInsert.size() != this.insertionPoints.length) {
            throw new IndexOutOfBoundsException("the number of strings to be inserted into SQL does not match the number of insertion points");
        }
        StringBuilder unfinishedSQL = new StringBuilder(this.sqlBuilder);
        int lengthSoFar = 0;
        for (int idx = 0; idx < this.insertionPoints.length; ++idx) {
            String parameterString = parameterToInsert.get(idx);
            unfinishedSQL.insert(this.insertionPoints[idx] + lengthSoFar, parameterString);
            lengthSoFar += parameterString.length();
        }
        return unfinishedSQL.toString();
    }

    public String getSQL() {
        return this.sqlBuilder.toString();
    }
}

