/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAdministrativePost;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionDuration;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSalaryFunding;
import org.kuali.kfs.module.bc.util.SalarySettingCalculator;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class PendingBudgetConstructionAppointmentFunding
extends PersistableBusinessObjectBase
implements MutableInactivatable {
    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String positionNumber;
    private String emplid;
    private String appointmentFundingDurationCode;
    private KualiInteger appointmentRequestedCsfAmount;
    private BigDecimal appointmentRequestedCsfFteQuantity;
    private BigDecimal appointmentRequestedCsfTimePercent;
    private KualiInteger appointmentTotalIntendedAmount;
    private BigDecimal appointmentTotalIntendedFteQuantity;
    private KualiInteger appointmentRequestedAmount;
    private BigDecimal appointmentRequestedTimePercent;
    private BigDecimal appointmentRequestedFteQuantity;
    private BigDecimal appointmentRequestedPayRate;
    private boolean appointmentFundingDeleteIndicator;
    private Integer appointmentFundingMonth;
    private boolean positionObjectChangeIndicator = false;
    private boolean positionSalaryChangeIndicator = false;
    private boolean active = true;
    private ObjectCode financialObject;
    private Chart chartOfAccounts;
    private Account account;
    private SubAccount subAccount;
    private SubObjectCode financialSubObject;
    private BudgetConstructionPosition budgetConstructionPosition;
    private BudgetConstructionAdministrativePost budgetConstructionAdministrativePost;
    private BudgetConstructionAccountReports budgetConstructionAccountReports;
    private BudgetConstructionIntendedIncumbent budgetConstructionIntendedIncumbent;
    private BudgetConstructionDuration budgetConstructionDuration;
    private List<BudgetConstructionCalculatedSalaryFoundationTracker> bcnCalculatedSalaryFoundationTracker;
    private List<BudgetConstructionSalaryFunding> budgetConstructionSalaryFunding = new ArrayList<BudgetConstructionSalaryFunding>();
    private List<BudgetConstructionAppointmentFundingReason> budgetConstructionAppointmentFundingReason;
    private KualiDecimal percentChange;
    private String adjustmentMeasurement;
    private KualiDecimal adjustmentAmount;
    private boolean persistedDeleteIndicator;
    private boolean vacatable;
    private boolean newLineIndicator;
    private boolean displayOnlyMode;
    private boolean budgetable;
    private boolean hourlyPaid;
    private boolean excludedFromTotal;
    private boolean override2PlugMode;
    private boolean purged;

    public PendingBudgetConstructionAppointmentFunding() {
        this.bcnCalculatedSalaryFoundationTracker = new ArrayList<BudgetConstructionCalculatedSalaryFoundationTracker>();
        this.budgetConstructionAppointmentFundingReason = new ArrayList<BudgetConstructionAppointmentFundingReason>();
    }

    public KualiDecimal getPercentChange() {
        this.percentChange = null;
        BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = this.getEffectiveCSFTracker();
        if (csfTracker != null) {
            KualiInteger baseAmount = csfTracker.getCsfAmount();
            KualiInteger requestedAmount = this.getAppointmentRequestedAmount();
            this.percentChange = SalarySettingCalculator.getPercentChange(baseAmount, requestedAmount);
        }
        return this.percentChange;
    }

    public void setPercentChange(KualiDecimal percentChange) {
        this.percentChange = percentChange;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String getEmplid() {
        return this.emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public String getAppointmentFundingDurationCode() {
        return this.appointmentFundingDurationCode;
    }

    public void setAppointmentFundingDurationCode(String appointmentFundingDurationCode) {
        this.appointmentFundingDurationCode = appointmentFundingDurationCode;
    }

    public KualiInteger getAppointmentRequestedCsfAmount() {
        return this.appointmentRequestedCsfAmount;
    }

    public void setAppointmentRequestedCsfAmount(KualiInteger appointmentRequestedCsfAmount) {
        this.appointmentRequestedCsfAmount = appointmentRequestedCsfAmount;
    }

    public BigDecimal getAppointmentRequestedCsfFteQuantity() {
        return this.appointmentRequestedCsfFteQuantity;
    }

    public void setAppointmentRequestedCsfFteQuantity(BigDecimal appointmentRequestedCsfFteQuantity) {
        this.appointmentRequestedCsfFteQuantity = appointmentRequestedCsfFteQuantity;
    }

    public BigDecimal getAppointmentRequestedCsfTimePercent() {
        return this.appointmentRequestedCsfTimePercent;
    }

    public void setAppointmentRequestedCsfTimePercent(BigDecimal appointmentRequestedCsfTimePercent) {
        this.appointmentRequestedCsfTimePercent = appointmentRequestedCsfTimePercent;
    }

    public KualiInteger getAppointmentTotalIntendedAmount() {
        return this.appointmentTotalIntendedAmount;
    }

    public void setAppointmentTotalIntendedAmount(KualiInteger appointmentTotalIntendedAmount) {
        this.appointmentTotalIntendedAmount = appointmentTotalIntendedAmount;
    }

    public BigDecimal getAppointmentTotalIntendedFteQuantity() {
        return this.appointmentTotalIntendedFteQuantity;
    }

    public void setAppointmentTotalIntendedFteQuantity(BigDecimal appointmentTotalIntendedFteQuantity) {
        this.appointmentTotalIntendedFteQuantity = appointmentTotalIntendedFteQuantity;
    }

    public KualiInteger getAppointmentRequestedAmount() {
        return this.appointmentRequestedAmount;
    }

    public void setAppointmentRequestedAmount(KualiInteger appointmentRequestedAmount) {
        this.appointmentRequestedAmount = appointmentRequestedAmount;
    }

    public BigDecimal getAppointmentRequestedTimePercent() {
        return this.appointmentRequestedTimePercent;
    }

    public void setAppointmentRequestedTimePercent(BigDecimal appointmentRequestedTimePercent) {
        this.appointmentRequestedTimePercent = appointmentRequestedTimePercent;
    }

    public BigDecimal getAppointmentRequestedFteQuantity() {
        return this.appointmentRequestedFteQuantity;
    }

    public void setAppointmentRequestedFteQuantity(BigDecimal appointmentRequestedFteQuantity) {
        this.appointmentRequestedFteQuantity = appointmentRequestedFteQuantity;
    }

    public BigDecimal getAppointmentRequestedPayRate() {
        return this.appointmentRequestedPayRate;
    }

    public void setAppointmentRequestedPayRate(BigDecimal appointmentRequestedPayRate) {
        this.appointmentRequestedPayRate = appointmentRequestedPayRate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isAppointmentFundingDeleteIndicator() {
        return !this.active;
    }

    public void setAppointmentFundingDeleteIndicator(boolean appointmentFundingDeleteIndicator) {
        this.active = !appointmentFundingDeleteIndicator;
    }

    public Integer getAppointmentFundingMonth() {
        return this.appointmentFundingMonth;
    }

    public void setAppointmentFundingMonth(Integer appointmentFundingMonth) {
        this.appointmentFundingMonth = appointmentFundingMonth;
    }

    public boolean isPositionObjectChangeIndicator() {
        return this.positionObjectChangeIndicator;
    }

    public void setPositionObjectChangeIndicator(boolean positionObjectChangeIndicator) {
        this.positionObjectChangeIndicator = positionObjectChangeIndicator;
    }

    public boolean isPositionSalaryChangeIndicator() {
        return this.positionSalaryChangeIndicator;
    }

    public void setPositionSalaryChangeIndicator(boolean positionSalaryChangeIndicator) {
        this.positionSalaryChangeIndicator = positionSalaryChangeIndicator;
    }

    public boolean isPositionChangeIndicator() {
        return this.isPositionSalaryChangeIndicator() || this.isPositionObjectChangeIndicator();
    }

    public ObjectCode getFinancialObject() {
        return this.financialObject;
    }

    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public SubObjectCode getFinancialSubObject() {
        return this.financialSubObject;
    }

    public void setFinancialSubObject(SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public BudgetConstructionPosition getBudgetConstructionPosition() {
        return this.budgetConstructionPosition;
    }

    public void setBudgetConstructionPosition(BudgetConstructionPosition budgetConstructionPosition) {
        this.budgetConstructionPosition = budgetConstructionPosition;
    }

    public List<BudgetConstructionSalaryFunding> getBudgetConstructionSalaryFunding() {
        return this.budgetConstructionSalaryFunding;
    }

    @Deprecated
    public void setBudgetConstructionSalaryFunding(List<BudgetConstructionSalaryFunding> budgetConstructionSalaryFunding) {
        this.budgetConstructionSalaryFunding = budgetConstructionSalaryFunding;
    }

    public List<BudgetConstructionAppointmentFundingReason> getBudgetConstructionAppointmentFundingReason() {
        return this.budgetConstructionAppointmentFundingReason;
    }

    @Deprecated
    public void setBudgetConstructionAppointmentFundingReason(List<BudgetConstructionAppointmentFundingReason> budgetConstructionAppointmentFundingReason) {
        this.budgetConstructionAppointmentFundingReason = budgetConstructionAppointmentFundingReason;
    }

    public BudgetConstructionAdministrativePost getBudgetConstructionAdministrativePost() {
        return this.budgetConstructionAdministrativePost;
    }

    public void setBudgetConstructionAdministrativePost(BudgetConstructionAdministrativePost budgetConstructionAdministrativePost) {
        this.budgetConstructionAdministrativePost = budgetConstructionAdministrativePost;
    }

    public BudgetConstructionAccountReports getBudgetConstructionAccountReports() {
        return this.budgetConstructionAccountReports;
    }

    public void setBudgetConstructionAccountReports(BudgetConstructionAccountReports budgetConstructionAccountReports) {
        this.budgetConstructionAccountReports = budgetConstructionAccountReports;
    }

    public BudgetConstructionDuration getBudgetConstructionDuration() {
        return this.budgetConstructionDuration;
    }

    public void setBudgetConstructionDuration(BudgetConstructionDuration budgetConstructionDuration) {
        this.budgetConstructionDuration = budgetConstructionDuration;
    }

    public BudgetConstructionIntendedIncumbent getBudgetConstructionIntendedIncumbent() {
        return this.budgetConstructionIntendedIncumbent;
    }

    public void setBudgetConstructionIntendedIncumbent(BudgetConstructionIntendedIncumbent budgetConstructionIntendedIncumbent) {
        this.budgetConstructionIntendedIncumbent = budgetConstructionIntendedIncumbent;
    }

    public List<BudgetConstructionCalculatedSalaryFoundationTracker> getBcnCalculatedSalaryFoundationTracker() {
        return this.bcnCalculatedSalaryFoundationTracker;
    }

    public void setBcnCalculatedSalaryFoundationTracker(List<BudgetConstructionCalculatedSalaryFoundationTracker> bcnCalculatedSalaryFoundationTracker) {
        this.bcnCalculatedSalaryFoundationTracker = bcnCalculatedSalaryFoundationTracker;
    }

    public KualiDecimal getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    public void setAdjustmentAmount(KualiDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public String getAdjustmentMeasurement() {
        return this.adjustmentMeasurement;
    }

    public void setAdjustmentMeasurement(String adjustmentMeasurement) {
        this.adjustmentMeasurement = adjustmentMeasurement;
    }

    public BudgetConstructionCalculatedSalaryFoundationTracker getEffectiveCSFTracker() {
        if (this.bcnCalculatedSalaryFoundationTracker == null || this.bcnCalculatedSalaryFoundationTracker.size() <= 0) {
            return null;
        }
        return this.bcnCalculatedSalaryFoundationTracker.get(0);
    }

    public boolean isVacatable() {
        return this.vacatable;
    }

    public void setVacatable(boolean vacatable) {
        this.vacatable = vacatable;
    }

    public boolean isPersistedDeleteIndicator() {
        return this.persistedDeleteIndicator;
    }

    public void setPersistedDeleteIndicator(boolean persistedDeleteIndicator) {
        this.persistedDeleteIndicator = persistedDeleteIndicator;
    }

    public Map<String, Object> getValuesMap() {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("universityFiscalYear", this.getUniversityFiscalYear());
        valuesMap.put("chartOfAccountsCode", this.getChartOfAccountsCode());
        valuesMap.put("accountNumber", this.getAccountNumber());
        valuesMap.put("subAccountNumber", this.getSubAccountNumber());
        valuesMap.put("financialObjectCode", this.getFinancialObjectCode());
        valuesMap.put("financialSubObjectCode", this.getFinancialSubObjectCode());
        valuesMap.put("positionNumber", this.getPositionNumber());
        valuesMap.put("emplid", this.getEmplid());
        return valuesMap;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.universityFiscalYear != null) {
            map.put("universityFiscalYear", this.getUniversityFiscalYear().toString());
        }
        map.put("chartOfAccountsCode", this.getChartOfAccountsCode());
        map.put("accountNumber", this.getAccountNumber());
        map.put("subAccountNumber", this.getSubAccountNumber());
        map.put("financialObjectCode", this.getFinancialObjectCode());
        map.put("financialSubObjectCode", this.getFinancialSubObjectCode());
        map.put("positionNumber", this.getPositionNumber());
        map.put("emplid", this.getEmplid());
        return map;
    }

    public String getAppointmentFundingString() {
        String pattern = " {0}, {1}, {2}, {3}, {4}, {5}, {6}";
        return MessageFormat.format(pattern, this.chartOfAccountsCode, this.accountNumber, this.subAccountNumber, this.financialObjectCode, this.financialSubObjectCode, this.emplid, this.positionNumber);
    }

    protected void postLoad() {
        super.postLoad();
        this.setPersistedDeleteIndicator(this.isAppointmentFundingDeleteIndicator());
        this.setNewLineIndicator(false);
    }

    public boolean isNewLineIndicator() {
        return this.newLineIndicator;
    }

    public boolean isHourlyPaid() {
        return this.hourlyPaid;
    }

    public boolean isDisplayOnlyMode() {
        return this.displayOnlyMode;
    }

    public boolean isBudgetable() {
        return this.budgetable;
    }

    public boolean isExcludedFromTotal() {
        return this.excludedFromTotal;
    }

    public boolean isOverride2PlugMode() {
        return this.override2PlugMode;
    }

    public void setDisplayOnlyMode(boolean displayOnlyMode) {
        this.displayOnlyMode = displayOnlyMode;
    }

    public void setBudgetable(boolean budgetable) {
        this.budgetable = budgetable;
    }

    public void setExcludedFromTotal(boolean excludedFromTotal) {
        this.excludedFromTotal = excludedFromTotal;
    }

    public void setOverride2PlugMode(boolean override2PlugMode) {
        this.override2PlugMode = override2PlugMode;
    }

    public void setNewLineIndicator(boolean newLineIndicator) {
        this.newLineIndicator = newLineIndicator;
    }

    public void setHourlyPaid(boolean hourlyPaid) {
        this.hourlyPaid = hourlyPaid;
    }

    public boolean isPurged() {
        return this.purged;
    }

    public void setPurged(boolean purged) {
        this.purged = purged;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getBudgetConstructionAppointmentFundingReason());
        return managedLists;
    }
}

