/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.lookup.SelectLookupableHelperServiceImpl;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.krad.bo.BusinessObject;

public class PositionLookupableHelperServiceImpl
extends SelectLookupableHelperServiceImpl {
    public ConfigurationService kualiConfigurationService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        Map requestParameters = super.getParameters();
        if (requestParameters.containsKey("showSalaryByPositionAction")) {
            String[] requestParm = (String[])requestParameters.get("showSalaryByPositionAction");
            Boolean showSalaryByPosition = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)requestParm[0]);
            if (!showSalaryByPosition.booleanValue()) {
                return this.getPositionCustomActionUrls(businessObject, pkNames);
            }
        } else {
            return this.getPositionCustomActionUrls(businessObject, pkNames);
        }
        return this.getSalarySettingByPositionUrls(businessObject);
    }

    private List<HtmlData> getPositionCustomActionUrls(BusinessObject businessObject, List pkNames) {
        BudgetConstructionPosition position = (BudgetConstructionPosition)businessObject;
        boolean payrollPositionFeed = BudgetParameterFinder.getPayrollPositionFeedIndicator();
        if (!payrollPositionFeed) {
            return super.getCustomActionUrls(businessObject, pkNames);
        }
        return super.getEmptyActionUrls();
    }

    protected String getActionUrlHref(BusinessObject businessObject, String methodToCall, List pkNames) {
        String href = super.getActionUrlHref(businessObject, methodToCall, pkNames);
        href = StringUtils.replace((String)href, (String)"maintenance.do", (String)"kr/maintenance.do");
        return href;
    }

    public boolean allowsMaintenanceNewOrCopyAction() {
        boolean payrollPositionFeed = BudgetParameterFinder.getPayrollPositionFeedIndicator();
        return !payrollPositionFeed;
    }

    private Properties getSalarySettingByPositionParameters(BusinessObject businessObject) {
        String[] requestParm;
        BudgetConstructionPosition position = (BudgetConstructionPosition)businessObject;
        Properties parameters = new Properties();
        parameters.put("methodToCall", "loadExpansionScreen");
        parameters.put("universityFiscalYear", position.getUniversityFiscalYear().toString());
        parameters.put("positionNumber", position.getPositionNumber());
        Map requestParameters = super.getParameters();
        boolean linkToNewWindow = true;
        if (requestParameters.containsKey("addLine")) {
            requestParm = (String[])requestParameters.get("addLine");
            parameters.put("addLine", requestParm[0]);
            Boolean addNewFunding = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)requestParm[0]);
            if (addNewFunding.booleanValue()) {
                linkToNewWindow = false;
            }
        } else {
            parameters.put("addLine", "false");
        }
        if (requestParameters.containsKey("docFormKey")) {
            requestParm = (String[])requestParameters.get("docFormKey");
            parameters.put("returnFormKey", requestParm[0]);
        } else if (requestParameters.containsKey("formKey")) {
            requestParm = (String[])requestParameters.get("formKey");
            parameters.put("returnFormKey", requestParm[0]);
        }
        if (requestParameters.containsKey("backLocation")) {
            requestParm = (String[])requestParameters.get("backLocation");
            parameters.put("backLocation", requestParm[0]);
        }
        if (requestParameters.containsKey("chartOfAccountsCode")) {
            requestParm = (String[])requestParameters.get("chartOfAccountsCode");
            parameters.put("chartOfAccountsCode", requestParm[0]);
        }
        if (requestParameters.containsKey("accountNumber")) {
            requestParm = (String[])requestParameters.get("accountNumber");
            parameters.put("accountNumber", requestParm[0]);
        }
        if (requestParameters.containsKey("subAccountNumber")) {
            requestParm = (String[])requestParameters.get("subAccountNumber");
            parameters.put("subAccountNumber", requestParm[0]);
        }
        if (requestParameters.containsKey("financialObjectCode")) {
            requestParm = (String[])requestParameters.get("financialObjectCode");
            parameters.put("financialObjectCode", requestParm[0]);
        }
        if (requestParameters.containsKey("financialSubObjectCode")) {
            requestParm = (String[])requestParameters.get("financialSubObjectCode");
            parameters.put("financialSubObjectCode", requestParm[0]);
        }
        if (requestParameters.containsKey("budgetByAccountMode")) {
            requestParm = (String[])requestParameters.get("budgetByAccountMode");
            parameters.put("budgetByAccountMode", requestParm[0]);
        }
        if (requestParameters.containsKey("mainWindow")) {
            requestParm = (String[])requestParameters.get("mainWindow");
            parameters.put("mainWindow", requestParm[0]);
        }
        if (requestParameters.containsKey("singleAccountMode")) {
            requestParm = (String[])requestParameters.get("singleAccountMode");
            parameters.put("singleAccountMode", requestParm[0]);
        } else {
            parameters.put("singleAccountMode", "false");
        }
        parameters.put("refreshPositionBeforeSalarySetting", "false");
        return parameters;
    }

    public List<HtmlData> getSalarySettingByPositionUrls(BusinessObject businessObject) {
        String[] requestParm;
        Boolean addNewFunding;
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        Properties parameters = this.getSalarySettingByPositionParameters(businessObject);
        String href = UrlFactory.parameterizeUrl((String)"budgetPositionSalarySetting.do", (Properties)parameters);
        HtmlData.AnchorHtmlData urlData1 = new HtmlData.AnchorHtmlData(href, "loadExpansionScreen", "Posn Salset");
        Map requestParameters = super.getParameters();
        boolean linkToNewWindow = true;
        if (requestParameters.containsKey("addLine") && (addNewFunding = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)(requestParm = (String[])requestParameters.get("addLine"))[0])).booleanValue()) {
            linkToNewWindow = false;
        }
        if (linkToNewWindow) {
            urlData1.setTarget("BCSecondWindow");
        }
        anchorHtmlDataList.add((HtmlData)urlData1);
        boolean payrollPositionFeed = BudgetParameterFinder.getPayrollPositionFeedIndicator();
        String url2 = "";
        if (payrollPositionFeed) {
            parameters.put("refreshPositionBeforeSalarySetting", "true");
            href = UrlFactory.parameterizeUrl((String)"budgetPositionSalarySetting.do", (Properties)parameters);
            HtmlData.AnchorHtmlData urlData2 = new HtmlData.AnchorHtmlData(href, "loadExpansionScreen", "Posn Salset w/sync");
            if (linkToNewWindow) {
                urlData2.setTarget("_blank");
            }
            anchorHtmlDataList.add((HtmlData)urlData2);
            ((HtmlData)anchorHtmlDataList.get(anchorHtmlDataList.lastIndexOf(urlData2))).setPrependDisplayText("<br />");
        }
        return anchorHtmlDataList;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

