/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject.lookup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ld.LaborLedgerBenefitsCalculation;
import org.kuali.kfs.integration.ld.LaborLedgerPositionObjectBenefit;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.RequestBenefits;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.bo.BusinessObject;

public class RequestBenefitsLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static Logger LOG = Logger.getLogger(RequestBenefitsLookupableHelperServiceImpl.class);
    private LaborModuleService laborModuleService;
    private BusinessObjectService businessObjectService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<RequestBenefits> requestBenefits = new ArrayList<RequestBenefits>();
        String accountNumber = fieldValues.get("accountNumber");
        Boolean categoryRateCalcMode = false;
        Boolean categoryRateCalcParmExists = ((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
        String sysParam = " ";
        if (categoryRateCalcParmExists.booleanValue() && (sysParam = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND")).equalsIgnoreCase("Y")) {
            categoryRateCalcMode = true;
        }
        Integer fiscalYear = Integer.valueOf(fieldValues.get("universityFiscalYear"));
        String chartOfAccountsCode = fieldValues.get("chartOfAccountsCode");
        String objectCode = fieldValues.get("financialObjectCode");
        List positionObjectBenefits = this.laborModuleService.retrieveActiveLaborPositionObjectBenefits(fiscalYear, chartOfAccountsCode, objectCode);
        for (LaborLedgerPositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
            KualiPercent fringePct = new KualiPercent(0.0);
            Boolean beneCalcExistsAndActive = true;
            LaborLedgerBenefitsCalculation benefitsCalculation = null;
            String laborBenefitRateCategoryCode = "";
            if (categoryRateCalcMode.booleanValue()) {
                HashMap<String, String> accountLookupFields = new HashMap<String, String>();
                accountLookupFields.put("chartOfAccountsCode", chartOfAccountsCode);
                accountLookupFields.put("accountNumber", accountNumber);
                Account account = (Account)this.businessObjectService.findByPrimaryKey(Account.class, accountLookupFields);
                laborBenefitRateCategoryCode = account.getLaborBenefitRateCategoryCode();
                benefitsCalculation = positionObjectBenefit.getLaborLedgerBenefitsCalculation(laborBenefitRateCategoryCode);
            } else {
                benefitsCalculation = positionObjectBenefit.getLaborLedgerBenefitsCalculation();
            }
            if (ObjectUtils.isNull((Object)benefitsCalculation) || !benefitsCalculation.isActive()) {
                beneCalcExistsAndActive = false;
                if (ObjectUtils.isNull((Object)benefitsCalculation)) {
                    LOG.warn((Object)("Could not locate a benefits calculation for {" + fiscalYear + "," + chartOfAccountsCode + "," + positionObjectBenefit.getFinancialObjectBenefitsTypeCode() + "," + positionObjectBenefit.getFinancialObjectCode() + "," + laborBenefitRateCategoryCode + "}"));
                }
            } else {
                fringePct = benefitsCalculation.getPositionFringeBenefitPercent();
            }
            if (!beneCalcExistsAndActive.booleanValue()) continue;
            RequestBenefits requestBenefit = new RequestBenefits();
            requestBenefit.setFinancialObjectBenefitsTypeCode(positionObjectBenefit.getFinancialObjectBenefitsTypeCode());
            requestBenefit.setFinancialObjectBenefitsTypeDescription(positionObjectBenefit.getLaborLedgerBenefitsCalculation().getLaborLedgerBenefitsType().getPositionBenefitTypeDescription());
            requestBenefit.setPositionFringeBenefitObjectCode(positionObjectBenefit.getLaborLedgerBenefitsCalculation().getPositionFringeBenefitObjectCode());
            requestBenefit.setPositionFringeBenefitObjectCodeName(positionObjectBenefit.getLaborLedgerBenefitsCalculation().getPositionFringeBenefitObject().getFinancialObjectCodeName());
            requestBenefit.setPositionFringeBenefitPercent(positionObjectBenefit.getLaborLedgerBenefitsCalculation().getPositionFringeBenefitPercent());
            BigDecimal requestAmount = new BigDecimal(Integer.valueOf(fieldValues.get("accountLineAnnualBalanceAmount")));
            BigDecimal fringePctDecimal = fringePct.bigDecimalValue().divide(new BigDecimal(100));
            BigDecimal result = requestAmount.multiply(fringePctDecimal).setScale(0, RoundingMode.HALF_UP);
            KualiInteger detAmount = new KualiInteger(result.toBigInteger());
            requestBenefit.setFringeDetailAmount(detAmount);
            requestBenefits.add(requestBenefit);
        }
        return requestBenefits;
    }

    public void setLaborModuleService(LaborModuleService laborModuleService) {
        this.laborModuleService = laborModuleService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

