/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.dataaccess.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import org.kuali.kfs.gl.businessobject.TransientBalanceInquiryAttributes;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.Position;
import org.kuali.kfs.module.bc.dataaccess.HumanResourcesPayrollDao;
import org.kuali.kfs.module.bc.document.dataaccess.impl.BudgetConstructionDaoJdbcBase;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

public class HumanResourcesPayrollDaoJdbc
extends BudgetConstructionDaoJdbcBase
implements HumanResourcesPayrollDao {
    @Override
    public Position getPosition(Integer universityFiscalYear, String positionNumber) {
        PositionData positionData = this.getPositionDataForFiscalYear(universityFiscalYear, positionNumber);
        if (positionData == null) {
            return null;
        }
        BudgetConstructionPosition position = new BudgetConstructionPosition();
        position.setUniversityFiscalYear(universityFiscalYear);
        position.setPositionNumber(positionNumber);
        this.populatePositionData(position, positionData);
        this.setDefaultObjectClass(position);
        return position;
    }

    protected PositionData getPositionDataForFiscalYear(Integer universityFiscalYear, String positionNumber) {
        Collection<PositionData> positionData = this.getPositionData(positionNumber);
        if (positionData == null || positionData.isEmpty()) {
            return null;
        }
        Integer baseFiscalYear = universityFiscalYear - 1;
        GregorianCalendar calendarJuly1 = new GregorianCalendar(baseFiscalYear, 6, 1);
        GregorianCalendar calendarAugust1 = new GregorianCalendar(universityFiscalYear, 7, 1);
        Date julyFirst = new Date(calendarJuly1.getTimeInMillis());
        Date augustFirst = new Date(calendarAugust1.getTimeInMillis());
        String academicTenureTrackSalaryPlan = new String("AC1");
        PositionData positionDataMaxEffectiveDate = null;
        for (PositionData posData : positionData) {
            Date positionEffectiveDate = posData.getEffectiveDate();
            if (positionEffectiveDate.compareTo(julyFirst) > 0 && (!academicTenureTrackSalaryPlan.equals(posData.getPositionSalaryPlanDefault()) || !positionEffectiveDate.equals(augustFirst)) || positionDataMaxEffectiveDate != null && positionDataMaxEffectiveDate.getEffectiveDate().compareTo(positionEffectiveDate) >= 0) continue;
            positionDataMaxEffectiveDate = posData;
        }
        return positionDataMaxEffectiveDate;
    }

    public Collection<PositionData> getPositionData(String positionNumber) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT POSITION_NBR, EFFDT, JOBCODE, POS_EFF_STATUS, DESCR, \n");
        sqlBuilder.append("        DESCRSHORT, BUSINESS_UNIT, DEPTID, POSN_STATUS, STATUS_DT, \n");
        sqlBuilder.append("        BUDGETED_POSN, STD_HRS_DEFAULT, STD_HRS_FREQUENCY, POS_REG_TEMP, \n");
        sqlBuilder.append("        POS_FTE, POS_SAL_PLAN_DFLT, POS_GRADE_DFLT \n");
        sqlBuilder.append(" FROM PS_POSITION_DATA \n");
        sqlBuilder.append(" WHERE POSITION_NBR = ? \n");
        String sqlString = sqlBuilder.toString();
        ParameterizedRowMapper<PositionData> mapper = new ParameterizedRowMapper<PositionData>(){

            public PositionData mapRow(ResultSet rs, int rowNum) throws SQLException {
                PositionData positionData = new PositionData();
                positionData.setPositionNumber(rs.getString("POSITION_NBR"));
                positionData.setEffectiveDate(rs.getDate("EFFDT"));
                positionData.setJobCode(rs.getString("JOBCODE"));
                positionData.setPositionEffectiveStatus(rs.getString("POS_EFF_STATUS"));
                positionData.setDescription(rs.getString("DESCR"));
                positionData.setShortDescription(rs.getString("DESCRSHORT"));
                positionData.setBusinessUnit(rs.getString("BUSINESS_UNIT"));
                positionData.setDepartmentId(rs.getString("DEPTID"));
                positionData.setPositionStatus(rs.getString("POSN_STATUS"));
                positionData.setStatusDate(rs.getDate("STATUS_DT"));
                positionData.setBudgetedPosition(rs.getString("BUDGETED_POSN"));
                positionData.setStandardHoursDefault(rs.getBigDecimal("STD_HRS_DEFAULT"));
                positionData.setStandardHoursFrequency(rs.getString("STD_HRS_FREQUENCY"));
                positionData.setPositionRegularTemporary(rs.getString("POS_REG_TEMP"));
                positionData.setPositionFullTimeEquivalency(rs.getBigDecimal("POS_FTE"));
                positionData.setPositionSalaryPlanDefault(rs.getString("POS_SAL_PLAN_DFLT"));
                positionData.setPositionGradeDefault(rs.getString("POS_GRADE_DFLT"));
                return positionData;
            }
        };
        return this.getSimpleJdbcTemplate().query(sqlString, (ParameterizedRowMapper)mapper, new Object[]{positionNumber});
    }

    public void populatePositionData(Position position, PositionData positionData) {
        position.setPositionEffectiveDate(positionData.getEffectiveDate());
        position.setJobCode(positionData.getJobCode());
        position.setPositionEffectiveStatus(positionData.getPositionEffectiveStatus());
        position.setPositionDescription(positionData.getDescription());
        position.setSetidDepartment(positionData.getBusinessUnit());
        position.setPositionDepartmentIdentifier(positionData.getDepartmentId());
        position.setPositionStatus(positionData.getPositionStatus());
        if ("Y".equalsIgnoreCase(positionData.getBudgetedPosition())) {
            position.setBudgetedPosition(true);
        } else {
            position.setBudgetedPosition(false);
        }
        position.setPositionStandardHoursDefault(positionData.getStandardHoursDefault());
        position.setPositionRegularTemporary(positionData.getPositionRegularTemporary());
        position.setPositionFullTimeEquivalency(positionData.getPositionFullTimeEquivalency());
        position.setPositionSalaryPlanDefault(positionData.getPositionSalaryPlanDefault());
        position.setPositionGradeDefault(positionData.getPositionGradeDefault());
    }

    public void setDefaultObjectClass(Position position) {
        String salaryPlan = position.getPositionSalaryPlanDefault();
        if ("AC1".equals(salaryPlan)) {
            position.setIuNormalWorkMonths(new Integer(10));
            position.setIuPayMonths(new Integer(10));
            position.setIuPositionType("AC");
            position.setIuDefaultObjectCode("2000");
        } else if ("PAO".equals(salaryPlan) || "PAU".equals(salaryPlan)) {
            position.setIuNormalWorkMonths(new Integer(12));
            position.setIuPayMonths(new Integer(12));
            position.setIuPositionType("SM");
            position.setIuDefaultObjectCode("2480");
        } else if (salaryPlan.startsWith("P")) {
            position.setIuNormalWorkMonths(new Integer(12));
            position.setIuPayMonths(new Integer(12));
            position.setIuPositionType("SM");
            position.setIuDefaultObjectCode("2400");
        } else {
            position.setIuNormalWorkMonths(new Integer(12));
            position.setIuPayMonths(new Integer(12));
            position.setIuPositionType("SB");
            position.setIuDefaultObjectCode("2500");
            position.setPositionUnionCode("B1");
        }
    }

    protected class PositionData
    extends PersistableBusinessObjectBase {
        private String positionNumber;
        private String jobCode;
        private Date effectiveDate;
        private String positionEffectiveStatus;
        private String description;
        private String shortDescription;
        private String businessUnit;
        private String departmentId;
        private String positionStatus;
        private Date statusDate;
        private String budgetedPosition;
        private BigDecimal standardHoursDefault;
        private String standardHoursFrequency;
        private String positionRegularTemporary;
        private BigDecimal positionFullTimeEquivalency;
        private String positionSalaryPlanDefault;
        private String positionGradeDefault;
        private TransientBalanceInquiryAttributes dummyBusinessObject = new TransientBalanceInquiryAttributes();

        public PositionData() {
            this.dummyBusinessObject.setLinkButtonOption("Drill Down");
        }

        public String getPositionNumber() {
            return this.positionNumber;
        }

        public void setPositionNumber(String positionNumber) {
            this.positionNumber = positionNumber;
        }

        public String getJobCode() {
            return this.jobCode;
        }

        public void setJobCode(String jobCode) {
            this.jobCode = jobCode;
        }

        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        public void setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public String getPositionEffectiveStatus() {
            return this.positionEffectiveStatus;
        }

        public void setPositionEffectiveStatus(String positionEffectiveStatus) {
            this.positionEffectiveStatus = positionEffectiveStatus;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        public String getBusinessUnit() {
            return this.businessUnit;
        }

        public void setBusinessUnit(String businessUnit) {
            this.businessUnit = businessUnit;
        }

        public String getDepartmentId() {
            return this.departmentId;
        }

        public void setDepartmentId(String departmentId) {
            this.departmentId = departmentId;
        }

        public String getPositionStatus() {
            return this.positionStatus;
        }

        public void setPositionStatus(String positionStatus) {
            this.positionStatus = positionStatus;
        }

        public Date getStatusDate() {
            return this.statusDate;
        }

        public void setStatusDate(Date statusDate) {
            this.statusDate = statusDate;
        }

        public String getBudgetedPosition() {
            return this.budgetedPosition;
        }

        public void setBudgetedPosition(String budgetedPosition) {
            this.budgetedPosition = budgetedPosition;
        }

        public BigDecimal getStandardHoursDefault() {
            return this.standardHoursDefault;
        }

        public void setStandardHoursDefault(BigDecimal standardHoursDefault) {
            this.standardHoursDefault = standardHoursDefault;
        }

        public String getStandardHoursFrequency() {
            return this.standardHoursFrequency;
        }

        public void setStandardHoursFrequency(String standardHoursFrequency) {
            this.standardHoursFrequency = standardHoursFrequency;
        }

        public String getPositionRegularTemporary() {
            return this.positionRegularTemporary;
        }

        public void setPositionRegularTemporary(String positionRegularTemporary) {
            this.positionRegularTemporary = positionRegularTemporary;
        }

        public BigDecimal getPositionFullTimeEquivalency() {
            return this.positionFullTimeEquivalency;
        }

        public void setPositionFullTimeEquivalency(BigDecimal positionFullTimeEquivalency) {
            this.positionFullTimeEquivalency = positionFullTimeEquivalency;
        }

        public String getPositionSalaryPlanDefault() {
            return this.positionSalaryPlanDefault;
        }

        public void setPositionSalaryPlanDefault(String positionSalaryPlanDefault) {
            this.positionSalaryPlanDefault = positionSalaryPlanDefault;
        }

        public String getPositionGradeDefault() {
            return this.positionGradeDefault;
        }

        public void setPositionGradeDefault(String positionGradeDefault) {
            this.positionGradeDefault = positionGradeDefault;
        }

        protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            m.put("positionNumber", this.positionNumber);
            if (this.effectiveDate != null) {
                m.put("effectiveDate", this.effectiveDate.toString());
            }
            return m;
        }

        public TransientBalanceInquiryAttributes getDummyBusinessObject() {
            return this.dummyBusinessObject;
        }

        public void setDummyBusinessObject(TransientBalanceInquiryAttributes dummyBusinessObject) {
            this.dummyBusinessObject = dummyBusinessObject;
        }
    }
}

