/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.dataaccess.impl;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.batch.dataaccess.impl.SQLForStep;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionMonthlyBudgetsCreateDeleteDao;
import org.kuali.kfs.module.bc.document.dataaccess.impl.BudgetConstructionDaoJdbcBase;

public class BudgetConstructionMonthlyBudgetsCreateDeleteDaoJdbc
extends BudgetConstructionDaoJdbcBase
implements BudgetConstructionMonthlyBudgetsCreateDeleteDao {
    private static Logger LOG = Logger.getLogger(BudgetConstructionMonthlyBudgetsCreateDeleteDaoJdbc.class);
    protected static ArrayList<SQLForStep> deleteAllSql = new ArrayList(2);
    protected static ArrayList<SQLForStep> spreadRevenueSql = new ArrayList(2);
    protected static ArrayList<SQLForStep> spreadExpenditureSql = new ArrayList(3);

    public BudgetConstructionMonthlyBudgetsCreateDeleteDaoJdbc() {
        StringBuilder sqlBuilder = new StringBuilder(5000);
        ArrayList<Integer> insertionPoints = new ArrayList<Integer>();
        sqlBuilder.append("DELETE FROM LD_BCNSTR_MONTH_T\n");
        sqlBuilder.append("WHERE (fdoc_nbr = ?)\n");
        sqlBuilder.append("  AND (univ_fiscal_yr = ?)\n");
        sqlBuilder.append("  AND (fin_coa_cd = ?)\n");
        sqlBuilder.append("  AND (account_nbr = ?)\n");
        sqlBuilder.append("  AND (sub_acct_nbr = ?)\n");
        sqlBuilder.append("  AND (fin_obj_typ_cd IN ");
        insertionPoints.add(sqlBuilder.length());
        sqlBuilder.append(")");
        deleteAllSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        deleteAllSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        sqlBuilder.delete(0, sqlBuilder.length());
        insertionPoints.clear();
        sqlBuilder.append("DELETE FROM LD_BCNSTR_MONTH_T\n");
        sqlBuilder.append("WHERE (fdoc_nbr = ?)\n");
        sqlBuilder.append("  AND (univ_fiscal_yr = ?)\n");
        sqlBuilder.append("  AND (fin_coa_cd = ?)\n");
        sqlBuilder.append("  AND (account_nbr = ?)\n");
        sqlBuilder.append("  AND (sub_acct_nbr = ?)\n");
        sqlBuilder.append("  AND (fin_obj_typ_cd IN ");
        insertionPoints.add(sqlBuilder.length());
        sqlBuilder.append(")");
        spreadRevenueSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        insertionPoints.clear();
        sqlBuilder.delete(0, sqlBuilder.length());
        sqlBuilder.append("INSERT INTO LD_BCNSTR_MONTH_T\n");
        sqlBuilder.append("(FDOC_NBR, UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD,\n");
        sqlBuilder.append(" FDOC_LN_MO1_AMT, FDOC_LN_MO2_AMT, FDOC_LN_MO3_AMT, FDOC_LN_MO4_AMT, FDOC_LN_MO5_AMT, FDOC_LN_MO6_AMT,\n");
        sqlBuilder.append(" FDOC_LN_MO7_AMT, FDOC_LN_MO8_AMT, FDOC_LN_MO9_AMT, FDOC_LN_MO10_AMT, FDOC_LN_MO11_AMT, FDOC_LN_MO12_AMT)\n");
        sqlBuilder.append("(SELECT ?, ?, ?, ?, ?, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD,\n");
        sqlBuilder.append("        ROUND((acln_annl_bal_amt / 12), 0) + \n");
        sqlBuilder.append("        (acln_annl_bal_amt - (ROUND((acln_annl_bal_amt / 12), 0) * 12)),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0)\n");
        sqlBuilder.append("        FROM LD_PND_BCNSTR_GL_T\n");
        sqlBuilder.append("        WHERE (fdoc_nbr = ?)\n");
        sqlBuilder.append("          AND (univ_fiscal_yr = ?)\n");
        sqlBuilder.append("          AND (fin_coa_cd = ?)\n");
        sqlBuilder.append("          AND (account_nbr = ?)\n");
        sqlBuilder.append("          AND (sub_acct_nbr = ?)\n");
        sqlBuilder.append("          AND (fin_obj_typ_cd IN ");
        insertionPoints.add(sqlBuilder.length());
        sqlBuilder.append("))");
        spreadRevenueSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        insertionPoints.clear();
        sqlBuilder.delete(0, sqlBuilder.length());
        sqlBuilder.append("DELETE FROM LD_BCNSTR_MONTH_T\n");
        sqlBuilder.append("WHERE (fdoc_nbr = ?)\n");
        sqlBuilder.append("  AND (univ_fiscal_yr = ?)\n");
        sqlBuilder.append("  AND (fin_coa_cd = ?)\n");
        sqlBuilder.append("  AND (account_nbr = ?)\n");
        sqlBuilder.append("  AND (sub_acct_nbr = ?)\n");
        sqlBuilder.append("  AND (fin_obj_typ_cd IN ");
        insertionPoints.add(sqlBuilder.length());
        sqlBuilder.append(")\n");
        sqlBuilder.append("AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                 FROM LD_BENEFITS_CALC_T\n");
        sqlBuilder.append("                 WHERE (LD_BENEFITS_CALC_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                   AND (LD_BENEFITS_CALC_T.FIN_COA_CD = ?)\n");
        sqlBuilder.append("                    AND (LD_BENEFITS_CALC_T.POS_FRNGBEN_OBJ_CD = LD_BCNSTR_MONTH_T.FIN_OBJECT_CD)))\n");
        spreadExpenditureSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        insertionPoints.clear();
        sqlBuilder.delete(0, sqlBuilder.length());
        sqlBuilder.append("INSERT INTO LD_BCNSTR_MONTH_T\n");
        sqlBuilder.append("(FDOC_NBR, UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD,\n");
        sqlBuilder.append(" FDOC_LN_MO1_AMT, FDOC_LN_MO2_AMT, FDOC_LN_MO3_AMT, FDOC_LN_MO4_AMT, FDOC_LN_MO5_AMT, FDOC_LN_MO6_AMT,\n");
        sqlBuilder.append(" FDOC_LN_MO7_AMT, FDOC_LN_MO8_AMT, FDOC_LN_MO9_AMT, FDOC_LN_MO10_AMT, FDOC_LN_MO11_AMT, FDOC_LN_MO12_AMT)\n");
        sqlBuilder.append("(SELECT ?, ?, ?, ?, ?, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD,\n");
        sqlBuilder.append("        ROUND((acln_annl_bal_amt / 12), 0) + \n");
        sqlBuilder.append("        (acln_annl_bal_amt - (ROUND((acln_annl_bal_amt / 12), 0) * 12)),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0),\n");
        sqlBuilder.append("        ROUND((LD_PND_BCNSTR_GL_T.acln_annl_bal_amt / 12), 0)\n");
        sqlBuilder.append("        FROM LD_PND_BCNSTR_GL_T\n");
        sqlBuilder.append("        WHERE (fdoc_nbr = ?)\n");
        sqlBuilder.append("          AND (univ_fiscal_yr = ?)\n");
        sqlBuilder.append("          AND (fin_coa_cd = ?)\n");
        sqlBuilder.append("          AND (account_nbr = ?)\n");
        sqlBuilder.append("          AND (sub_acct_nbr = ?)\n");
        sqlBuilder.append("AND (NOT EXISTS (SELECT 1\n");
        sqlBuilder.append("                 FROM LD_BENEFITS_CALC_T\n");
        sqlBuilder.append("                 WHERE (LD_BENEFITS_CALC_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("                   AND (LD_BENEFITS_CALC_T.FIN_COA_CD = ?)\n");
        sqlBuilder.append("                  AND (LD_BENEFITS_CALC_T.POS_FRNGBEN_OBJ_CD = LD_PND_BCNSTR_GL_T.FIN_OBJECT_CD)))\n");
        sqlBuilder.append("          AND (fin_obj_typ_cd IN ");
        insertionPoints.add(sqlBuilder.length());
        sqlBuilder.append("))");
        spreadExpenditureSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        insertionPoints.clear();
        sqlBuilder.delete(0, sqlBuilder.length());
        sqlBuilder.append("SELECT COUNT(*)\n");
        sqlBuilder.append("FROM (LD_BCNSTR_MONTH_T INNER JOIN LD_LBR_OBJ_BENE_T\n");
        sqlBuilder.append("  ON ((LD_BCNSTR_MONTH_T.UNIV_FISCAL_YR = LD_LBR_OBJ_BENE_T.UNIV_FISCAL_YR) AND\n");
        sqlBuilder.append("      (LD_BCNSTR_MONTH_T.FIN_COA_CD = LD_LBR_OBJ_BENE_T.FIN_COA_CD) AND\n");
        sqlBuilder.append("      (LD_BCNSTR_MONTH_T.FIN_OBJECT_CD = LD_LBR_OBJ_BENE_T.FIN_OBJECT_CD)))\n");
        sqlBuilder.append("WHERE (LD_BCNSTR_MONTH_T.FDOC_NBR = ?)\n");
        sqlBuilder.append("  AND (LD_BCNSTR_MONTH_T.UNIV_FISCAL_YR = ?)\n");
        sqlBuilder.append("  AND (LD_BCNSTR_MONTH_T.FIN_COA_CD = ?)\n");
        sqlBuilder.append("  AND (LD_BCNSTR_MONTH_T.ACCOUNT_NBR = ?)\n");
        sqlBuilder.append("  AND (LD_BCNSTR_MONTH_T.SUB_ACCT_NBR = ?)\n");
        sqlBuilder.append("  AND (LD_BCNSTR_MONTH_T.FIN_OBJ_TYP_CD IN ");
        insertionPoints.add(sqlBuilder.length());
        sqlBuilder.append(")\n");
        spreadExpenditureSql.add(new SQLForStep(sqlBuilder, insertionPoints));
        insertionPoints.clear();
    }

    @Override
    public void deleteBudgetConstructionMonthlyBudgetsRevenue(String documentNumber, Integer fiscalYear, String chartCode, String accountNumber, String subAccountNumber, String revenueINList) {
        ArrayList<String> inSqlString = new ArrayList<String>();
        inSqlString.add(revenueINList);
        int returnCount = this.getSimpleJdbcTemplate().update(deleteAllSql.get(0).getSQL(inSqlString), new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber});
        LOG.warn((Object)String.format("\n%s\n Expenditure (all) rows deleted for (%s,%d,%s,%s,%s) = %d", this.getDbPlatform().toString(), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, returnCount));
    }

    @Override
    public void deleteBudgetConstructionMonthlyBudgetsExpenditure(String documentNumber, Integer fiscalYear, String chartCode, String accountNumber, String subAccountNumber, String expenditureINList) {
        ArrayList<String> inSqlString = new ArrayList<String>();
        inSqlString.add(expenditureINList);
        int returnCount = this.getSimpleJdbcTemplate().update(deleteAllSql.get(1).getSQL(inSqlString), new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber});
        LOG.warn((Object)String.format("\n%s\n Expenditure (all) rows deleted for (%s,%d,%s,%s,%s) = %d", this.getDbPlatform().toString(), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, returnCount));
    }

    @Override
    public void spreadBudgetConstructionMonthlyBudgetsRevenue(String documentNumber, Integer fiscalYear, String chartCode, String accountNumber, String subAccountNumber, String revenueINList) {
        ArrayList<String> inSqlString = new ArrayList<String>();
        inSqlString.add(revenueINList);
        int returnCount = this.getSimpleJdbcTemplate().update(spreadRevenueSql.get(0).getSQL(inSqlString), new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber});
        LOG.warn((Object)String.format("\n%s\n RevenueSpread rows deleted for (%s,%d,%s,%s,%s) = %d", this.getDbPlatform().toString(), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, returnCount));
        returnCount = this.getSimpleJdbcTemplate().update(spreadRevenueSql.get(1).getSQL(inSqlString), new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber});
        LOG.warn((Object)String.format("\n%s\n RevenueSpread rows inserted for (%s,%d,%s,%s,%s) = %d", this.getDbPlatform().toString(), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, returnCount));
    }

    @Override
    public boolean spreadBudgetConstructionMonthlyBudgetsExpenditure(String documentNumber, Integer fiscalYear, String chartCode, String accountNumber, String subAccountNumber, String expenditureINList) {
        ArrayList<String> inSqlString = new ArrayList<String>();
        inSqlString.add(expenditureINList);
        int returnCount = this.getSimpleJdbcTemplate().update(spreadExpenditureSql.get(0).getSQL(inSqlString), new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, fiscalYear, chartCode});
        LOG.warn((Object)String.format("\n%s\n ExpenditureSpread rows deleted for (%s,%d,%s,%s,%s) = %d", this.getDbPlatform().toString(), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, returnCount));
        returnCount = this.getSimpleJdbcTemplate().update(spreadExpenditureSql.get(1).getSQL(inSqlString), new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, fiscalYear, chartCode});
        LOG.warn((Object)String.format("\n%s\n ExpenditureSpread rows inserted for (%s,%d,%s,%s,%s) = %d", this.getDbPlatform().toString(), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber, returnCount));
        return this.budgetConstructionMonthlyBudgetContainsBenefitsExpenditure(spreadExpenditureSql.get(2).getSQL(inSqlString), documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber);
    }

    protected boolean budgetConstructionMonthlyBudgetContainsBenefitsExpenditure(String BenefitsObjectsCheckSQL, String documentNumber, Integer fiscalYear, String chartCode, String accountNumber, String subAccountNumber) {
        Long numberOfBenefitsEligibleRows = this.getSimpleJdbcTemplate().queryForLong(BenefitsObjectsCheckSQL, new Object[]{documentNumber, fiscalYear, chartCode, accountNumber, subAccountNumber});
        return numberOfBenefitsEligibleRows != 0L;
    }
}

