/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.dataaccess.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.batch.dataaccess.impl.SQLForStep;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionSalarySummaryReportDao;
import org.kuali.kfs.module.bc.document.dataaccess.impl.BudgetConstructionDaoJdbcBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class BudgetConstructionSalarySummaryReportDaoJdbc
extends BudgetConstructionDaoJdbcBase
implements BudgetConstructionSalarySummaryReportDao {
    private static Logger LOG = Logger.getLogger(BudgetConstructionSalarySummaryReportDaoJdbc.class);
    protected static ArrayList<SQLForStep> updateReportsSalarySummaryThreshold = new ArrayList(7);
    protected static ArrayList<SQLForStep> salarySummaryAboveThreshold = new ArrayList(1);
    protected static ArrayList<SQLForStep> salarySummaryBelowThreshold = new ArrayList(1);
    protected static ArrayList<SQLForStep> updateReportsSalarySummaryNoThresholdReason = new ArrayList(1);
    protected static ArrayList<SQLForStep> updateReportsSalarySummaryNoThresholdNoReason = new ArrayList(1);
    protected static ArrayList<SQLForStep> updateReportsSalarySummaryCommon = new ArrayList(2);

    public BudgetConstructionSalarySummaryReportDaoJdbc() {
        ArrayList<Integer> insertionPoints = new ArrayList<Integer>(10);
        StringBuilder sqlText = new StringBuilder(1500);
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM01_MT \n");
        sqlText.append(" (SESID, EMPLID, POSITION_NBR, SAL_AMT, SAL_PCT, SAL_MTHS, POS_CSF_AMT, POS_CSF_TM_PCT, SAL_PMTHS) \n");
        sqlText.append("SELECT ?, bcaf.emplid, bcaf.position_nbr,  bcaf.appt_rqst_amt, bcaf.appt_rqst_tm_pct, bcaf.appt_fnd_mo, bcsf.pos_csf_amt, bcsf.pos_csf_tm_pct, posn.iu_pay_months \n");
        sqlText.append("FROM (LD_PNDBC_APPTFND_T bcaf LEFT OUTER JOIN LD_BCN_CSF_TRCKR_T bcsf \n");
        sqlText.append(" ON ((bcaf.fin_coa_cd = bcsf.fin_coa_cd) AND (bcaf.account_nbr = bcsf.account_nbr) \n");
        sqlText.append(" AND(bcaf.sub_acct_nbr = bcsf.sub_acct_nbr) AND (bcaf.fin_object_cd = bcsf.fin_object_cd) \n");
        sqlText.append(" AND(bcaf.fin_sub_obj_cd = bcsf.fin_sub_obj_cd) AND (bcaf.position_nbr = bcsf.position_nbr)\n");
        sqlText.append(" AND(bcaf.emplid = bcsf.emplid) AND (bcaf.univ_fiscal_yr= bcsf.univ_fiscal_yr))),\n");
        sqlText.append("      LD_BCN_POS_T posn, LD_BCN_CTRL_LIST_T ctrl, LD_BCN_OBJ_PICK_T pick\n");
        sqlText.append("WHERE ctrl.person_unvl_id = ? \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = ctrl.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.fin_coa_cd = ctrl.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = ctrl.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = ctrl.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.emplid <> '");
        insertionPoints.add(sqlText.length());
        sqlText.append("' \n");
        sqlText.append(" AND bcaf.appt_fnd_dur_cd = '");
        insertionPoints.add(sqlText.length());
        sqlText.append("' \n");
        sqlText.append(" AND bcaf.fin_object_cd = pick.fin_object_cd \n");
        sqlText.append(" AND pick.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND pick.select_flag > 0 \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = posn.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.position_nbr = posn.position_nbr \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText, insertionPoints));
        sqlText.delete(0, sqlText.length());
        insertionPoints.clear();
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM01_MT \n");
        sqlText.append("(SESID, EMPLID, POSITION_NBR, SAL_AMT, SAL_PCT, SAL_MTHS, \n");
        sqlText.append(" POS_CSF_AMT, POS_CSF_TM_PCT, SAL_PMTHS) \n");
        sqlText.append("SELECT ?, bcaf.emplid, bcaf.position_nbr, bcaf.appt_rqst_csf_amt, bcaf.appt_rqcsf_tm_pct, posn.iu_norm_work_months, \n");
        sqlText.append("  bcsf.pos_csf_amt, bcsf.pos_csf_tm_pct, posn.iu_pay_months \n");
        sqlText.append("FROM (LD_PNDBC_APPTFND_T bcaf LEFT OUTER JOIN LD_BCN_CSF_TRCKR_T bcsf \n");
        sqlText.append(" ON ((bcaf.fin_coa_cd = bcsf.fin_coa_cd) AND (bcaf.account_nbr = bcsf.account_nbr) \n");
        sqlText.append("AND (bcaf.sub_acct_nbr = bcsf.sub_acct_nbr) AND (bcaf.fin_object_cd = bcsf.fin_object_cd) \n");
        sqlText.append("AND (bcaf.fin_sub_obj_cd = bcsf.fin_sub_obj_cd) AND (bcaf.position_nbr = bcsf.position_nbr) \n");
        sqlText.append("AND (bcaf.emplid = bcsf.emplid) AND (bcaf.univ_fiscal_yr= bcsf.univ_fiscal_yr))), LD_BCN_POS_T posn, LD_BCN_CTRL_LIST_T ctrl, LD_BCN_OBJ_PICK_T pick \n");
        sqlText.append("WHERE ctrl.person_unvl_id = ? \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = ctrl.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.fin_coa_cd = ctrl.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = ctrl.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = ctrl.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.emplid <> '\n");
        insertionPoints.add(sqlText.length());
        sqlText.append("' \n");
        sqlText.append(" AND bcaf.appt_fnd_dur_cd <> '");
        insertionPoints.add(sqlText.length());
        sqlText.append("' \n");
        sqlText.append(" AND bcaf.fin_object_cd = pick.fin_object_cd \n");
        sqlText.append(" AND pick.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND pick.select_flag > 0 \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = posn.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.position_nbr = posn.position_nbr \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText, insertionPoints));
        sqlText.delete(0, sqlText.length());
        insertionPoints.clear();
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM02_MT \n");
        sqlText.append("(SESID, EMPLID, SAL_MTHS, SAL_PMTHS) \n");
        sqlText.append("SELECT DISTINCT ?, sd.emplid, sd.sal_mths, sd.sal_pmths \n");
        sqlText.append("FROM LD_BCN_BUILD_SALSUMM01_MT sd \n");
        sqlText.append("WHERE sesid = ? \n");
        sqlText.append("AND sd.sal_amt = (SELECT max(sd2.sal_amt) \n");
        sqlText.append("                  FROM LD_BCN_BUILD_SALSUMM01_MT sd2\n");
        sqlText.append("                  WHERE sd2.sesid = sd.sesid AND sd2.emplid = sd.emplid)\n");
        sqlText.append("AND sd.sal_mths = (SELECT max(sd4.sal_mths) \n");
        sqlText.append("                  FROM LD_BCN_BUILD_SALSUMM01_MT sd4\n");
        sqlText.append("                  WHERE sd4.sesid = sd.sesid AND sd4.emplid = sd.emplid AND sd4.sal_amt = sd.sal_amt)\n");
        sqlText.append("AND sd.position_nbr = (SELECT min(sd3.position_nbr) \n");
        sqlText.append("                       FROM LD_BCN_BUILD_SALSUMM01_MT sd3\n");
        sqlText.append("                       WHERE sd3.sesid = sd.sesid  \n");
        sqlText.append("                         AND sd3.emplid = sd.emplid AND sd3.sal_amt = sd.sal_amt AND sd3.sal_mths = sd.sal_mths) \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM03_MT\n");
        sqlText.append("(SESID, EMPLID, CSF_MTHS, CSF_PMTHS) \n");
        sqlText.append("SELECT DISTINCT ?, sd.emplid, p.iu_norm_work_months, p.iu_pay_months \n");
        sqlText.append("FROM LD_BCN_BUILD_SALSUMM01_MT sd, LD_BCN_POS_T p \n");
        sqlText.append("WHERE sesid = ? \n");
        sqlText.append(" AND sd.pos_csf_amt = (SELECT max(sd2.pos_csf_amt)  \n");
        sqlText.append("                       FROM LD_BCN_BUILD_SALSUMM01_MT sd2\n");
        sqlText.append("                       WHERE sd2.sesid = sd.sesid AND sd2.emplid = sd.emplid) \n");
        sqlText.append(" AND sd.position_nbr = (SELECT min(sd3.position_nbr) \n");
        sqlText.append("                        FROM LD_BCN_BUILD_SALSUMM01_MT sd3\n");
        sqlText.append("                        WHERE sd3.sesid = sd.sesid AND sd3.emplid = sd.emplid AND sd3.pos_csf_amt = sd.pos_csf_amt) \n");
        sqlText.append(" AND p.univ_fiscal_yr = ? AND p.position_nbr = sd.position_nbr \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM04_MT \n");
        sqlText.append("(SESID, EMPLID, POS_CSF_AMT, RES_CSF_AMT, POS_CSF_TM_PCT, \n");
        sqlText.append(" SAL_AMT, SAL_PCT, SAL_MTHS, SAL_PMTHS, CSF_MTHS, CSF_PMTHS) \n");
        sqlText.append("SELECT ?, sm.emplid, SUM(COALESCE(sd.pos_csf_amt,0)), 0, SUM(COALESCE(sd.pos_csf_tm_pct,0)), \n");
        sqlText.append(" SUM(COALESCE(sd.sal_amt,0)), SUM(COALESCE(sd.sal_pct,0)), sm.sal_mths, sm.sal_pmths, COALESCE(cm.csf_mths,0), COALESCE(cm.csf_pmths,0) \n");
        sqlText.append("FROM (LD_BCN_BUILD_SALSUMM02_MT sm LEFT OUTER JOIN LD_BCN_BUILD_SALSUMM03_MT cm \n");
        sqlText.append("      ON ((sm.sesid = cm.sesid) AND (sm.emplid = cm.emplid))),\n");
        sqlText.append("      LD_BCN_BUILD_SALSUMM01_MT sd \n");
        sqlText.append("WHERE sm.sesid = ? \n");
        sqlText.append(" AND sd.sesid = sm.sesid \n");
        sqlText.append(" AND sd.emplid = sm.emplid \n");
        sqlText.append("GROUP BY sm.emplid, sm.sal_mths, sm.sal_pmths, cm.csf_mths, cm.csf_pmths \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("UPDATE LD_BCN_BUILD_SALSUMM04_MT \n");
        sqlText.append("SET res_csf_amt = ROUND(COALESCE(((pos_csf_amt * sal_pct * sal_mths * csf_pmths) \n");
        sqlText.append(" / (pos_csf_tm_pct * csf_mths * sal_pmths)), 0.00),0) \n");
        sqlText.append("WHERE sesid = ? AND pos_csf_tm_pct <> 0 AND csf_mths <> 0 AND sal_pmths <> 0 \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("UPDATE LD_BCN_BUILD_SALSUMM04_MT \n");
        sqlText.append("SET res_csf_amt = ROUND(COALESCE(((res_csf_amt * sal_pmths) / csf_pmths), 0.00),0) \n");
        sqlText.append("WHERE sesid = ? AND sal_pmths <> csf_pmths AND csf_pmths <> 0 \n");
        updateReportsSalarySummaryThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM05_MT \n");
        sqlText.append("(SESID, EMPLID) \n");
        sqlText.append("SELECT ?, emplid \n");
        sqlText.append("FROM LD_BCN_BUILD_SALSUMM04_MT \n");
        sqlText.append("WHERE sesid = ? \n");
        sqlText.append(" AND ROUND((((sal_amt - res_csf_amt) / res_csf_amt) * 100),1) >= ? \n");
        sqlText.append(" AND res_csf_amt <> 0 \n");
        sqlText.append(" AND sal_amt <> 0 \n");
        salarySummaryAboveThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM05_MT \n");
        sqlText.append("(SESID, EMPLID) \n");
        sqlText.append("SELECT ?, emplid \n");
        sqlText.append("FROM LD_BCN_BUILD_SALSUMM04_MT \n");
        sqlText.append("WHERE sesid = ? \n");
        sqlText.append(" AND ROUND((((sal_amt - res_csf_amt) / res_csf_amt) * 100),1) <= ? \n");
        sqlText.append(" AND res_csf_amt <> 0 \n");
        sqlText.append(" AND sal_amt <> 0 \n");
        salarySummaryBelowThreshold.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM05_MT\n");
        sqlText.append("(SESID, EMPLID) \n");
        sqlText.append("SELECT DISTINCT ?, bcaf.emplid  \n");
        sqlText.append("FROM LD_BCN_CTRL_LIST_T ctrl, LD_PNDBC_APPTFND_T bcaf, LD_BCN_OBJ_PICK_T pick, LD_BCN_AF_REASON_T reas, LD_BCN_RSN_CD_PK_T rpk \n");
        sqlText.append("WHERE ctrl.person_unvl_id = ? \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = ctrl.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.fin_coa_cd = ctrl.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = ctrl.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = ctrl.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.emplid <> '");
        insertionPoints.add(sqlText.length());
        sqlText.append("' \n");
        sqlText.append(" AND bcaf.fin_object_cd = pick.fin_object_cd \n");
        sqlText.append(" AND pick.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND pick.select_flag > 0 \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = reas.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.fin_coa_cd = reas.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = reas.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = reas.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.fin_object_cd = reas.fin_object_cd \n");
        sqlText.append(" AND bcaf.fin_sub_obj_cd = reas.fin_sub_obj_cd \n");
        sqlText.append(" AND bcaf.position_nbr = reas.position_nbr \n");
        sqlText.append(" AND bcaf.emplid = reas.emplid \n");
        sqlText.append(" AND reas.appt_fnd_reason_cd = rpk.appt_fnd_reason_cd \n");
        sqlText.append(" AND rpk.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND rpk.select_flag <> 0 \n");
        updateReportsSalarySummaryNoThresholdReason.add(new SQLForStep(sqlText, insertionPoints));
        sqlText.delete(0, sqlText.length());
        insertionPoints.clear();
        sqlText.append("INSERT INTO LD_BCN_BUILD_SALSUMM05_MT \n");
        sqlText.append("(SESID, EMPLID) \n");
        sqlText.append("SELECT DISTINCT ?, bcaf.emplid \n");
        sqlText.append("FROM LD_BCN_CTRL_LIST_T ctrl, LD_PNDBC_APPTFND_T bcaf, LD_BCN_OBJ_PICK_T pick \n");
        sqlText.append("WHERE ctrl.person_unvl_id = ? \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = ctrl.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.fin_coa_cd = ctrl.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = ctrl.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = ctrl.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.emplid <> '");
        insertionPoints.add(sqlText.length());
        sqlText.append("' \n");
        sqlText.append(" AND bcaf.fin_object_cd = pick.fin_object_cd \n");
        sqlText.append(" AND pick.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND pick.select_flag > 0 \n");
        updateReportsSalarySummaryNoThresholdNoReason.add(new SQLForStep(sqlText, insertionPoints));
        sqlText.delete(0, sqlText.length());
        insertionPoints.clear();
        sqlText.append("INSERT INTO LD_BCN_SAL_SSN_T \n");
        sqlText.append("(PERSON_UNVL_ID, ORG_FIN_COA_CD, ORG_CD, PERSON_NM, EMPLID)");
        sqlText.append("SELECT DISTINCT ?, ctrl.sel_org_fin_coa, ctrl.sel_org_cd, iinc.person_nm, bcaf.emplid \n");
        sqlText.append("FROM LD_BCN_CTRL_LIST_T ctrl, LD_PNDBC_APPTFND_T bcaf, LD_BCN_BUILD_SALSUMM05_MT tssn, LD_BCN_OBJ_PICK_T pick, LD_BCN_INTINCBNT_T iinc \n");
        sqlText.append("WHERE  ctrl.person_unvl_id = ? \n");
        sqlText.append(" AND bcaf.fin_coa_cd = ctrl.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = ctrl.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = ctrl.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.emplid = iinc.emplid \n");
        sqlText.append(" AND bcaf.emplid = tssn.emplid \n");
        sqlText.append(" AND tssn.sesid = ? \n");
        sqlText.append(" AND bcaf.fin_object_cd = pick.fin_object_cd \n");
        sqlText.append(" AND pick.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND pick.select_flag > 0 \n");
        updateReportsSalarySummaryCommon.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_SAL_FND_T \n");
        sqlText.append("(PERSON_UNVL_ID, EMPLID, POSITION_NBR, UNIV_FISCAL_YR, FIN_COA_CD,  \n");
        sqlText.append(" ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD) \n");
        sqlText.append("SELECT DISTINCT ?, bcaf.emplid, bcaf.position_nbr, bcaf.univ_fiscal_yr, bcaf.fin_coa_cd, \n");
        sqlText.append(" bcaf.account_nbr, bcaf.sub_acct_nbr, bcaf.fin_object_cd, bcaf.fin_sub_obj_cd \n");
        sqlText.append("FROM LD_BCN_CTRL_LIST_T ctrl, LD_PNDBC_APPTFND_T bcaf, LD_BCN_BUILD_SALSUMM05_MT tssn, LD_BCN_OBJ_PICK_T pick \n");
        sqlText.append("WHERE ctrl.person_unvl_id = ? \n");
        sqlText.append(" AND bcaf.univ_fiscal_yr = ctrl.univ_fiscal_yr \n");
        sqlText.append(" AND bcaf.fin_coa_cd = ctrl.fin_coa_cd \n");
        sqlText.append(" AND bcaf.account_nbr = ctrl.account_nbr \n");
        sqlText.append(" AND bcaf.sub_acct_nbr = ctrl.sub_acct_nbr \n");
        sqlText.append(" AND bcaf.emplid = tssn.emplid \n");
        sqlText.append(" AND tssn.sesid = ? \n");
        sqlText.append(" AND bcaf.fin_object_cd = pick.fin_object_cd \n");
        sqlText.append(" AND pick.person_unvl_id = ctrl.person_unvl_id \n");
        sqlText.append(" AND pick.select_flag > 0 \n");
        updateReportsSalarySummaryCommon.add(new SQLForStep(sqlText));
        sqlText.delete(0, sqlText.length());
    }

    protected void clearUserPreviouSalarySummaryReports(String principalName) {
        this.clearTempTableByUnvlId("LD_BCN_SAL_SSN_T", "PERSON_UNVL_ID", principalName);
        this.clearTempTableByUnvlId("LD_BCN_SAL_FND_T", "PERSON_UNVL_ID", principalName);
    }

    protected void clearCommonWorkTable(String idForSession) {
        this.clearTempTableBySesId("LD_BCN_BUILD_SALSUMM05_MT", "SESID", idForSession);
    }

    protected void clearThresholdWorkTables(String idForSession) {
        this.clearTempTableBySesId("LD_BCN_BUILD_SALSUMM01_MT", "SESID", idForSession);
        this.clearTempTableBySesId("LD_BCN_BUILD_SALSUMM02_MT", "SESID", idForSession);
        this.clearTempTableBySesId("LD_BCN_BUILD_SALSUMM03_MT", "SESID", idForSession);
        this.clearTempTableBySesId("LD_BCN_BUILD_SALSUMM04_MT", "SESID", idForSession);
    }

    protected void runCommonSQLForSalaryReports(String principalName, String idForSession) {
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryCommon.get(0).getSQL(), new Object[]{principalName, principalName, idForSession});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryCommon.get(1).getSQL(), new Object[]{principalName, principalName, idForSession});
        this.clearCommonWorkTable(idForSession);
    }

    @Override
    public void updateSalaryAndReasonSummaryReportsWithThreshold(String principalName, Integer previousFiscalYear, boolean reportGreaterThanOrEqualToThreshold, KualiDecimal threshold) {
        String idForSession = UUID.randomUUID().toString();
        this.clearUserPreviouSalarySummaryReports(principalName);
        ArrayList<String> durationCodeDefault = new ArrayList<String>(2);
        durationCodeDefault.add("VACANT");
        durationCodeDefault.add(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode);
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(0).getSQL(durationCodeDefault), new Object[]{idForSession, principalName});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(1).getSQL(durationCodeDefault), new Object[]{idForSession, principalName});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(2).getSQL(), new Object[]{idForSession, idForSession});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(3).getSQL(), new Object[]{idForSession, idForSession, previousFiscalYear});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(4).getSQL(), new Object[]{idForSession, idForSession});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(5).getSQL(), new Object[]{idForSession});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryThreshold.get(6).getSQL(), new Object[]{idForSession});
        BigDecimal thresholdValue = threshold.bigDecimalValue();
        if (reportGreaterThanOrEqualToThreshold) {
            this.getSimpleJdbcTemplate().update(salarySummaryAboveThreshold.get(0).getSQL(), new Object[]{idForSession, idForSession, thresholdValue});
        } else {
            this.getSimpleJdbcTemplate().update(salarySummaryBelowThreshold.get(0).getSQL(), new Object[]{idForSession, idForSession, thresholdValue});
        }
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryCommon.get(0).getSQL(), new Object[]{principalName, principalName, idForSession});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryCommon.get(1).getSQL(), new Object[]{principalName, principalName, idForSession});
        this.clearThresholdWorkTables(idForSession);
        this.clearCommonWorkTable(idForSession);
    }

    @Override
    public void updateSalaryAndReasonSummaryReportsWithoutThreshold(String principalName, boolean listSalariesWithReasonCodes) {
        String idForSession = UUID.randomUUID().toString();
        ArrayList<String> vacantEmplid = new ArrayList<String>(1);
        vacantEmplid.add("VACANT");
        this.clearUserPreviouSalarySummaryReports(principalName);
        if (listSalariesWithReasonCodes) {
            this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryNoThresholdReason.get(0).getSQL(vacantEmplid), new Object[]{idForSession, principalName});
        } else {
            this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryNoThresholdNoReason.get(0).getSQL(vacantEmplid), new Object[]{idForSession, principalName});
        }
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryCommon.get(0).getSQL(), new Object[]{principalName, principalName, idForSession});
        this.getSimpleJdbcTemplate().update(updateReportsSalarySummaryCommon.get(1).getSQL(), new Object[]{principalName, principalName, idForSession});
        this.clearCommonWorkTable(idForSession);
    }
}

