/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.dataaccess.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetPullupDao;
import org.kuali.kfs.module.bc.document.dataaccess.impl.BudgetConstructionDaoJdbcBase;

public class BudgetPullupDaoJdbc
extends BudgetConstructionDaoJdbcBase
implements BudgetPullupDao {
    private static Logger LOG = Logger.getLogger(BudgetPullupDaoJdbc.class);
    protected static final int MAXLEVEL = 50;
    protected static String[] initPointOfViewTemplates = new String[1];
    protected static String[] insertChildOrgTemplates = new String[2];

    public BudgetPullupDaoJdbc() {
        StringBuilder sqlText = new StringBuilder(500);
        sqlText.append("INSERT INTO LD_BCN_PULLUP_T \n");
        sqlText.append(" (PERSON_UNVL_ID, FIN_COA_CD, ORG_CD, RPTS_TO_FIN_COA_CD, RPTS_TO_ORG_CD, PULL_FLAG) \n");
        sqlText.append("SELECT ?, r.fin_coa_cd, r.org_cd, r.rpts_to_fin_coa_cd, r.rpts_to_org_cd, ? \n");
        sqlText.append("FROM LD_BCN_ORG_RPTS_T r \n");
        sqlText.append("WHERE fin_coa_cd = ? \n");
        sqlText.append("  AND org_cd = ? \n");
        BudgetPullupDaoJdbc.initPointOfViewTemplates[0] = sqlText.toString();
        sqlText.delete(0, sqlText.length());
        sqlText.append("INSERT INTO LD_BCN_PULLUP_T \n");
        sqlText.append(" (PERSON_UNVL_ID, FIN_COA_CD, ORG_CD, RPTS_TO_FIN_COA_CD, RPTS_TO_ORG_CD, PULL_FLAG) \n");
        sqlText.append("SELECT ?, r.fin_coa_cd, r.org_cd, r.rpts_to_fin_coa_cd, r.rpts_to_org_cd, ? \n");
        sqlText.append("FROM LD_BCN_ORG_RPTS_T r, LD_BCN_PULLUP_T p, CA_ORG_T o \n");
        sqlText.append("WHERE p.person_unvl_id = ? \n");
        sqlText.append("  AND p.pull_flag = ? \n");
        sqlText.append("  AND p.fin_coa_cd = r.rpts_to_fin_coa_cd \n");
        sqlText.append("  AND p.org_cd = r.rpts_to_org_cd \n");
        sqlText.append("  AND not (r.fin_coa_cd = r.rpts_to_fin_coa_cd and r.org_cd = r.rpts_to_org_cd)");
        sqlText.append("  AND o.fin_coa_cd = r.fin_coa_cd \n");
        sqlText.append("  AND o.org_cd = r.org_cd \n");
        sqlText.append("  AND o.org_active_cd = 'Y' \n");
        BudgetPullupDaoJdbc.insertChildOrgTemplates[0] = sqlText.toString();
        sqlText.delete(0, sqlText.length());
        sqlText.append("UPDATE LD_BCN_PULLUP_T \n");
        sqlText.append("SET pull_flag = 0 \n");
        sqlText.append("WHERE person_unvl_id = ? \n");
        BudgetPullupDaoJdbc.insertChildOrgTemplates[1] = sqlText.toString();
    }

    @Override
    public void buildSubTree(String principalName, String chartOfAccountsCode, String organizationCode, int currentLevel) {
        this.initPointOfView(principalName, chartOfAccountsCode, organizationCode, currentLevel);
        this.insertChildOrgs(principalName, currentLevel);
    }

    protected void initPointOfView(String principalName, String chartOfAccountsCode, String organizationCode, int currentLevel) {
        LOG.debug((Object)"initPointOfView() called");
        this.getSimpleJdbcTemplate().update(initPointOfViewTemplates[0], new Object[]{principalName, currentLevel, chartOfAccountsCode, organizationCode});
    }

    protected void insertChildOrgs(String principalName, int previousLevel) {
        LOG.debug((Object)"insertChildOrgs() called");
        if (previousLevel <= 50) {
            int currentLevel = previousLevel + 1;
            int rowsAffected = this.getSimpleJdbcTemplate().update(insertChildOrgTemplates[0], new Object[]{principalName, currentLevel, principalName, previousLevel});
            if (rowsAffected > 0) {
                this.insertChildOrgs(principalName, currentLevel);
            } else {
                this.getSimpleJdbcTemplate().update(insertChildOrgTemplates[1], new Object[]{principalName});
            }
        } else {
            LOG.warn((Object)String.format("\nWarning: One or more selected organizations have reporting organizations more than maxlevel of %d deep.", 50));
        }
    }

    @Override
    public void cleanGeneralLedgerObjectSummaryTable(String principalName) {
        this.clearTempTableByUnvlId("LD_BCN_PULLUP_T", "PERSON_UNVL_ID", principalName);
    }
}

