/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAdministrativePost;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgPositionFundingDetailReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgPositionFundingDetailReportTotal;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPositionFunding;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReportThresholdSettings;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionPositionFundingDetailReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionPositionFundingDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionPositionFundingDetailReportServiceImpl
implements BudgetConstructionPositionFundingDetailReportService {
    protected BudgetConstructionPositionFundingDetailReportDao budgetConstructionPositionFundingDetailReportDao;
    protected ConfigurationService kualiConfigurationService;
    protected BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper;
    protected SalarySettingService salarySettingService;

    @Override
    public void updatePositionFundingDetailReport(String principalName, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        boolean applyAThreshold = budgetConstructionReportThresholdSettings.isUseThreshold();
        boolean selectOnlyGreaterThanOrEqualToThreshold = budgetConstructionReportThresholdSettings.isUseGreaterThanOperator();
        KualiDecimal thresholdPercent = budgetConstructionReportThresholdSettings.getThresholdPercent();
        this.budgetConstructionPositionFundingDetailReportDao.updateReportsPositionFundingDetailTable(principalName, applyAThreshold, selectOnlyGreaterThanOrEqualToThreshold, thresholdPercent);
    }

    @Override
    public Collection<BudgetConstructionOrgPositionFundingDetailReport> buildReports(Integer universityFiscalYear, String principalName) {
        ArrayList<BudgetConstructionOrgPositionFundingDetailReport> reportSet = new ArrayList<BudgetConstructionOrgPositionFundingDetailReport>();
        Collection positionFundingDetailList = this.budgetConstructionReportsServiceHelper.getDataForBuildingReports(BudgetConstructionPositionFunding.class, principalName, this.buildOrderByList());
        List listForCalculateTotalPerson = BudgetConstructionReportHelper.deleteDuplicated((List)positionFundingDetailList, this.fieldsForPerson());
        List listForCalculateTotalOrg = BudgetConstructionReportHelper.deleteDuplicated((List)positionFundingDetailList, this.fieldsForOrg());
        Collection<BudgetConstructionOrgPositionFundingDetailReportTotal> fundingDetailTotalPerson = this.calculatePersonTotal(positionFundingDetailList, listForCalculateTotalPerson);
        Collection<BudgetConstructionOrgPositionFundingDetailReportTotal> fundingDetailTotalOrg = this.calculateOrgTotal(positionFundingDetailList, listForCalculateTotalOrg);
        String objectCodes = this.budgetConstructionReportsServiceHelper.getSelectedObjectCodes(principalName);
        for (BudgetConstructionPositionFunding positionFundingDetailEntry : positionFundingDetailList) {
            BudgetConstructionOrgPositionFundingDetailReport orgPositionFundingDetailReportEntry = new BudgetConstructionOrgPositionFundingDetailReport();
            this.buildReportsHeader(universityFiscalYear, objectCodes, orgPositionFundingDetailReportEntry, positionFundingDetailEntry);
            this.buildReportsBody(universityFiscalYear, orgPositionFundingDetailReportEntry, positionFundingDetailEntry);
            this.buildReportsTotal(orgPositionFundingDetailReportEntry, positionFundingDetailEntry, fundingDetailTotalPerson, fundingDetailTotalOrg);
            reportSet.add(orgPositionFundingDetailReportEntry);
        }
        return reportSet;
    }

    public void buildReportsHeader(Integer universityFiscalYear, String objectCodes, BudgetConstructionOrgPositionFundingDetailReport orgPositionFundingDetailReportEntry, BudgetConstructionPositionFunding positionFundingDetail) {
        String chartDesc = positionFundingDetail.getSelectedOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        String orgName = positionFundingDetail.getSelectedOrganization().getOrganizationName();
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgPositionFundingDetailReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgPositionFundingDetailReportEntry.setOrganizationCode(positionFundingDetail.getSelectedOrganizationCode());
        if (orgName == null) {
            orgPositionFundingDetailReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgPositionFundingDetailReportEntry.setOrganizationName(orgName);
        }
        orgPositionFundingDetailReportEntry.setOrgChartOfAccountsCode(positionFundingDetail.getSelectedOrganizationChartOfAccountsCode());
        if (chartDesc == null) {
            orgPositionFundingDetailReportEntry.setOrgChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgPositionFundingDetailReportEntry.setOrgChartOfAccountDescription(chartDesc);
        }
        orgPositionFundingDetailReportEntry.setReqFy(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgPositionFundingDetailReportEntry.setFinancialObjectCode(positionFundingDetail.getFinancialObjectCode());
        orgPositionFundingDetailReportEntry.setObjectCodes(objectCodes);
    }

    public void buildReportsBody(Integer universityFiscalYear, BudgetConstructionOrgPositionFundingDetailReport detailReportEntry, BudgetConstructionPositionFunding positionFundingDetailEntry) {
        PendingBudgetConstructionAppointmentFunding appointmentFundingEntry = positionFundingDetailEntry.getPendingAppointmentFunding();
        BudgetConstructionIntendedIncumbent budgetConstructionIntendedIncumbent = this.budgetConstructionReportsServiceHelper.getBudgetConstructionIntendedIncumbent(appointmentFundingEntry);
        BudgetConstructionAdministrativePost budgetConstructionAdministrativePost = this.budgetConstructionReportsServiceHelper.getBudgetConstructionAdministrativePost(appointmentFundingEntry);
        BudgetConstructionPosition budgetConstructionPosition = this.budgetConstructionReportsServiceHelper.getBudgetConstructionPosition(universityFiscalYear, appointmentFundingEntry);
        detailReportEntry.setChartOfAccountsCode(positionFundingDetailEntry.getChartOfAccountsCode());
        detailReportEntry.setAccountNumber(positionFundingDetailEntry.getAccountNumber());
        detailReportEntry.setSubAccountNumber(positionFundingDetailEntry.getSubAccountNumber());
        detailReportEntry.setFinancialSubObjectCode(positionFundingDetailEntry.getFinancialSubObjectCode());
        if (positionFundingDetailEntry.getName() != null) {
            int nameLength = positionFundingDetailEntry.getName().length();
            detailReportEntry.setName(positionFundingDetailEntry.getName().substring(0, nameLength > 35 ? 35 : nameLength));
            if (budgetConstructionIntendedIncumbent != null) {
                if (budgetConstructionIntendedIncumbent.getIuClassificationLevel() == null) {
                    detailReportEntry.setCls("UnDf");
                } else {
                    detailReportEntry.setCls(budgetConstructionIntendedIncumbent.getIuClassificationLevel());
                }
            }
        } else {
            detailReportEntry.setName("VACANT");
            detailReportEntry.setCls("");
        }
        if (budgetConstructionAdministrativePost != null) {
            detailReportEntry.setAdministrativePost(budgetConstructionAdministrativePost.getAdministrativePost());
        }
        if (budgetConstructionPosition != null) {
            detailReportEntry.setPositionNumber(budgetConstructionPosition.getPositionNumber());
            detailReportEntry.setNormalWorkMonthsAndiuPayMonths(budgetConstructionPosition.getIuNormalWorkMonths() + "/" + budgetConstructionPosition.getIuPayMonths());
            detailReportEntry.setPositionFte(BudgetConstructionReportHelper.setDecimalDigit(budgetConstructionPosition.getPositionFullTimeEquivalency(), 2, false));
            detailReportEntry.setPositionSalaryPlanDefault(budgetConstructionPosition.getPositionSalaryPlanDefault());
            detailReportEntry.setPositionGradeDefault(budgetConstructionPosition.getPositionGradeDefault());
            detailReportEntry.setPositionStandardHoursDefault(budgetConstructionPosition.getPositionStandardHoursDefault());
        }
        BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFundingEntry.getEffectiveCSFTracker();
        detailReportEntry.setAmountChange(new Integer(0));
        detailReportEntry.setPercentChange(BigDecimal.ZERO);
        if (csfTracker != null) {
            detailReportEntry.setCsfFundingStatusCode(csfTracker.getCsfFundingStatusCode());
            detailReportEntry.setCsfTimePercent(BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfTimePercent(), 2, false));
            detailReportEntry.setCsfAmount(new Integer(csfTracker.getCsfAmount().intValue()));
            detailReportEntry.setCsfFullTimeEmploymentQuantity(BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfFullTimeEmploymentQuantity(), 5, false));
            Integer amountChange = new Integer(0);
            BigDecimal percentChange = BigDecimal.ZERO;
            BigDecimal csfFte = BudgetConstructionReportHelper.setDecimalDigit(csfTracker.getCsfFullTimeEmploymentQuantity(), 5, false);
            BigDecimal reqFte = BudgetConstructionReportHelper.setDecimalDigit(appointmentFundingEntry.getAppointmentRequestedFteQuantity(), 5, false);
            if (reqFte.compareTo(csfFte) == 0) {
                amountChange = appointmentFundingEntry.getAppointmentRequestedAmount().subtract(csfTracker.getCsfAmount()).intValue();
                percentChange = BudgetConstructionReportHelper.calculatePercent(new BigDecimal(amountChange), csfTracker.getCsfAmount().bigDecimalValue());
            }
            detailReportEntry.setAmountChange(amountChange);
            detailReportEntry.setPercentChange(BudgetConstructionReportHelper.calculatePercent(new BigDecimal(amountChange), csfTracker.getCsfAmount().bigDecimalValue()));
        }
        if (appointmentFundingEntry != null) {
            detailReportEntry.setFinancialSubObjectCode(appointmentFundingEntry.getFinancialSubObjectCode());
            detailReportEntry.setAppointmentFundingMonth(appointmentFundingEntry.getAppointmentFundingMonth());
            detailReportEntry.setAppointmentRequestedAmount(new Integer(appointmentFundingEntry.getAppointmentRequestedAmount().intValue()));
            detailReportEntry.setAppointmentRequestedTimePercent(BudgetConstructionReportHelper.setDecimalDigit(appointmentFundingEntry.getAppointmentRequestedTimePercent(), 2, false));
            detailReportEntry.setAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(appointmentFundingEntry.getAppointmentRequestedFteQuantity(), 5, false));
            if (this.salarySettingService.isHourlyPaidObject(appointmentFundingEntry.getUniversityFiscalYear(), appointmentFundingEntry.getChartOfAccountsCode(), appointmentFundingEntry.getFinancialObjectCode())) {
                detailReportEntry.setAppointmentRequestedPayRate(appointmentFundingEntry.getAppointmentRequestedPayRate());
            }
            detailReportEntry.setAppointmentFundingDurationCode(appointmentFundingEntry.getAppointmentFundingDurationCode());
            detailReportEntry.setAppointmentRequestedCsfAmount(BudgetConstructionReportHelper.convertKualiInteger(appointmentFundingEntry.getAppointmentRequestedCsfAmount()));
            detailReportEntry.setAppointmentRequestedCsfTimePercent(BudgetConstructionReportHelper.setDecimalDigit(appointmentFundingEntry.getAppointmentRequestedCsfTimePercent(), 2, false));
            detailReportEntry.setAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(appointmentFundingEntry.getAppointmentRequestedCsfFteQuantity(), 5, false));
            detailReportEntry.setAppointmentTotalIntendedAmount(BudgetConstructionReportHelper.convertKualiInteger(appointmentFundingEntry.getAppointmentTotalIntendedAmount()));
            detailReportEntry.setAppointmentTotalIntendedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(appointmentFundingEntry.getAppointmentTotalIntendedFteQuantity(), 5, false));
            detailReportEntry.setEmplid(appointmentFundingEntry.getEmplid());
        }
        if (appointmentFundingEntry.isAppointmentFundingDeleteIndicator()) {
            detailReportEntry.setDeleteBox("*");
        } else {
            detailReportEntry.setDeleteBox("");
        }
    }

    public void buildReportsTotal(BudgetConstructionOrgPositionFundingDetailReport orgPositionFundingDetailReportEntry, BudgetConstructionPositionFunding positionFundingDetail, Collection<BudgetConstructionOrgPositionFundingDetailReportTotal> fundingDetailTotalPerson, Collection<BudgetConstructionOrgPositionFundingDetailReportTotal> fundingDetailTotalOrg) {
        for (BudgetConstructionOrgPositionFundingDetailReportTotal fundingDetailTotalPersonEntry : fundingDetailTotalPerson) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)fundingDetailTotalPersonEntry.getBudgetConstructionPositionFunding(), (BusinessObject)positionFundingDetail, this.fieldsForPerson())) continue;
            orgPositionFundingDetailReportEntry.setTotalPersonPositionCsfAmount(fundingDetailTotalPersonEntry.getTotalPersonPositionCsfAmount());
            orgPositionFundingDetailReportEntry.setTotalPersonAppointmentRequestedAmount(fundingDetailTotalPersonEntry.getTotalPersonAppointmentRequestedAmount());
            orgPositionFundingDetailReportEntry.setTotalPersonPositionCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(fundingDetailTotalPersonEntry.getTotalPersonPositionCsfFteQuantity(), 5, false));
            orgPositionFundingDetailReportEntry.setTotalPersonAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(fundingDetailTotalPersonEntry.getTotalPersonAppointmentRequestedFteQuantity(), 5, false));
            orgPositionFundingDetailReportEntry.setTotalPersonAmountChange(new Integer(0));
            orgPositionFundingDetailReportEntry.setTotalPersonPercentChange(BigDecimal.ZERO);
            BigDecimal csfFte = BudgetConstructionReportHelper.setDecimalDigit(fundingDetailTotalPersonEntry.getTotalPersonPositionCsfFteQuantity(), 5, false);
            BigDecimal reqFte = BudgetConstructionReportHelper.setDecimalDigit(fundingDetailTotalPersonEntry.getTotalPersonAppointmentRequestedFteQuantity(), 5, false);
            if (csfFte.compareTo(reqFte) == 0) {
                Integer amountChange = fundingDetailTotalPersonEntry.getTotalPersonAppointmentRequestedAmount() - fundingDetailTotalPersonEntry.getTotalPersonPositionCsfAmount();
                BigDecimal percentChange = BigDecimal.ZERO;
                orgPositionFundingDetailReportEntry.setTotalPersonAmountChange(amountChange);
                if (!fundingDetailTotalPersonEntry.getTotalPersonPositionCsfAmount().equals(new Integer(0))) {
                    percentChange = BudgetConstructionReportHelper.calculatePercent(amountChange, (int)fundingDetailTotalPersonEntry.getTotalPersonPositionCsfAmount());
                }
                orgPositionFundingDetailReportEntry.setTotalPersonPercentChange(percentChange);
            }
            orgPositionFundingDetailReportEntry.setPersonSortCode(fundingDetailTotalPersonEntry.getPersonSortCode());
        }
        for (BudgetConstructionOrgPositionFundingDetailReportTotal fundingDetailTotalOrgEntry : fundingDetailTotalOrg) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)fundingDetailTotalOrgEntry.getBudgetConstructionPositionFunding(), (BusinessObject)positionFundingDetail, this.fieldsForOrg())) continue;
            orgPositionFundingDetailReportEntry.setTotalOrgPositionCsfAmount(fundingDetailTotalOrgEntry.getTotalOrgPositionCsfAmount());
            orgPositionFundingDetailReportEntry.setTotalOrgAppointmentRequestedAmount(fundingDetailTotalOrgEntry.getTotalOrgAppointmentRequestedAmount());
            orgPositionFundingDetailReportEntry.setTotalOrgPositionCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(fundingDetailTotalOrgEntry.getTotalOrgPositionCsfFteQuantity(), 5, false));
            orgPositionFundingDetailReportEntry.setTotalOrgAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(fundingDetailTotalOrgEntry.getTotalOrgAppointmentRequestedFteQuantity(), 5, false));
            Integer amountChange = fundingDetailTotalOrgEntry.getTotalOrgAppointmentRequestedAmount() - fundingDetailTotalOrgEntry.getTotalOrgPositionCsfAmount();
            orgPositionFundingDetailReportEntry.setTotalOrgAmountChange(amountChange);
            orgPositionFundingDetailReportEntry.setTotalOrgPercentChange(BudgetConstructionReportHelper.calculatePercent(new BigDecimal(amountChange), new BigDecimal(fundingDetailTotalOrgEntry.getTotalOrgPositionCsfAmount())));
            if (orgPositionFundingDetailReportEntry.getPersonSortCode() != null) continue;
            orgPositionFundingDetailReportEntry.setPersonSortCode(fundingDetailTotalOrgEntry.getPersonSortCode());
        }
    }

    protected Collection<BudgetConstructionOrgPositionFundingDetailReportTotal> calculatePersonTotal(Collection<BudgetConstructionPositionFunding> positionFundingDetailList, List<BudgetConstructionPositionFunding> listForCalculateTotalPerson) {
        ArrayList<BudgetConstructionOrgPositionFundingDetailReportTotal> returnCollection = new ArrayList<BudgetConstructionOrgPositionFundingDetailReportTotal>();
        Integer totalPersonPositionCsfAmount = new Integer(0);
        Integer totalPersonAppointmentRequestedAmount = new Integer(0);
        BigDecimal totalPersonPositionCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal totalPersonAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        Integer personSortCode = new Integer(0);
        PendingBudgetConstructionAppointmentFunding pendingAppointmentFunding = null;
        for (BudgetConstructionPositionFunding budgetConstructionPositionFunding : listForCalculateTotalPerson) {
            for (BudgetConstructionPositionFunding positionFundingEntry : positionFundingDetailList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)budgetConstructionPositionFunding, (BusinessObject)positionFundingEntry, this.fieldsForPerson())) continue;
                pendingAppointmentFunding = positionFundingEntry.getPendingAppointmentFunding();
                if (pendingAppointmentFunding.getBcnCalculatedSalaryFoundationTracker().size() > 0) {
                    BudgetConstructionCalculatedSalaryFoundationTracker calculatedSalaryFoundationTracker = pendingAppointmentFunding.getBcnCalculatedSalaryFoundationTracker().get(0);
                    totalPersonPositionCsfAmount = totalPersonPositionCsfAmount + new Integer(calculatedSalaryFoundationTracker.getCsfAmount().intValue());
                    totalPersonPositionCsfFteQuantity = totalPersonPositionCsfFteQuantity.add(calculatedSalaryFoundationTracker.getCsfFullTimeEmploymentQuantity());
                }
                if (pendingAppointmentFunding != null) {
                    totalPersonAppointmentRequestedAmount = totalPersonAppointmentRequestedAmount + new Integer(pendingAppointmentFunding.getAppointmentRequestedAmount().intValue());
                    totalPersonAppointmentRequestedFteQuantity = totalPersonAppointmentRequestedFteQuantity.add(pendingAppointmentFunding.getAppointmentRequestedFteQuantity());
                }
                personSortCode = personSortCode + 1;
            }
            BudgetConstructionOrgPositionFundingDetailReportTotal budgetConstructionOrgPositionFundingDetailReportTotal = new BudgetConstructionOrgPositionFundingDetailReportTotal();
            budgetConstructionOrgPositionFundingDetailReportTotal.setBudgetConstructionPositionFunding(budgetConstructionPositionFunding);
            budgetConstructionOrgPositionFundingDetailReportTotal.setTotalPersonPositionCsfAmount(totalPersonPositionCsfAmount);
            budgetConstructionOrgPositionFundingDetailReportTotal.setTotalPersonPositionCsfFteQuantity(totalPersonPositionCsfFteQuantity);
            budgetConstructionOrgPositionFundingDetailReportTotal.setTotalPersonAppointmentRequestedAmount(totalPersonAppointmentRequestedAmount);
            budgetConstructionOrgPositionFundingDetailReportTotal.setTotalPersonAppointmentRequestedFteQuantity(totalPersonAppointmentRequestedFteQuantity);
            if (personSortCode > 1) {
                budgetConstructionOrgPositionFundingDetailReportTotal.setPersonSortCode(new Integer(1));
            }
            returnCollection.add(budgetConstructionOrgPositionFundingDetailReportTotal);
            totalPersonPositionCsfAmount = new Integer(0);
            totalPersonAppointmentRequestedAmount = new Integer(0);
            totalPersonPositionCsfFteQuantity = BigDecimal.ZERO;
            totalPersonAppointmentRequestedFteQuantity = BigDecimal.ZERO;
            personSortCode = new Integer(0);
        }
        return returnCollection;
    }

    protected Collection<BudgetConstructionOrgPositionFundingDetailReportTotal> calculateOrgTotal(Collection<BudgetConstructionPositionFunding> positionFundingDetailList, List<BudgetConstructionPositionFunding> listForCalculateTotalOrg) {
        ArrayList<BudgetConstructionOrgPositionFundingDetailReportTotal> returnCollection = new ArrayList<BudgetConstructionOrgPositionFundingDetailReportTotal>();
        Integer totalOrgPositionCsfAmount = new Integer(0);
        Integer totalOrgAppointmentRequestedAmount = new Integer(0);
        BigDecimal totalOrgPositionCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal totalOrgAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        PendingBudgetConstructionAppointmentFunding pendingAppointmentFunding = null;
        for (BudgetConstructionPositionFunding budgetConstructionPositionFunding : listForCalculateTotalOrg) {
            for (BudgetConstructionPositionFunding positionFundingEntry : positionFundingDetailList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)budgetConstructionPositionFunding, (BusinessObject)positionFundingEntry, this.fieldsForOrg())) continue;
                pendingAppointmentFunding = positionFundingEntry.getPendingAppointmentFunding();
                if (pendingAppointmentFunding.getBcnCalculatedSalaryFoundationTracker().size() > 0) {
                    BudgetConstructionCalculatedSalaryFoundationTracker calculatedSalaryFoundationTracker = pendingAppointmentFunding.getBcnCalculatedSalaryFoundationTracker().get(0);
                    totalOrgPositionCsfAmount = totalOrgPositionCsfAmount + new Integer(calculatedSalaryFoundationTracker.getCsfAmount().intValue());
                    totalOrgPositionCsfFteQuantity = totalOrgPositionCsfFteQuantity.add(calculatedSalaryFoundationTracker.getCsfFullTimeEmploymentQuantity());
                }
                if (pendingAppointmentFunding == null) continue;
                totalOrgAppointmentRequestedAmount = totalOrgAppointmentRequestedAmount + new Integer(pendingAppointmentFunding.getAppointmentRequestedAmount().intValue());
                totalOrgAppointmentRequestedFteQuantity = totalOrgAppointmentRequestedFteQuantity.add(pendingAppointmentFunding.getAppointmentRequestedFteQuantity());
            }
            BudgetConstructionOrgPositionFundingDetailReportTotal budgetConstructionOrgOrgFundingDetailReportTotal = new BudgetConstructionOrgPositionFundingDetailReportTotal();
            budgetConstructionOrgOrgFundingDetailReportTotal.setBudgetConstructionPositionFunding(budgetConstructionPositionFunding);
            budgetConstructionOrgOrgFundingDetailReportTotal.setTotalOrgPositionCsfAmount(totalOrgPositionCsfAmount);
            budgetConstructionOrgOrgFundingDetailReportTotal.setTotalOrgPositionCsfFteQuantity(totalOrgPositionCsfFteQuantity);
            budgetConstructionOrgOrgFundingDetailReportTotal.setTotalOrgAppointmentRequestedAmount(totalOrgAppointmentRequestedAmount);
            budgetConstructionOrgOrgFundingDetailReportTotal.setTotalOrgAppointmentRequestedFteQuantity(totalOrgAppointmentRequestedFteQuantity);
            returnCollection.add(budgetConstructionOrgOrgFundingDetailReportTotal);
            totalOrgPositionCsfAmount = new Integer(0);
            totalOrgAppointmentRequestedAmount = new Integer(0);
            totalOrgPositionCsfFteQuantity = BigDecimal.ZERO;
            totalOrgAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        }
        return returnCollection;
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("selectedOrganizationChartOfAccountsCode");
        returnList.add("selectedOrganizationCode");
        returnList.add("name");
        returnList.add("emplid");
        returnList.add("positionNumber");
        returnList.add("universityFiscalYear");
        returnList.add("chartOfAccountsCode");
        returnList.add("accountNumber");
        returnList.add("subAccountNumber");
        returnList.add("financialObjectCode");
        returnList.add("financialSubObjectCode");
        return returnList;
    }

    protected List<String> fieldsForPerson() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.addAll(this.fieldsForOrg());
        fieldList.add("emplid");
        return fieldList;
    }

    protected List<String> fieldsForOrg() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("selectedOrganizationChartOfAccountsCode");
        fieldList.add("selectedOrganizationCode");
        return fieldList;
    }

    public void setBudgetConstructionPositionFundingDetailReportDao(BudgetConstructionPositionFundingDetailReportDao budgetConstructionPositionFundingDetailReportDao) {
        this.budgetConstructionPositionFundingDetailReportDao = budgetConstructionPositionFundingDetailReportDao;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBudgetConstructionReportsServiceHelper(BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper) {
        this.budgetConstructionReportsServiceHelper = budgetConstructionReportsServiceHelper;
    }

    public void setSalarySettingService(SalarySettingService salarySettingService) {
        this.salarySettingService = salarySettingService;
    }
}

