/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAdministrativePost;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionObjectDump;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionObjectPick;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReasonCodePick;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSalaryFunding;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSalarySocialSecurityNumber;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.sys.service.NonTransactional;
import org.springframework.transaction.annotation.Transactional;

public class BudgetConstructionReportsServiceHelperImpl
implements BudgetConstructionReportsServiceHelper {
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceServiceOjb;

    @Override
    @Transactional
    public Collection getDataForBuildingReports(Class clazz, String principalName, List<String> orderList) {
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalName);
        return this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(clazz, searchCriteria, orderList);
    }

    @Override
    @Transactional
    public Collection getDataForBuildingReports(Class clazz, Map searchCriteria, List<String> orderList) {
        return this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(clazz, searchCriteria, orderList);
    }

    @Override
    @NonTransactional
    public void generatePdf(List<String> errorMessages, ByteArrayOutputStream baos) throws DocumentException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        for (String error : errorMessages) {
            document.add((Element)new Paragraph(error));
        }
        document.close();
    }

    @Override
    @Transactional
    public ObjectCode getObjectCode(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", universityFiscalYear);
        searchCriteria.put("chartOfAccountsCode", chartOfAccountsCode);
        searchCriteria.put("financialObjectCode", financialObjectCode);
        return (ObjectCode)this.businessObjectService.findByPrimaryKey(ObjectCode.class, searchCriteria);
    }

    @Override
    @Transactional
    public String getSelectedObjectCodes(String principalName) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("principalId", principalName);
        searchCriteria.put("selectFlag", 1);
        Collection objectPickList = this.businessObjectService.findMatching(BudgetConstructionObjectPick.class, searchCriteria);
        String objectCodes = "";
        int count = 0;
        for (BudgetConstructionObjectPick objectPick : objectPickList) {
            objectCodes = objectCodes + objectPick.getFinancialObjectCode();
            if (++count >= objectPickList.size()) continue;
            objectCodes = objectCodes + ", ";
        }
        return objectCodes;
    }

    @Override
    @Transactional
    public String getSelectedReasonCodes(String principalName) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("principalId", principalName);
        searchCriteria.put("selectFlag", 1);
        Collection reasonCodePickList = this.businessObjectService.findMatching(BudgetConstructionReasonCodePick.class, searchCriteria);
        String reasonCodes = "";
        int count = 0;
        for (BudgetConstructionReasonCodePick reasonPick : reasonCodePickList) {
            reasonCodes = reasonCodes + reasonPick.getAppointmentFundingReasonCode();
            if (++count >= reasonCodePickList.size()) continue;
            reasonCodes = reasonCodes + ", ";
        }
        return reasonCodes;
    }

    @Override
    @Transactional
    public BudgetConstructionAdministrativePost getBudgetConstructionAdministrativePost(PendingBudgetConstructionAppointmentFunding appointmentFundingEntry) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("emplid", appointmentFundingEntry.getEmplid());
        searchCriteria.put("positionNumber", appointmentFundingEntry.getPositionNumber());
        return (BudgetConstructionAdministrativePost)this.businessObjectService.findByPrimaryKey(BudgetConstructionAdministrativePost.class, searchCriteria);
    }

    @Override
    @Transactional
    public BudgetConstructionPosition getBudgetConstructionPosition(Integer universityFiscalYear, PendingBudgetConstructionAppointmentFunding appointmentFundingEntry) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("positionNumber", appointmentFundingEntry.getPositionNumber());
        searchCriteria.put("universityFiscalYear", universityFiscalYear);
        return (BudgetConstructionPosition)this.businessObjectService.findByPrimaryKey(BudgetConstructionPosition.class, searchCriteria);
    }

    @Override
    @Transactional
    public BudgetConstructionIntendedIncumbent getBudgetConstructionIntendedIncumbent(PendingBudgetConstructionAppointmentFunding appointmentFundingEntry) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("emplid", appointmentFundingEntry.getEmplid());
        return (BudgetConstructionIntendedIncumbent)this.businessObjectService.findByPrimaryKey(BudgetConstructionIntendedIncumbent.class, searchCriteria);
    }

    @Override
    @Transactional
    public BudgetConstructionSalarySocialSecurityNumber getBudgetConstructionSalarySocialSecurityNumber(String principalName, BudgetConstructionSalaryFunding salaryFunding) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalName);
        searchCriteria.put("emplid", salaryFunding.getEmplid());
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("organizationChartOfAccountsCode");
        orderList.add("organizationCode");
        orderList.add("name");
        orderList.add("emplid");
        return (BudgetConstructionSalarySocialSecurityNumber)this.businessObjectService.findByPrimaryKey(BudgetConstructionSalarySocialSecurityNumber.class, searchCriteria);
    }

    @Override
    @Transactional
    public Collection<BudgetConstructionSalaryFunding> getSalaryFunding(String principalName, String emplid) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalName);
        searchCriteria.put("emplid", emplid);
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("positionNumber");
        orderList.add("universityFiscalYear");
        orderList.add("chartOfAccountsCode");
        orderList.add("accountNumber");
        orderList.add("subAccountNumber");
        orderList.add("financialObjectCode");
        orderList.add("financialSubObjectCode");
        return this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(BudgetConstructionSalaryFunding.class, searchCriteria, orderList);
    }

    @Override
    @Transactional
    public Collection<PendingBudgetConstructionAppointmentFunding> getPendingBudgetConstructionAppointmentFundingList(Integer universityFiscalYear, BudgetConstructionObjectDump budgetConstructionObjectDump) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", universityFiscalYear);
        searchCriteria.put("chartOfAccountsCode", budgetConstructionObjectDump.getChartOfAccountsCode());
        searchCriteria.put("accountNumber", budgetConstructionObjectDump.getAccountNumber());
        searchCriteria.put("subAccountNumber", budgetConstructionObjectDump.getSubAccountNumber());
        searchCriteria.put("financialObjectCode", budgetConstructionObjectDump.getFinancialObjectCode());
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("financialObjectCode");
        orderList.add("financialSubObjectCode");
        orderList.add("positionNumber");
        orderList.add("emplid");
        return this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(PendingBudgetConstructionAppointmentFunding.class, searchCriteria, orderList);
    }

    @NonTransactional
    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    @NonTransactional
    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

