/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgSynchronizationProblemsReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPositionFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionSynchronizationProblemsReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionSynchronizationProblemsReportService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionSynchronizationProblemsReportServiceImpl
implements BudgetConstructionSynchronizationProblemsReportService {
    protected BudgetConstructionSynchronizationProblemsReportDao budgetConstructionSynchronizationProblemsReportDao;
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceServiceOjb;

    @Override
    public void updateSynchronizationProblemsReport(String principalName) {
        this.budgetConstructionSynchronizationProblemsReportDao.updateReportsSynchronizationProblemsTable(principalName);
    }

    @Override
    public Collection<BudgetConstructionOrgSynchronizationProblemsReport> buildReports(Integer universityFiscalYear, String principalName) {
        ArrayList<BudgetConstructionOrgSynchronizationProblemsReport> reportSet = new ArrayList<BudgetConstructionOrgSynchronizationProblemsReport>();
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalName);
        List<String> orderList = this.buildOrderByList();
        List synchronizationProblemsList = this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(BudgetConstructionPositionFunding.class, searchCriteria, orderList);
        HashMap<BudgetConstructionPositionFunding, BudgetConstructionPosition> positionMap = new HashMap<BudgetConstructionPositionFunding, BudgetConstructionPosition>();
        for (BudgetConstructionPositionFunding positionFundingEntry : synchronizationProblemsList) {
            BudgetConstructionPosition budgetConstructionPosition = this.getBudgetConstructionPosition(universityFiscalYear, positionFundingEntry.getPendingAppointmentFunding());
            positionMap.put(positionFundingEntry, budgetConstructionPosition);
        }
        for (BudgetConstructionPositionFunding positionFundingEntry : synchronizationProblemsList) {
            BudgetConstructionOrgSynchronizationProblemsReport orgSynchronizationProblemsReportEntry = new BudgetConstructionOrgSynchronizationProblemsReport();
            this.buildReportsHeader(universityFiscalYear, orgSynchronizationProblemsReportEntry, positionFundingEntry);
            this.buildReportsBody(orgSynchronizationProblemsReportEntry, positionFundingEntry, positionMap);
            reportSet.add(orgSynchronizationProblemsReportEntry);
        }
        return reportSet;
    }

    public void buildReportsHeader(Integer universityFiscalYear, BudgetConstructionOrgSynchronizationProblemsReport orgSynchronizationProblemsReportEntry, BudgetConstructionPositionFunding positionFunding) {
        String chartDesc = positionFunding.getSelectedOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        String orgName = positionFunding.getSelectedOrganization().getOrganizationName();
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgSynchronizationProblemsReportEntry.setChartOfAccountsCode(positionFunding.getSelectedOrganizationChartOfAccountsCode());
        orgSynchronizationProblemsReportEntry.setOrganizationCode(positionFunding.getSelectedOrganizationCode());
        if (chartDesc == null) {
            orgSynchronizationProblemsReportEntry.setChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgSynchronizationProblemsReportEntry.setChartOfAccountDescription(chartDesc);
        }
        if (orgName == null) {
            orgSynchronizationProblemsReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgSynchronizationProblemsReportEntry.setOrganizationName(orgName);
        }
        orgSynchronizationProblemsReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
    }

    public void buildReportsBody(BudgetConstructionOrgSynchronizationProblemsReport orgSynchronizationProblemsReportEntry, BudgetConstructionPositionFunding positionFunding, Map positionMap) {
        orgSynchronizationProblemsReportEntry.setBodyChartOfAccountsCode(positionFunding.getChartOfAccountsCode());
        orgSynchronizationProblemsReportEntry.setAccountNumber(positionFunding.getAccountNumber());
        orgSynchronizationProblemsReportEntry.setSubAccountNumber(positionFunding.getSubAccountNumber());
        orgSynchronizationProblemsReportEntry.setFinancialObjectCode(positionFunding.getFinancialObjectCode());
        orgSynchronizationProblemsReportEntry.setFinancialSubObjectCode(positionFunding.getFinancialSubObjectCode());
        orgSynchronizationProblemsReportEntry.setPositionNumber(positionFunding.getPositionNumber());
        orgSynchronizationProblemsReportEntry.setEmplid(positionFunding.getEmplid());
        orgSynchronizationProblemsReportEntry.setName(positionFunding.getName());
        orgSynchronizationProblemsReportEntry.setPositionObjectChangeIndicator(this.booleanToString(positionFunding.getPendingAppointmentFunding().isPositionObjectChangeIndicator()));
        orgSynchronizationProblemsReportEntry.setPositionSalaryChangeIndicator(this.booleanToString(positionFunding.getPendingAppointmentFunding().isPositionSalaryChangeIndicator()));
        BudgetConstructionPosition budgetConstructionPosition = (BudgetConstructionPosition)positionMap.get((Object)positionFunding);
        orgSynchronizationProblemsReportEntry.setPositionEffectiveStatus(budgetConstructionPosition.getPositionEffectiveStatus());
        orgSynchronizationProblemsReportEntry.setBudgetedPosition(this.booleanToString(budgetConstructionPosition.isBudgetedPosition()));
    }

    protected String booleanToString(boolean boo) {
        if (boo) {
            return "Y";
        }
        return "N";
    }

    protected BudgetConstructionPosition getBudgetConstructionPosition(Integer universityFiscalYear, PendingBudgetConstructionAppointmentFunding appointmentFundingEntry) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("positionNumber", appointmentFundingEntry.getPositionNumber());
        searchCriteria.put("universityFiscalYear", universityFiscalYear);
        return (BudgetConstructionPosition)this.businessObjectService.findByPrimaryKey(BudgetConstructionPosition.class, searchCriteria);
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("principalId");
        returnList.add("selectedOrganizationChartOfAccountsCode");
        returnList.add("selectedOrganizationCode");
        returnList.add("chartOfAccountsCode");
        returnList.add("accountNumber");
        returnList.add("subAccountNumber");
        returnList.add("financialObjectCode");
        returnList.add("financialSubObjectCode");
        returnList.add("name");
        returnList.add("positionNumber");
        return returnList;
    }

    public void setBudgetConstructionSynchronizationProblemsReportDao(BudgetConstructionSynchronizationProblemsReportDao budgetConstructionSynchronizationProblemsReportDao) {
        this.budgetConstructionSynchronizationProblemsReportDao = budgetConstructionSynchronizationProblemsReportDao;
    }

    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

