/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.integration.ld.LaborLedgerBenefitsCalculation;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.SessionDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.businessobject.SalarySettingExpansion;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.module.bc.document.service.BenefitsCalculationService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.BudgetParameterService;
import org.kuali.kfs.module.bc.document.validation.event.DeleteMonthlySpreadEvent;
import org.kuali.kfs.module.bc.document.validation.impl.BudgetConstructionRuleUtil;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionForm;
import org.kuali.kfs.module.bc.document.web.struts.MonthlyBudgetForm;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.transaction.annotation.Transactional;

public class BudgetDocumentServiceImpl
implements BudgetDocumentService {
    private static Logger LOG = Logger.getLogger(BudgetDocumentServiceImpl.class);
    protected BudgetConstructionDao budgetConstructionDao;
    protected DocumentDao documentDao;
    protected DocumentService documentService;
    protected WorkflowDocumentService workflowDocumentService;
    protected BenefitsCalculationService benefitsCalculationService;
    protected BusinessObjectService businessObjectService;
    protected KualiModuleService kualiModuleService;
    protected ParameterService parameterService;
    protected BudgetParameterService budgetParameterService;
    protected FiscalYearFunctionControlService fiscalYearFunctionControlService;
    protected OptionsService optionsService;
    protected PersistenceService persistenceService;
    protected OrganizationService organizationService;
    protected String defaultLaborBenefitRateCategoryCode;

    @Override
    @Transactional
    public BudgetConstructionHeader getByCandidateKey(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear) {
        return this.budgetConstructionDao.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
    }

    @Override
    @Transactional
    public Document saveDocument(BudgetConstructionDocument budgetConstructionDocument) throws WorkflowException, ValidationException {
        budgetConstructionDocument.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("R");
        this.saveDocumentNoWorkflow(budgetConstructionDocument);
        ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).addDocumentToUserSession(GlobalVariables.getUserSession(), budgetConstructionDocument.getDocumentHeader().getWorkflowDocument());
        MessageList messagesSoFar = KNSGlobalVariables.getMessageList();
        budgetConstructionDocument.getDocumentHeader().getWorkflowDocument().logAnnotation("Document Updated");
        KNSGlobalVariables.getMessageList().addAll((Collection)messagesSoFar);
        return budgetConstructionDocument;
    }

    @Override
    @Transactional
    public Document saveDocumentNoWorkflow(BudgetConstructionDocument bcDoc) throws ValidationException {
        return this.saveDocumentNoWorkFlow(bcDoc, BCConstants.MonthSpreadDeleteType.NONE, true);
    }

    @Override
    @Transactional
    public Document saveDocumentNoWorkFlow(BudgetConstructionDocument bcDoc, BCConstants.MonthSpreadDeleteType monthSpreadDeleteType, boolean doMonthRICheck) throws ValidationException {
        this.checkForNulls((Document)bcDoc);
        bcDoc.prepareForSave();
        if (doMonthRICheck) {
            this.validateAndPersistDocument((Document)bcDoc, (KualiDocumentEvent)new SaveDocumentEvent((Document)bcDoc));
        } else {
            this.validateAndPersistDocument((Document)bcDoc, (KualiDocumentEvent)new DeleteMonthlySpreadEvent((Document)bcDoc, monthSpreadDeleteType));
        }
        return bcDoc;
    }

    @Override
    @Transactional
    public void saveMonthlyBudget(MonthlyBudgetForm monthlyBudgetForm, BudgetConstructionMonthly budgetConstructionMonthly) {
        KualiInteger pbglRequestAmount;
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)((Object)GlobalVariables.getUserSession().retrieveObject(monthlyBudgetForm.getReturnFormKey()));
        BudgetConstructionDocument bcDoc = budgetConstructionForm.getBudgetConstructionDocument();
        KualiInteger changeAmount = KualiInteger.ZERO;
        KualiInteger monthTotalAmount = budgetConstructionMonthly.getFinancialDocumentMonthTotalLineAmount();
        if (!monthTotalAmount.equals((Object)(pbglRequestAmount = budgetConstructionMonthly.getPendingBudgetConstructionGeneralLedger().getAccountLineAnnualBalanceAmount()))) {
            changeAmount = monthTotalAmount.subtract(pbglRequestAmount);
            budgetConstructionMonthly.refreshReferenceObject("pendingBudgetConstructionGeneralLedger");
            PendingBudgetConstructionGeneralLedger sourceRow = (PendingBudgetConstructionGeneralLedger)this.businessObjectService.retrieve((PersistableBusinessObject)budgetConstructionMonthly.getPendingBudgetConstructionGeneralLedger());
            sourceRow.setAccountLineAnnualBalanceAmount(monthTotalAmount);
            this.businessObjectService.save((PersistableBusinessObject)sourceRow);
            this.addOrUpdatePBGLRow(bcDoc, sourceRow, monthlyBudgetForm.isRevenue());
            if (monthlyBudgetForm.isRevenue()) {
                bcDoc.setRevenueAccountLineAnnualBalanceAmountTotal(bcDoc.getRevenueAccountLineAnnualBalanceAmountTotal().add(changeAmount));
            } else {
                bcDoc.setExpenditureAccountLineAnnualBalanceAmountTotal(bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal().add(changeAmount));
            }
        }
        this.businessObjectService.save((PersistableBusinessObject)budgetConstructionMonthly);
        this.callForBenefitsCalcIfNeeded(bcDoc, budgetConstructionMonthly, changeAmount);
    }

    @Override
    @Transactional
    public void callForBenefitsCalcIfNeeded(BudgetConstructionDocument bcDoc, BudgetConstructionMonthly budgetConstructionMonthly, KualiInteger pbglChangeAmount) {
        if (!this.benefitsCalculationService.isBenefitsCalculationDisabled() && budgetConstructionMonthly.getPendingBudgetConstructionGeneralLedger().getPositionObjectBenefit() != null && !budgetConstructionMonthly.getPendingBudgetConstructionGeneralLedger().getPositionObjectBenefit().isEmpty()) {
            bcDoc.setMonthlyBenefitsCalcNeeded(true);
            if (pbglChangeAmount.isNonZero()) {
                bcDoc.setBenefitsCalcNeeded(true);
            }
        }
    }

    @Override
    @Transactional
    public void calculateBenefitsIfNeeded(BudgetConstructionDocument bcDoc) {
        if (bcDoc.isBenefitsCalcNeeded() || bcDoc.isMonthlyBenefitsCalcNeeded()) {
            if (bcDoc.isBenefitsCalcNeeded()) {
                this.calculateAnnualBenefits(bcDoc);
            }
            if (bcDoc.isMonthlyBenefitsCalcNeeded()) {
                this.calculateMonthlyBenefits(bcDoc);
            }
            this.reloadBenefitsLines(bcDoc);
        }
    }

    @Override
    @Transactional
    public void calculateBenefits(BudgetConstructionDocument bcDoc) {
        this.calculateAnnualBenefits(bcDoc);
        this.calculateMonthlyBenefits(bcDoc);
        this.reloadBenefitsLines(bcDoc);
    }

    @Transactional
    protected void calculateAnnualBenefits(BudgetConstructionDocument bcDoc) {
        bcDoc.setBenefitsCalcNeeded(false);
        if (!bcDoc.isSalarySettingOnly()) {
            String sysParam = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
            LOG.debug((Object)("sysParam: " + sysParam));
            if (sysParam.equalsIgnoreCase("Y")) {
                this.benefitsCalculationService.calculateAnnualBudgetConstructionGeneralLedgerBenefits(bcDoc.getDocumentNumber(), bcDoc.getUniversityFiscalYear(), bcDoc.getChartOfAccountsCode(), bcDoc.getAccountNumber(), bcDoc.getSubAccountNumber(), bcDoc.getAccount().getLaborBenefitRateCategoryCode());
            } else {
                this.benefitsCalculationService.calculateAnnualBudgetConstructionGeneralLedgerBenefits(bcDoc.getDocumentNumber(), bcDoc.getUniversityFiscalYear(), bcDoc.getChartOfAccountsCode(), bcDoc.getAccountNumber(), bcDoc.getSubAccountNumber());
            }
            KNSGlobalVariables.getMessageList().add("message.budget.benefitsCalculated", new String[0]);
        }
    }

    @Transactional
    protected void calculateMonthlyBenefits(BudgetConstructionDocument bcDoc) {
        bcDoc.setMonthlyBenefitsCalcNeeded(false);
        if (!bcDoc.isSalarySettingOnly()) {
            String sysParam = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
            LOG.debug((Object)("sysParam: " + sysParam));
            if (sysParam.equalsIgnoreCase("Y")) {
                this.benefitsCalculationService.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(bcDoc.getDocumentNumber(), bcDoc.getUniversityFiscalYear(), bcDoc.getChartOfAccountsCode(), bcDoc.getAccountNumber(), bcDoc.getSubAccountNumber(), bcDoc.getAccount().getLaborBenefitRateCategoryCode());
            } else {
                this.benefitsCalculationService.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(bcDoc.getDocumentNumber(), bcDoc.getUniversityFiscalYear(), bcDoc.getChartOfAccountsCode(), bcDoc.getAccountNumber(), bcDoc.getSubAccountNumber());
            }
            KNSGlobalVariables.getMessageList().add("message.budget.benefitsMonthlyCalculated", new String[0]);
        }
    }

    @NonTransactional
    protected void checkForNulls(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentNumber() == null) {
            throw new IllegalStateException("invalid (null) documentHeaderId");
        }
    }

    @Transactional
    public void validateAndPersistDocument(Document document, KualiDocumentEvent event) throws ValidationException {
        if (document == null) {
            LOG.error((Object)"document passed to validateAndPersist was null");
            throw new IllegalArgumentException("invalid (null) document");
        }
        LOG.info((Object)("validating and preparing to persist document " + document.getDocumentNumber()));
        document.validateBusinessRules(event);
        document.prepareForSave(event);
        try {
            LOG.info((Object)("storing document " + document.getDocumentNumber()));
            this.documentDao.save(document);
        }
        catch (OptimisticLockingFailureException e) {
            LOG.error((Object)("exception encountered on store of document " + e.getMessage()));
            throw e;
        }
        document.postProcessSave(event);
    }

    @Override
    @Transactional
    public void validateDocument(Document document) throws ValidationException {
        if (document == null) {
            LOG.error((Object)"document passed to validateDocument was null");
            throw new IllegalArgumentException("invalid (null) document");
        }
        LOG.info((Object)("validating document " + document.getDocumentNumber()));
        document.validateBusinessRules((KualiDocumentEvent)new SaveDocumentEvent(document));
    }

    @Override
    @Transactional
    public List<PendingBudgetConstructionGeneralLedger> getPBGLSalarySettingRows(BudgetConstructionDocument bcDocument) {
        List<String> ssObjects = this.getDetailSalarySettingLaborObjects(bcDocument.getUniversityFiscalYear(), bcDocument.getChartOfAccountsCode());
        ssObjects.add("2PLG");
        List pbglSalarySettingRows = this.budgetConstructionDao.getPBGLSalarySettingRows(bcDocument.getDocumentNumber(), ssObjects);
        return pbglSalarySettingRows;
    }

    @Override
    @NonTransactional
    public List<String> getDetailSalarySettingLaborObjects(Integer universityFiscalYear, String chartOfAccountsCode) {
        ArrayList<String> detailSalarySettingObjects = new ArrayList<String>();
        HashMap<String, Object> laborObjectCodeMap = new HashMap<String, Object>();
        laborObjectCodeMap.put("universityFiscalYear", universityFiscalYear);
        laborObjectCodeMap.put("chartOfAccountsCode", chartOfAccountsCode);
        laborObjectCodeMap.put("detailPositionRequiredIndicator", true);
        List laborLedgerObjects = this.kualiModuleService.getResponsibleModuleService(LaborLedgerObject.class).getExternalizableBusinessObjectsList(LaborLedgerObject.class, laborObjectCodeMap);
        for (LaborLedgerObject laborObject : laborLedgerObjects) {
            detailSalarySettingObjects.add(laborObject.getFinancialObjectCode());
        }
        return detailSalarySettingObjects;
    }

    @Override
    @NonTransactional
    public BudgetConstructionDocument addOrUpdatePBGLRow(BudgetConstructionDocument bcDoc, PendingBudgetConstructionGeneralLedger sourceRow, boolean isRevenue) {
        List<PendingBudgetConstructionGeneralLedger> pbglRows = isRevenue ? bcDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines() : bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines();
        int index = 0;
        boolean insertNeeded = true;
        for (PendingBudgetConstructionGeneralLedger pbglRow : pbglRows) {
            String sourceRowKey;
            String pbglRowKey = pbglRow.getFinancialObjectCode() + pbglRow.getFinancialSubObjectCode();
            if (pbglRowKey.compareToIgnoreCase(sourceRowKey = sourceRow.getFinancialObjectCode() + sourceRow.getFinancialSubObjectCode()) == 0) {
                insertNeeded = false;
                pbglRow.setAccountLineAnnualBalanceAmount(sourceRow.getAccountLineAnnualBalanceAmount());
                pbglRow.setPersistedAccountLineAnnualBalanceAmount(sourceRow.getAccountLineAnnualBalanceAmount());
                pbglRow.setVersionNumber(sourceRow.getVersionNumber());
                break;
            }
            if (pbglRowKey.compareToIgnoreCase(sourceRowKey) > 0) break;
            ++index;
        }
        if (insertNeeded) {
            sourceRow.setPersistedAccountLineAnnualBalanceAmount(sourceRow.getAccountLineAnnualBalanceAmount());
            pbglRows.add(index, sourceRow);
        }
        return bcDoc;
    }

    @Transactional
    protected void reloadBenefitsLines(BudgetConstructionDocument bcDoc) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", bcDoc.getUniversityFiscalYear());
        fieldValues.put("chartOfAccountsCode", bcDoc.getChartOfAccountsCode());
        List benefitsCalculation = this.kualiModuleService.getResponsibleModuleService(LaborLedgerBenefitsCalculation.class).getExternalizableBusinessObjectsList(LaborLedgerBenefitsCalculation.class, fieldValues);
        ArrayList<String> fringeObjects = new ArrayList<String>();
        for (LaborLedgerBenefitsCalculation element : benefitsCalculation) {
            fringeObjects.add(element.getPositionFringeBenefitObjectCode());
        }
        List dbPBGLFringeLines = this.budgetConstructionDao.getDocumentPBGLFringeLines(bcDoc.getDocumentNumber(), fringeObjects);
        List<PendingBudgetConstructionGeneralLedger> docPBGLExpLines = bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines();
        KualiInteger docRequestTotals = KualiInteger.ZERO;
        KualiInteger dbRequestTotals = KualiInteger.ZERO;
        ListIterator<PendingBudgetConstructionGeneralLedger> docLines = docPBGLExpLines.listIterator();
        while (docLines.hasNext()) {
            PendingBudgetConstructionGeneralLedger docLine = docLines.next();
            if (!fringeObjects.contains(docLine.getFinancialObjectCode())) continue;
            docRequestTotals = docRequestTotals.add(docLine.getAccountLineAnnualBalanceAmount());
            docLines.remove();
        }
        if (dbPBGLFringeLines != null && !dbPBGLFringeLines.isEmpty()) {
            if (docPBGLExpLines == null || docPBGLExpLines.isEmpty()) {
                docPBGLExpLines.addAll(dbPBGLFringeLines);
            } else {
                ListIterator dbLines = dbPBGLFringeLines.listIterator();
                docLines = docPBGLExpLines.listIterator();
                PendingBudgetConstructionGeneralLedger dbLine = (PendingBudgetConstructionGeneralLedger)((Object)dbLines.next());
                PendingBudgetConstructionGeneralLedger docLine = docLines.next();
                boolean dbDone = false;
                boolean docDone = false;
                while (!dbDone) {
                    if (docDone || docLine.getFinancialObjectCode().compareToIgnoreCase(dbLine.getFinancialObjectCode()) > 0) {
                        if (!docDone) {
                            docLine = docLines.previous();
                        }
                        dbRequestTotals = dbRequestTotals.add(dbLine.getAccountLineAnnualBalanceAmount());
                        dbLine.setPersistedAccountLineAnnualBalanceAmount(dbLine.getAccountLineAnnualBalanceAmount());
                        this.populatePBGLLine(dbLine);
                        docLines.add(dbLine);
                        if (!docDone) {
                            docLine = docLines.next();
                        }
                        if (dbLines.hasNext()) {
                            dbLine = (PendingBudgetConstructionGeneralLedger)((Object)dbLines.next());
                            continue;
                        }
                        dbDone = true;
                        continue;
                    }
                    if (docLines.hasNext()) {
                        docLine = docLines.next();
                        continue;
                    }
                    docDone = true;
                }
            }
        }
        bcDoc.setExpenditureAccountLineAnnualBalanceAmountTotal(bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal().add(dbRequestTotals.subtract(docRequestTotals)));
    }

    @Override
    @Transactional
    public void populatePBGLLine(PendingBudgetConstructionGeneralLedger line) {
        List<String> REFRESH_FIELDS = StringUtils.isNotBlank((String)line.getFinancialSubObjectCode()) ? Collections.unmodifiableList(Arrays.asList("financialObject", "financialSubObject", "budgetConstructionMonthly")) : Collections.unmodifiableList(Arrays.asList("financialObject", "budgetConstructionMonthly"));
        this.persistenceService.retrieveReferenceObjects((Object)line, REFRESH_FIELDS);
    }

    @Override
    @Transactional
    public KualiInteger getPendingBudgetConstructionAppointmentFundingRequestSum(PendingBudgetConstructionGeneralLedger salaryDetailLine) {
        return this.budgetConstructionDao.getPendingBudgetConstructionAppointmentFundingRequestSum(salaryDetailLine);
    }

    @Override
    @NonTransactional
    public boolean isBudgetableDocument(BudgetConstructionHeader bcHeader) {
        Account account;
        if (bcHeader == null) {
            return false;
        }
        Integer budgetYear = bcHeader.getUniversityFiscalYear();
        boolean isBudgetableAccount = this.isBudgetableAccount(budgetYear, account = bcHeader.getAccount(), true);
        if (isBudgetableAccount) {
            SubAccount subAccount = bcHeader.getSubAccount();
            String subAccountNumber = bcHeader.getSubAccountNumber();
            return this.isBudgetableSubAccount(subAccount, subAccountNumber);
        }
        return false;
    }

    @Override
    @NonTransactional
    public boolean isBudgetableDocumentNoWagesCheck(BudgetConstructionHeader bcHeader) {
        Account account;
        if (bcHeader == null) {
            return false;
        }
        Integer budgetYear = bcHeader.getUniversityFiscalYear();
        boolean isBudgetableAccount = this.isBudgetableAccount(budgetYear, account = bcHeader.getAccount(), false);
        if (isBudgetableAccount) {
            SubAccount subAccount = bcHeader.getSubAccount();
            String subAccountNumber = bcHeader.getSubAccountNumber();
            return this.isBudgetableSubAccount(subAccount, subAccountNumber);
        }
        return false;
    }

    @Override
    @NonTransactional
    public boolean isBudgetableDocument(BudgetConstructionDocument document) {
        Account account;
        if (document == null) {
            return false;
        }
        Integer budgetYear = document.getUniversityFiscalYear();
        boolean isBudgetableAccount = this.isBudgetableAccount(budgetYear, account = document.getAccount(), true);
        if (isBudgetableAccount) {
            SubAccount subAccount = document.getSubAccount();
            String subAccountNumber = document.getSubAccountNumber();
            return this.isBudgetableSubAccount(subAccount, subAccountNumber);
        }
        return false;
    }

    @Override
    @NonTransactional
    public boolean isBudgetableDocumentNoWagesCheck(BudgetConstructionDocument document) {
        Account account;
        if (document == null) {
            return false;
        }
        Integer budgetYear = document.getUniversityFiscalYear();
        boolean isBudgetableAccount = this.isBudgetableAccount(budgetYear, account = document.getAccount(), false);
        if (isBudgetableAccount) {
            SubAccount subAccount = document.getSubAccount();
            String subAccountNumber = document.getSubAccountNumber();
            return this.isBudgetableSubAccount(subAccount, subAccountNumber);
        }
        return false;
    }

    @Override
    @NonTransactional
    public boolean isAssociatedWithBudgetableDocument(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        BudgetConstructionHeader bcHeader = this.getBudgetConstructionHeader(appointmentFunding);
        return this.isBudgetableDocument(bcHeader);
    }

    @Override
    @NonTransactional
    public boolean isBudgetableAccount(Integer budgetYear, Account account, boolean isWagesCheck) {
        SubFundGroup subFundGroup;
        if (budgetYear == null || account == null) {
            return false;
        }
        if (!account.isActive()) {
            return false;
        }
        Calendar expDate = BudgetConstructionRuleUtil.getNoBudgetAllowedExpireDate(budgetYear);
        if (account.isExpired(expDate)) {
            return false;
        }
        if (StringUtils.equals((String)account.getBudgetRecordingLevelCode(), (String)"N")) {
            return false;
        }
        return !isWagesCheck || (subFundGroup = account.getSubFundGroup()) != null && subFundGroup.isSubFundGroupWagesIndicator();
    }

    @Override
    @NonTransactional
    public boolean isBudgetableSubAccount(SubAccount subAccount, String subAccountNumber) {
        if (StringUtils.isNotEmpty((String)subAccountNumber) && StringUtils.equals((String)subAccountNumber, (String)KFSConstants.getDashSubAccountNumber())) {
            return true;
        }
        if (ObjectUtils.isNull((Object)subAccount) || !subAccount.isActive()) {
            return false;
        }
        A21SubAccount a21SubAccount = subAccount.getA21SubAccount();
        return !ObjectUtils.isNotNull((Object)a21SubAccount) || !StringUtils.equals((String)a21SubAccount.getSubAccountTypeCode(), (String)"CS");
    }

    @Override
    @Transactional
    public boolean isAccountReportsExist(String chartOfAccountsCode, String accountNumber) {
        BudgetConstructionAccountReports accountReports = this.budgetConstructionDao.getAccountReports(chartOfAccountsCode, accountNumber);
        return accountReports != null;
    }

    @Override
    @Transactional
    public void updatePendingBudgetGeneralLedger(PendingBudgetConstructionAppointmentFunding appointmentFunding, KualiInteger updateAmount) {
        BudgetConstructionHeader budgetConstructionHeader = this.getBudgetConstructionHeader(appointmentFunding);
        if (budgetConstructionHeader == null) {
            return;
        }
        PendingBudgetConstructionGeneralLedger pendingRecord = this.getPendingBudgetConstructionGeneralLedger(budgetConstructionHeader, appointmentFunding, updateAmount, false);
        this.businessObjectService.save((PersistableBusinessObject)pendingRecord);
    }

    @Override
    @Transactional
    public void updatePendingBudgetGeneralLedgerPlug(PendingBudgetConstructionAppointmentFunding appointmentFunding, KualiInteger updateAmount) {
        if (updateAmount == null) {
            throw new IllegalArgumentException("The update amount cannot be null");
        }
        BudgetConstructionHeader budgetConstructionHeader = this.getBudgetConstructionHeader(appointmentFunding);
        if (budgetConstructionHeader == null) {
            return;
        }
        if (this.canUpdatePlugRecord(appointmentFunding)) {
            PendingBudgetConstructionGeneralLedger plugRecord = this.getPendingBudgetConstructionGeneralLedger(budgetConstructionHeader, appointmentFunding, updateAmount, true);
            KualiInteger annualBalanceAmount = plugRecord.getAccountLineAnnualBalanceAmount();
            KualiInteger beginningBalanceAmount = plugRecord.getFinancialBeginningBalanceLineAmount();
            if ((annualBalanceAmount == null || annualBalanceAmount.isZero()) && (beginningBalanceAmount == null || beginningBalanceAmount.isZero())) {
                this.businessObjectService.delete((PersistableBusinessObject)plugRecord);
            } else {
                this.businessObjectService.save((PersistableBusinessObject)plugRecord);
            }
        }
    }

    @Override
    @Transactional
    public PendingBudgetConstructionGeneralLedger updatePendingBudgetGeneralLedgerPlug(BudgetConstructionDocument bcDoc, KualiInteger updateAmount) {
        String twoPlugKey = "2PLG" + KFSConstants.getDashFinancialSubObjectCode();
        List<PendingBudgetConstructionGeneralLedger> expenditureRows = bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines();
        PendingBudgetConstructionGeneralLedger twoPlugRow = null;
        int index = 0;
        boolean insertNeeded = true;
        for (PendingBudgetConstructionGeneralLedger expRow : expenditureRows) {
            String expRowKey = expRow.getFinancialObjectCode() + expRow.getFinancialSubObjectCode();
            if (expRowKey.compareToIgnoreCase(twoPlugKey) == 0) {
                insertNeeded = false;
                expRow.setAccountLineAnnualBalanceAmount(expRow.getAccountLineAnnualBalanceAmount().add(updateAmount.negated()));
                expRow.setPersistedAccountLineAnnualBalanceAmount(expRow.getAccountLineAnnualBalanceAmount());
                this.businessObjectService.save((PersistableBusinessObject)expRow);
                expRow.refresh();
                twoPlugRow = expRow;
                break;
            }
            if (expRowKey.compareToIgnoreCase(twoPlugKey) > 0) break;
            ++index;
        }
        if (insertNeeded) {
            String objectCode = "2PLG";
            String subObjectCode = KFSConstants.getDashFinancialSubObjectCode();
            String objectTypeCode = this.optionsService.getOptions(bcDoc.getUniversityFiscalYear()).getFinObjTypeExpenditureexpCd();
            PendingBudgetConstructionGeneralLedger pendingRecord = new PendingBudgetConstructionGeneralLedger();
            pendingRecord.setDocumentNumber(bcDoc.getDocumentNumber());
            pendingRecord.setUniversityFiscalYear(bcDoc.getUniversityFiscalYear());
            pendingRecord.setChartOfAccountsCode(bcDoc.getChartOfAccountsCode());
            pendingRecord.setAccountNumber(bcDoc.getAccountNumber());
            pendingRecord.setSubAccountNumber(bcDoc.getSubAccountNumber());
            pendingRecord.setFinancialObjectCode(objectCode);
            pendingRecord.setFinancialSubObjectCode(subObjectCode);
            pendingRecord.setFinancialBalanceTypeCode("BB");
            pendingRecord.setFinancialObjectTypeCode(objectTypeCode);
            pendingRecord.setFinancialBeginningBalanceLineAmount(KualiInteger.ZERO);
            pendingRecord.setAccountLineAnnualBalanceAmount(updateAmount);
            pendingRecord.setPersistedAccountLineAnnualBalanceAmount(pendingRecord.getAccountLineAnnualBalanceAmount());
            this.businessObjectService.save((PersistableBusinessObject)pendingRecord);
            expenditureRows.add(index, pendingRecord);
            twoPlugRow = pendingRecord;
            bcDoc.setContainsTwoPlug(true);
        }
        bcDoc.setExpenditureAccountLineAnnualBalanceAmountTotal(bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal().add(updateAmount.negated()));
        return twoPlugRow;
    }

    @Override
    @NonTransactional
    public BudgetConstructionHeader getBudgetConstructionHeader(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        String accountNumber = appointmentFunding.getAccountNumber();
        String subAccountNumber = appointmentFunding.getSubAccountNumber();
        Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
        return this.getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear);
    }

    @Override
    @NonTransactional
    public BudgetConstructionDocument getBudgetConstructionDocument(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", appointmentFunding.getUniversityFiscalYear());
        fieldValues.put("chartOfAccountsCode", appointmentFunding.getChartOfAccountsCode());
        fieldValues.put("accountNumber", appointmentFunding.getAccountNumber());
        fieldValues.put("subAccountNumber", appointmentFunding.getSubAccountNumber());
        Collection documents = this.businessObjectService.findMatching(BudgetConstructionDocument.class, fieldValues);
        Iterator iterator = documents.iterator();
        if (iterator.hasNext()) {
            BudgetConstructionDocument document = (BudgetConstructionDocument)((Object)iterator.next());
            try {
                return (BudgetConstructionDocument)this.documentService.getByDocumentHeaderId(document.getDocumentHeader().getDocumentNumber());
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Fail to retrieve the document for appointment funding" + (Object)((Object)appointmentFunding), e);
            }
        }
        return null;
    }

    @Override
    @NonTransactional
    public BudgetConstructionDocument getBudgetConstructionDocument(SalarySettingExpansion salarySettingExpansion) {
        try {
            return (BudgetConstructionDocument)this.documentService.getByDocumentHeaderId(salarySettingExpansion.getDocumentNumber());
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Fail to retrieve the document for salary expansion" + salarySettingExpansion, e);
        }
    }

    @Transactional
    protected boolean canUpdatePlugRecord(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        if (appointmentFunding.isOverride2PlugMode()) {
            return false;
        }
        Account account = appointmentFunding.getAccount();
        if (BudgetParameterFinder.getNotGenerate2PlgSubFundGroupCodes().contains(account.getSubFundGroupCode())) {
            return false;
        }
        return !account.isForContractsAndGrants();
    }

    @Transactional
    protected PendingBudgetConstructionGeneralLedger getPendingBudgetConstructionGeneralLedger(BudgetConstructionHeader budgetConstructionHeader, PendingBudgetConstructionAppointmentFunding appointmentFunding, KualiInteger updateAmount, boolean is2PLG) {
        if (budgetConstructionHeader == null) {
            throw new IllegalArgumentException("The given budget construction document header cannot be null");
        }
        if (appointmentFunding == null) {
            throw new IllegalArgumentException("The given pending budget appointment funding cannot be null");
        }
        if (updateAmount == null) {
            throw new IllegalArgumentException("The update amount cannot be null");
        }
        PendingBudgetConstructionGeneralLedger pendingRecord = this.retrievePendingBudgetConstructionGeneralLedger(budgetConstructionHeader, appointmentFunding, is2PLG);
        if (pendingRecord != null) {
            KualiInteger newAnnaulBalanceAmount = pendingRecord.getAccountLineAnnualBalanceAmount().add(updateAmount);
            pendingRecord.setAccountLineAnnualBalanceAmount(newAnnaulBalanceAmount);
        } else if (!is2PLG || is2PLG && updateAmount.isNonZero()) {
            Integer budgetYear = appointmentFunding.getUniversityFiscalYear();
            String objectCode = is2PLG ? "2PLG" : appointmentFunding.getFinancialObjectCode();
            String subObjectCode = is2PLG ? KFSConstants.getDashFinancialSubObjectCode() : appointmentFunding.getFinancialSubObjectCode();
            String objectTypeCode = this.optionsService.getOptions(budgetYear).getFinObjTypeExpenditureexpCd();
            pendingRecord = new PendingBudgetConstructionGeneralLedger();
            pendingRecord.setDocumentNumber(budgetConstructionHeader.getDocumentNumber());
            pendingRecord.setUniversityFiscalYear(appointmentFunding.getUniversityFiscalYear());
            pendingRecord.setChartOfAccountsCode(appointmentFunding.getChartOfAccountsCode());
            pendingRecord.setAccountNumber(appointmentFunding.getAccountNumber());
            pendingRecord.setSubAccountNumber(appointmentFunding.getSubAccountNumber());
            pendingRecord.setFinancialObjectCode(objectCode);
            pendingRecord.setFinancialSubObjectCode(subObjectCode);
            pendingRecord.setFinancialBalanceTypeCode("BB");
            pendingRecord.setFinancialObjectTypeCode(objectTypeCode);
            pendingRecord.setFinancialBeginningBalanceLineAmount(KualiInteger.ZERO);
            pendingRecord.setAccountLineAnnualBalanceAmount(updateAmount);
        }
        return pendingRecord;
    }

    @NonTransactional
    protected PendingBudgetConstructionGeneralLedger retrievePendingBudgetConstructionGeneralLedger(BudgetConstructionHeader budgetConstructionHeader, PendingBudgetConstructionAppointmentFunding appointmentFunding, boolean is2PLG) {
        String objectCode = is2PLG ? "2PLG" : appointmentFunding.getFinancialObjectCode();
        String subObjectCode = is2PLG ? KFSConstants.getDashFinancialSubObjectCode() : appointmentFunding.getFinancialSubObjectCode();
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("documentNumber", budgetConstructionHeader.getDocumentNumber());
        searchCriteria.put("universityFiscalYear", budgetConstructionHeader.getUniversityFiscalYear());
        searchCriteria.put("chartOfAccountsCode", budgetConstructionHeader.getChartOfAccountsCode());
        searchCriteria.put("accountNumber", budgetConstructionHeader.getAccountNumber());
        searchCriteria.put("subAccountNumber", budgetConstructionHeader.getSubAccountNumber());
        searchCriteria.put("financialBalanceTypeCode", "BB");
        searchCriteria.put("financialObjectTypeCode", this.optionsService.getOptions(appointmentFunding.getUniversityFiscalYear()).getFinObjTypeExpenditureexpCd());
        searchCriteria.put("financialObjectCode", objectCode);
        searchCriteria.put("financialSubObjectCode", subObjectCode);
        return (PendingBudgetConstructionGeneralLedger)this.businessObjectService.findByPrimaryKey(PendingBudgetConstructionGeneralLedger.class, searchCriteria);
    }

    @Override
    @NonTransactional
    public List<PendingBudgetConstructionGeneralLedger> retrievePendingBudgetConstructionGeneralLedger(BudgetConstructionHeader budgetConstructionHeader) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("documentNumber", budgetConstructionHeader.getDocumentNumber());
        searchCriteria.put("universityFiscalYear", budgetConstructionHeader.getUniversityFiscalYear());
        searchCriteria.put("chartOfAccountsCode", budgetConstructionHeader.getChartOfAccountsCode());
        searchCriteria.put("accountNumber", budgetConstructionHeader.getAccountNumber());
        searchCriteria.put("subAccountNumber", budgetConstructionHeader.getSubAccountNumber());
        return (List)this.businessObjectService.findMatching(PendingBudgetConstructionGeneralLedger.class, searchCriteria);
    }

    @Override
    @Transactional
    public List<BudgetConstructionAccountOrganizationHierarchy> retrieveOrBuildAccountOrganizationHierarchy(Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber) {
        String organizationCode;
        String organizationChartOfAccountsCode;
        Integer currentLevel;
        String rootOrganization;
        String[] rootNode;
        String rootChart;
        boolean overFlow;
        List<BudgetConstructionAccountOrganizationHierarchy> accountOrgHier = new ArrayList<BudgetConstructionAccountOrganizationHierarchy>();
        BudgetConstructionAccountReports accountReports = this.budgetConstructionDao.getAccountReports(chartOfAccountsCode, accountNumber);
        if (accountReports != null && ((accountOrgHier = this.budgetConstructionDao.getAccountOrgHierForAccount(chartOfAccountsCode, accountNumber, universityFiscalYear)) == null || accountOrgHier.isEmpty()) && !(overFlow = this.budgetConstructionDao.insertAccountIntoAccountOrganizationHierarchy(rootChart = (rootNode = this.organizationService.getRootOrganizationCode())[0], rootOrganization = rootNode[1], universityFiscalYear, chartOfAccountsCode, accountNumber, currentLevel = new Integer(1), organizationChartOfAccountsCode = accountReports.getReportsToChartOfAccountsCode(), organizationCode = accountReports.getReportsToOrganizationCode()))) {
            accountOrgHier = this.budgetConstructionDao.getAccountOrgHierForAccount(chartOfAccountsCode, accountNumber, universityFiscalYear);
        }
        return accountOrgHier;
    }

    @Override
    @Transactional
    public BudgetConstructionDocument instantiateNewBudgetConstructionDocument(BudgetConstructionDocument budgetConstructionDocument) throws WorkflowException {
        budgetConstructionDocument.setOrganizationLevelChartOfAccountsCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_CHART_OF_ACCOUNTS_CODE);
        budgetConstructionDocument.setOrganizationLevelOrganizationCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_ORGANIZATION_CODE);
        budgetConstructionDocument.setOrganizationLevelCode(BCConstants.INITIAL_ORGANIZATION_LEVEL_CODE);
        budgetConstructionDocument.setBudgetTransactionLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
        budgetConstructionDocument.setBudgetLockUserIdentifier(BCConstants.DEFAULT_BUDGET_HEADER_LOCK_IDS);
        FinancialSystemDocumentHeader kualiDocumentHeader = budgetConstructionDocument.getFinancialSystemDocumentHeader();
        budgetConstructionDocument.setDocumentNumber(budgetConstructionDocument.getDocumentHeader().getDocumentNumber());
        kualiDocumentHeader.setOrganizationDocumentNumber(budgetConstructionDocument.getUniversityFiscalYear().toString());
        kualiDocumentHeader.setFinancialDocumentStatusCode("?");
        kualiDocumentHeader.setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        kualiDocumentHeader.setDocumentDescription(String.format("%s %d %s %s", "Budget Construction", budgetConstructionDocument.getUniversityFiscalYear(), budgetConstructionDocument.getChartOfAccountsCode(), budgetConstructionDocument.getAccountNumber()));
        kualiDocumentHeader.setExplanation("Budget Construction");
        ArrayList emptyAdHocList = new ArrayList();
        this.documentService.routeDocument((Document)budgetConstructionDocument, "created by application UI", emptyAdHocList);
        return budgetConstructionDocument;
    }

    @Override
    @Transactional
    public List<BudgetConstructionAccountOrganizationHierarchy> getPushPullLevelList(BudgetConstructionDocument bcDoc, Person person) {
        ArrayList<BudgetConstructionAccountOrganizationHierarchy> pushOrPullList = new ArrayList<BudgetConstructionAccountOrganizationHierarchy>();
        pushOrPullList.addAll(this.budgetConstructionDao.getAccountOrgHierForAccount(bcDoc.getChartOfAccountsCode(), bcDoc.getAccountNumber(), bcDoc.getUniversityFiscalYear()));
        if (pushOrPullList.size() >= 1) {
            BudgetConstructionAccountOrganizationHierarchy levelZero = new BudgetConstructionAccountOrganizationHierarchy();
            levelZero.setUniversityFiscalYear(bcDoc.getUniversityFiscalYear());
            levelZero.setChartOfAccountsCode(bcDoc.getChartOfAccountsCode());
            levelZero.setAccountNumber(bcDoc.getAccountNumber());
            levelZero.setOrganizationLevelCode(0);
            levelZero.setOrganizationChartOfAccountsCode(((BudgetConstructionAccountOrganizationHierarchy)((Object)pushOrPullList.get(0))).getOrganizationChartOfAccountsCode());
            levelZero.setOrganizationCode(((BudgetConstructionAccountOrganizationHierarchy)((Object)pushOrPullList.get(0))).getOrganizationCode());
            pushOrPullList.add(0, levelZero);
        }
        return pushOrPullList;
    }

    @NonTransactional
    public void setBudgetConstructionDao(BudgetConstructionDao budgetConstructionDao) {
        this.budgetConstructionDao = budgetConstructionDao;
    }

    @NonTransactional
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @NonTransactional
    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    @NonTransactional
    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    @NonTransactional
    public void setBenefitsCalculationService(BenefitsCalculationService benefitsCalculationService) {
        this.benefitsCalculationService = benefitsCalculationService;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setBudgetParameterService(BudgetParameterService budgetParameterService) {
        this.budgetParameterService = budgetParameterService;
    }

    @NonTransactional
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @NonTransactional
    public void setFiscalYearFunctionControlService(FiscalYearFunctionControlService fiscalYearFunctionControlService) {
        this.fiscalYearFunctionControlService = fiscalYearFunctionControlService;
    }

    @NonTransactional
    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    @NonTransactional
    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    @NonTransactional
    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @NonTransactional
    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @NonTransactional
    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    @Transactional
    public String getDefaultLaborBenefitRateCategoryCode() {
        if (ObjectUtils.isNull((Object)this.defaultLaborBenefitRateCategoryCode)) {
            this.defaultLaborBenefitRateCategoryCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(Account.class, "DEFAULT_BENEFIT_RATE_CATEGORY_CODE") != false ? ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(Account.class, "DEFAULT_BENEFIT_RATE_CATEGORY_CODE") : "";
        }
        return this.defaultLaborBenefitRateCategoryCode;
    }

    @Transactional
    public void setDefaultLaborBenefitRateCategoryCode(String defaultLaborBenefitRateCategoryCode) {
        this.defaultLaborBenefitRateCategoryCode = defaultLaborBenefitRateCategoryCode;
    }
}

