/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountDump;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.dataaccess.ReportDumpDao;
import org.kuali.kfs.module.bc.document.service.ReportExportService;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ReportExportServiceImpl
implements ReportExportService {
    protected ReportDumpDao reportDumpDao;
    protected BusinessObjectService businessObjectService;

    @Override
    public void updateAccountDump(String principalId) {
        this.reportDumpDao.updateAccountDump(principalId);
    }

    @Override
    public StringBuilder buildOrganizationAccountDumpFile(String principalId, String fieldSeperator, String textDelimiter) {
        this.updateAccountDump(principalId);
        StringBuilder results = new StringBuilder();
        List<BudgetConstructionAccountDump> accountDumpRecords = this.getBudgetConstructionAccountDump(principalId);
        for (BudgetConstructionAccountDump accountRecord : accountDumpRecords) {
            List<PendingBudgetConstructionGeneralLedger> pendingEntryList = this.getPendingBudgetConstructionGeneralLedgerRecords(accountRecord);
            for (PendingBudgetConstructionGeneralLedger pendingEntry : pendingEntryList) {
                results.append(this.constructAccountDumpLine(pendingEntry, textDelimiter, fieldSeperator));
            }
        }
        this.reportDumpDao.cleanAccountDump(principalId);
        return results;
    }

    @Override
    public StringBuilder buildOrganizationFundingDumpFile(String principalId, String fieldSeperator, String textDelimiter) {
        this.updateAccountDump(principalId);
        StringBuilder results = new StringBuilder();
        List<BudgetConstructionAccountDump> accountDumpRecords = this.getBudgetConstructionAccountDump(principalId);
        for (BudgetConstructionAccountDump accountRecord : accountDumpRecords) {
            List<PendingBudgetConstructionAppointmentFunding> pendingBudgetConstructionAppointmentFundingList = this.getPendingBudgetConstructionAppointmentFundingRecords(accountRecord);
            for (PendingBudgetConstructionAppointmentFunding fundingRecord : pendingBudgetConstructionAppointmentFundingList) {
                results.append(this.constructFundingDumpLine(fundingRecord, fieldSeperator, textDelimiter));
            }
        }
        this.reportDumpDao.cleanAccountDump(principalId);
        return results;
    }

    @Override
    public StringBuilder buildOrganizationMonthlyDumpFile(String principalId, String fieldSeperator, String textDelimiter) {
        this.updateAccountDump(principalId);
        StringBuilder results = new StringBuilder();
        List<BudgetConstructionAccountDump> accountDumpRecords = this.getBudgetConstructionAccountDump(principalId);
        for (BudgetConstructionAccountDump accountRecord : accountDumpRecords) {
            List<BudgetConstructionMonthly> budgetConstructionMonthlyList = this.getBudgetConstructionMonthlyRecords(accountRecord);
            for (BudgetConstructionMonthly monthlyRecord : budgetConstructionMonthlyList) {
                results.append(this.constructMonthlyDumpLine(monthlyRecord, fieldSeperator, textDelimiter));
            }
        }
        this.reportDumpDao.cleanAccountDump(principalId);
        return results;
    }

    @Override
    public StringBuilder buildAccountDumpFile(String principalId, String fieldSeperator, String textDelimiter, Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        StringBuilder results = new StringBuilder();
        HashMap<String, Object> searchFields = new HashMap<String, Object>();
        searchFields.put("universityFiscalYear", universityFiscalYear);
        searchFields.put("chartOfAccountsCode", chartOfAccountsCode);
        searchFields.put("accountNumber", accountNumber);
        searchFields.put("subAccountNumber", subAccountNumber);
        ArrayList pendingEntryList = new ArrayList(this.businessObjectService.findMatching(PendingBudgetConstructionGeneralLedger.class, searchFields));
        for (PendingBudgetConstructionGeneralLedger pendingEntry : pendingEntryList) {
            results.append(this.constructAccountDumpLine(pendingEntry, textDelimiter, fieldSeperator));
        }
        return results;
    }

    @Override
    public StringBuilder buildAccountFundingDumpFile(String principalId, String fieldSeperator, String textDelimiter, Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        StringBuilder results = new StringBuilder();
        HashMap<String, Object> searchFields = new HashMap<String, Object>();
        searchFields.put("universityFiscalYear", universityFiscalYear);
        searchFields.put("chartOfAccountsCode", chartOfAccountsCode);
        searchFields.put("accountNumber", accountNumber);
        searchFields.put("subAccountNumber", subAccountNumber);
        ArrayList pendingBudgetConstructionAppointmentFundingList = new ArrayList(this.businessObjectService.findMatching(PendingBudgetConstructionAppointmentFunding.class, searchFields));
        for (PendingBudgetConstructionAppointmentFunding fundingRecord : pendingBudgetConstructionAppointmentFundingList) {
            results.append(this.constructFundingDumpLine(fundingRecord, fieldSeperator, textDelimiter));
        }
        return results;
    }

    @Override
    public StringBuilder buildAccountMonthlyDumpFile(String principalId, String fieldSeperator, String textDelimiter, Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        StringBuilder results = new StringBuilder();
        HashMap<String, Object> searchFields = new HashMap<String, Object>();
        searchFields.put("universityFiscalYear", universityFiscalYear);
        searchFields.put("chartOfAccountsCode", chartOfAccountsCode);
        searchFields.put("accountNumber", accountNumber);
        searchFields.put("subAccountNumber", subAccountNumber);
        ArrayList budgetConstructionMonthlyList = new ArrayList(this.businessObjectService.findMatching(BudgetConstructionMonthly.class, searchFields));
        for (BudgetConstructionMonthly monthlyRecord : budgetConstructionMonthlyList) {
            results.append(this.constructMonthlyDumpLine(monthlyRecord, fieldSeperator, textDelimiter));
        }
        return results;
    }

    public void setReportDumpDao(ReportDumpDao reportDumpDao) {
        this.reportDumpDao = reportDumpDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected List<PendingBudgetConstructionGeneralLedger> getPendingBudgetConstructionGeneralLedgerRecords(BudgetConstructionAccountDump accountRecord) {
        HashMap<String, Object> searchParameters = new HashMap<String, Object>();
        searchParameters.put("universityFiscalYear", accountRecord.getUniversityFiscalYear());
        searchParameters.put("chartOfAccountsCode", accountRecord.getChartOfAccountsCode());
        searchParameters.put("accountNumber", accountRecord.getAccountNumber());
        searchParameters.put("subAccountNumber", accountRecord.getSubAccountNumber());
        ArrayList<PendingBudgetConstructionGeneralLedger> results = new ArrayList<PendingBudgetConstructionGeneralLedger>(this.businessObjectService.findMatchingOrderBy(PendingBudgetConstructionGeneralLedger.class, searchParameters, "financialObjectCode", true));
        DynamicCollectionComparator.sort(results, (String[])new String[]{"financialObjectCode", "financialSubObjectCode"});
        return results;
    }

    protected List<PendingBudgetConstructionAppointmentFunding> getPendingBudgetConstructionAppointmentFundingRecords(BudgetConstructionAccountDump accountRecord) {
        HashMap<String, Object> searchParameters = new HashMap<String, Object>();
        searchParameters.put("universityFiscalYear", accountRecord.getUniversityFiscalYear());
        searchParameters.put("chartOfAccountsCode", accountRecord.getChartOfAccountsCode());
        searchParameters.put("accountNumber", accountRecord.getAccountNumber());
        searchParameters.put("subAccountNumber", accountRecord.getSubAccountNumber());
        ArrayList<PendingBudgetConstructionAppointmentFunding> results = new ArrayList<PendingBudgetConstructionAppointmentFunding>(this.businessObjectService.findMatchingOrderBy(PendingBudgetConstructionAppointmentFunding.class, searchParameters, "financialObjectCode", true));
        DynamicCollectionComparator.sort(results, (String[])new String[]{"financialObjectCode", "financialSubObjectCode", "positionNumber", "emplid"});
        return results;
    }

    protected List<BudgetConstructionMonthly> getBudgetConstructionMonthlyRecords(BudgetConstructionAccountDump accountRecord) {
        HashMap<String, Object> searchParameters = new HashMap<String, Object>();
        searchParameters.put("universityFiscalYear", accountRecord.getUniversityFiscalYear());
        searchParameters.put("chartOfAccountsCode", accountRecord.getChartOfAccountsCode());
        searchParameters.put("accountNumber", accountRecord.getAccountNumber());
        searchParameters.put("subAccountNumber", accountRecord.getSubAccountNumber());
        ArrayList<BudgetConstructionMonthly> results = new ArrayList<BudgetConstructionMonthly>(this.businessObjectService.findMatchingOrderBy(BudgetConstructionMonthly.class, searchParameters, "financialObjectCode", true));
        DynamicCollectionComparator.sort(results, (String[])new String[]{"financialObjectCode", "financialSubObjectCode"});
        return results;
    }

    protected List<BudgetConstructionAccountDump> getBudgetConstructionAccountDump(String principalId) {
        HashMap<String, String> searchParameters = new HashMap<String, String>();
        searchParameters.put("principalId", principalId);
        return new ArrayList<BudgetConstructionAccountDump>(this.businessObjectService.findMatching(BudgetConstructionAccountDump.class, searchParameters));
    }

    protected String constructAccountDumpLine(PendingBudgetConstructionGeneralLedger pendingEntry, String textDelimiter, String fieldSeperator) {
        HashMap<String, String> accountReportSearchParameters = new HashMap<String, String>();
        accountReportSearchParameters.put("chartOfAccountsCode", pendingEntry.getChartOfAccountsCode());
        accountReportSearchParameters.put("accountNumber", pendingEntry.getAccountNumber());
        BudgetConstructionAccountReports accountReport = (BudgetConstructionAccountReports)this.businessObjectService.findByPrimaryKey(BudgetConstructionAccountReports.class, accountReportSearchParameters);
        String line = "";
        line = textDelimiter + pendingEntry.getDocumentNumber() + textDelimiter + fieldSeperator;
        line = line + pendingEntry.getUniversityFiscalYear() + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getChartOfAccountsCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getAccountNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + accountReport.getReportsToOrganizationCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getSubAccountNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getFinancialObjectCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getFinancialSubObjectCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getFinancialBalanceTypeCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + pendingEntry.getFinancialObjectTypeCode() + textDelimiter + fieldSeperator;
        line = line + pendingEntry.getFinancialBeginningBalanceLineAmount() + fieldSeperator;
        line = line + pendingEntry.getAccountLineAnnualBalanceAmount() + fieldSeperator;
        line = line + textDelimiter + accountReport.getBudgetConstructionOrganizationReports().getResponsibilityCenterCode() + textDelimiter;
        line = line + "\r\n";
        return line;
    }

    protected String constructFundingDumpLine(PendingBudgetConstructionAppointmentFunding fundingRecord, String fieldSeperator, String textDelimiter) {
        HashMap<String, String> accountReportSearchParameters = new HashMap<String, String>();
        accountReportSearchParameters.put("chartOfAccountsCode", fundingRecord.getChartOfAccountsCode());
        accountReportSearchParameters.put("accountNumber", fundingRecord.getAccountNumber());
        BudgetConstructionAccountReports accountReport = (BudgetConstructionAccountReports)this.businessObjectService.findByPrimaryKey(BudgetConstructionAccountReports.class, accountReportSearchParameters);
        if (!fundingRecord.getEmplid().equals("VACANT")) {
            fundingRecord.refreshReferenceObject("budgetConstructionIntendedIncumbent");
        }
        String line = "";
        line = line + fundingRecord.getUniversityFiscalYear() + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getChartOfAccountsCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getAccountNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + accountReport.getReportsToOrganizationCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getSubAccountNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getFinancialObjectCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getFinancialSubObjectCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getPositionNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getBudgetConstructionPosition().getPositionDescription() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getBudgetConstructionPosition().getSetidSalary() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getBudgetConstructionPosition().getPositionSalaryPlanDefault() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getBudgetConstructionPosition().getPositionGradeDefault() + textDelimiter + fieldSeperator;
        line = line + fundingRecord.getBudgetConstructionPosition().getIuNormalWorkMonths() + fieldSeperator;
        line = line + fundingRecord.getBudgetConstructionPosition().getIuPayMonths() + fieldSeperator;
        line = line + textDelimiter + fundingRecord.getEmplid() + textDelimiter + fieldSeperator;
        if (ObjectUtils.isNotNull((Object)fundingRecord.getBudgetConstructionIntendedIncumbent())) {
            line = line + textDelimiter + fundingRecord.getBudgetConstructionIntendedIncumbent().getName() + textDelimiter + fieldSeperator;
            line = line + textDelimiter + fundingRecord.getBudgetConstructionIntendedIncumbent().getIuClassificationLevel() + textDelimiter + fieldSeperator;
        } else {
            line = line + textDelimiter + textDelimiter + fieldSeperator;
            line = line + textDelimiter + textDelimiter + fieldSeperator;
        }
        line = ObjectUtils.isNotNull((Object)((Object)fundingRecord.getBudgetConstructionAdministrativePost())) ? line + textDelimiter + fundingRecord.getBudgetConstructionAdministrativePost().getAdministrativePost() + textDelimiter + fieldSeperator : line + textDelimiter + textDelimiter + fieldSeperator;
        if (fundingRecord.getBcnCalculatedSalaryFoundationTracker().isEmpty()) {
            line = line + "" + fieldSeperator;
            line = line + "" + fieldSeperator;
            line = line + "" + fieldSeperator;
        } else {
            line = line + new KualiDecimal(fundingRecord.getBcnCalculatedSalaryFoundationTracker().get(0).getCsfAmount().intValue()) + fieldSeperator;
            line = line + new KualiDecimal(fundingRecord.getBcnCalculatedSalaryFoundationTracker().get(0).getCsfFullTimeEmploymentQuantity()) + fieldSeperator;
            line = line + new KualiDecimal(fundingRecord.getBcnCalculatedSalaryFoundationTracker().get(0).getCsfTimePercent()) + fieldSeperator;
        }
        line = line + textDelimiter + fundingRecord.getAppointmentFundingDurationCode() + textDelimiter + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedCsfAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedCsfFteQuantity()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedTimePercent()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentTotalIntendedAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentTotalIntendedFteQuantity()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedTimePercent()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedFteQuantity()) + fieldSeperator;
        line = line + new KualiDecimal(fundingRecord.getAppointmentRequestedPayRate()) + fieldSeperator;
        line = line + textDelimiter + (fundingRecord.isAppointmentFundingDeleteIndicator() ? "Y" : "N") + textDelimiter + fieldSeperator;
        line = line + fundingRecord.getAppointmentFundingMonth() + fieldSeperator;
        List<BudgetConstructionAppointmentFundingReason> appointmentFundingReasonList = fundingRecord.getBudgetConstructionAppointmentFundingReason();
        line = ObjectUtils.isNotNull(appointmentFundingReasonList) && !appointmentFundingReasonList.isEmpty() ? line + textDelimiter + (appointmentFundingReasonList.get(0).getAppointmentFundingReasonCode() == null ? "" : appointmentFundingReasonList.get(0).getAppointmentFundingReasonCode()) + textDelimiter + fieldSeperator : line + textDelimiter + "" + textDelimiter + fieldSeperator;
        line = line + textDelimiter + accountReport.getBudgetConstructionOrganizationReports().getResponsibilityCenterCode() + textDelimiter;
        line = line + "\r\n";
        return line;
    }

    protected String constructMonthlyDumpLine(BudgetConstructionMonthly monthlyRecord, String fieldSeperator, String textDelimiter) {
        HashMap<String, String> accountReportSearchParameters = new HashMap<String, String>();
        accountReportSearchParameters.put("chartOfAccountsCode", monthlyRecord.getChartOfAccountsCode());
        accountReportSearchParameters.put("accountNumber", monthlyRecord.getAccountNumber());
        BudgetConstructionAccountReports accountReport = (BudgetConstructionAccountReports)this.businessObjectService.findByPrimaryKey(BudgetConstructionAccountReports.class, accountReportSearchParameters);
        String line = "";
        line = line + textDelimiter + monthlyRecord.getDocumentNumber() + textDelimiter + fieldSeperator;
        line = line + monthlyRecord.getUniversityFiscalYear() + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getChartOfAccountsCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getAccountNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + accountReport.getReportsToOrganizationCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getSubAccountNumber() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getFinancialObjectCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getFinancialSubObjectCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getFinancialBalanceTypeCode() + textDelimiter + fieldSeperator;
        line = line + textDelimiter + monthlyRecord.getFinancialObjectTypeCode() + textDelimiter + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth1LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth2LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth3LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth4LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth5LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth6LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth7LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth8LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth9LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth10LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth11LineAmount().intValue()) + fieldSeperator;
        line = line + new KualiDecimal(monthlyRecord.getFinancialDocumentMonth12LineAmount().intValue()) + fieldSeperator;
        line = line + textDelimiter + accountReport.getBudgetConstructionOrganizationReports().getResponsibilityCenterCode() + textDelimiter;
        line = line + "\r\n";
        return line;
    }
}

