/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;

public class BudgetConstructionOrganizationReportsRule
extends MaintenanceDocumentRuleBase {
    protected static final Logger LOG = Logger.getLogger(BudgetConstructionOrganizationReportsRule.class);
    protected OrganizationService orgService;
    protected ChartService chartService;
    protected BudgetConstructionOrganizationReportsService bcOrgReportsService;
    protected BudgetConstructionOrganizationReports oldBCOrgReports;
    protected BudgetConstructionOrganizationReports newBCOrgReports;

    public BudgetConstructionOrganizationReportsRule() {
        this.setOrgService((OrganizationService)SpringContext.getBean(OrganizationService.class));
        this.setChartService((ChartService)SpringContext.getBean(ChartService.class));
        this.setBCOrgReportsService((BudgetConstructionOrganizationReportsService)SpringContext.getBean(BudgetConstructionOrganizationReportsService.class));
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        LOG.debug((Object)"Entering processCustomApproveDocumentBusinessRules()");
        return success &= this.checkSimpleRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        LOG.debug((Object)"Entering processCustomRouteDocumentBusinessRules()");
        return success &= this.checkSimpleRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering processCustomSaveDocumentBusinessRules()");
        this.checkSimpleRules(document);
        return true;
    }

    protected boolean checkSimpleRules(MaintenanceDocument document) {
        boolean success = true;
        Integer maxLoopCount = 40;
        boolean orgMustReportToSelf = false;
        Organization tempOrg = null;
        if (ObjectUtils.isNotNull((Object)this.newBCOrgReports.getChartOfAccountsCode()) && ObjectUtils.isNotNull((Object)this.newBCOrgReports.getOrganizationCode()) && ObjectUtils.isNotNull((Object)(tempOrg = this.orgService.getByPrimaryId(this.newBCOrgReports.getChartOfAccountsCode(), this.newBCOrgReports.getOrganizationCode()))) && ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(Organization.class, "ORGANIZATION_TYPES_THAT_MUST_REPORT_TO_SELF", tempOrg.getOrganizationTypeCode()).evaluationSucceeds()) {
            orgMustReportToSelf = true;
        }
        if (ObjectUtils.isNotNull((Object)this.newBCOrgReports.getReportsToChartOfAccountsCode()) && ObjectUtils.isNotNull((Object)this.newBCOrgReports.getReportsToOrganizationCode()) && ObjectUtils.isNotNull((Object)this.newBCOrgReports.getChartOfAccountsCode()) && ObjectUtils.isNotNull((Object)this.newBCOrgReports.getOrganizationCode())) {
            if (!orgMustReportToSelf) {
                if (this.newBCOrgReports.getReportsToChartOfAccountsCode().equals(this.newBCOrgReports.getChartOfAccountsCode()) && this.newBCOrgReports.getReportsToOrganizationCode().equals(this.newBCOrgReports.getOrganizationCode())) {
                    this.putFieldError("reportsToOrganizationCode", "error.document.orgMaintenance.reportingOrgCannotBeSameOrg");
                    success = false;
                } else {
                    String lastReportsToChartOfAccountsCode = this.newBCOrgReports.getReportsToChartOfAccountsCode();
                    String lastReportsToOrganizationCode = this.newBCOrgReports.getReportsToOrganizationCode();
                    boolean continueSearch = true;
                    Integer loopCount = 0;
                    do {
                        BudgetConstructionOrganizationReports tempBCOrgReports = this.bcOrgReportsService.getByPrimaryId(lastReportsToChartOfAccountsCode, lastReportsToOrganizationCode);
                        Integer n = loopCount;
                        Integer n2 = loopCount = Integer.valueOf(loopCount + 1);
                        if (ObjectUtils.isNull((Object)((Object)tempBCOrgReports))) {
                            continueSearch = false;
                            if (loopCount == 1) {
                                this.putFieldError("reportsToOrganizationCode", "error.document.orgMaintenance.reportingOrgMustExist");
                                success = false;
                            }
                        } else {
                            lastReportsToChartOfAccountsCode = tempBCOrgReports.getReportsToChartOfAccountsCode();
                            lastReportsToOrganizationCode = tempBCOrgReports.getReportsToOrganizationCode();
                            if (tempBCOrgReports.getReportsToChartOfAccountsCode().equals(this.newBCOrgReports.getChartOfAccountsCode()) && tempBCOrgReports.getReportsToOrganizationCode().equals(this.newBCOrgReports.getOrganizationCode())) {
                                this.putFieldError("reportsToOrganizationCode", "error.document.orgMaintenance.reportingOrgCannotBeCircularRefToSameOrg");
                                success = false;
                                continueSearch = false;
                            }
                        }
                        if (loopCount > maxLoopCount) {
                            continueSearch = false;
                        }
                        if (!continueSearch || !tempBCOrgReports.getReportsToChartOfAccountsCode().equals(tempBCOrgReports.getReportsToChartOfAccountsCode()) || !tempBCOrgReports.getReportsToOrganizationCode().equals(tempBCOrgReports.getOrganizationCode())) continue;
                        continueSearch = false;
                    } while (continueSearch);
                }
            } else if (!this.newBCOrgReports.getReportsToChartOfAccountsCode().equals(this.newBCOrgReports.getChartOfAccountsCode()) || !this.newBCOrgReports.getReportsToOrganizationCode().equals(this.newBCOrgReports.getOrganizationCode())) {
                this.putFieldError("reportsToOrganizationCode", "error.document.orgMaintenance.reportingOrgMustBeSameOrg");
                success = false;
            }
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.oldBCOrgReports = (BudgetConstructionOrganizationReports)((Object)super.getOldBo());
        this.newBCOrgReports = (BudgetConstructionOrganizationReports)((Object)super.getNewBo());
    }

    public void setOrgService(OrganizationService orgService) {
        this.orgService = orgService;
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
    }

    public void setBCOrgReportsService(BudgetConstructionOrganizationReportsService bcOrgReportsService) {
        this.bcOrgReportsService = bcOrgReportsService;
    }
}

