/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.rules.rule.SaveDocumentRule;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.validation.AddBudgetConstructionDocumentRule;
import org.kuali.kfs.module.bc.document.validation.AddPendingBudgetGeneralLedgerLineRule;
import org.kuali.kfs.module.bc.document.validation.BudgetExpansionRule;
import org.kuali.kfs.module.bc.document.validation.DeleteMonthlySpreadRule;
import org.kuali.kfs.module.bc.document.validation.DeletePendingBudgetGeneralLedgerLineRule;
import org.kuali.kfs.module.bc.document.validation.SalarySettingRule;
import org.kuali.kfs.module.bc.document.validation.SaveMonthlyBudgetRule;
import org.kuali.kfs.module.bc.document.validation.event.BudgetExpansionEvent;
import org.kuali.kfs.module.bc.document.validation.impl.BudgetConstructionDocumentRules;
import org.kuali.kfs.module.bc.document.validation.impl.SalarySettingRules;

public class BudgetConstructionRules
implements BudgetExpansionRule,
SalarySettingRule,
SaveDocumentRule,
AddBudgetConstructionDocumentRule<BudgetConstructionDocument>,
AddPendingBudgetGeneralLedgerLineRule<BudgetConstructionDocument, PendingBudgetConstructionGeneralLedger>,
DeletePendingBudgetGeneralLedgerLineRule<BudgetConstructionDocument, PendingBudgetConstructionGeneralLedger>,
DeleteMonthlySpreadRule<BudgetConstructionDocument>,
SaveMonthlyBudgetRule<BudgetConstructionDocument, BudgetConstructionMonthly> {
    private Collection<BusinessRule> expansionRules = new ArrayList<BusinessRule>();
    private BudgetConstructionDocumentRules budgetConstructionDocumentRules;
    private SalarySettingRule salarySettingRules;

    public BudgetConstructionRules() {
        try {
            this.budgetConstructionDocumentRules = (BudgetConstructionDocumentRules)BudgetConstructionDocumentRules.class.newInstance();
            this.expansionRules.add((BusinessRule)this.budgetConstructionDocumentRules);
            this.salarySettingRules = (SalarySettingRule)SalarySettingRules.class.newInstance();
            this.expansionRules.add(this.salarySettingRules);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean processExpansionRule(BudgetExpansionEvent budgetExpansionEvent) {
        boolean valid = true;
        Class expansionRuleClass = budgetExpansionEvent.getExpansionRuleInterfaceClass();
        for (BusinessRule expansionRule : this.expansionRules) {
            if (!expansionRuleClass.isAssignableFrom(expansionRule.getClass())) continue;
            valid &= budgetExpansionEvent.invokeExpansionRuleMethod(expansionRule);
        }
        return valid;
    }

    public boolean processSaveDocument(Document document) {
        return this.budgetConstructionDocumentRules.processSaveDocument(document);
    }

    @Override
    public boolean processAddBudgetConstructionDocumentRules(BudgetConstructionDocument budgetConstructionDocument) {
        return this.budgetConstructionDocumentRules.processAddBudgetConstructionDocumentRules(budgetConstructionDocument);
    }

    @Override
    public boolean processAddPendingBudgetGeneralLedgerLineRules(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger, boolean isRevenue) {
        return this.budgetConstructionDocumentRules.processAddPendingBudgetGeneralLedgerLineRules(budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, isRevenue);
    }

    @Override
    public boolean processDeletePendingBudgetGeneralLedgerLineRules(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger, boolean isRevenue) {
        return this.budgetConstructionDocumentRules.processDeletePendingBudgetGeneralLedgerLineRules(budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, isRevenue);
    }

    @Override
    public boolean processDeleteMonthlySpreadRules(BudgetConstructionDocument budgetConstructionDocument, BCConstants.MonthSpreadDeleteType monthSpreadDeleteType) {
        return this.budgetConstructionDocumentRules.processDeleteMonthlySpreadRules(budgetConstructionDocument, monthSpreadDeleteType);
    }

    @Override
    public boolean processSaveMonthlyBudgetRules(BudgetConstructionDocument budgetConstructionDocument, BudgetConstructionMonthly budgetConstructionMonthly) {
        return this.budgetConstructionDocumentRules.processSaveMonthlyBudgetRules(budgetConstructionDocument, budgetConstructionMonthly);
    }

    @Override
    public boolean processAddAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> existingAppointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding, BCConstants.SynchronizationCheckType synchronizationCheckType) {
        return this.salarySettingRules.processAddAppointmentFunding(existingAppointmentFundings, appointmentFunding, synchronizationCheckType);
    }

    @Override
    public boolean processSaveAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding, BCConstants.SynchronizationCheckType synchronizationCheckType) {
        return this.salarySettingRules.processSaveAppointmentFunding(appointmentFunding, synchronizationCheckType);
    }

    @Override
    public boolean processNormalizePayrateAndAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        return this.salarySettingRules.processNormalizePayrateAndAmount(appointmentFunding);
    }

    @Override
    public boolean processAdjustSalaraySettingLinePercent(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        return this.salarySettingRules.processAdjustSalaraySettingLinePercent(appointmentFunding);
    }

    @Override
    public boolean processQuickSaveAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        return this.salarySettingRules.processQuickSaveAppointmentFunding(appointmentFunding);
    }
}

