/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionRuleHelperService;
import org.kuali.kfs.module.bc.document.service.SalarySettingRuleHelperService;
import org.kuali.kfs.module.bc.document.validation.SalarySettingRule;
import org.kuali.kfs.module.bc.service.HumanResourcesPayrollService;
import org.kuali.kfs.sys.context.SpringContext;

public class SalarySettingRules
implements SalarySettingRule {
    private static final Logger LOG = Logger.getLogger(SalarySettingRules.class);
    protected BudgetConstructionRuleHelperService budgetConstructionRuleHelperService = (BudgetConstructionRuleHelperService)SpringContext.getBean(BudgetConstructionRuleHelperService.class);
    protected SalarySettingRuleHelperService salarySettingRuleHelperService = (SalarySettingRuleHelperService)SpringContext.getBean(SalarySettingRuleHelperService.class);
    protected HumanResourcesPayrollService humanResourcesPayrollService = (HumanResourcesPayrollService)SpringContext.getBean(HumanResourcesPayrollService.class);
    protected MessageMap errorMap = GlobalVariables.getMessageMap();

    @Override
    public boolean processQuickSaveAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        boolean isAssociatedWithBudgetableDocument;
        LOG.debug((Object)"processQuickSaveAppointmentFunding() start");
        boolean hasValidFormat = this.budgetConstructionRuleHelperService.isFieldFormatValid(appointmentFunding, this.errorMap);
        if (!hasValidFormat) {
            return hasValidFormat;
        }
        MessageMap tempErrorMap = new MessageMap();
        tempErrorMap.addToErrorPath("salarySettingExpansion");
        boolean hasValidReference = true;
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidObjectCode(appointmentFunding, tempErrorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidSubObjectCode(appointmentFunding, tempErrorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidIncumbentQuickSalarySetting(appointmentFunding, this.errorMap);
        if (!(hasValidReference &= this.budgetConstructionRuleHelperService.hasValidPosition(appointmentFunding, this.errorMap))) {
            this.errorMap.merge(tempErrorMap);
            return hasValidReference;
        }
        String defaultObjectCode = appointmentFunding.getBudgetConstructionPosition().getIuDefaultObjectCode();
        String objectCode = appointmentFunding.getFinancialObjectCode();
        if (!StringUtils.equals((String)objectCode, (String)defaultObjectCode)) {
            this.errorMap.putError("positionNumber", "error.budget.notDefaultObjectCode", new String[]{defaultObjectCode});
            return false;
        }
        if (!appointmentFunding.getEmplid().equalsIgnoreCase("VACANT")) {
            String positionNumber;
            Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
            String emplid = appointmentFunding.getEmplid();
            boolean hasActiveJob = this.humanResourcesPayrollService.isActiveJob(emplid, positionNumber = appointmentFunding.getPositionNumber(), fiscalYear, BCConstants.SynchronizationCheckType.NONE);
            if (!hasActiveJob) {
                this.errorMap.putError("positionNumber", "error.budget.noActiveJobFound", new String[]{appointmentFunding.getEmplid(), appointmentFunding.getPositionNumber()});
                return hasActiveJob;
            }
        }
        if (!(isAssociatedWithBudgetableDocument = this.budgetConstructionRuleHelperService.isAssociatedWithValidDocument(appointmentFunding, this.errorMap, "appointmentRequestedAmount"))) {
            return isAssociatedWithBudgetableDocument;
        }
        boolean hasValidAmounts = this.hasValidAmountsQuickSalarySetting(appointmentFunding, this.errorMap);
        if (!hasValidAmounts) {
            return hasValidAmounts;
        }
        return true;
    }

    @Override
    public boolean processSaveAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding, BCConstants.SynchronizationCheckType synchronizationCheckType) {
        LOG.debug((Object)"processSaveAppointmentFunding() start");
        boolean hasValidFormat = this.budgetConstructionRuleHelperService.isFieldFormatValid(appointmentFunding, this.errorMap);
        if (!hasValidFormat) {
            return hasValidFormat;
        }
        boolean hasValidReferences = this.hasValidRefences(appointmentFunding, this.errorMap);
        if (!hasValidReferences) {
            return hasValidReferences;
        }
        boolean isObjectCodeMatching = this.salarySettingRuleHelperService.hasObjectCodeMatchingDefaultOfPosition(appointmentFunding, this.errorMap);
        if (!isObjectCodeMatching) {
            return isObjectCodeMatching;
        }
        boolean hasActiveJob = this.salarySettingRuleHelperService.hasActiveJob(appointmentFunding, this.errorMap, synchronizationCheckType);
        if (!hasActiveJob) {
            return hasActiveJob;
        }
        boolean isAssociatedWithBudgetableDocument = this.budgetConstructionRuleHelperService.isAssociatedWithValidDocument(appointmentFunding, this.errorMap, "appointmentRequestedAmount");
        if (!isAssociatedWithBudgetableDocument) {
            return isAssociatedWithBudgetableDocument;
        }
        boolean hasValidAmounts = this.hasValidAmounts(appointmentFunding, this.errorMap);
        if (!hasValidAmounts) {
            return hasValidAmounts;
        }
        return true;
    }

    @Override
    public boolean processAddAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> existingAppointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding, BCConstants.SynchronizationCheckType synchronizationCheckType) {
        LOG.debug((Object)"processAddAppointmentFunding() start");
        boolean hasNoExistingLine = this.salarySettingRuleHelperService.hasNoExistingLine(existingAppointmentFundings, appointmentFunding, this.errorMap);
        if (!hasNoExistingLine) {
            return hasNoExistingLine;
        }
        boolean hasValidFormat = this.budgetConstructionRuleHelperService.isFieldFormatValid(appointmentFunding, this.errorMap);
        if (!hasValidFormat) {
            return hasValidFormat;
        }
        boolean hasValidReferences = this.hasValidRefences(appointmentFunding, this.errorMap);
        if (!hasValidReferences) {
            return hasValidReferences;
        }
        boolean isObjectCodeMatching = this.salarySettingRuleHelperService.hasObjectCodeMatchingDefaultOfPosition(appointmentFunding, this.errorMap);
        if (!isObjectCodeMatching) {
            return isObjectCodeMatching;
        }
        boolean hasActiveJob = this.salarySettingRuleHelperService.hasActiveJob(appointmentFunding, this.errorMap, synchronizationCheckType);
        if (!hasActiveJob) {
            return hasActiveJob;
        }
        boolean isAssociatedWithBudgetableDocument = this.budgetConstructionRuleHelperService.isAssociatedWithValidDocument(appointmentFunding, this.errorMap, "accountNumber");
        if (!isAssociatedWithBudgetableDocument) {
            return isAssociatedWithBudgetableDocument;
        }
        appointmentFunding.setBudgetable(Boolean.TRUE);
        boolean hasValidAmounts = this.hasValidAmounts(appointmentFunding, this.errorMap);
        if (!hasValidAmounts) {
            return hasValidAmounts;
        }
        return true;
    }

    @Override
    public boolean processAdjustSalaraySettingLinePercent(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        boolean canBeAdjusted = this.salarySettingRuleHelperService.canBeAdjusted(appointmentFunding, this.errorMap);
        if (!canBeAdjusted) {
            return false;
        }
        boolean hasValidAdjustmentAmount = this.salarySettingRuleHelperService.hasValidAdjustmentAmount(appointmentFunding, this.errorMap);
        return hasValidAdjustmentAmount;
    }

    @Override
    public boolean processNormalizePayrateAndAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        return this.salarySettingRuleHelperService.hasValidPayRateOrAnnualAmount(appointmentFunding, this.errorMap);
    }

    private boolean hasValidRefences(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        boolean hasValidReference = this.budgetConstructionRuleHelperService.hasValidChart(appointmentFunding, errorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidAccount(appointmentFunding, errorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidObjectCode(appointmentFunding, errorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidSubAccount(appointmentFunding, errorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidSubObjectCode(appointmentFunding, errorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasDetailPositionRequiredObjectCode(appointmentFunding, errorMap);
        hasValidReference &= this.budgetConstructionRuleHelperService.hasValidPosition(appointmentFunding, errorMap);
        return hasValidReference &= this.budgetConstructionRuleHelperService.hasValidIncumbent(appointmentFunding, errorMap);
    }

    private boolean hasValidAmounts(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        boolean hasValidAmounts = this.salarySettingRuleHelperService.hasValidRequestedAmount(appointmentFunding, errorMap);
        hasValidAmounts &= this.salarySettingRuleHelperService.hasValidRequestedFteQuantity(appointmentFunding, errorMap);
        hasValidAmounts &= this.salarySettingRuleHelperService.hasValidRequestedFundingMonth(appointmentFunding, errorMap);
        hasValidAmounts &= this.salarySettingRuleHelperService.hasValidRequestedTimePercent(appointmentFunding, errorMap);
        hasValidAmounts &= this.salarySettingRuleHelperService.hasRequestedAmountZeroWhenFullYearLeave(appointmentFunding, errorMap);
        hasValidAmounts &= this.salarySettingRuleHelperService.hasRequestedFteQuantityZeroWhenFullYearLeave(appointmentFunding, errorMap);
        hasValidAmounts &= this.salarySettingRuleHelperService.hasValidRequestedCsfAmount(appointmentFunding, errorMap);
        return hasValidAmounts &= this.salarySettingRuleHelperService.hasValidRequestedCsfTimePercent(appointmentFunding, errorMap);
    }

    private boolean hasValidAmountsQuickSalarySetting(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        boolean hasValidAmounts = this.salarySettingRuleHelperService.hasValidRequestedAmountQuickSalarySetting(appointmentFunding, errorMap);
        return hasValidAmounts;
    }
}

