/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.businessobject.BCKeyLabelPair;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BenefitsCalculationService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionProcessorService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.BudgetParameterService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentFormBase;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;

public class BudgetConstructionForm
extends FinancialSystemTransactionalDocumentFormBase {
    private static final Logger LOG = Logger.getLogger(BudgetConstructionForm.class);
    protected PendingBudgetConstructionGeneralLedger newRevenueLine;
    protected PendingBudgetConstructionGeneralLedger newExpenditureLine;
    protected static String revenueObjectTypeCodesLookup;
    protected static String expenditureObjectTypeCodesLookup;
    protected boolean closingDocument = false;
    protected boolean hideDetails = false;
    protected boolean pickListClose = false;
    protected boolean securityNoAccess = false;
    protected boolean hideAdjustmentMeasurement = true;
    protected KualiDecimal revenueAdjustmentAmount;
    protected KualiDecimal expenditureAdjustmentAmount;
    protected List<BCKeyLabelPair> pushdownLevelKeyLabels;
    protected List<BCKeyLabelPair> pullupLevelKeyLabels;
    protected String pushdownKeyCode;
    protected String pullupKeyCode;
    protected List<BudgetConstructionAccountOrganizationHierarchy> accountOrgHierLevels;
    protected boolean checkTwoPlugAdjustment = false;
    protected HashMap<String, PendingBudgetConstructionGeneralLedger> preSalarySettingRows;
    protected String backLocation;
    protected String returnAnchor;
    protected String returnFormKey;
    protected Integer universityFiscalYear;
    protected String chartOfAccountsCode;
    protected String accountNumber;
    protected String subAccountNumber;
    protected boolean pickListMode;
    protected boolean accountReportsExist;
    protected boolean mainWindow = false;
    protected String balanceInquiryReturnAnchor;
    protected String dashSubAccountNumber;
    protected String dashFinancialSubObjectCode;

    public BudgetConstructionForm() {
        this.setNewExpenditureLine(new PendingBudgetConstructionGeneralLedger());
        this.setNewRevenueLine(new PendingBudgetConstructionGeneralLedger());
        this.setAccountOrgHierLevels(new ArrayList<BudgetConstructionAccountOrganizationHierarchy>());
        this.setPullupLevelKeyLabels(new ArrayList<BCKeyLabelPair>());
        this.setPushdownLevelKeyLabels(new ArrayList<BCKeyLabelPair>());
        this.setDashFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        this.setDashSubAccountNumber(KFSConstants.getDashSubAccountNumber());
        LOG.debug((Object)"creating BudgetConstructionForm");
    }

    protected String getDefaultDocumentTypeName() {
        return "BC";
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        String methodToCall = this.getMethodToCall();
        BudgetConstructionDocument bcDoc = this.getBudgetConstructionDocument();
        if (StringUtils.isNotBlank((String)methodToCall)) {
            if (methodToCall.equals("insertRevenueLine")) {
                PendingBudgetConstructionGeneralLedger revLine = this.getNewRevenueLine();
                ((BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class)).performForceUppercase((BusinessObject)revLine);
                this.populateRevenueLine(bcDoc, this.getNewRevenueLine());
            } else {
                this.populatePBGLLine(this.getNewRevenueLine());
            }
            if (methodToCall.equals("insertExpenditureLine")) {
                PendingBudgetConstructionGeneralLedger expLine = this.getNewExpenditureLine();
                ((BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class)).performForceUppercase((BusinessObject)expLine);
                this.populateExpenditureLine(bcDoc, this.getNewExpenditureLine());
            } else {
                this.populatePBGLLine(this.getNewExpenditureLine());
            }
            this.populatePBGLLines();
            this.setDocTypeName(this.discoverDocumentTypeName());
        }
    }

    public void initializePersistedRequestAmounts(boolean initSalarySetting) {
        if (initSalarySetting) {
            this.setPreSalarySettingRows(new HashMap<String, PendingBudgetConstructionGeneralLedger>());
        }
        BudgetConstructionDocument bcDoc = this.getBudgetConstructionDocument();
        for (PendingBudgetConstructionGeneralLedger revenueLine : bcDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines()) {
            revenueLine.setPersistedAccountLineAnnualBalanceAmount(revenueLine.getAccountLineAnnualBalanceAmount());
        }
        for (PendingBudgetConstructionGeneralLedger expenditureLine : bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines()) {
            expenditureLine.setPersistedAccountLineAnnualBalanceAmount(expenditureLine.getAccountLineAnnualBalanceAmount());
            if (!initSalarySetting || (expenditureLine.getLaborObject() == null || !expenditureLine.getLaborObject().isDetailPositionRequiredIndicator()) && !expenditureLine.getFinancialObjectCode().equalsIgnoreCase("2PLG")) continue;
            this.getPreSalarySettingRows().put(expenditureLine.getFinancialObjectCode() + expenditureLine.getFinancialSubObjectCode(), expenditureLine);
        }
    }

    public void initializePersistedRequestAmounts() {
        this.initializePersistedRequestAmounts(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populatePushPullLevelKeyLabels(BudgetConstructionDocument bcDoc, List<BudgetConstructionAccountOrganizationHierarchy> levels, boolean isPull) {
        if (levels.isEmpty() || bcDoc.getOrganizationLevelCode() < 0 || bcDoc.getOrganizationLevelCode() >= levels.size()) return;
        if (isPull) {
            this.pullupLevelKeyLabels.clear();
            HashMap<String, BudgetConstructionAccountOrganizationHierarchy> rvwHierMap = new HashMap<String, BudgetConstructionAccountOrganizationHierarchy>();
            for (int i = bcDoc.getOrganizationLevelCode() + 1; i < levels.size(); ++i) {
                BudgetConstructionAccountOrganizationHierarchy rvwHier = levels.get(i);
                rvwHierMap.put(rvwHier.getOrganizationChartOfAccountsCode() + rvwHier.getOrganizationCode(), rvwHier);
            }
            if (rvwHierMap.isEmpty()) return;
            try {
                List<Organization> povOrgs = ((BudgetConstructionProcessorService)SpringContext.getBean(BudgetConstructionProcessorService.class)).getProcessorOrgs(GlobalVariables.getUserSession().getPerson());
                if (povOrgs.isEmpty()) return;
                for (Organization povOrg : povOrgs) {
                    if (!rvwHierMap.containsKey(povOrg.getChartOfAccountsCode() + povOrg.getOrganizationCode())) continue;
                    BudgetConstructionAccountOrganizationHierarchy level = (BudgetConstructionAccountOrganizationHierarchy)((Object)rvwHierMap.get(povOrg.getChartOfAccountsCode() + povOrg.getOrganizationCode()));
                    ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObject((Object)level, "organization");
                    this.pullupLevelKeyLabels.add(new BCKeyLabelPair(level.getOrganizationLevelCode().toString(), level.getOrganizationLevelCode().toString() + ":" + level.getOrganizationChartOfAccountsCode() + "-" + level.getOrganizationCode() + " " + level.getOrganization().getOrganizationName()));
                }
                return;
            }
            catch (Exception povOrgs) {
                return;
            }
        } else {
            this.pushdownLevelKeyLabels.clear();
            for (int i = bcDoc.getOrganizationLevelCode() - 1; i >= 0; --i) {
                BudgetConstructionAccountOrganizationHierarchy level = levels.get(i);
                ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObject((Object)level, "organization");
                if (level.getOrganizationLevelCode() == 0) {
                    this.pushdownLevelKeyLabels.add(new BCKeyLabelPair(level.getOrganizationLevelCode().toString(), level.getOrganizationLevelCode().toString() + ":" + level.getOrganizationChartOfAccountsCode() + "-" + level.getOrganizationCode() + " " + "Fiscal Officer Access Level"));
                    continue;
                }
                this.pushdownLevelKeyLabels.add(new BCKeyLabelPair(level.getOrganizationLevelCode().toString(), level.getOrganizationLevelCode().toString() + ":" + level.getOrganizationChartOfAccountsCode() + "-" + level.getOrganizationCode() + " " + level.getOrganization().getOrganizationName()));
            }
        }
    }

    public void populatePBGLLines() {
        BudgetConstructionDocument bcDoc = this.getBudgetConstructionDocument();
        bcDoc.zeroTotals();
        for (PendingBudgetConstructionGeneralLedger revenueLine : bcDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines()) {
            this.populateRevenueLine(bcDoc, revenueLine);
        }
        for (PendingBudgetConstructionGeneralLedger expenditureLine : bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines()) {
            this.populateExpenditureLine(bcDoc, expenditureLine);
        }
    }

    public void populateRevenueLine(BudgetConstructionDocument bcDoc, PendingBudgetConstructionGeneralLedger revenueLine) {
        this.populatePBGLLine(revenueLine);
        if (revenueLine.getFinancialBeginningBalanceLineAmount() != null) {
            bcDoc.setRevenueFinancialBeginningBalanceLineAmountTotal(bcDoc.getRevenueFinancialBeginningBalanceLineAmountTotal().add(revenueLine.getFinancialBeginningBalanceLineAmount()));
        }
        if (revenueLine.getAccountLineAnnualBalanceAmount() != null) {
            bcDoc.setRevenueAccountLineAnnualBalanceAmountTotal(bcDoc.getRevenueAccountLineAnnualBalanceAmountTotal().add(revenueLine.getAccountLineAnnualBalanceAmount()));
        }
    }

    public void populateExpenditureLine(BudgetConstructionDocument bcDoc, PendingBudgetConstructionGeneralLedger expenditureLine) {
        this.populatePBGLLine(expenditureLine);
        if (expenditureLine.getFinancialBeginningBalanceLineAmount() != null) {
            bcDoc.setExpenditureFinancialBeginningBalanceLineAmountTotal(bcDoc.getExpenditureFinancialBeginningBalanceLineAmountTotal().add(expenditureLine.getFinancialBeginningBalanceLineAmount()));
        }
        if (expenditureLine.getAccountLineAnnualBalanceAmount() != null) {
            bcDoc.setExpenditureAccountLineAnnualBalanceAmountTotal(bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal().add(expenditureLine.getAccountLineAnnualBalanceAmount()));
        }
        if (expenditureLine.getFinancialObjectCode() != null && expenditureLine.getFinancialObjectCode().contentEquals("2PLG")) {
            bcDoc.setContainsTwoPlug(true);
        }
    }

    protected void populatePBGLLine(PendingBudgetConstructionGeneralLedger line) {
        ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).populatePBGLLine(line);
    }

    public BudgetConstructionDocument getBudgetConstructionDocument() {
        return (BudgetConstructionDocument)this.getDocument();
    }

    public void setBudgetConstructionDocument(BudgetConstructionDocument budgetConstructionDocument) {
        this.setDocument((Document)budgetConstructionDocument);
    }

    public PendingBudgetConstructionGeneralLedger getNewExpenditureLine() {
        return this.newExpenditureLine;
    }

    public void setNewExpenditureLine(PendingBudgetConstructionGeneralLedger newExpenditureLine) {
        this.newExpenditureLine = newExpenditureLine;
    }

    public PendingBudgetConstructionGeneralLedger getNewRevenueLine() {
        return this.newRevenueLine;
    }

    public void setNewRevenueLine(PendingBudgetConstructionGeneralLedger newRevenueLine) {
        this.newRevenueLine = newRevenueLine;
    }

    public void initNewLine(PendingBudgetConstructionGeneralLedger line, boolean isRevenue) {
        OptionsService optionsService = (OptionsService)SpringContext.getBean(OptionsService.class);
        BudgetConstructionDocument tdoc = this.getBudgetConstructionDocument();
        line.setDocumentNumber(tdoc.getDocumentNumber());
        line.setUniversityFiscalYear(tdoc.getUniversityFiscalYear());
        line.setChartOfAccountsCode(tdoc.getChartOfAccountsCode());
        line.setAccountNumber(tdoc.getAccountNumber());
        line.setSubAccountNumber(tdoc.getSubAccountNumber());
        line.setFinancialBalanceTypeCode(optionsService.getOptions(tdoc.getUniversityFiscalYear()).getBaseBudgetFinancialBalanceTypeCd());
        line.setFinancialBeginningBalanceLineAmount(KualiInteger.ZERO);
        line.setAccountLineAnnualBalanceAmount(KualiInteger.ZERO);
        if (isRevenue) {
            line.setFinancialObjectTypeCode(optionsService.getOptions(tdoc.getUniversityFiscalYear()).getFinObjectTypeIncomecashCode());
        } else {
            line.setFinancialObjectTypeCode(optionsService.getOptions(tdoc.getUniversityFiscalYear()).getFinObjTypeExpenditureexpCd());
        }
    }

    public boolean isBudgetableDocument() {
        return this.getBudgetConstructionDocument().isBudgetableDocument();
    }

    public boolean isHideDetails() {
        return this.hideDetails;
    }

    public boolean getHideDetails() {
        return this.isHideDetails();
    }

    public void setHideDetails(boolean hideDetails) {
        this.hideDetails = hideDetails;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public boolean isHideAdjustmentMeasurement() {
        return this.hideAdjustmentMeasurement;
    }

    public void setHideAdjustmentMeasurement(boolean hideAdjustmentMeasurement) {
        this.hideAdjustmentMeasurement = hideAdjustmentMeasurement;
    }

    public KualiDecimal getRevenueAdjustmentAmount() {
        return this.revenueAdjustmentAmount;
    }

    public void setRevenueAdjustmentAmount(KualiDecimal adjustmentAmount) {
        this.revenueAdjustmentAmount = adjustmentAmount;
    }

    public KualiDecimal getExpenditureAdjustmentAmount() {
        return this.expenditureAdjustmentAmount;
    }

    public void setExpenditureAdjustmentAmount(KualiDecimal expenditureAdjustmentAmount) {
        this.expenditureAdjustmentAmount = expenditureAdjustmentAmount;
    }

    public boolean isBenefitsCalculationDisabled() {
        return ((BenefitsCalculationService)SpringContext.getBean(BenefitsCalculationService.class)).isBenefitsCalculationDisabled();
    }

    public boolean isSalarySettingDisabled() {
        return ((SalarySettingService)SpringContext.getBean(SalarySettingService.class)).isSalarySettingDisabled();
    }

    public boolean isPickListMode() {
        return this.pickListMode;
    }

    public void setPickListMode(boolean pickListMode) {
        this.pickListMode = pickListMode;
    }

    public boolean isAccountReportsExist() {
        this.accountReportsExist = false;
        if (this.getBudgetConstructionDocument().getDocumentNumber() != null && ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).isAccountReportsExist(this.getChartOfAccountsCode(), this.getAccountNumber())) {
            this.accountReportsExist = true;
        }
        return this.accountReportsExist;
    }

    public void setAccountReportsExist(boolean accountReportsExist) {
        this.accountReportsExist = accountReportsExist;
    }

    public boolean isPickListClose() {
        return this.pickListClose;
    }

    public void setPickListClose(boolean pickListClose) {
        this.pickListClose = pickListClose;
    }

    public boolean isSecurityNoAccess() {
        return this.securityNoAccess;
    }

    public void setSecurityNoAccess(boolean securityNoAccess) {
        this.securityNoAccess = securityNoAccess;
    }

    public String getBackLocation() {
        return this.backLocation;
    }

    public void setBackLocation(String backLocation) {
        this.backLocation = backLocation;
    }

    public String getReturnAnchor() {
        return this.returnAnchor;
    }

    public void setReturnAnchor(String returnAnchor) {
        this.returnAnchor = returnAnchor;
    }

    public String getReturnFormKey() {
        return this.returnFormKey;
    }

    public void setReturnFormKey(String returnFormKey) {
        this.returnFormKey = returnFormKey;
    }

    public String getBalanceInquiryReturnAnchor() {
        return this.balanceInquiryReturnAnchor;
    }

    public void setBalanceInquiryReturnAnchor(String balanceInquiryReturnAnchor) {
        this.balanceInquiryReturnAnchor = balanceInquiryReturnAnchor;
    }

    public String getPullupKeyCode() {
        return this.pullupKeyCode;
    }

    public void setPullupKeyCode(String pullupKeyCode) {
        this.pullupKeyCode = pullupKeyCode;
    }

    public List<BCKeyLabelPair> getPullupLevelKeyLabels() {
        return this.pullupLevelKeyLabels;
    }

    public void setPullupLevelKeyLabels(List<BCKeyLabelPair> pullupLevelKeyLabels) {
        this.pullupLevelKeyLabels = pullupLevelKeyLabels;
    }

    public List<BudgetConstructionAccountOrganizationHierarchy> getAccountOrgHierLevels() {
        return this.accountOrgHierLevels;
    }

    public void setAccountOrgHierLevels(List<BudgetConstructionAccountOrganizationHierarchy> accountOrgHierLevels) {
        this.accountOrgHierLevels = accountOrgHierLevels;
    }

    public String getPushdownKeyCode() {
        return this.pushdownKeyCode;
    }

    public void setPushdownKeyCode(String pushdownKeyCode) {
        this.pushdownKeyCode = pushdownKeyCode;
    }

    public List<BCKeyLabelPair> getPushdownLevelKeyLabels() {
        return this.pushdownLevelKeyLabels;
    }

    public void setPushdownLevelKeyLabels(List<BCKeyLabelPair> pushdownLevelKeyLabels) {
        this.pushdownLevelKeyLabels = pushdownLevelKeyLabels;
    }

    public boolean isCheckTwoPlugAdjustment() {
        return this.checkTwoPlugAdjustment;
    }

    public void setCheckTwoPlugAdjustment(boolean checkTwoPlugAdjustment) {
        this.checkTwoPlugAdjustment = checkTwoPlugAdjustment;
    }

    public HashMap<String, PendingBudgetConstructionGeneralLedger> getPreSalarySettingRows() {
        return this.preSalarySettingRows;
    }

    public void setPreSalarySettingRows(HashMap<String, PendingBudgetConstructionGeneralLedger> preSalarySettingRows) {
        this.preSalarySettingRows = preSalarySettingRows;
    }

    public boolean isClosingDocument() {
        return this.closingDocument;
    }

    public void setClosingDocument(boolean closingDocument) {
        this.closingDocument = closingDocument;
    }

    public boolean isSystemViewOnly() {
        return this.getEditingMode().containsKey("systemViewOnly");
    }

    public boolean isEditAllowed() {
        return this.getDocumentActions().keySet().contains("canEdit");
    }

    public boolean isMainWindow() {
        return this.mainWindow;
    }

    public void setMainWindow(boolean mainWindow) {
        this.mainWindow = mainWindow;
    }

    public static String getRevenueObjectTypeCodesLookup() {
        if (revenueObjectTypeCodesLookup == null) {
            revenueObjectTypeCodesLookup = ((BudgetParameterService)SpringContext.getBean(BudgetParameterService.class)).getLookupObjectTypes(true);
        }
        return revenueObjectTypeCodesLookup;
    }

    public static String getExpenditureObjectTypeCodesLookup() {
        if (expenditureObjectTypeCodesLookup == null) {
            expenditureObjectTypeCodesLookup = ((BudgetParameterService)SpringContext.getBean(BudgetParameterService.class)).getLookupObjectTypes(false);
        }
        return expenditureObjectTypeCodesLookup;
    }

    public String getDashSubAccountNumber() {
        return this.dashSubAccountNumber;
    }

    public void setDashSubAccountNumber(String dashSubAccountNumber) {
        this.dashSubAccountNumber = dashSubAccountNumber;
    }

    public String getDashFinancialSubObjectCode() {
        return this.dashFinancialSubObjectCode;
    }

    public void setDashFinancialSubObjectCode(String dashFinancialSubObjectCode) {
        this.dashFinancialSubObjectCode = dashFinancialSubObjectCode;
    }
}

