/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.document.service.BudgetRequestImportService;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionImportExportAction;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionImportExportForm;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionRequestImportForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;

public class BudgetConstructionRequestImportAction
extends BudgetConstructionImportExportAction {
    private static final Logger LOG = Logger.getLogger(BudgetConstructionRequestImportAction.class);

    public ActionForward start(ActionMapping arg0, ActionForm arg1, HttpServletRequest arg2, HttpServletResponse arg3) throws Exception {
        return arg0.findForward("import_export");
    }

    public ActionForward submit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionRequestImportForm budgetConstructionImportForm = (BudgetConstructionRequestImportForm)form;
        BudgetRequestImportService budgetRequestImportService = (BudgetRequestImportService)SpringContext.getBean(BudgetRequestImportService.class);
        Integer budgetYear = budgetConstructionImportForm.getUniversityFiscalYear();
        ArrayList<String> messageList = new ArrayList<String>();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy ' ' HH:mm:ss", Locale.US);
        boolean isValid = this.validateFormData(budgetConstructionImportForm);
        if (!isValid) {
            return mapping.findForward("import_export");
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        String principalId = user.getPrincipalId();
        Date startTime = new Date();
        messageList.add("Import run started " + dateFormatter.format(startTime));
        messageList.add(" ");
        messageList.add("Text file load phase - parsing");
        List parsingErrors = budgetRequestImportService.processImportFile(budgetConstructionImportForm.getFile().getInputStream(), principalId, this.getFieldSeparator(budgetConstructionImportForm), this.getTextFieldDelimiter(budgetConstructionImportForm), budgetConstructionImportForm.getFileType(), budgetYear);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!parsingErrors.isEmpty()) {
            messageList.addAll(parsingErrors);
            messageList.add("Import run finished at " + dateFormatter.getCalendar().getTime().toString());
            budgetRequestImportService.generatePdf(messageList, baos);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)"budgetImportLog.pdf");
            return null;
        }
        messageList.add("Text file load complete");
        messageList.add(" ");
        messageList.add("Validate data phase");
        List<String> dataValidationErrorList = budgetRequestImportService.validateData(budgetYear, principalId);
        if (!dataValidationErrorList.isEmpty()) {
            messageList.add("Errors found during data validation");
            messageList.addAll(dataValidationErrorList);
        }
        messageList.add("Validate data complete");
        messageList.add(" ");
        messageList.add("Update budget phase");
        List<String> updateErrorMessages = budgetRequestImportService.loadBudget(user, budgetConstructionImportForm.getFileType(), budgetYear);
        messageList.addAll(updateErrorMessages);
        messageList.add("Update budget complete");
        messageList.add(" ");
        Date endTime = new Date();
        messageList.add("Import run finished at " + dateFormatter.format(endTime));
        budgetRequestImportService.generatePdf(messageList, baos);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)"budgetImportLog.pdf");
        return null;
    }

    @Override
    public boolean validateFormData(BudgetConstructionImportExportForm form) {
        boolean isValid = super.validateFormData(form);
        BudgetConstructionRequestImportForm requestImportForm = (BudgetConstructionRequestImportForm)form;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!((FiscalYearFunctionControlService)SpringContext.getBean(FiscalYearFunctionControlService.class)).isBudgetUpdateAllowed(requestImportForm.getUniversityFiscalYear())) {
            errorMap.putError("GLOBAL_ERRORS", "message.budget.systemViewOnly", new String[0]);
            isValid &= false;
        }
        if (requestImportForm.getFile() == null || requestImportForm.getFile().getFileSize() == 0) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.missingFile", new String[0]);
            isValid = false;
        }
        if (requestImportForm.getFile() != null && requestImportForm.getFile().getFileSize() == 0) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.emptyFile", new String[0]);
            isValid = false;
        }
        if (requestImportForm.getFile() != null && StringUtils.isBlank((String)requestImportForm.getFile().getFileName())) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.missingFileName", new String[0]);
            isValid = false;
        }
        if (StringUtils.isBlank((String)requestImportForm.getFileType())) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.missingFileType", new String[0]);
            isValid = false;
        }
        return isValid;
    }
}

