/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountSelect;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockSummary;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.OrganizationBCDocumentSearchService;
import org.kuali.kfs.module.bc.document.validation.event.AddBudgetConstructionDocumentEvent;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionSelectionForm;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.report.ReportControlListBuildHelper;
import org.kuali.kfs.module.bc.util.BudgetUrlUtil;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class BudgetConstructionSelectionAction
extends BudgetExpansionAction {
    private static final Logger LOG = Logger.getLogger(BudgetConstructionSelectionAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        ReportControlListBuildHelper buildHelper = (ReportControlListBuildHelper)GlobalVariables.getUserSession().retrieveObject("controlBuildHelper");
        if (buildHelper == null) {
            buildHelper = new ReportControlListBuildHelper();
        }
        buildHelper.setForceRebuild(true);
        GlobalVariables.getUserSession().addObject("controlBuildHelper", (Object)buildHelper);
        return forward;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FiscalYearFunctionControlService fiscalYearFunctionControlService;
        BudgetConstructionSelectionForm budgetConstructionSelectionForm;
        block8: {
            budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
            fiscalYearFunctionControlService = (FiscalYearFunctionControlService)SpringContext.getBean(FiscalYearFunctionControlService.class);
            ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            Boolean isBCInProgress = (Boolean)GlobalVariables.getUserSession().retrieveObject("BcDocBCInProgress");
            if (isBCInProgress != null && isBCInProgress.booleanValue()) {
                String question = request.getParameter("questionIndex");
                if (question == null) {
                    return this.performQuestionWithoutInput(mapping, form, request, response, "DocDelete", kualiConfiguration.getPropertyValueAsString("document.budget.question.confirmCleanup.text"), "confirmationQuestion", "loadExpansionScreen", "");
                }
                String buttonClicked = request.getParameter("buttonClicked");
                if ("DocDelete".equals(question) && "0".equals(buttonClicked)) {
                    GlobalVariables.getUserSession().removeObjectsByPrefix("BcDoc");
                    HttpSession sess = request.getSession(Boolean.FALSE.booleanValue());
                    sess.removeAttribute("KualiForm");
                    break block8;
                } else {
                    budgetConstructionSelectionForm.setSessionInProgressDetected(true);
                    KNSGlobalVariables.getMessageList().add("message.budget.system.session.notCleaned", new String[0]);
                    return mapping.findForward("basic");
                }
            }
            GlobalVariables.getUserSession().removeObjectsByPrefix("BcDoc");
            HttpSession sess = request.getSession(Boolean.FALSE.booleanValue());
            sess.removeAttribute("KualiForm");
        }
        List activeBCYears = fiscalYearFunctionControlService.getActiveBudgetYear();
        if (activeBCYears.size() != 1) {
            budgetConstructionSelectionForm.setUniversityFiscalYear(null);
            if (activeBCYears.size() < 1) {
                KNSGlobalVariables.getMessageList().add("message.budget.system.not.active", new String[0]);
            } else {
                KNSGlobalVariables.getMessageList().add("message.budget.system.multiple.active", new String[0]);
            }
        } else {
            budgetConstructionSelectionForm.setUniversityFiscalYear((Integer)activeBCYears.get(0));
        }
        budgetConstructionSelectionForm.getBudgetConstructionHeader().setUniversityFiscalYear(budgetConstructionSelectionForm.getUniversityFiscalYear());
        return mapping.findForward("basic");
    }

    public ActionForward performBCDocumentOpen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        BudgetConstructionHeader bcHeader = budgetConstructionSelectionForm.getBudgetConstructionHeader();
        Integer universityFiscalYear = bcHeader.getUniversityFiscalYear();
        String chartOfAccountsCode = bcHeader.getChartOfAccountsCode();
        String accountNumber = bcHeader.getAccountNumber();
        String subAccountNumber = StringUtils.isBlank((String)bcHeader.getSubAccountNumber()) ? KFSConstants.getDashSubAccountNumber() : bcHeader.getSubAccountNumber();
        BudgetConstructionHeader tHeader = ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, universityFiscalYear);
        if (tHeader == null) {
            BudgetConstructionDocument budgetConstructionDocument = (BudgetConstructionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("BC");
            budgetConstructionDocument.setUniversityFiscalYear(universityFiscalYear);
            budgetConstructionDocument.setChartOfAccountsCode(chartOfAccountsCode);
            budgetConstructionDocument.setAccountNumber(accountNumber);
            budgetConstructionDocument.setSubAccountNumber(subAccountNumber);
            List<String> refreshFields = Collections.unmodifiableList(Arrays.asList("account", "subAccount"));
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)budgetConstructionDocument, refreshFields);
            boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddBudgetConstructionDocumentEvent("budgetConstructionHeader", (Document)budgetConstructionDocument));
            if (rulePassed) {
                List<BudgetConstructionAccountOrganizationHierarchy> newAccountOrganizationHierarchy = ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).retrieveOrBuildAccountOrganizationHierarchy(universityFiscalYear, chartOfAccountsCode, accountNumber);
                if (newAccountOrganizationHierarchy == null || newAccountOrganizationHierarchy.isEmpty()) {
                    GlobalVariables.getMessageMap().putError("budgetConstructionHeader", "error.budget.AccountOrganizationHierarchy", new String[]{chartOfAccountsCode + "-" + accountNumber});
                    return mapping.findForward("basic");
                }
                ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).instantiateNewBudgetConstructionDocument(budgetConstructionDocument);
                tHeader = ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, universityFiscalYear);
                if (tHeader == null) {
                    GlobalVariables.getMessageMap().putError("budgetConstructionHeader", "error.existence", new String[]{"BC Document"});
                    return mapping.findForward("basic");
                }
            } else {
                return mapping.findForward("basic");
            }
        }
        this.flagBCInProgress();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "docHandler");
        parameters.put("universityFiscalYear", tHeader.getUniversityFiscalYear().toString());
        parameters.put("chartOfAccountsCode", tHeader.getChartOfAccountsCode());
        parameters.put("accountNumber", tHeader.getAccountNumber());
        parameters.put("subAccountNumber", tHeader.getSubAccountNumber());
        parameters.put("pickListMode", "false");
        parameters.put("mainWindow", "true");
        String lookupUrl = BudgetUrlUtil.buildBudgetUrl(mapping, budgetConstructionSelectionForm, "budgetBudgetConstruction.do", parameters);
        return new ActionForward(lookupUrl, true);
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        String refreshCaller = request.getParameter("refreshCaller");
        if (refreshCaller != null && refreshCaller.toUpperCase().endsWith("Lookupable".toUpperCase())) {
            List<String> REFRESH_FIELDS = Collections.unmodifiableList(Arrays.asList("chartOfAccounts", "account", "subAccount", "budgetConstructionAccountReports"));
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)budgetConstructionSelectionForm.getBudgetConstructionHeader(), REFRESH_FIELDS);
        }
        GlobalVariables.getUserSession().removeObject("BcDocBCInProgress");
        HttpSession sess = request.getSession(Boolean.FALSE.booleanValue());
        sess.removeAttribute("KualiForm");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward returnToCaller(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        return mapping.findForward("portal");
    }

    public ActionForward performOrgSalarySetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        ActionForward forward = this.performOrgSelectionTree(BCConstants.OrgSelOpMode.SALSET, mapping, form, request, response);
        return forward;
    }

    public ActionForward performOrgSelectionTree(BCConstants.OrgSelOpMode opMode, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        this.flagBCInProgress();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "loadExpansionScreen");
        parameters.put("operatingMode", opMode.toString());
        parameters.put("universityFiscalYear", budgetConstructionSelectionForm.getUniversityFiscalYear().toString());
        String lookupUrl = BudgetUrlUtil.buildBudgetUrl(mapping, budgetConstructionSelectionForm, "budgetOrganizationSelectionTree.do", parameters);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward performReportDump(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        ActionForward forward = this.performOrgSelectionTree(BCConstants.OrgSelOpMode.REPORTS, mapping, form, request, response);
        return forward;
    }

    public ActionForward performRequestImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        this.flagBCInProgress();
        String lookupUrl = BudgetUrlUtil.buildBudgetUrl(mapping, budgetConstructionSelectionForm, "budgetBudgetConstructionRequestImport.do", null);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward performPayrateImportExport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        this.flagBCInProgress();
        String lookupUrl = BudgetUrlUtil.buildBudgetUrl(mapping, budgetConstructionSelectionForm, "budgetPayrateImportExport.do", null);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward performLockMonitor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        this.flagBCInProgress();
        HashMap<String, String> urlParms = new HashMap<String, String>();
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, budgetConstructionSelectionForm, 5, BudgetConstructionLockSummary.class.getName(), urlParms);
        return new ActionForward(url, true);
    }

    public ActionForward performOrgPullup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        ActionForward forward = this.performOrgSelectionTree(BCConstants.OrgSelOpMode.PULLUP, mapping, form, request, response);
        return forward;
    }

    public ActionForward performOrgPushdown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        ActionForward forward = this.performOrgSelectionTree(BCConstants.OrgSelOpMode.PUSHDOWN, mapping, form, request, response);
        return forward;
    }

    public ActionForward performMyAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        int rowCount = ((OrganizationBCDocumentSearchService)SpringContext.getBean(OrganizationBCDocumentSearchService.class)).buildAccountManagerDelegateList(GlobalVariables.getUserSession().getPerson().getPrincipalId(), budgetConstructionSelectionForm.getUniversityFiscalYear());
        if (rowCount == 0) {
            KNSGlobalVariables.getMessageList().add("error.budget.noRecordsMyAccounts", new String[0]);
            return mapping.findForward("basic");
        }
        this.flagBCInProgress();
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, budgetConstructionSelectionForm, 9, BudgetConstructionAccountSelect.class.getName(), null);
        return new ActionForward(url, true);
    }

    public ActionForward performMyOrganization(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionSelectionForm budgetConstructionSelectionForm = (BudgetConstructionSelectionForm)form;
        ActionForward forward = this.performOrgSelectionTree(BCConstants.OrgSelOpMode.ACCOUNT, mapping, form, request, response);
        return forward;
    }

    public void flagBCInProgress() {
        GlobalVariables.getUserSession().addObject("BcDocBCInProgress", (Object)Boolean.TRUE);
    }
}

