/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.web.struts.DetailSalarySettingAction;
import org.kuali.kfs.module.bc.document.web.struts.IncumbentSalarySettingForm;
import org.kuali.kfs.module.bc.service.BudgetConstructionIntendedIncumbentService;
import org.kuali.kfs.sys.context.SpringContext;

public class IncumbentSalarySettingAction
extends DetailSalarySettingAction {
    private static final Logger LOG = Logger.getLogger(IncumbentSalarySettingAction.class);
    private BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    private BudgetConstructionIntendedIncumbentService budgetConstructionIntendedIncumbentService = (BudgetConstructionIntendedIncumbentService)SpringContext.getBean(BudgetConstructionIntendedIncumbentService.class);

    @Override
    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> fieldValues;
        BudgetConstructionIntendedIncumbent budgetConstructionIntendedIncumbent;
        IncumbentSalarySettingForm incumbentSalarySettingForm = (IncumbentSalarySettingForm)form;
        MessageMap errorMap = incumbentSalarySettingForm.isBudgetByAccountMode() ? incumbentSalarySettingForm.getCallBackErrors() : GlobalVariables.getMessageMap();
        if (incumbentSalarySettingForm.isRefreshIncumbentBeforeSalarySetting()) {
            this.budgetConstructionIntendedIncumbentService.refreshIncumbentFromExternal(incumbentSalarySettingForm.getEmplid());
        }
        if ((budgetConstructionIntendedIncumbent = (BudgetConstructionIntendedIncumbent)this.businessObjectService.findByPrimaryKey(BudgetConstructionIntendedIncumbent.class, fieldValues = incumbentSalarySettingForm.getKeyMapOfSalarySettingItem())) == null) {
            String emplid = (String)fieldValues.get("emplid");
            errorMap.putError("GlobalMessages", "error.budget.incumbentNotFound", new String[]{emplid});
            if (incumbentSalarySettingForm.isBudgetByAccountMode()) {
                return this.returnToCaller(mapping, form, request, response);
            }
            this.cleanupAnySessionForm(mapping, request);
            return mapping.findForward("organizationSalarySettingReturning");
        }
        incumbentSalarySettingForm.setBudgetConstructionIntendedIncumbent(budgetConstructionIntendedIncumbent);
        if (incumbentSalarySettingForm.isSingleAccountMode()) {
            incumbentSalarySettingForm.pickAppointmentFundingsForSingleAccount();
        }
        if (!incumbentSalarySettingForm.isViewOnlyEntry()) {
            incumbentSalarySettingForm.postProcessBCAFLines();
            incumbentSalarySettingForm.setNewBCAFLine(incumbentSalarySettingForm.createNewAppointmentFundingLine());
            boolean accessModeUpdated = incumbentSalarySettingForm.updateAccessMode(errorMap);
            if (!accessModeUpdated) {
                if (incumbentSalarySettingForm.isBudgetByAccountMode()) {
                    return this.returnToCaller(mapping, form, request, response);
                }
                this.cleanupAnySessionForm(mapping, request);
                return mapping.findForward("organizationSalarySettingReturning");
            }
            boolean gotLocks = incumbentSalarySettingForm.acquirePositionAndFundingLocks(errorMap);
            if (!gotLocks) {
                if (incumbentSalarySettingForm.isBudgetByAccountMode()) {
                    return this.returnToCaller(mapping, form, request, response);
                }
                this.cleanupAnySessionForm(mapping, request);
                return mapping.findForward("organizationSalarySettingReturning");
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward saveAction = super.save(mapping, form, request, response);
        IncumbentSalarySettingForm incumbentSalarySettingForm = (IncumbentSalarySettingForm)form;
        this.sendWarnings(incumbentSalarySettingForm, KNSGlobalVariables.getMessageList());
        return saveAction;
    }

    public void sendWarnings(IncumbentSalarySettingForm incumbentSalarySettingForm, MessageList warnings) {
        List<PendingBudgetConstructionAppointmentFunding> activeAppointmentFundings = incumbentSalarySettingForm.getActiveFundingLines();
        if (activeAppointmentFundings == null || activeAppointmentFundings.isEmpty()) {
            return;
        }
        BigDecimal requestedFteQuantityTotal = incumbentSalarySettingForm.getAppointmentRequestedFteQuantityTotal();
        boolean hasFundingLineInvolvedLeaveWithoutPay = this.hasFundingLineInvolvedLeaveWithoutPay(activeAppointmentFundings);
        if (!hasFundingLineInvolvedLeaveWithoutPay && requestedFteQuantityTotal.compareTo(BigDecimal.ONE) != 0) {
            warnings.add("warning.budget.fteNotOne", new String[0]);
        }
    }

    @Override
    protected String getFundingAwareObjectName() {
        return "budgetConstructionIntendedIncumbent";
    }

    @Override
    public BCConstants.SynchronizationCheckType getSynchronizationCheckType() {
        return BCConstants.SynchronizationCheckType.POSN;
    }
}

