/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.web.struts.DetailSalarySettingForm;

public class PositionSalarySettingForm
extends DetailSalarySettingForm {
    private static final Logger LOG = Logger.getLogger(PositionSalarySettingForm.class);
    private boolean refreshPositionBeforeSalarySetting;
    private BudgetConstructionPosition budgetConstructionPosition;

    public PositionSalarySettingForm() {
        this.setBudgetConstructionPosition(new BudgetConstructionPosition());
    }

    @Override
    public PendingBudgetConstructionAppointmentFunding createNewAppointmentFundingLine() {
        PendingBudgetConstructionAppointmentFunding appointmentFunding = super.createNewAppointmentFundingLine();
        appointmentFunding.setPositionNumber(this.getBudgetConstructionPosition().getPositionNumber());
        appointmentFunding.setFinancialObjectCode(this.getBudgetConstructionPosition().getIuDefaultObjectCode());
        return appointmentFunding;
    }

    @Override
    public Map<String, Object> getKeyMapOfSalarySettingItem() {
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("universityFiscalYear", this.getUniversityFiscalYear());
        keyMap.put("positionNumber", this.getPositionNumber());
        return keyMap;
    }

    @Override
    public String getRefreshCallerName() {
        return "PositionSalarySetting";
    }

    @Override
    public List<PendingBudgetConstructionAppointmentFunding> getAppointmentFundings() {
        return this.getBudgetConstructionPosition().getPendingBudgetConstructionAppointmentFunding();
    }

    public BudgetConstructionPosition getBudgetConstructionPosition() {
        return this.budgetConstructionPosition;
    }

    public void setBudgetConstructionPosition(BudgetConstructionPosition budgetConstructionPosition) {
        this.budgetConstructionPosition = budgetConstructionPosition;
    }

    public boolean isPendingPositionSalaryChange() {
        List<PendingBudgetConstructionAppointmentFunding> activeAppointmentFundings = this.getActiveFundingLines();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : activeAppointmentFundings) {
            if (appointmentFunding.isDisplayOnlyMode() || !appointmentFunding.isPositionChangeIndicator()) continue;
            return true;
        }
        return false;
    }

    public boolean isRefreshPositionBeforeSalarySetting() {
        return this.refreshPositionBeforeSalarySetting;
    }

    public void setRefreshPositionBeforeSalarySetting(boolean refreshPositionBeforeSalarySetting) {
        this.refreshPositionBeforeSalarySetting = refreshPositionBeforeSalarySetting;
    }

    public String getDocumentTitle() {
        return "Salary Setting by Position";
    }
}

