/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.SalarySettingExpansion;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.validation.event.QuickSaveSalarySettingEvent;
import org.kuali.kfs.module.bc.document.web.struts.QuickSalarySettingForm;
import org.kuali.kfs.module.bc.document.web.struts.SalarySettingBaseAction;
import org.kuali.kfs.module.bc.util.BudgetUrlUtil;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class QuickSalarySettingAction
extends SalarySettingBaseAction {
    private static final Logger LOG = Logger.getLogger(QuickSalarySettingAction.class);
    private BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    private SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    private BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"refresh() started");
        super.refresh(mapping, form, request, response);
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        salarySettingForm.setRefreshIncumbentBeforeSalarySetting(false);
        salarySettingForm.setRefreshPositionBeforeSalarySetting(false);
        return this.loadExpansionScreen(mapping, form, request, response);
    }

    public ActionForward addIncumbent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isSaved;
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        if (!salarySettingForm.isViewOnlyEntry() && !(isSaved = this.save(form))) {
            return mapping.findForward("basic");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("chartOfAccountsCode", salarySettingForm.getChartOfAccountsCode());
        parameters.put("accountNumber", salarySettingForm.getAccountNumber());
        parameters.put("subAccountNumber", salarySettingForm.getSubAccountNumber());
        parameters.put("financialObjectCode", salarySettingForm.getFinancialObjectCode());
        parameters.put("financialSubObjectCode", salarySettingForm.getFinancialSubObjectCode());
        parameters.put("showSalaryByIncumbentAction", Boolean.TRUE.toString());
        parameters.put("budgetByAccountMode", Boolean.TRUE.toString());
        parameters.put("addLine", Boolean.TRUE.toString());
        parameters.put("mainWindow", salarySettingForm.isMainWindow() ? "true" : "false");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)salarySettingForm.getAnchor())) {
            parameters.put("returnAnchor", salarySettingForm.getAnchor());
        }
        parameters.put("returnFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        String lookupUrl = BudgetUrlUtil.buildTempListLookupUrl(mapping, salarySettingForm, 11, BudgetConstructionIntendedIncumbent.class.getName(), parameters);
        this.cleanupAnySessionForm(mapping, request);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward addPosition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isSaved;
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        if (!salarySettingForm.isViewOnlyEntry() && !(isSaved = this.save(form))) {
            return mapping.findForward("basic");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("chartOfAccountsCode", salarySettingForm.getChartOfAccountsCode());
        parameters.put("accountNumber", salarySettingForm.getAccountNumber());
        parameters.put("subAccountNumber", salarySettingForm.getSubAccountNumber());
        parameters.put("financialObjectCode", salarySettingForm.getFinancialObjectCode());
        parameters.put("financialSubObjectCode", salarySettingForm.getFinancialSubObjectCode());
        parameters.put("showSalaryByPositionAction", Boolean.toString(salarySettingForm.isBudgetByAccountMode()));
        parameters.put("budgetByAccountMode", Boolean.TRUE.toString());
        parameters.put("addLine", Boolean.TRUE.toString());
        parameters.put("mainWindow", salarySettingForm.isMainWindow() ? "true" : "false");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)salarySettingForm.getAnchor())) {
            parameters.put("returnAnchor", salarySettingForm.getAnchor());
        }
        parameters.put("returnFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        String lookupUrl = BudgetUrlUtil.buildTempListLookupUrl(mapping, salarySettingForm, 10, BudgetConstructionPosition.class.getName(), parameters);
        this.cleanupAnySessionForm(mapping, request);
        return new ActionForward(lookupUrl, true);
    }

    @Override
    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        Map<String, Object> keyMap = salarySettingForm.getKeyMapOfSalarySettingItem();
        SalarySettingExpansion salarySettingExpansion = (SalarySettingExpansion)this.businessObjectService.findByPrimaryKey(SalarySettingExpansion.class, keyMap);
        if (salarySettingExpansion == null) {
            GlobalVariables.getMessageMap().putError("GlobalMessages", "error.budget.salarySettingExpansionNotFound", new String[0]);
            return this.returnToCaller(mapping, form, request, response);
        }
        salarySettingForm.setSalarySettingExpansion(salarySettingExpansion);
        return mapping.findForward("basic");
    }

    public ActionForward performIncumbentSalarySetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isSaved;
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        if (!salarySettingForm.isViewOnlyEntry() && !(isSaved = this.save(form))) {
            return mapping.findForward("basic");
        }
        String salarySettingURL = this.buildDetailSalarySettingURL(mapping, form, request, "budgetIncumbentSalarySetting.do");
        this.cleanupAnySessionForm(mapping, request);
        return new ActionForward(salarySettingURL, true);
    }

    public ActionForward performPositionSalarySetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isSaved;
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        if (!salarySettingForm.isViewOnlyEntry() && !(isSaved = this.save(form))) {
            return mapping.findForward("basic");
        }
        String salarySettingURL = this.buildDetailSalarySettingURL(mapping, form, request, "budgetPositionSalarySetting.do");
        this.cleanupAnySessionForm(mapping, request);
        return new ActionForward(salarySettingURL, true);
    }

    public ActionForward adjustAllSalarySettingLinesPercent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        SalarySettingExpansion salarySettingExpansion = salarySettingForm.getSalarySettingExpansion();
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        KualiDecimal adjustmentAmount = salarySettingForm.getAdjustmentAmount();
        String adjustmentMeasurement = salarySettingForm.getAdjustmentMeasurement();
        if (StringUtils.isBlank((String)adjustmentMeasurement)) {
            GlobalVariables.getMessageMap().putError("adjustmentMeasurement", "error.budget.adjustmentPercentRequired", new String[0]);
            return mapping.findForward("basic");
        }
        if (ObjectUtils.isNull((Object)adjustmentAmount)) {
            GlobalVariables.getMessageMap().putError("adjustmentAmount", "error.budget.adjustmentAmountRequired", new String[0]);
            return mapping.findForward("basic");
        }
        BudgetConstructionDocument document = this.budgetDocumentService.getBudgetConstructionDocument(salarySettingExpansion);
        if (document == null) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.budgetDocumentNotFound", new String[]{salarySettingExpansion.getSalarySettingExpansionString()});
            return mapping.findForward("basic");
        }
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            appointmentFunding.setAdjustmentAmount(adjustmentAmount);
            appointmentFunding.setAdjustmentMeasurement(adjustmentMeasurement);
            String errorKeyPrefix = this.getErrorKeyPrefixOfAppointmentFundingLine(appointmentFundings, appointmentFunding);
            ActionForward actionForward = this.adjustSalarySettingLinePercent(mapping, (ActionForm)salarySettingForm, appointmentFunding, document, errorKeyPrefix);
        }
        return mapping.findForward("basic");
    }

    public ActionForward toggleAdjustmentMeasurement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuickSalarySettingForm salarySettingForm;
        boolean currentStatus = (salarySettingForm = (QuickSalarySettingForm)form).isHideAdjustmentMeasurement();
        salarySettingForm.setHideAdjustmentMeasurement(!currentStatus);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        ActionForward closeActionForward = salarySettingForm.isViewOnlyEntry() || salarySettingForm.isSalarySettingClosed() ? this.returnAfterClose(salarySettingForm, mapping, request, response) : super.close(mapping, (ActionForm)salarySettingForm, request, response);
        return closeActionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isSaved = this.save(form);
        if (isSaved) {
            KNSGlobalVariables.getMessageList().add("message.budget.salarySettingSaved", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private boolean save(ActionForm form) {
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        SalarySettingExpansion salarySettingExpansion = salarySettingForm.getSalarySettingExpansion();
        BudgetConstructionDocument document = this.budgetDocumentService.getBudgetConstructionDocument(salarySettingExpansion);
        if (document == null) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.budgetDocumentNotFound", new String[]{salarySettingExpansion.getSalarySettingExpansionString()});
            return false;
        }
        boolean isBudgetAllowed = this.budgetDocumentService.isBudgetableDocument(document);
        List<PendingBudgetConstructionAppointmentFunding> savableAppointmentFundings = salarySettingForm.getAppointmentFundings();
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        for (PendingBudgetConstructionAppointmentFunding savableFunding : savableAppointmentFundings) {
            String errorKeyPrefix = this.getErrorKeyPrefixOfAppointmentFundingLine(appointmentFundings, savableFunding);
            if (savableFunding.isAppointmentFundingDeleteIndicator()) continue;
            this.salarySettingService.recalculateDerivedInformation(savableFunding);
            if (!isBudgetAllowed) {
                GlobalVariables.getMessageMap().addToErrorPath(errorKeyPrefix);
                GlobalVariables.getMessageMap().putError("appointmentRequestedAmount", "error.budget.documentNotBudgetable", new String[]{salarySettingExpansion.getSalarySettingExpansionString()});
                return false;
            }
            boolean isValid = this.invokeRules((KualiDocumentEvent)new QuickSaveSalarySettingEvent("", errorKeyPrefix, document, savableFunding));
            if (isValid) continue;
            return false;
        }
        this.salarySettingService.saveSalarySetting(salarySettingExpansion);
        salarySettingExpansion.refresh();
        return true;
    }

    private String buildDetailSalarySettingURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, String salarySettingAction) {
        QuickSalarySettingForm salarySettingForm = (QuickSalarySettingForm)form;
        int indexOfSelectedLine = this.getSelectedLine(request);
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        DynamicCollectionComparator.sort(appointmentFundings, (String[])new String[]{"positionNumber", "emplid"});
        PendingBudgetConstructionAppointmentFunding appointmentFunding = appointmentFundings.get(indexOfSelectedLine);
        Map<String, String> salarySettingMethodAction = this.getSalarySettingMethodActionInfo();
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        String baseAction = basePath + "/" + salarySettingAction;
        String methodToCall = salarySettingMethodAction.get(salarySettingAction);
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        parameters.put("universityFiscalYear", appointmentFunding.getUniversityFiscalYear().toString());
        parameters.put("chartOfAccountsCode", appointmentFunding.getChartOfAccountsCode());
        parameters.put("accountNumber", appointmentFunding.getAccountNumber());
        parameters.put("subAccountNumber", appointmentFunding.getSubAccountNumber());
        parameters.put("financialObjectCode", appointmentFunding.getFinancialObjectCode());
        parameters.put("financialSubObjectCode", appointmentFunding.getFinancialSubObjectCode());
        parameters.put("positionNumber", appointmentFunding.getPositionNumber());
        parameters.put("emplid", appointmentFunding.getEmplid());
        parameters.put("refreshIncumbentBeforeSalarySetting", Boolean.valueOf(salarySettingForm.isRefreshIncumbentBeforeSalarySetting()).toString());
        parameters.put("refreshPositionBeforeSalarySetting", Boolean.valueOf(salarySettingForm.isRefreshPositionBeforeSalarySetting()).toString());
        parameters.put("budgetByAccountMode", Boolean.TRUE.toString());
        parameters.put("addLine", Boolean.FALSE.toString());
        parameters.put("mainWindow", salarySettingForm.isMainWindow() ? "true" : "false");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)salarySettingForm.getAnchor())) {
            parameters.put("returnAnchor", salarySettingForm.getAnchor());
        }
        parameters.put("returnFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        return UrlFactory.parameterizeUrl((String)baseAction, (Properties)parameters);
    }

    private Map<String, String> getSalarySettingMethodActionInfo() {
        HashMap<String, String> salarySettingMethodAction = new HashMap<String, String>();
        salarySettingMethodAction.put("budgetIncumbentSalarySetting.do", "loadExpansionScreen");
        salarySettingMethodAction.put("budgetPositionSalarySetting.do", "loadExpansionScreen");
        return salarySettingMethodAction;
    }

    @Override
    protected String getFundingAwareObjectName() {
        return "salarySettingExpansion";
    }
}

