/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.ByteArrayOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.BudgetConstructionReportMode;
import org.kuali.kfs.module.bc.document.service.ReportExportService;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionImportExportAction;
import org.kuali.kfs.module.bc.document.web.struts.ReportExportForm;
import org.kuali.kfs.sys.context.SpringContext;

public class ReportExportAction
extends BudgetConstructionImportExportAction {
    private static final Logger LOG = Logger.getLogger(ReportExportAction.class);

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportExportForm reportDumpForm = (ReportExportForm)form;
        BudgetConstructionReportMode reportMode = BudgetConstructionReportMode.getBudgetConstructionReportModeByName(reportDumpForm.getReportMode());
        if (reportMode == null) {
            LOG.error((Object)("Invalid report mode passed to report export action: " + reportDumpForm.getReportMode()));
            throw new RuntimeException("Invalid report mode passed to report export action: " + reportDumpForm.getReportMode());
        }
        switch (reportMode) {
            case ACCOUNT_EXPORT: {
                reportDumpForm.setTitle("Budget Revenue/Expenditure Export");
                break;
            }
            case MONTHLY_EXPORT: {
                reportDumpForm.setTitle("Monthly Budget Export");
                break;
            }
            case FUNDING_EXPORT: {
                reportDumpForm.setTitle("Budgeted Salary Lines Export");
            }
        }
        return mapping.findForward("import_export");
    }

    public ActionForward submit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportExportForm reportExportForm = (ReportExportForm)form;
        boolean isValid = this.validateFormData(reportExportForm);
        if (!isValid) {
            return mapping.findForward("import_export");
        }
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        BudgetConstructionReportMode reportMode = BudgetConstructionReportMode.getBudgetConstructionReportModeByName(reportExportForm.getReportMode());
        StringBuilder fileString = null;
        String fileName = "";
        switch (reportMode) {
            case ACCOUNT_EXPORT: {
                fileString = reportExportForm.isOrgReport() ? ((ReportExportService)SpringContext.getBean(ReportExportService.class)).buildOrganizationAccountDumpFile(principalId, this.getFieldSeparator(reportExportForm), this.getTextFieldDelimiter(reportExportForm)) : ((ReportExportService)SpringContext.getBean(ReportExportService.class)).buildAccountDumpFile(principalId, this.getFieldSeparator(reportExportForm), this.getTextFieldDelimiter(reportExportForm), reportExportForm.getUniversityFiscalYear(), reportExportForm.getChartOfAccountsCode(), reportExportForm.getAccountNumber(), reportExportForm.getSubAccountNumber());
                fileName = "account_export.txt";
                break;
            }
            case MONTHLY_EXPORT: {
                fileString = reportExportForm.isOrgReport() ? ((ReportExportService)SpringContext.getBean(ReportExportService.class)).buildOrganizationMonthlyDumpFile(principalId, this.getFieldSeparator(reportExportForm), this.getTextFieldDelimiter(reportExportForm)) : ((ReportExportService)SpringContext.getBean(ReportExportService.class)).buildAccountMonthlyDumpFile(principalId, this.getFieldSeparator(reportExportForm), this.getTextFieldDelimiter(reportExportForm), reportExportForm.getUniversityFiscalYear(), reportExportForm.getChartOfAccountsCode(), reportExportForm.getAccountNumber(), reportExportForm.getSubAccountNumber());
                fileName = "monthly_export.txt";
                break;
            }
            case FUNDING_EXPORT: {
                fileString = reportExportForm.isOrgReport() ? ((ReportExportService)SpringContext.getBean(ReportExportService.class)).buildOrganizationFundingDumpFile(principalId, this.getFieldSeparator(reportExportForm), this.getTextFieldDelimiter(reportExportForm)) : ((ReportExportService)SpringContext.getBean(ReportExportService.class)).buildAccountFundingDumpFile(principalId, this.getFieldSeparator(reportExportForm), this.getTextFieldDelimiter(reportExportForm), reportExportForm.getUniversityFiscalYear(), reportExportForm.getChartOfAccountsCode(), reportExportForm.getAccountNumber(), reportExportForm.getSubAccountNumber());
                fileName = "funding_export.txt";
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (fileString.length() == 0) {
            String noDataMessage = "No data found.";
            baos.write(noDataMessage.getBytes());
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"text/plain", (ByteArrayOutputStream)baos, (String)fileName);
        } else {
            baos.write(fileString.toString().getBytes());
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"text/plain", (ByteArrayOutputStream)baos, (String)fileName);
        }
        return null;
    }
}

