/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.text.MessageFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAuthorizationStatus;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.validation.event.AdjustSalarySettingLinePercentEvent;
import org.kuali.kfs.module.bc.document.validation.event.NormalizePayrateAndAmountEvent;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.document.web.struts.SalarySettingBaseForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public abstract class SalarySettingBaseAction
extends BudgetExpansionAction {
    private static final Logger LOG = Logger.getLogger(SalarySettingBaseAction.class);
    protected SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    protected BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    protected ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    protected BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
    protected KualiRuleService kualiRuleService = (KualiRuleService)SpringContext.getBean(KualiRuleService.class);

    public abstract ActionForward loadExpansionScreen(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        if (!salarySettingForm.isBudgetByAccountMode() && salarySettingForm.getMethodToCall() != null && salarySettingForm.getMethodToCall().equals("loadExpansionScreen")) {
            this.initAuthorization(salarySettingForm);
        }
        this.populateAuthorizationFields(salarySettingForm);
        ActionForward forward = super.execute(mapping, form, request, response);
        salarySettingForm.postProcessBCAFLines();
        if (salarySettingForm.getMethodToCall().equals("refresh") && "session".equals(mapping.getScope())) {
            HttpSession sess = request.getSession(Boolean.FALSE.booleanValue());
            String formName = mapping.getAttribute();
            sess.setAttribute(formName, (Object)salarySettingForm);
        }
        return forward;
    }

    protected void populateAuthorizationFields(SalarySettingBaseForm salarySettingForm) {
        BudgetConstructionAuthorizationStatus authorizationStatus = (BudgetConstructionAuthorizationStatus)GlobalVariables.getUserSession().retrieveObject("BcDocEditStatus");
        if (authorizationStatus == null) {
            return;
        }
        salarySettingForm.setDocumentActions(authorizationStatus.getDocumentActions());
        salarySettingForm.setEditingMode(authorizationStatus.getEditingMode());
    }

    protected void initAuthorization(SalarySettingBaseForm salarySettingForm) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean isAuthorized = ((IdentityManagementService)SpringContext.getBean(IdentityManagementService.class)).isAuthorized(user.getPrincipalId(), "KFS-BC", "Use Organization Salary Setting", null);
        if (!isAuthorized) {
            throw new AuthorizationException(user.getName(), "view", salarySettingForm.getAccountNumber() + ", " + salarySettingForm.getSubAccountNumber());
        }
        salarySettingForm.getDocumentActions().put("canEdit", "true");
        if (!((FiscalYearFunctionControlService)SpringContext.getBean(FiscalYearFunctionControlService.class)).isBudgetUpdateAllowed(salarySettingForm.getUniversityFiscalYear())) {
            salarySettingForm.getEditingMode().put("systemViewOnly", "true");
        }
        BudgetConstructionAuthorizationStatus editStatus = new BudgetConstructionAuthorizationStatus();
        editStatus.setDocumentActions(salarySettingForm.getDocumentActions());
        editStatus.setEditingMode(salarySettingForm.getEditingMode());
        GlobalVariables.getUserSession().addObject("BcDocEditStatus", (Object)editStatus);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlobalVariables.getMessageMap().putError("GlobalMessages", "error.unimplemented", new String[]{"Save For Salary Setting by Incumbent"});
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        String question = request.getParameter("questionIndex");
        if (StringUtils.isBlank((String)question)) {
            String questionText = this.kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text");
            return this.performQuestionWithoutInput(mapping, (ActionForm)salarySettingForm, request, response, "DocSaveBeforeClose", questionText, "confirmationQuestion", "close", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (StringUtils.equals((String)"DocSaveBeforeClose", (String)question) && StringUtils.equals((String)"0", (String)buttonClicked)) {
            ActionForward saveAction = this.save(mapping, (ActionForm)salarySettingForm, request, response);
            return saveAction;
        }
        salarySettingForm.setSalarySettingClosed(true);
        return this.returnAfterClose(salarySettingForm, mapping, request, response);
    }

    public ActionForward vacateSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        PendingBudgetConstructionAppointmentFunding appointmentFunding = this.getSelectedFundingLine(request, salarySettingForm);
        this.salarySettingService.vacateAppointmentFunding(appointmentFundings, appointmentFunding);
        return mapping.findForward("basic");
    }

    public ActionForward purgeSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        this.getSelectedFundingLine(request, salarySettingForm).setPurged(true);
        return mapping.findForward("basic");
    }

    public ActionForward restorePurgedSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        this.getSelectedFundingLine(request, salarySettingForm).setPurged(false);
        return mapping.findForward("basic");
    }

    public ActionForward deleteSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        PendingBudgetConstructionAppointmentFunding appointmentFunding = this.getSelectedFundingLine(request, salarySettingForm);
        this.salarySettingService.markAsDelete(appointmentFunding);
        return mapping.findForward("basic");
    }

    public ActionForward undeleteSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        this.getSelectedFundingLine(request, salarySettingForm).setAppointmentFundingDeleteIndicator(false);
        return mapping.findForward("basic");
    }

    public ActionForward revertSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        PendingBudgetConstructionAppointmentFunding appointmentFunding = this.getSelectedFundingLine(request, salarySettingForm);
        this.salarySettingService.revert(appointmentFundings, appointmentFunding);
        return mapping.findForward("basic");
    }

    public ActionForward adjustSalarySettingLinePercent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        PendingBudgetConstructionAppointmentFunding appointmentFunding = this.getSelectedFundingLine(request, salarySettingForm);
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        String errorKeyPrefix = this.getErrorKeyPrefixOfAppointmentFundingLine(appointmentFundings, appointmentFunding);
        BudgetConstructionDocument document = this.budgetDocumentService.getBudgetConstructionDocument(appointmentFunding);
        if (document == null) {
            GlobalVariables.getMessageMap().putError(errorKeyPrefix, "error.budget.budgetDocumentNotFound", new String[]{appointmentFunding.getAppointmentFundingString()});
            return mapping.findForward("basic");
        }
        return this.adjustSalarySettingLinePercent(mapping, (ActionForm)salarySettingForm, appointmentFunding, document, errorKeyPrefix);
    }

    public ActionForward adjustSalarySettingLinePercent(ActionMapping mapping, ActionForm form, PendingBudgetConstructionAppointmentFunding appointmentFunding, BudgetConstructionDocument document, String errorKeyPrefix) {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        AdjustSalarySettingLinePercentEvent adjustPercentEvent = new AdjustSalarySettingLinePercentEvent("", errorKeyPrefix, document, appointmentFunding);
        boolean isValid = this.invokeRules((KualiDocumentEvent)adjustPercentEvent);
        if (!isValid) {
            return mapping.findForward("basic");
        }
        this.adjustSalary(appointmentFunding);
        return mapping.findForward("basic");
    }

    protected void adjustSalary(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        String adjustmentMeasurement = appointmentFunding.getAdjustmentMeasurement();
        if (BCConstants.SalaryAdjustmentMeasurement.PERCENT.measurement.equals(adjustmentMeasurement)) {
            this.salarySettingService.adjustRequestedSalaryByPercent(appointmentFunding);
        } else if (BCConstants.SalaryAdjustmentMeasurement.AMOUNT.measurement.equals(adjustmentMeasurement)) {
            this.salarySettingService.adjustRequestedSalaryByAmount(appointmentFunding);
        }
    }

    public ActionForward normalizePayRateAndAmount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SalarySettingBaseForm salarySettingForm = (SalarySettingBaseForm)form;
        PendingBudgetConstructionAppointmentFunding appointmentFunding = this.getSelectedFundingLine(request, salarySettingForm);
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        String errorKeyPrefix = this.getErrorKeyPrefixOfAppointmentFundingLine(appointmentFundings, appointmentFunding);
        BudgetConstructionDocument document = this.budgetDocumentService.getBudgetConstructionDocument(appointmentFunding);
        if (document == null) {
            GlobalVariables.getMessageMap().putError(errorKeyPrefix, "error.budget.budgetDocumentNotFound", new String[]{appointmentFunding.getAppointmentFundingString()});
            return mapping.findForward("basic");
        }
        NormalizePayrateAndAmountEvent normalizePayRateAndAmountEvent = new NormalizePayrateAndAmountEvent("", errorKeyPrefix, document, appointmentFunding);
        boolean isValid = this.invokeRules((KualiDocumentEvent)normalizePayRateAndAmountEvent);
        if (!isValid) {
            return mapping.findForward("basic");
        }
        this.salarySettingService.normalizePayRateAndAmount(appointmentFunding);
        return mapping.findForward("basic");
    }

    protected PendingBudgetConstructionAppointmentFunding getSelectedFundingLine(HttpServletRequest request, SalarySettingBaseForm salarySettingForm) {
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        int indexOfSelectedLine = this.getSelectedLine(request);
        return appointmentFundings.get(indexOfSelectedLine);
    }

    protected boolean invokeRules(KualiDocumentEvent event) {
        return this.kualiRuleService.applyRules(event);
    }

    protected String getErrorKeyPrefixOfAppointmentFundingLine(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        int indexOfFundingLine = appointmentFundings.indexOf((Object)appointmentFunding);
        String pattern = "{0}.{1}[{2}]";
        return MessageFormat.format(pattern, this.getFundingAwareObjectName(), "pendingBudgetConstructionAppointmentFunding", indexOfFundingLine);
    }

    protected ActionForward returnAfterClose(SalarySettingBaseForm salarySettingForm, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (salarySettingForm.isBudgetByAccountMode()) {
            salarySettingForm.getCallBackMessages().add("message.budget.successfulClose", new String[0]);
            return this.returnToCaller(mapping, (ActionForm)salarySettingForm, request, response);
        }
        this.cleanupAnySessionForm(mapping, request);
        KNSGlobalVariables.getMessageList().add("message.budget.successfulClose", new String[0]);
        return mapping.findForward("organizationSalarySettingReturning");
    }

    protected abstract String getFundingAwareObjectName();
}

