/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.kim.role.RoleTypeServiceBase;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimAttributeFieldContract;

public class AccountOrganizationHierarchyRoleTypeServiceImpl
extends RoleTypeServiceBase {
    public static final String DESCEND_HIERARCHY_TRUE_VALUE = "Y";
    public static final String DESCEND_HIERARCHY_FALSE_VALUE = "N";
    protected BudgetDocumentService budgetDocumentService;

    protected boolean performMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if ((qualification == null || qualification.isEmpty()) && roleQualifier != null && !roleQualifier.isEmpty()) {
            return true;
        }
        if (qualification == null || qualification.isEmpty() || roleQualifier == null || roleQualifier.isEmpty()) {
            return false;
        }
        String orgChartOfAccountsCode = qualification.get("organizationChartOfAccountsCode");
        String organizationCode = qualification.get("organizationCode");
        String roleChartOfAccountsCode = roleQualifier.get("chartOfAccountsCode");
        String roleOrganizationCode = roleQualifier.get("organizationCode");
        String descendHierarchy = DESCEND_HIERARCHY_FALSE_VALUE;
        if (qualification.containsKey("descendHierarchy")) {
            descendHierarchy = qualification.get("descendHierarchy");
        }
        if (DESCEND_HIERARCHY_TRUE_VALUE.equals(descendHierarchy)) {
            Integer universityFiscalYear = Integer.valueOf(qualification.get("universityFiscalYear"));
            String chartOfAccountsCode = qualification.get("chartOfAccountsCode");
            String accountNumber = qualification.get("accountNumber");
            Integer organizationLevelCode = Integer.parseInt(qualification.get("organizationLevelCode"));
            String accountReportExists = qualification.get("accountReportsExist");
            if (Boolean.FALSE.toString().equals(accountReportExists)) {
                return true;
            }
            Integer roleOrganizationLevelCode = -1;
            List<BudgetConstructionAccountOrganizationHierarchy> accountOrganizationHierarchy = this.budgetDocumentService.retrieveOrBuildAccountOrganizationHierarchy(universityFiscalYear, chartOfAccountsCode, accountNumber);
            for (BudgetConstructionAccountOrganizationHierarchy accountOrganization : accountOrganizationHierarchy) {
                if (!accountOrganization.getOrganizationChartOfAccountsCode().equals(roleChartOfAccountsCode) || !accountOrganization.getOrganizationCode().equals(roleOrganizationCode)) continue;
                roleOrganizationLevelCode = accountOrganization.getOrganizationLevelCode();
            }
            if (roleOrganizationLevelCode == -1) {
                return false;
            }
            return roleOrganizationLevelCode >= organizationLevelCode;
        }
        return roleChartOfAccountsCode.equals(orgChartOfAccountsCode) && roleOrganizationCode.equals(organizationCode);
    }

    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypId) {
        List fields = super.getAttributeDefinitions(kimTypId);
        ArrayList<KimAttributeField> updatedFields = new ArrayList<KimAttributeField>(fields.size());
        for (KimAttributeField definition : fields) {
            if ("organizationCode".equals(definition.getAttributeField().getName())) {
                KimAttributeField.Builder updatedField = KimAttributeField.Builder.create((KimAttributeFieldContract)definition);
                updatedField.getAttributeField().setRequired(false);
                updatedFields.add(updatedField.build());
                continue;
            }
            updatedFields.add(definition);
        }
        return fields;
    }
}

