/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.util;

import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.bc.batch.GenesisBatchStep;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPayRateHolding;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class BudgetParameterFinder {
    private static ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);

    public static Collection<String> getBiweeklyPayTypeCodes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "BIWEEKLY_PAY_TYPE_CODES");
    }

    public static Integer getAnnualWorkingHours() {
        String annualWorkingHours = parameterService.getParameterValueAsString(BudgetConstructionDocument.class, "ANNUAL_WORKING_HOURS");
        return Integer.valueOf(StringUtils.trim((String)annualWorkingHours));
    }

    public static Integer getWeeklyWorkingHours() {
        String weeklyWorkingHours = parameterService.getParameterValueAsString(BudgetConstructionDocument.class, "WEEKLY_WORKING_HOURS");
        return Integer.valueOf(StringUtils.trim((String)weeklyWorkingHours));
    }

    public static BigDecimal getWeeklyWorkingHoursAsDecimal() {
        Integer weeklyWorkingHours = BudgetParameterFinder.getWeeklyWorkingHours();
        return BigDecimal.valueOf(weeklyWorkingHours.intValue());
    }

    public static Collection<String> getNotGenerate2PlgSubFundGroupCodes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "GENERATE_2PLG_SUB_FUND_GROUPS");
    }

    public static Collection<String> getBiweeklyPayObjectCodes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionPayRateHolding.class, "BIWEEKLY_PAY_OBJECT_CODES");
    }

    public static Collection<String> getRevenueObjectTypes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "REVENUE_OBJECT_TYPES");
    }

    public static Collection<String> getExpenditureObjectTypes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "EXPENDITURE_OBJECT_TYPES");
    }

    public static Collection<String> getBudgetAggregationCodes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "BUDGET_AGGREGATION_CODES");
    }

    public static Collection<String> getFringeBenefitDesignatorCodes() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "FRINGE_BENEFIT_DESIGNATOR_CODES");
    }

    public static Collection<String> getSalarySettingFundGroups() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "SALARY_SETTING_FUND_GROUPS");
    }

    public static Collection<String> getSalarySettingSubFundGroups() {
        return parameterService.getParameterValuesAsString(BudgetConstructionDocument.class, "SALARY_SETTING_SUB_FUND_GROUPS");
    }

    public static boolean getPayrollIncumbentFeedIndictor() {
        return parameterService.getParameterValueAsBoolean(BudgetConstructionIntendedIncumbent.class, "EXTERNAL_INCUMBENT_FEED_IND");
    }

    public static boolean getPayrollPositionFeedIndicator() {
        return parameterService.getParameterValueAsBoolean(BudgetConstructionPosition.class, "EXTERNAL_POSITION_FEED_IND");
    }

    public static Integer getBaseFiscalYear() {
        String yearValue = parameterService.getParameterValueAsString(GenesisBatchStep.class, "SOURCE_FISCAL_YEAR");
        return Integer.valueOf(StringUtils.trim((String)yearValue));
    }
}

