/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.dataaccess.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionLockDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class BudgetConstructionLockDaoOjb
extends PlatformAwareDaoBaseOjb
implements BudgetConstructionLockDao {
    private BudgetConstructionDao budgetConstructionDao;

    @Override
    public List<BudgetConstructionHeader> getAllAccountLocks(String lockUnivId) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((String)lockUnivId)) {
            criteria.addEqualTo("budgetLockUserIdentifier", (Object)lockUnivId);
        } else {
            criteria.addNotNull("budgetLockUserIdentifier");
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(BudgetConstructionHeader.class, (Criteria)criteria);
        query.addOrderByAscending("universityFiscalYear");
        query.addOrderByAscending("chartOfAccountsCode");
        query.addOrderByAscending("accountNumber");
        query.addOrderByAscending("subAccountNumber");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public List<PendingBudgetConstructionAppointmentFunding> getAllPositionFundingLocks(String lockUnivId) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((String)lockUnivId)) {
            criteria.addEqualTo("appointmentFundingLockUserId", (Object)lockUnivId);
        } else {
            criteria.addNotNull("appointmentFundingLockUserId");
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(BudgetConstructionFundingLock.class, (Criteria)criteria);
        query.addOrderByAscending("universityFiscalYear");
        query.addOrderByAscending("chartOfAccountsCode");
        query.addOrderByAscending("accountNumber");
        query.addOrderByAscending("subAccountNumber");
        List allFundingLocks = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<PendingBudgetConstructionAppointmentFunding> positionFundingLocks = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (BudgetConstructionFundingLock fundingLock : allFundingLocks) {
            Criteria criteria2 = new Criteria();
            criteria2.addEqualTo("universityFiscalYear", (Object)fundingLock.getUniversityFiscalYear());
            criteria2.addEqualTo("chartOfAccountsCode", (Object)fundingLock.getChartOfAccountsCode());
            criteria2.addEqualTo("accountNumber", (Object)fundingLock.getAccountNumber());
            criteria2.addEqualTo("subAccountNumber", (Object)fundingLock.getSubAccountNumber());
            criteria2.addEqualTo("budgetConstructionPosition.positionLockUserIdentifier", (Object)fundingLock.getAppointmentFundingLockUserId());
            positionFundingLocks.addAll((List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PendingBudgetConstructionAppointmentFunding.class, (Criteria)criteria2)));
        }
        return positionFundingLocks;
    }

    @Override
    public List<BudgetConstructionPosition> getOrphanedPositionLocks(String lockUnivId) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((String)lockUnivId)) {
            criteria.addEqualTo("positionLockUserIdentifier", (Object)lockUnivId);
        } else {
            criteria.addNotNull("positionLockUserIdentifier");
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(BudgetConstructionPosition.class, (Criteria)criteria);
        query.addOrderByAscending("universityFiscalYear");
        query.addOrderByAscending("positionNumber");
        List allPositionLocks = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<BudgetConstructionPosition> orphanedPositionLocks = new ArrayList<BudgetConstructionPosition>();
        for (BudgetConstructionPosition position : allPositionLocks) {
            Criteria criteria2 = new Criteria();
            criteria2.addEqualTo("universityFiscalYear", (Object)position.getUniversityFiscalYear());
            criteria2.addEqualTo("positionNumber", (Object)position.getPositionNumber());
            Criteria subCrit = new Criteria();
            subCrit.addEqualToField("universityFiscalYear", "parentQuery.universityFiscalYear");
            subCrit.addEqualToField("chartOfAccountsCode", "parentQuery.chartOfAccountsCode");
            subCrit.addEqualToField("accountNumber", "parentQuery.accountNumber");
            subCrit.addEqualToField("subAccountNumber", "parentQuery.subAccountNumber");
            subCrit.addEqualTo("appointmentFundingLockUserId", (Object)position.getPositionLockUserIdentifier());
            ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(BudgetConstructionFundingLock.class, (Criteria)subCrit);
            subQuery.setAttributes(new String[]{"1"});
            criteria2.addExists((Query)subQuery);
            List appointmentFundingLocks = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PendingBudgetConstructionAppointmentFunding.class, (Criteria)criteria2));
            if (appointmentFundingLocks != null && !appointmentFundingLocks.isEmpty()) continue;
            orphanedPositionLocks.add(position);
        }
        return orphanedPositionLocks;
    }

    @Override
    public List<BudgetConstructionHeader> getAllTransactionLocks(String lockUnivId) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((String)lockUnivId)) {
            criteria.addEqualTo("budgetTransactionLockUserIdentifier", (Object)lockUnivId);
        } else {
            criteria.addNotNull("budgetTransactionLockUserIdentifier");
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(BudgetConstructionHeader.class, (Criteria)criteria);
        query.addOrderByAscending("universityFiscalYear");
        query.addOrderByAscending("chartOfAccountsCode");
        query.addOrderByAscending("accountNumber");
        query.addOrderByAscending("subAccountNumber");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public List<BudgetConstructionFundingLock> getOrphanedFundingLocks(String lockUnivId) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((String)lockUnivId)) {
            criteria.addEqualTo("appointmentFundingLockUserId", (Object)lockUnivId);
        } else {
            criteria.addNotNull("appointmentFundingLockUserId");
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(BudgetConstructionFundingLock.class, (Criteria)criteria);
        query.addOrderByAscending("universityFiscalYear");
        query.addOrderByAscending("chartOfAccountsCode");
        query.addOrderByAscending("accountNumber");
        query.addOrderByAscending("subAccountNumber");
        List allFundingLocks = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<BudgetConstructionFundingLock> orphanedFundingLocks = new ArrayList<BudgetConstructionFundingLock>();
        for (BudgetConstructionFundingLock fundingLock : allFundingLocks) {
            String positionNumber = this.budgetConstructionDao.getPositionAssociatedWithFundingLock(fundingLock);
            if (!"NotFnd".equals(positionNumber)) continue;
            orphanedFundingLocks.add(fundingLock);
        }
        return orphanedFundingLocks;
    }

    public void setBudgetConstructionDao(BudgetConstructionDao budgetConstructionDao) {
        this.budgetConstructionDao = budgetConstructionDao;
    }
}

