/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.batch.dataaccess.GenesisDao;
import org.kuali.kfs.module.bc.batch.service.BudgetConstructionHumanResourcesPayrollInterfaceService;
import org.kuali.kfs.module.bc.batch.service.GenesisService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class GenesisServiceImpl
implements GenesisService {
    protected GenesisDao genesisDao;
    protected BudgetConstructionHumanResourcesPayrollInterfaceService budgetConstructionHumanResourcesPayrollInterfaceService;
    private static Logger LOG = Logger.getLogger(GenesisServiceImpl.class);

    @Override
    public boolean BatchPositionSynchAllowed(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        boolean ReturnValue = this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BCGENE") || this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BCACTV") && this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BSSYNC");
        return ReturnValue;
    }

    @Override
    public boolean CSFUpdatesAllowed(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        boolean ReturnValue = this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BCGENE") || this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BCACTV") && this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "CSFUPD");
        return ReturnValue;
    }

    @Override
    public boolean GLUpdatesAllowed(Integer BaseYear) {
        Integer RequestYear = BaseYear + 1;
        boolean ReturnValue = this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BCGENE") || this.genesisDao.getBudgetConstructionControlFlag(RequestYear, "BCACTV") && this.genesisDao.getBudgetConstructionControlFlag(BaseYear, "BASEAD");
        return ReturnValue;
    }

    @Override
    public boolean IsBudgetConstructionInUpdateMode(Integer baseYear) {
        Integer requestYear = baseYear + 1;
        return this.genesisDao.getBudgetConstructionControlFlag(requestYear, "BCGENE") || this.genesisDao.getBudgetConstructionControlFlag(requestYear, "BCACTV") && this.genesisDao.getBudgetConstructionControlFlag(requestYear, "BCUPDT");
    }

    @Override
    public void clearDBForGenesis(Integer BaseYear) {
        this.genesisDao.clearDBForGenesis(BaseYear);
    }

    @Override
    public Integer genesisFiscalYearFromToday() {
        return this.genesisDao.fiscalYearFromToday();
    }

    @Override
    public void bCUpdateStep(Integer BaseYear) {
        LOG.warn((Object)String.format("\n\nStarting BC Update:\n  clear hanging locks\n", new Object[0]));
        this.genesisDao.clearHangingBCLocks(BaseYear);
        LOG.warn((Object)String.format("\n  validate object classes\n", new Object[0]));
        this.genesisDao.ensureObjectClassRIForBudget(BaseYear);
        LOG.warn((Object)String.format("\n  create new documents\n", new Object[0]));
        this.genesisDao.createNewBCDocumentsFromGLCSF(BaseYear, this.GLUpdatesAllowed(BaseYear), this.CSFUpdatesAllowed(BaseYear));
        if (this.GLUpdatesAllowed(BaseYear)) {
            LOG.warn((Object)String.format("\n  add rows to pending general ledger\n", new Object[0]));
            this.genesisDao.updateToPBGL(BaseYear);
        }
        boolean CSFOK = this.CSFUpdatesAllowed(BaseYear);
        boolean PSSynchOK = this.BatchPositionSynchAllowed(BaseYear);
        boolean BCUpdatesAllowed = this.IsBudgetConstructionInUpdateMode(BaseYear);
        LOG.warn((Object)String.format("\n  update Budget Construction Position\n", new Object[0]));
        this.budgetConstructionHumanResourcesPayrollInterfaceService.refreshBudgetConstructionPosition(BaseYear, PSSynchOK, CSFOK);
        LOG.warn((Object)String.format("\n  intended incumbent", new Object[0]));
        this.budgetConstructionHumanResourcesPayrollInterfaceService.refreshBudgetConstructionIntendedIncumbent(BaseYear, PSSynchOK, CSFOK, BCUpdatesAllowed);
        if (CSFOK) {
            LOG.warn((Object)String.format("\n  build appointment funding\n", new Object[0]));
            this.genesisDao.buildAppointmentFundingAndBCSF(BaseYear);
        }
        LOG.warn((Object)String.format("\n  rebuild the organization hierarchy\n", new Object[0]));
        this.genesisDao.rebuildOrganizationHierarchy(BaseYear);
        Integer requestFiscalYear = BaseYear + 1;
        LOG.warn((Object)String.format("\n  look for accounts missing from Budget Construction Accounting\n", new Object[0]));
        HashMap missingAccounts = (HashMap)this.genesisDao.verifyAccountsAreAccessible(requestFiscalYear);
        for (Map.Entry missingAccount : missingAccounts.entrySet()) {
            String[] missingValues = (String[])missingAccount.getValue();
            LOG.warn((Object)String.format("    (chart: %s, account: %s) not found in Budget Construction Accounting\n", missingValues[0], missingValues[1]));
        }
    }

    @Override
    public void genesisStep(Integer BaseYear) {
        LOG.warn((Object)String.format("\nstarting Genesis:\n  flags", new Object[0]));
        this.genesisDao.setControlFlagsAtTheStartOfGenesis(BaseYear);
        LOG.warn((Object)String.format("\n  clear database", new Object[0]));
        this.genesisDao.clearDBForGenesis(BaseYear);
        LOG.warn((Object)String.format("\n  chart for budget", new Object[0]));
        this.genesisDao.createChartForNextBudgetCycle();
        LOG.warn((Object)String.format("\n  referential integrity for object classes", new Object[0]));
        this.genesisDao.ensureObjectClassRIForBudget(BaseYear);
        LOG.warn((Object)String.format("\n  new BC documents", new Object[0]));
        this.genesisDao.createNewBCDocumentsFromGLCSF(BaseYear, this.GLUpdatesAllowed(BaseYear), this.CSFUpdatesAllowed(BaseYear));
        LOG.warn((Object)String.format("\n  load to PBGL", new Object[0]));
        this.genesisDao.initialLoadToPBGL(BaseYear);
        LOG.warn((Object)String.format("\n  new positions", new Object[0]));
        boolean CSFOK = this.CSFUpdatesAllowed(BaseYear);
        boolean PSSynchOK = this.BatchPositionSynchAllowed(BaseYear);
        boolean BCUpdatesAllowed = this.IsBudgetConstructionInUpdateMode(BaseYear);
        this.budgetConstructionHumanResourcesPayrollInterfaceService.refreshBudgetConstructionPosition(BaseYear, PSSynchOK, CSFOK);
        LOG.warn((Object)String.format("\n  intended incumbent", new Object[0]));
        this.budgetConstructionHumanResourcesPayrollInterfaceService.refreshBudgetConstructionIntendedIncumbent(BaseYear, PSSynchOK, CSFOK, BCUpdatesAllowed);
        if (CSFOK) {
            LOG.warn((Object)"\n  appointment funding/BCSF");
            this.genesisDao.buildAppointmentFundingAndBCSF(BaseYear);
        }
        LOG.warn((Object)"\n  organization hierarchy");
        this.genesisDao.rebuildOrganizationHierarchy(BaseYear);
        LOG.warn((Object)"\n  reset control flags");
        this.genesisDao.setControlFlagsAtTheEndOfGenesis(BaseYear);
        LOG.warn((Object)"\n  end of genesis");
    }

    @Override
    public Map verifyAccountsAreAccessible(Integer requestFiscalYear) {
        return this.genesisDao.verifyAccountsAreAccessible(requestFiscalYear);
    }

    public void setGenesisDao(GenesisDao genesisDao) {
        this.genesisDao = genesisDao;
    }

    public void setBudgetConstructionHumanResourcesPayrollInterfaceService(BudgetConstructionHumanResourcesPayrollInterfaceService budgetConstructionHumanResourcesPayrollInterfaceService) {
        this.budgetConstructionHumanResourcesPayrollInterfaceService = budgetConstructionHumanResourcesPayrollInterfaceService;
    }
}

