/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BenefitsCalculationService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.BudgetParameterService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.validation.AddBudgetConstructionDocumentRule;
import org.kuali.kfs.module.bc.document.validation.AddPendingBudgetGeneralLedgerLineRule;
import org.kuali.kfs.module.bc.document.validation.DeleteMonthlySpreadRule;
import org.kuali.kfs.module.bc.document.validation.DeletePendingBudgetGeneralLedgerLineRule;
import org.kuali.kfs.module.bc.document.validation.SaveMonthlyBudgetRule;
import org.kuali.kfs.module.bc.document.validation.impl.BudgetConstructionRuleUtil;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.AccountingLineRuleHelperService;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.bo.BusinessObject;

public class BudgetConstructionDocumentRules
extends TransactionalDocumentRuleBase
implements AddBudgetConstructionDocumentRule<BudgetConstructionDocument>,
AddPendingBudgetGeneralLedgerLineRule<BudgetConstructionDocument, PendingBudgetConstructionGeneralLedger>,
DeletePendingBudgetGeneralLedgerLineRule<BudgetConstructionDocument, PendingBudgetConstructionGeneralLedger>,
DeleteMonthlySpreadRule<BudgetConstructionDocument>,
SaveMonthlyBudgetRule<BudgetConstructionDocument, BudgetConstructionMonthly> {
    protected static Logger LOG = Logger.getLogger(BudgetConstructionDocumentRules.class);
    protected static BudgetParameterService budgetParameterService = (BudgetParameterService)SpringContext.getBean(BudgetParameterService.class);
    protected static AccountingLineRuleHelperService accountingLineRuleHelper = (AccountingLineRuleHelperService)SpringContext.getBean(AccountingLineRuleHelperService.class);
    protected static DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
    protected static SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    protected static BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    protected static FiscalYearFunctionControlService fiscalYearFunctionControlService = (FiscalYearFunctionControlService)SpringContext.getBean(FiscalYearFunctionControlService.class);
    protected Collection<String> revenueObjectTypesParamValues = BudgetParameterFinder.getRevenueObjectTypes();
    protected Collection<String> expenditureObjectTypesParamValues = BudgetParameterFinder.getExpenditureObjectTypes();
    protected Collection<String> budgetAggregationCodesParamValues = BudgetParameterFinder.getBudgetAggregationCodes();
    protected Collection<String> fringeBenefitDesignatorCodesParamValues = BudgetParameterFinder.getFringeBenefitDesignatorCodes();
    protected Collection<String> salarySettingFundGroupsParamValues = BudgetParameterFinder.getSalarySettingFundGroups();
    protected Collection<String> salarySettingSubFundGroupsParamValues = BudgetParameterFinder.getSalarySettingSubFundGroups();
    protected static final String TARGET_ERROR_PROPERTY_NAME = "accountLineAnnualBalanceAmount";

    @Override
    public boolean processAddBudgetConstructionDocumentRules(BudgetConstructionDocument budgetConstructionDocument) {
        LOG.debug((Object)"processAddBudgetConstructionDocumentRules(Document) - start");
        MessageMap errors = GlobalVariables.getMessageMap();
        boolean isValid = true;
        int originalErrorCount = errors.getErrorCount();
        ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validateBusinessObject((BusinessObject)budgetConstructionDocument);
        int currentErrorCount = errors.getErrorCount();
        if (!(isValid &= currentErrorCount == originalErrorCount)) {
            return isValid;
        }
        if (!fiscalYearFunctionControlService.isBudgetUpdateAllowed(budgetConstructionDocument.getUniversityFiscalYear())) {
            errors.putError("accountNumber", "message.budget.systemViewOnly", new String[0]);
            isValid &= false;
        }
        DataDictionary dd = dataDictionaryService.getDataDictionary();
        String pkeyValue = budgetConstructionDocument.getChartOfAccountsCode() + "-" + budgetConstructionDocument.getAccountNumber();
        if (isValid &= this.isValidAccount(budgetConstructionDocument.getAccount(), pkeyValue, dd, "accountNumber")) {
            isValid &= this.isBudgetAllowed(budgetConstructionDocument, "accountNumber", errors, true, true);
        }
        if (!isValid) {
            KNSGlobalVariables.getMessageList().add("message.budget.nocreate.document", new String[0]);
        }
        LOG.debug((Object)"processAddBudgetConstructionDocumentRules(Document) - end");
        return isValid;
    }

    public boolean processSaveDocument(Document document) {
        LOG.debug((Object)"processSaveDocument(Document) - start");
        boolean isValid = true;
        if (isValid &= this.isDocumentAttributesValid(document, true)) {
            isValid &= this.processSaveBudgetDocumentRules((BudgetConstructionDocument)document, BCConstants.MonthSpreadDeleteType.NONE);
        }
        LOG.debug((Object)"processSaveDocument(Document) - end");
        return isValid;
    }

    @Override
    public boolean processDeleteMonthlySpreadRules(BudgetConstructionDocument budgetConstructionDocument, BCConstants.MonthSpreadDeleteType monthSpreadDeleteType) {
        LOG.debug((Object)"processDeleteRevenueMonthlySpreadRules(Document) - start");
        boolean isValid = true;
        if (isValid &= this.isDocumentAttributesValid((Document)budgetConstructionDocument, true)) {
            isValid &= this.processSaveBudgetDocumentRules(budgetConstructionDocument, monthSpreadDeleteType);
        }
        LOG.debug((Object)"processDeleteRevenueMonthlySpreadRules(Document) - end");
        return isValid;
    }

    public boolean processSaveBudgetDocumentRules(BudgetConstructionDocument budgetConstructionDocument, BCConstants.MonthSpreadDeleteType monthSpreadDeleteType) {
        MessageMap errors = GlobalVariables.getMessageMap();
        boolean doRevMonthRICheck = true;
        boolean doExpMonthRICheck = true;
        boolean isValid = true;
        List<String> refreshFields = Collections.unmodifiableList(Arrays.asList("account", "subAccount"));
        ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)budgetConstructionDocument, refreshFields);
        errors.addToErrorPath("document");
        if (monthSpreadDeleteType == BCConstants.MonthSpreadDeleteType.REVENUE) {
            doRevMonthRICheck = false;
            doExpMonthRICheck = true;
        } else if (monthSpreadDeleteType == BCConstants.MonthSpreadDeleteType.EXPENDITURE) {
            doRevMonthRICheck = true;
            doExpMonthRICheck = false;
        }
        isValid &= this.checkPendingBudgetConstructionGeneralLedgerLines(budgetConstructionDocument, errors, true, doRevMonthRICheck);
        errors.removeFromErrorPath("document");
        return isValid &= this.checkPendingBudgetConstructionGeneralLedgerLines(budgetConstructionDocument, errors, false, doExpMonthRICheck);
    }

    @Override
    public boolean processAddPendingBudgetGeneralLedgerLineRules(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger, boolean isRevenue) {
        LOG.debug((Object)"processAddPendingBudgetGeneralLedgerLineRules() start");
        MessageMap errors = GlobalVariables.getMessageMap();
        boolean isValid = true;
        int originalErrorCount = errors.getErrorCount();
        ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validateBusinessObject((BusinessObject)pendingBudgetConstructionGeneralLedger);
        int currentErrorCount = errors.getErrorCount();
        if (isValid &= currentErrorCount == originalErrorCount) {
            List<String> refreshFields = Collections.unmodifiableList(Arrays.asList("account", "subAccount"));
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)budgetConstructionDocument, refreshFields);
            if (isValid &= this.checkPendingBudgetConstructionGeneralLedgerLine(budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, errors, isRevenue, true)) {
                isValid &= this.isNewLineUnique(budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, errors, isRevenue);
            }
        }
        if (!isValid) {
            LOG.info((Object)"business rule checks failed in processAddPendingBudgetGeneralLedgerLineRules in BudgetConstructionRules");
        }
        LOG.debug((Object)"processAddPendingBudgetGeneralLedgerLineRules() end");
        return isValid;
    }

    @Override
    public boolean processDeletePendingBudgetGeneralLedgerLineRules(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger, boolean isRevenue) {
        String pkeyVal;
        LOG.debug((Object)"processDeletePendingBudgetGeneralLedgerLineRules() start");
        MessageMap errors = GlobalVariables.getMessageMap();
        boolean isValid = true;
        if (pendingBudgetConstructionGeneralLedger.getFinancialBeginningBalanceLineAmount().isZero()) {
            isValid &= true;
        } else {
            isValid &= false;
            pkeyVal = pendingBudgetConstructionGeneralLedger.getFinancialObjectCode() + "," + pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode();
            GlobalVariables.getMessageMap().putError(TARGET_ERROR_PROPERTY_NAME, "error.budget.noDeleteAllowedWithBase", new String[]{pkeyVal});
        }
        if (!isRevenue) {
            isValid &= this.isNotFringeBenefitObject(this.fringeBenefitDesignatorCodesParamValues, pendingBudgetConstructionGeneralLedger, errors, false);
            if (!((SalarySettingService)SpringContext.getBean(SalarySettingService.class)).isSalarySettingDisabled() && pendingBudgetConstructionGeneralLedger.getLaborObject() != null && pendingBudgetConstructionGeneralLedger.getLaborObject().isDetailPositionRequiredIndicator() && pendingBudgetConstructionGeneralLedger.isPendingBudgetConstructionAppointmentFundingExists()) {
                isValid &= false;
                pkeyVal = pendingBudgetConstructionGeneralLedger.getFinancialObjectCode() + "," + pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode();
                GlobalVariables.getMessageMap().putError(TARGET_ERROR_PROPERTY_NAME, "error.budget.noDeleteAllowedSalaryDetail", new String[]{pkeyVal});
            }
            if (!((BenefitsCalculationService)SpringContext.getBean(BenefitsCalculationService.class)).isBenefitsCalculationDisabled() && isValid && pendingBudgetConstructionGeneralLedger.getPositionObjectBenefit() != null && !pendingBudgetConstructionGeneralLedger.getPositionObjectBenefit().isEmpty()) {
                budgetConstructionDocument.setBenefitsCalcNeeded(true);
                if (pendingBudgetConstructionGeneralLedger.getBudgetConstructionMonthly() != null && !pendingBudgetConstructionGeneralLedger.getBudgetConstructionMonthly().isEmpty()) {
                    budgetConstructionDocument.setMonthlyBenefitsCalcNeeded(true);
                }
            }
        }
        LOG.debug((Object)"processDeletePendingBudgetGeneralLedgerLineRules() end");
        return isValid;
    }

    @Override
    public boolean processSaveMonthlyBudgetRules(BudgetConstructionDocument budgetConstructionDocument, BudgetConstructionMonthly budgetConstructionMonthly) {
        LOG.debug((Object)"processSaveMonthlyBudgetRules() start");
        budgetConstructionMonthly.refreshNonUpdateableReferences();
        PendingBudgetConstructionGeneralLedger pbgl = budgetConstructionMonthly.getPendingBudgetConstructionGeneralLedger();
        MessageMap errors = GlobalVariables.getMessageMap();
        boolean isValid = true;
        int originalErrorCount = errors.getErrorCount();
        ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validateBusinessObject((BusinessObject)budgetConstructionMonthly);
        int currentErrorCount = errors.getErrorCount();
        isValid &= currentErrorCount == originalErrorCount;
        if (!budgetConstructionDocument.isBudgetableDocument()) {
            isValid &= Boolean.FALSE.booleanValue();
            errors.putError("financialDocumentMonth1LineAmount", "error.budget.documentNotBudgetable", new String[]{budgetConstructionDocument.getAccountNumber() + ";" + budgetConstructionDocument.getSubAccountNumber()});
        }
        DataDictionary dd = dataDictionaryService.getDataDictionary();
        if (isValid) {
            ObjectCode objectCode = budgetConstructionMonthly.getFinancialObject();
            isValid &= this.isValidObjectCode(objectCode, budgetConstructionMonthly.getFinancialObjectCode(), dd, "financialObjectCode");
            if (StringUtils.isNotBlank((String)budgetConstructionMonthly.getFinancialSubObjectCode()) && !budgetConstructionMonthly.getFinancialSubObjectCode().equalsIgnoreCase(KFSConstants.getDashFinancialSubObjectCode())) {
                SubObjectCode subObjectCode = budgetConstructionMonthly.getFinancialSubObject();
                isValid &= this.isValidSubObjectCode(subObjectCode, budgetConstructionMonthly.getFinancialSubObjectCode(), dd, "financialSubObjectCode");
            }
        }
        if (isValid) {
            KualiInteger monthlyTotal = budgetConstructionMonthly.getFinancialDocumentMonthTotalLineAmount();
            if (!salarySettingService.isSalarySettingDisabled() && pbgl.getLaborObject() != null && pbgl.getLaborObject().isDetailPositionRequiredIndicator() && !monthlyTotal.equals((Object)pbgl.getAccountLineAnnualBalanceAmount())) {
                isValid &= false;
                errors.putError("financialDocumentMonth1LineAmount", "error.budget.monthlyDetailSalarySettingNoRequestOverride", new String[]{budgetConstructionMonthly.getFinancialObjectCode(), monthlyTotal.toString(), pbgl.getAccountLineAnnualBalanceAmount().toString()});
            }
            if (monthlyTotal.isZero()) {
                boolean nonZeroMonthlyExists = false;
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth1LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth2LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth3LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth4LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth5LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth6LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth7LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth8LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth9LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth10LineAmount().isNonZero();
                nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth11LineAmount().isNonZero();
                if (nonZeroMonthlyExists |= budgetConstructionMonthly.getFinancialDocumentMonth12LineAmount().isNonZero()) {
                    isValid &= false;
                    errors.putError("financialDocumentMonth1LineAmount", "error.budget.monthlyTotalZero", new String[0]);
                }
            }
        } else {
            LOG.info((Object)"business rule checks failed in processSaveMonthlyBudgetRules in BudgetConstructionDocumentRules");
        }
        LOG.debug((Object)"processSaveMonthlyBudgetRules() end");
        return isValid;
    }

    protected boolean checkPendingBudgetConstructionGeneralLedgerLines(BudgetConstructionDocument budgetConstructionDocument, MessageMap errors, boolean isRevenue, boolean doMonthRICheck) {
        String linesErrorPath;
        List<PendingBudgetConstructionGeneralLedger> pendingBudgetConstructionGeneralLedgerLines;
        boolean isValid = true;
        if (isRevenue) {
            pendingBudgetConstructionGeneralLedgerLines = budgetConstructionDocument.getPendingBudgetConstructionGeneralLedgerRevenueLines();
            linesErrorPath = "pendingBudgetConstructionGeneralLedgerRevenueLines";
        } else {
            pendingBudgetConstructionGeneralLedgerLines = budgetConstructionDocument.getPendingBudgetConstructionGeneralLedgerExpenditureLines();
            linesErrorPath = "pendingBudgetConstructionGeneralLedgerExpenditureLines";
        }
        Integer index = 0;
        for (PendingBudgetConstructionGeneralLedger element : pendingBudgetConstructionGeneralLedgerLines) {
            boolean forceMonthlyRICheck;
            boolean isRequestAmountChanged;
            errors.addToErrorPath(linesErrorPath + "[" + index + "]");
            int originalErrorCount = errors.getErrorCount();
            this.validatePrimitiveFromDescriptor((Object)element, TARGET_ERROR_PROPERTY_NAME, "", true);
            int currentErrorCount = errors.getErrorCount();
            boolean isReqAmountValid = currentErrorCount == originalErrorCount;
            isValid &= isReqAmountValid;
            originalErrorCount = errors.getErrorCount();
            boolean bl = isRequestAmountChanged = isReqAmountValid && !element.getAccountLineAnnualBalanceAmount().equals((Object)element.getPersistedAccountLineAnnualBalanceAmount());
            if (isReqAmountValid && element.getAccountLineAnnualBalanceAmount().isNonZero()) {
                boolean isSalaryFringeLine = false;
                if (!isRevenue && this.fringeBenefitDesignatorCodesParamValues != null && element.getLaborObject() != null) {
                    isSalaryFringeLine = this.fringeBenefitDesignatorCodesParamValues.contains(element.getLaborObject().getFinancialObjectFringeOrSalaryCode());
                }
                boolean is2PLG = !isRevenue && element.getFinancialObjectCode().contentEquals("2PLG");
                boolean isCleanupModeActionForceCheck = budgetConstructionDocument.isCleanupModeActionForceCheck();
                if (isRequestAmountChanged || doMonthRICheck && !is2PLG && !isSalaryFringeLine || !budgetConstructionDocument.isBudgetableDocument() && isCleanupModeActionForceCheck && !is2PLG && !isSalaryFringeLine) {
                    isValid &= this.checkPendingBudgetConstructionGeneralLedgerLine(budgetConstructionDocument, element, errors, isRevenue, false);
                }
            }
            boolean forceTwoPlugRICheck = budgetConstructionDocument.isContainsTwoPlug() && element.getLaborObject() != null && element.getLaborObject().isDetailPositionRequiredIndicator();
            boolean bl2 = forceMonthlyRICheck = budgetConstructionDocument.isContainsTwoPlug() && (element.getLaborObject() == null || !element.getLaborObject().isDetailPositionRequiredIndicator());
            if (isReqAmountValid && (isRequestAmountChanged || forceTwoPlugRICheck)) {
                BudgetConstructionMonthly budgetConstructionMonthly;
                if ((doMonthRICheck || forceMonthlyRICheck) && element.getBudgetConstructionMonthly() != null && !element.getBudgetConstructionMonthly().isEmpty() && (budgetConstructionMonthly = element.getBudgetConstructionMonthly().get(0)) != null) {
                    KualiInteger monthSum = KualiInteger.ZERO;
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth1LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth2LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth3LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth4LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth5LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth6LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth7LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth8LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth9LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth10LineAmount());
                    monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth11LineAmount());
                    if (!(monthSum = monthSum.add(budgetConstructionMonthly.getFinancialDocumentMonth12LineAmount())).equals((Object)element.getAccountLineAnnualBalanceAmount())) {
                        isValid &= false;
                        String pkeyVal = element.getFinancialObjectCode() + "," + element.getFinancialSubObjectCode();
                        GlobalVariables.getMessageMap().putError(TARGET_ERROR_PROPERTY_NAME, "error.budget.monthlySumRequestNotEqual", new String[]{pkeyVal, monthSum.toString(), element.getAccountLineAnnualBalanceAmount().toString()});
                    }
                }
                if (!((SalarySettingService)SpringContext.getBean(SalarySettingService.class)).isSalarySettingDisabled() && element.getLaborObject() != null && element.getLaborObject().isDetailPositionRequiredIndicator()) {
                    KualiInteger salarySum = KualiInteger.ZERO;
                    if (element.isPendingBudgetConstructionAppointmentFundingExists()) {
                        salarySum = ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).getPendingBudgetConstructionAppointmentFundingRequestSum(element);
                    }
                    if (!salarySum.equals((Object)element.getAccountLineAnnualBalanceAmount())) {
                        isValid &= false;
                        String pkeyVal = element.getFinancialObjectCode() + "," + element.getFinancialSubObjectCode();
                        GlobalVariables.getMessageMap().putError(TARGET_ERROR_PROPERTY_NAME, "error.budget.salarySumRequestNotEqual", new String[]{pkeyVal, salarySum.toString(), element.getAccountLineAnnualBalanceAmount().toString()});
                    }
                }
                if (isReqAmountValid && !element.getAccountLineAnnualBalanceAmount().equals((Object)element.getPersistedAccountLineAnnualBalanceAmount()) && !((BenefitsCalculationService)SpringContext.getBean(BenefitsCalculationService.class)).isBenefitsCalculationDisabled()) {
                    currentErrorCount = errors.getErrorCount();
                    boolean bl3 = isReqAmountValid = currentErrorCount == originalErrorCount;
                    if (isReqAmountValid && element.getPositionObjectBenefit() != null && !element.getPositionObjectBenefit().isEmpty()) {
                        budgetConstructionDocument.setBenefitsCalcNeeded(true);
                    }
                }
            }
            errors.removeFromErrorPath(linesErrorPath + "[" + index + "]");
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return isValid;
    }

    protected boolean checkPendingBudgetConstructionGeneralLedgerLine(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger, MessageMap errors, boolean isRevenue, boolean isAdd) {
        LOG.debug((Object)"checkPendingBudgetConstructionGeneralLedgerLine() start");
        boolean isValid = true;
        pendingBudgetConstructionGeneralLedger.refreshNonUpdateableReferences();
        if (isValid &= this.validatePBGLLine(pendingBudgetConstructionGeneralLedger, isAdd)) {
            isValid &= this.isBudgetAggregationAllowed(this.budgetAggregationCodesParamValues, pendingBudgetConstructionGeneralLedger, errors, isAdd);
            isValid &= this.isBudgetAllowed(budgetConstructionDocument, "financialObjectCode", errors, isAdd, false);
            if (isRevenue) {
                isValid &= this.isNotSalarySettingOnly(this.salarySettingFundGroupsParamValues, this.salarySettingSubFundGroupsParamValues, budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, errors, isRevenue, isAdd);
                isValid &= this.isObjectTypeAllowed(this.revenueObjectTypesParamValues, pendingBudgetConstructionGeneralLedger, errors, isRevenue, isAdd);
            } else {
                isValid &= this.isObjectTypeAllowed(this.expenditureObjectTypesParamValues, pendingBudgetConstructionGeneralLedger, errors, isRevenue, isAdd);
                isValid &= this.isNonWagesAccountNotLaborObject(budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, errors, isAdd);
                isValid &= this.isNotSalarySettingOnly(this.salarySettingFundGroupsParamValues, this.salarySettingSubFundGroupsParamValues, budgetConstructionDocument, pendingBudgetConstructionGeneralLedger, errors, isRevenue, isAdd);
                isValid &= this.isNotFringeBenefitObject(this.fringeBenefitDesignatorCodesParamValues, pendingBudgetConstructionGeneralLedger, errors, isAdd);
            }
        }
        if (!isValid) {
            LOG.info((Object)"business rule checks failed in checkPendingBudgetConstructionGeneralLedgerLine in BudgetConstructionRules");
        }
        LOG.debug((Object)"checkPendingBudgetConstructionGeneralLedgerLine() end");
        return isValid;
    }

    protected boolean validatePBGLLine(PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger, boolean isAdd) {
        if (pendingBudgetConstructionGeneralLedger == null) {
            throw new IllegalStateException(this.getKualiConfigurationService().getPropertyValueAsString("error.document.nullAccountingLine"));
        }
        DataDictionary dd = dataDictionaryService.getDataDictionary();
        boolean valid = true;
        ObjectCode objectCode = pendingBudgetConstructionGeneralLedger.getFinancialObject();
        valid = isAdd ? (valid &= this.isValidObjectCode(objectCode, pendingBudgetConstructionGeneralLedger.getFinancialObjectCode(), dd, "financialObjectCode")) : (valid &= this.isValidObjectCode(objectCode, pendingBudgetConstructionGeneralLedger.getFinancialObjectCode(), dd, TARGET_ERROR_PROPERTY_NAME));
        if (StringUtils.isNotBlank((String)pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode()) && !pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode().equalsIgnoreCase(KFSConstants.getDashFinancialSubObjectCode())) {
            SubObjectCode subObjectCode = pendingBudgetConstructionGeneralLedger.getFinancialSubObject();
            valid = isAdd ? (valid &= this.isValidSubObjectCode(subObjectCode, pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode(), dd, "financialSubObjectCode")) : (valid &= this.isValidSubObjectCode(subObjectCode, pendingBudgetConstructionGeneralLedger.getFinancialSubObjectCode(), dd, TARGET_ERROR_PROPERTY_NAME));
        }
        return valid;
    }

    protected void validatePrimitiveFromDescriptor(Object object, String attributeName, String errorPrefix, boolean validateRequired) {
        try {
            PropertyDescriptor attributeDescriptor = PropertyUtils.getPropertyDescriptor((Object)object, (String)attributeName);
            this.validatePrimitiveFromDescriptor(object.getClass().getName(), object, attributeDescriptor, "", true);
        }
        catch (NoSuchMethodException e) {
            throw new InfrastructureException("unable to find propertyDescriptor for property '" + attributeName + "'", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("unable to access propertyDescriptor for property '" + attributeName + "'", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new InfrastructureException("unable to invoke methods for property '" + attributeName + "'", (Exception)e);
        }
    }

    protected void validatePrimitiveFromDescriptor(String entryName, Object object, PropertyDescriptor propertyDescriptor, String errorPrefix, boolean validateRequired) {
        if (null != propertyDescriptor && dataDictionaryService.isAttributeDefined(entryName, propertyDescriptor.getName()).booleanValue()) {
            Object value = ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName());
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (TypeUtils.isStringClass(propertyType) || TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType) || TypeUtils.isTemporalClass(propertyType)) {
                if (value != null && StringUtils.isNotBlank((String)value.toString())) {
                    if (!TypeUtils.isTemporalClass(propertyType)) {
                        ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validate(object, entryName, propertyDescriptor.getName(), false);
                    }
                } else if (validateRequired) {
                    ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validate(object, entryName, propertyDescriptor.getName(), true);
                }
            }
        }
    }

    protected boolean isObjectTypeAllowed(Collection<String> paramValues, PendingBudgetConstructionGeneralLedger accountingLine, MessageMap errors, boolean isRevenue, boolean isAdd) {
        boolean isAllowed = true;
        if (paramValues != null) {
            if (!paramValues.contains(accountingLine.getFinancialObject().getFinancialObjectTypeCode())) {
                isAllowed = false;
                String targetErrorProperty = isAdd ? "financialObjectCode" : TARGET_ERROR_PROPERTY_NAME;
                if (isRevenue) {
                    this.putError(errors, targetErrorProperty, "error.budget.object.type.invalid.revenue", isAdd, accountingLine.getFinancialObjectCode(), accountingLine.getFinancialObject().getFinancialObjectTypeCode());
                } else {
                    this.putError(errors, targetErrorProperty, "error.budget.object.type.invalid.expense", isAdd, accountingLine.getFinancialObjectCode(), accountingLine.getFinancialObject().getFinancialObjectTypeCode());
                }
            }
        } else {
            isAllowed = false;
        }
        return isAllowed;
    }

    protected boolean isBudgetAggregationAllowed(Collection<String> paramValues, PendingBudgetConstructionGeneralLedger accountingLine, MessageMap errors, boolean isAdd) {
        boolean isAllowed = true;
        if (paramValues != null) {
            if (!paramValues.contains(accountingLine.getFinancialObject().getFinancialBudgetAggregationCd())) {
                isAllowed = false;
                this.putError(errors, "financialObjectCode", "error.document.incorrectObjCodeWithBudgetAggregation", isAdd, accountingLine.getFinancialObjectCode(), accountingLine.getFinancialObject().getFinancialBudgetAggregationCd());
            }
        } else {
            isAllowed = false;
        }
        return isAllowed;
    }

    protected boolean isNewLineUnique(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger newLine, MessageMap errors, boolean isRevenue) {
        boolean isUnique = true;
        List<PendingBudgetConstructionGeneralLedger> existingLines = isRevenue ? budgetConstructionDocument.getPendingBudgetConstructionGeneralLedgerRevenueLines() : budgetConstructionDocument.getPendingBudgetConstructionGeneralLedgerExpenditureLines();
        if (BudgetConstructionRuleUtil.hasExistingPBGLLine(existingLines, newLine)) {
            isUnique = false;
            errors.putError("financialObjectCode", "error.budget.lineExists", new String[]{newLine.getFinancialObjectCode() + "," + newLine.getFinancialSubObjectCode()});
        }
        return isUnique;
    }

    protected boolean isNonWagesAccountNotLaborObject(BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger accountingLine, MessageMap errors, boolean isAdd) {
        boolean isAllowed = true;
        if (!(budgetConstructionDocument.getAccount().getSubFundGroup() != null && budgetConstructionDocument.getAccount().getSubFundGroup().isSubFundGroupWagesIndicator() || accountingLine.getLaborObject() == null)) {
            isAllowed = false;
            this.putError(errors, "financialObjectCode", "error.budget.laborObjectInNoWagesAccount", isAdd, accountingLine.getFinancialObjectCode());
        }
        return isAllowed;
    }

    protected boolean isNotFringeBenefitObject(Collection<String> paramValues, PendingBudgetConstructionGeneralLedger accountingLine, MessageMap errors, boolean isAdd) {
        boolean isAllowed = true;
        if (paramValues != null) {
            if (accountingLine.getLaborObject() != null && paramValues.contains(accountingLine.getLaborObject().getFinancialObjectFringeOrSalaryCode())) {
                isAllowed = false;
                this.putError(errors, "financialObjectCode", "error.budget.fringeBenefitObjectNotAllowed", isAdd, accountingLine.getFinancialObjectCode());
            }
        } else {
            isAllowed = false;
        }
        return isAllowed;
    }

    protected boolean isNotSalarySettingOnly(Collection<String> fundGroupParamValues, Collection<String> subfundGroupParamValues, BudgetConstructionDocument budgetConstructionDocument, PendingBudgetConstructionGeneralLedger accountingLine, MessageMap errors, boolean isRevenue, boolean isAdd) {
        boolean isAllowed = true;
        BCConstants.AccountSalarySettingOnlyCause retVal = budgetParameterService.isSalarySettingOnlyAccount(budgetConstructionDocument);
        if (retVal != BCConstants.AccountSalarySettingOnlyCause.MISSING_PARAM) {
            if (retVal != BCConstants.AccountSalarySettingOnlyCause.NONE && (isRevenue || accountingLine.getLaborObject() == null || !accountingLine.getLaborObject().isDetailPositionRequiredIndicator())) {
                isAllowed = false;
                if (retVal == BCConstants.AccountSalarySettingOnlyCause.FUND || retVal == BCConstants.AccountSalarySettingOnlyCause.FUND_AND_SUBFUND) {
                    this.putError(errors, "financialObjectCode", "error.budget.salarySettingObjectOnly", isAdd, "fund " + budgetConstructionDocument.getAccount().getSubFundGroup().getFundGroupCode());
                }
                if (retVal == BCConstants.AccountSalarySettingOnlyCause.SUBFUND || retVal == BCConstants.AccountSalarySettingOnlyCause.FUND_AND_SUBFUND) {
                    this.putError(errors, "financialObjectCode", "error.budget.salarySettingObjectOnly", isAdd, "subfund " + budgetConstructionDocument.getAccount().getSubFundGroup().getSubFundGroupCode());
                }
            }
        } else {
            this.putError(errors, "financialObjectCode", "error.budget.salarySettingObjectOnlyNoParameter", isAdd, budgetConstructionDocument.getAccount().getSubFundGroup().getFundGroupCode() + "," + budgetConstructionDocument.getAccount().getSubFundGroup().getSubFundGroupCode());
            isAllowed = false;
        }
        return isAllowed;
    }

    protected boolean isBudgetAllowed(BudgetConstructionDocument budgetConstructionDocument, String propertyName, MessageMap errors, boolean isAdd, boolean isDocumentAdd) {
        boolean isAllowed = true;
        SimpleDateFormat tdf = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
        if (!budgetConstructionDocument.getAccount().isActive()) {
            isAllowed = false;
            this.putError(errors, propertyName, "error.closed", isAdd, "account: " + budgetConstructionDocument.getAccountNumber());
        }
        Calendar expDate = BudgetConstructionRuleUtil.getNoBudgetAllowedExpireDate(budgetConstructionDocument.getUniversityFiscalYear());
        if (budgetConstructionDocument.getAccount().isExpired(expDate)) {
            isAllowed = false;
            this.putError(errors, propertyName, "error.budget.noBudgetAllowed", isAdd, budgetConstructionDocument.getAccountNumber(), tdf.format(budgetConstructionDocument.getAccount().getAccountExpirationDate()));
        }
        if (budgetConstructionDocument.getAccount().getBudgetRecordingLevelCode().equalsIgnoreCase("N")) {
            isAllowed = false;
            this.putError(errors, propertyName, "error.budget.budgetRecordingLevelNotAllowed", isAdd, budgetConstructionDocument.getAccountNumber(), "N");
        }
        DataDictionary dd = dataDictionaryService.getDataDictionary();
        if (StringUtils.isNotBlank((String)budgetConstructionDocument.getSubAccountNumber()) && !budgetConstructionDocument.getSubAccountNumber().equalsIgnoreCase(KFSConstants.getDashSubAccountNumber())) {
            SubAccount subAccount = budgetConstructionDocument.getSubAccount();
            isAllowed = isAdd ? (isDocumentAdd ? (isAllowed &= this.isValidSubAccount(subAccount, budgetConstructionDocument.getSubAccountNumber(), dd, "subAccountNumber")) : (isAllowed &= this.isValidSubAccount(subAccount, budgetConstructionDocument.getSubAccountNumber(), dd, propertyName))) : (isAllowed &= this.isValidSubAccount(subAccount, budgetConstructionDocument.getSubAccountNumber(), dd, TARGET_ERROR_PROPERTY_NAME));
            HashMap<String, String> searchCriteria = new HashMap<String, String>();
            searchCriteria.put("chartOfAccountsCode", budgetConstructionDocument.getChartOfAccountsCode());
            searchCriteria.put("accountNumber", budgetConstructionDocument.getAccountNumber());
            searchCriteria.put("subAccountNumber", budgetConstructionDocument.getSubAccountNumber());
            A21SubAccount a21SubAccount = (A21SubAccount)businessObjectService.findByPrimaryKey(A21SubAccount.class, searchCriteria);
            if (ObjectUtils.isNotNull((Object)a21SubAccount) && a21SubAccount.getSubAccountTypeCode().equalsIgnoreCase("CS")) {
                isAllowed = false;
                this.putError(errors, "subAccountNumber", "error.budget.subAccountTypeNotAllowed", isAdd, budgetConstructionDocument.getSubAccountNumber(), "CS");
            }
        }
        return isAllowed;
    }

    public boolean isValidAccount(Account account, String value, DataDictionary dataDictionary, String errorPropertyName) {
        String label = dataDictionary.getBusinessObjectEntry(Account.class.getName()).getAttributeDefinition("accountNumber").getShortLabel();
        if (ObjectUtils.isNull((Object)account)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label + ":" + value});
            return false;
        }
        return true;
    }

    public boolean isValidSubAccount(SubAccount subAccount, String value, DataDictionary dataDictionary, String errorPropertyName) {
        String label = dataDictionary.getBusinessObjectEntry(SubAccount.class.getName()).getAttributeDefinition("subAccountNumber").getShortLabel();
        if (ObjectUtils.isNull((Object)subAccount)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label + ":" + value});
            return false;
        }
        if (!subAccount.isActive()) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.document.subAccountInactive", new String[]{label + ":" + value});
            return false;
        }
        return true;
    }

    public boolean isValidSubObjectCode(SubObjectCode subObjectCode, String value, DataDictionary dataDictionary, String errorPropertyName) {
        String label = dataDictionary.getBusinessObjectEntry(SubObjectCode.class.getName()).getAttributeDefinition("financialSubObjectCode").getShortLabel();
        if (ObjectUtils.isNull((Object)subObjectCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label + ":" + value});
            return false;
        }
        if (!subObjectCode.isActive()) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label + ":" + value});
            return false;
        }
        return true;
    }

    public boolean isValidObjectCode(ObjectCode objectCode, String value, DataDictionary dataDictionary, String errorPropertyName) {
        String label = dataDictionary.getBusinessObjectEntry(ObjectCode.class.getName()).getAttributeDefinition("financialObjectCode").getShortLabel();
        if (ObjectUtils.isNull((Object)objectCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label + ":" + value});
            return false;
        }
        if (!objectCode.isFinancialObjectActiveCode()) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label + ":" + value});
            return false;
        }
        return true;
    }

    protected void putError(MessageMap errors, String propertyName, String errorKey, boolean isAdd, String ... errorParameters) {
        if (isAdd) {
            errors.putError(propertyName, errorKey, errorParameters);
        } else {
            errors.putError(TARGET_ERROR_PROPERTY_NAME, errorKey, errorParameters);
        }
    }
}

