/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.kns.kim.role.RoleTypeServiceBase;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionProcessorService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.identity.BudgetConstructionNoAccessMessageSetting;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;

public class DocumentDerivedRoleTypeServiceImpl
extends RoleTypeServiceBase
implements BudgetConstructionNoAccessMessageSetting {
    private static Logger LOG = Logger.getLogger(DocumentDerivedRoleTypeServiceImpl.class);
    protected static final String UNMATCHABLE_QUALIFICATION = "!~!~!~!~!~";
    protected BudgetConstructionProcessorService budgetConstructionProcessorService;
    protected BudgetDocumentService budgetDocumentService;

    public Map<String, String> convertQualificationForMemberRoles(String namespaceCode, String roleName, String memberRoleNamespaceCode, String memberRoleName, Map<String, String> qualification) {
        HashMap<String, String> newQualification = new HashMap<String, String>();
        if (qualification != null && !qualification.isEmpty()) {
            Integer organizationLevelCode;
            String universityFiscalYear = qualification.get("universityFiscalYear");
            String chartOfAccountsCode = qualification.get("chartOfAccountsCode");
            String accountNumber = qualification.get("accountNumber");
            String orgChartOfAccountsCode = qualification.get("organizationChartOfAccountsCode");
            String organizationCode = qualification.get("organizationCode");
            String accountReportExists = qualification.get("accountReportsExist");
            Integer n = organizationLevelCode = qualification.get("organizationLevelCode") != null ? Integer.valueOf(Integer.parseInt(qualification.get("organizationLevelCode"))) : null;
            if ("Processor".equals(memberRoleName)) {
                if ("Document Editor".equals(roleName) && organizationLevelCode != null && organizationLevelCode == 0) {
                    organizationCode = UNMATCHABLE_QUALIFICATION;
                }
            } else if (organizationLevelCode != null && organizationLevelCode != 0 && ("Document Editor".equals(roleName) || Boolean.TRUE.toString().equals(accountReportExists))) {
                accountNumber = UNMATCHABLE_QUALIFICATION;
            }
            String descendHierarchy = "N";
            if ("Document Viewer".equals(roleName)) {
                descendHierarchy = "Y";
                newQualification.put("universityFiscalYear", universityFiscalYear);
                newQualification.put("organizationLevelCode", organizationLevelCode != null ? organizationLevelCode.toString() : null);
            }
            newQualification.put("chartOfAccountsCode", chartOfAccountsCode);
            newQualification.put("accountNumber", accountNumber);
            newQualification.put("organizationChartOfAccountsCode", orgChartOfAccountsCode);
            newQualification.put("organizationCode", organizationCode);
            newQualification.put("descendHierarchy", descendHierarchy);
            newQualification.put("accountReportsExist", accountReportExists);
            if (qualification.containsKey("documentTypeName")) {
                newQualification.put("documentTypeName", qualification.get("documentTypeName"));
            }
        }
        return newQualification;
    }

    @Override
    public void setNoAccessMessage(BudgetConstructionDocument document, Person user, MessageMap messageMap) {
        LOG.info((Object)"Started DocumentDerivedRoleTypeServiceImpl.setNoAccessMessage");
        HashMap<String, String> qualification = new HashMap<String, String>(3);
        qualification.put("chartOfAccountsCode", document.getChartOfAccountsCode());
        qualification.put("accountNumber", document.getAccountNumber());
        qualification.put("documentTypeName", "BC");
        RoleService roleService = KimApiServiceLocator.getRoleService();
        boolean isFiscalOfficerOrDelegate = roleService.principalHasRole(user.getPrincipalId(), Collections.singletonList(roleService.getRoleIdByNamespaceCodeAndName("KFS-SYS", "Fiscal Officer")), qualification);
        boolean isBCProcessor = false;
        boolean isProcessorInAccountHierarchy = false;
        List<Organization> userProcessingOrgs = this.budgetConstructionProcessorService.getProcessorOrgs(user);
        if (userProcessingOrgs != null && !userProcessingOrgs.isEmpty()) {
            isBCProcessor = true;
            List<BudgetConstructionAccountOrganizationHierarchy> accountOrganizationHierarchy = this.budgetDocumentService.retrieveOrBuildAccountOrganizationHierarchy(document.getUniversityFiscalYear(), document.getChartOfAccountsCode(), document.getAccountNumber());
            for (BudgetConstructionAccountOrganizationHierarchy accountOrganization : accountOrganizationHierarchy) {
                if (!userProcessingOrgs.contains(accountOrganization.getOrganization())) continue;
                isProcessorInAccountHierarchy = true;
            }
        }
        if (document.getOrganizationLevelCode() == 0) {
            messageMap.putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.budget.userNotInHierarchy", new String[0]);
        } else if (isFiscalOfficerOrDelegate || isProcessorInAccountHierarchy) {
            messageMap.putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.budget.userBelowDocLevel", new String[0]);
        } else if (isBCProcessor) {
            messageMap.putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.budget.userNotInHierarchy", new String[0]);
        } else {
            messageMap.putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.budget.userNotOrgApprover", new String[0]);
        }
        LOG.info((Object)"Finished DocumentDerivedRoleTypeServiceImpl.setNoAccessMessage");
    }

    public void setBudgetConstructionProcessorService(BudgetConstructionProcessorService budgetConstructionProcessorService) {
        this.budgetConstructionProcessorService = budgetConstructionProcessorService;
    }

    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    public List<KeyValue> getAttributeValidValues(String kimTypeId, String attributeName) {
        return Collections.emptyList();
    }

    public List<String> getQualifiersForExactMatch() {
        return Collections.emptyList();
    }

    public List<RoleMembership> getRoleMembersFromApplicationRole(String namespaceCode, String roleName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        return Collections.emptyList();
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        return Collections.emptyList();
    }

    public List<RoleMembership> sortRoleMembers(List<RoleMembership> roleMembers) throws RiceIllegalArgumentException {
        return Collections.emptyList();
    }

    public List<RemotableAttributeError> validateUniqueAttributes(String kimTypeId, Map<String, String> newAttributes, Map<String, String> oldAttributes) throws RiceIllegalArgumentException {
        return Collections.emptyList();
    }

    public List<RemotableAttributeError> validateUnmodifiableAttributes(String kimTypeId, Map<String, String> originalAttributes, Map<String, String> newAttributes) throws RiceIllegalArgumentException {
        return Collections.emptyList();
    }

    public String getWorkflowDocumentTypeName() {
        return null;
    }

    public List<String> getWorkflowRoutingAttributes(String routeLevel) {
        if (StringUtils.isBlank((String)routeLevel)) {
            throw new RiceIllegalArgumentException("routeLevel was null or blank");
        }
        return Collections.emptyList();
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        return Collections.emptyList();
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (attributes == null) {
            throw new RiceIllegalArgumentException("attributes was null or blank");
        }
        return Collections.emptyList();
    }

    public List<RemotableAttributeError> validateAttributesAgainstExisting(String kimTypeId, Map<String, String> newAttributes, Map<String, String> oldAttributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (newAttributes == null) {
            throw new RiceIllegalArgumentException("newAttributes was null or blank");
        }
        if (oldAttributes == null) {
            throw new RiceIllegalArgumentException("oldAttributes was null or blank");
        }
        return Collections.emptyList();
    }

    public boolean doesRoleQualifierMatchQualification(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        if (roleQualifier == null) {
            throw new RiceIllegalArgumentException("roleQualifier was null");
        }
        return true;
    }

    public List<RoleMembership> getMatchingRoleMemberships(Map<String, String> qualification, List<RoleMembership> roleMemberList) {
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        if (roleMemberList == null) {
            throw new RiceIllegalArgumentException("roleMemberList was null");
        }
        return Collections.unmodifiableList(new ArrayList<RoleMembership>(roleMemberList));
    }

    public boolean isDerivedRoleType() {
        return true;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (groupIds == null) {
            throw new RiceIllegalArgumentException("groupIds was null or blank");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        return false;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        return false;
    }
}

