/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionRequestMove;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class ImportRequestFileParsingHelper {
    public static BudgetConstructionRequestMove parseLine(String lineToParse, String fieldSeperator, String textDelimiter, boolean isAnnual) {
        ArrayList<String> attributes = new ArrayList<String>();
        BudgetConstructionRequestMove budgetConstructionRequestMove = new BudgetConstructionRequestMove();
        int expectedNumberOfSeparators = isAnnual ? 5 : 16;
        if (!ImportRequestFileParsingHelper.isLineCorrectlyFormatted(lineToParse = lineToParse.trim(), fieldSeperator, textDelimiter, isAnnual)) {
            return null;
        }
        if (textDelimiter.equalsIgnoreCase(BCConstants.RequestImportTextFieldDelimiter.NOTHING.getDelimiter())) {
            attributes.addAll(Arrays.asList(lineToParse.split(ImportRequestFileParsingHelper.isFieldSeparatorSpecialCharacter(fieldSeperator) ? "\\" + fieldSeperator : fieldSeperator)));
        } else if (ImportRequestFileParsingHelper.getEscapedFieldSeparatorCount(lineToParse, fieldSeperator, textDelimiter, isAnnual) == 0) {
            lineToParse = StringUtils.remove((String)lineToParse, (String)textDelimiter);
            attributes.addAll(Arrays.asList(lineToParse.split(ImportRequestFileParsingHelper.isFieldSeparatorSpecialCharacter(fieldSeperator) ? "\\" + fieldSeperator : fieldSeperator)));
        } else {
            int firstIndexOfTextDelimiter = 0;
            int nextIndexOfTextDelimiter = lineToParse.indexOf(textDelimiter, firstIndexOfTextDelimiter + 1);
            int expectedNumberOfTextDelimiters = 10;
            for (int i = 0; i < expectedNumberOfTextDelimiters / 2; ++i) {
                attributes.add(lineToParse.substring(firstIndexOfTextDelimiter, nextIndexOfTextDelimiter).replaceAll(textDelimiter, ""));
                firstIndexOfTextDelimiter = lineToParse.indexOf(textDelimiter, nextIndexOfTextDelimiter + 1);
                nextIndexOfTextDelimiter = lineToParse.indexOf(textDelimiter, firstIndexOfTextDelimiter + 1);
            }
            String remainingNonStringValuesToParse = lineToParse.substring(lineToParse.lastIndexOf(textDelimiter + 1));
            attributes.addAll(Arrays.asList(remainingNonStringValuesToParse.split(ImportRequestFileParsingHelper.isFieldSeparatorSpecialCharacter(fieldSeperator) ? "\\" + fieldSeperator : fieldSeperator)));
        }
        if (attributes.size() < expectedNumberOfSeparators + 1) {
            return null;
        }
        budgetConstructionRequestMove.setChartOfAccountsCode((String)attributes.get(0));
        budgetConstructionRequestMove.setAccountNumber((String)attributes.get(1));
        budgetConstructionRequestMove.setSubAccountNumber((String)attributes.get(2));
        budgetConstructionRequestMove.setFinancialObjectCode((String)attributes.get(3));
        budgetConstructionRequestMove.setFinancialSubObjectCode((String)attributes.get(4));
        try {
            if (isAnnual) {
                budgetConstructionRequestMove.setAccountLineAnnualBalanceAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(5))));
            } else {
                budgetConstructionRequestMove.setFinancialDocumentMonth1LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(5))));
                budgetConstructionRequestMove.setFinancialDocumentMonth2LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(6))));
                budgetConstructionRequestMove.setFinancialDocumentMonth3LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(7))));
                budgetConstructionRequestMove.setFinancialDocumentMonth4LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(8))));
                budgetConstructionRequestMove.setFinancialDocumentMonth5LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(9))));
                budgetConstructionRequestMove.setFinancialDocumentMonth6LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(10))));
                budgetConstructionRequestMove.setFinancialDocumentMonth7LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(11))));
                budgetConstructionRequestMove.setFinancialDocumentMonth8LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(12))));
                budgetConstructionRequestMove.setFinancialDocumentMonth9LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(13))));
                budgetConstructionRequestMove.setFinancialDocumentMonth10LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(14))));
                budgetConstructionRequestMove.setFinancialDocumentMonth11LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(15))));
                budgetConstructionRequestMove.setFinancialDocumentMonth12LineAmount(new KualiInteger((long)Integer.parseInt((String)attributes.get(16))));
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return budgetConstructionRequestMove;
    }

    public static boolean isLineCorrectlyFormatted(String lineToParse, String fieldSeperator, String textDelimiter, boolean isAnnual) {
        int expectedNumberOfSeparators;
        int fieldSeparatorCount = StringUtils.countMatches((String)lineToParse, (String)fieldSeperator);
        int n = expectedNumberOfSeparators = isAnnual ? 5 : 16;
        if (textDelimiter.equalsIgnoreCase(BCConstants.RequestImportTextFieldDelimiter.NOTHING.getDelimiter())) {
            if (isAnnual ? fieldSeparatorCount != 5 : fieldSeparatorCount != 16) {
                return false;
            }
        } else {
            if (StringUtils.countMatches((String)lineToParse, (String)textDelimiter) != 10) {
                return false;
            }
            if (ImportRequestFileParsingHelper.getEscapedFieldSeparatorCount(lineToParse, fieldSeperator, textDelimiter, isAnnual) == -1 || fieldSeparatorCount - ImportRequestFileParsingHelper.getEscapedFieldSeparatorCount(lineToParse, fieldSeperator, textDelimiter, isAnnual) != expectedNumberOfSeparators) {
                return false;
            }
        }
        return true;
    }

    private static int getEscapedFieldSeparatorCount(String lineToParse, String fieldSeperator, String textDelimiter, boolean isAnnual) {
        int firstIndexOfTextDelimiter = 0;
        int nextIndexOfTextDelimiter = lineToParse.indexOf(textDelimiter, firstIndexOfTextDelimiter + 1);
        int expectedNumberOfSeparators = isAnnual ? 5 : 16;
        int expectedTextDelimitersCount = 10;
        int actualNumberOfTextDelimiters = StringUtils.countMatches((String)lineToParse, (String)textDelimiter);
        int totalSeparatorsInLineToParse = StringUtils.countMatches((String)lineToParse, (String)fieldSeperator);
        int escapedSeparatorsCount = 0;
        if (textDelimiter.equalsIgnoreCase(BCConstants.RequestImportTextFieldDelimiter.NOTHING.getDelimiter())) {
            return 0;
        }
        if (totalSeparatorsInLineToParse == expectedNumberOfSeparators) {
            return 0;
        }
        if (actualNumberOfTextDelimiters != expectedTextDelimitersCount) {
            return -1;
        }
        for (int i = 0; i < expectedTextDelimitersCount / 2; ++i) {
            String escapedString = lineToParse.substring(firstIndexOfTextDelimiter, nextIndexOfTextDelimiter);
            escapedSeparatorsCount += StringUtils.countMatches((String)escapedString, (String)fieldSeperator);
            firstIndexOfTextDelimiter = lineToParse.indexOf(textDelimiter, nextIndexOfTextDelimiter + 1);
            nextIndexOfTextDelimiter = lineToParse.indexOf(textDelimiter, firstIndexOfTextDelimiter + 1);
        }
        return escapedSeparatorsCount;
    }

    private static boolean isFieldSeparatorSpecialCharacter(String delimiter) {
        if (delimiter.equals(".")) {
            return true;
        }
        if (delimiter.equals("[")) {
            return true;
        }
        if (delimiter.equals("\\")) {
            return true;
        }
        if (delimiter.equals("*")) {
            return true;
        }
        if (delimiter.equals("^")) {
            return true;
        }
        return delimiter.equals("$");
    }
}

