/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.lookup.SelectLookupableHelperServiceImpl;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.krad.bo.BusinessObject;

public class IntendedIncumbentLookupableHelperServiceImpl
extends SelectLookupableHelperServiceImpl {
    public ConfigurationService kualiConfigurationService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        Map requestParameters = super.getParameters();
        if (requestParameters.containsKey("showSalaryByIncumbentAction")) {
            String[] requestParm = (String[])requestParameters.get("showSalaryByIncumbentAction");
            Boolean showSalaryByIncumbent = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)requestParm[0]);
            if (!showSalaryByIncumbent.booleanValue()) {
                return this.getIncumbentCustomActionUrls(businessObject, pkNames);
            }
        } else {
            return this.getIncumbentCustomActionUrls(businessObject, pkNames);
        }
        return this.getSalarySettingByIncumbentUrls(businessObject);
    }

    protected String getActionUrlHref(BusinessObject businessObject, String methodToCall, List pkNames) {
        String href = super.getActionUrlHref(businessObject, methodToCall, pkNames);
        return StringUtils.replace((String)href, (String)"maintenance.do", (String)"kr/maintenance.do");
    }

    private List<HtmlData> getIncumbentCustomActionUrls(BusinessObject businessObject, List pkNames) {
        BudgetConstructionIntendedIncumbent intendedIncumbent = (BudgetConstructionIntendedIncumbent)businessObject;
        boolean payrollIncumbentFeed = BudgetParameterFinder.getPayrollIncumbentFeedIndictor();
        if (!payrollIncumbentFeed) {
            return super.getCustomActionUrls(businessObject, pkNames);
        }
        return super.getEmptyActionUrls();
    }

    public boolean allowsMaintenanceNewOrCopyAction() {
        boolean payrollIncumbentFeed = BudgetParameterFinder.getPayrollIncumbentFeedIndictor();
        return !payrollIncumbentFeed;
    }

    protected Properties getSalarySettingByIncumbentParameters(BusinessObject businessObject) {
        String[] requestParm;
        BudgetConstructionIntendedIncumbent intendedIncumbent = (BudgetConstructionIntendedIncumbent)businessObject;
        Properties parameters = new Properties();
        parameters.put("methodToCall", "loadExpansionScreen");
        parameters.put("emplid", intendedIncumbent.getEmplid());
        Map requestParameters = super.getParameters();
        boolean linkToNewWindow = true;
        if (requestParameters.containsKey("addLine")) {
            String[] requestParm2 = (String[])requestParameters.get("addLine");
            parameters.put("addLine", requestParm2[0]);
            Boolean addNewFunding = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)requestParm2[0]);
            if (addNewFunding.booleanValue()) {
                linkToNewWindow = false;
            }
        } else {
            parameters.put("addLine", "false");
        }
        String[] universityFiscalYear = (String[])super.getParameters().get("universityFiscalYear");
        parameters.put("universityFiscalYear", universityFiscalYear[0]);
        if (requestParameters.containsKey("docFormKey")) {
            requestParm = (String[])requestParameters.get("docFormKey");
            parameters.put("returnFormKey", requestParm[0]);
        } else if (requestParameters.containsKey("formKey")) {
            requestParm = (String[])requestParameters.get("formKey");
            parameters.put("returnFormKey", requestParm[0]);
        }
        if (requestParameters.containsKey("backLocation")) {
            requestParm = (String[])requestParameters.get("backLocation");
            parameters.put("backLocation", requestParm[0]);
        }
        if (requestParameters.containsKey("chartOfAccountsCode")) {
            requestParm = (String[])requestParameters.get("chartOfAccountsCode");
            parameters.put("chartOfAccountsCode", requestParm[0]);
        }
        if (requestParameters.containsKey("accountNumber")) {
            requestParm = (String[])requestParameters.get("accountNumber");
            parameters.put("accountNumber", requestParm[0]);
        }
        if (requestParameters.containsKey("subAccountNumber")) {
            requestParm = (String[])requestParameters.get("subAccountNumber");
            parameters.put("subAccountNumber", requestParm[0]);
        }
        if (requestParameters.containsKey("financialObjectCode")) {
            requestParm = (String[])requestParameters.get("financialObjectCode");
            parameters.put("financialObjectCode", requestParm[0]);
        }
        if (requestParameters.containsKey("financialSubObjectCode")) {
            requestParm = (String[])requestParameters.get("financialSubObjectCode");
            parameters.put("financialSubObjectCode", requestParm[0]);
        }
        if (requestParameters.containsKey("budgetByAccountMode")) {
            requestParm = (String[])requestParameters.get("budgetByAccountMode");
            parameters.put("budgetByAccountMode", requestParm[0]);
        }
        if (requestParameters.containsKey("mainWindow")) {
            requestParm = (String[])requestParameters.get("mainWindow");
            parameters.put("mainWindow", requestParm[0]);
        }
        if (requestParameters.containsKey("singleAccountMode")) {
            requestParm = (String[])requestParameters.get("singleAccountMode");
            parameters.put("singleAccountMode", requestParm[0]);
        } else {
            parameters.put("singleAccountMode", "false");
        }
        parameters.put("refreshIncumbentBeforeSalarySetting", "false");
        return parameters;
    }

    public List<HtmlData> getSalarySettingByIncumbentUrls(BusinessObject businessObject) {
        String[] requestParm;
        Boolean addNewFunding;
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        Properties parameters = this.getSalarySettingByIncumbentParameters(businessObject);
        String href = UrlFactory.parameterizeUrl((String)"budgetIncumbentSalarySetting.do", (Properties)parameters);
        HtmlData.AnchorHtmlData urlData1 = new HtmlData.AnchorHtmlData(href, "loadExpansionScreen", "Incmbnt Salset");
        Map requestParameters = super.getParameters();
        boolean linkToNewWindow = true;
        if (requestParameters.containsKey("addLine") && (addNewFunding = (Boolean)new BooleanFormatter().convertFromPresentationFormat((Object)(requestParm = (String[])requestParameters.get("addLine"))[0])).booleanValue()) {
            linkToNewWindow = false;
        }
        if (linkToNewWindow) {
            urlData1.setTarget("BCSecondWindow");
        }
        anchorHtmlDataList.add((HtmlData)urlData1);
        boolean payrollIncumbentFeed = BudgetParameterFinder.getPayrollIncumbentFeedIndictor();
        if (payrollIncumbentFeed) {
            parameters.put("refreshIncumbentBeforeSalarySetting", "true");
            href = UrlFactory.parameterizeUrl((String)"budgetIncumbentSalarySetting.do", (Properties)parameters);
            HtmlData.AnchorHtmlData urlData2 = new HtmlData.AnchorHtmlData(href, "loadExpansionScreen", "Incmbnt Salset w/sync");
            if (linkToNewWindow) {
                urlData2.setTarget("_blank");
            }
            anchorHtmlDataList.add((HtmlData)urlData2);
            ((HtmlData)anchorHtmlDataList.get(anchorHtmlDataList.lastIndexOf(urlData2))).setPrependDisplayText("<br />");
        }
        return anchorHtmlDataList;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

