/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.service.impl;

import java.sql.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.bc.batch.dataaccess.GeneralLedgerBudgetLoadDao;
import org.kuali.kfs.module.bc.batch.service.GLBudgetLoadService;
import org.kuali.kfs.module.bc.batch.service.GenesisService;
import org.kuali.kfs.sys.service.HomeOriginationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class GLBudgetLoadServiceImpl
implements GLBudgetLoadService {
    private static Logger LOG = Logger.getLogger(GLBudgetLoadServiceImpl.class);
    protected DateTimeService dateTimeService;
    protected HomeOriginationService homeOriginationService;
    private GenesisService genesisService;
    private GeneralLedgerBudgetLoadDao generalLedgerBudgetLoadDao;

    @Override
    public void loadPendingBudgetConstructionGeneralLedger(Integer FiscalYear) {
        Date currentSqlDate = this.dateTimeService.getCurrentSqlDate();
        String financialSystemOriginationCode = this.homeOriginationService.getHomeOrigination().getFinSystemHomeOriginationCode();
        LOG.warn((Object)String.format("\n\n********Budget construction general ledger load started for %d********", FiscalYear));
        this.generalLedgerBudgetLoadDao.loadGeneralLedgerFromBudget(FiscalYear, currentSqlDate, financialSystemOriginationCode);
        LOG.warn((Object)String.format("\n\n********Budget construction general ledger load ended********", new Object[0]));
    }

    @Override
    public void loadPendingBudgetConstructionGeneralLedger() {
        Integer nextFiscalYear = this.genesisService.genesisFiscalYearFromToday() + 1;
        LOG.warn((Object)String.format("\n\n********Budget construction general ledger load started for %d********", nextFiscalYear));
        this.loadPendingBudgetConstructionGeneralLedger(nextFiscalYear);
        LOG.warn((Object)String.format("\n\n********Budget construction general ledger load ended********", new Object[0]));
    }

    public void setGeneralLedgerBudgetLoadDao(GeneralLedgerBudgetLoadDao generalLedgerBudgetLoadDao) {
        this.generalLedgerBudgetLoadDao = generalLedgerBudgetLoadDao;
    }

    public void setGenesisService(GenesisService genesisService) {
        this.genesisService = genesisService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setHomeOriginationService(HomeOriginationService homeOriginationService) {
        this.homeOriginationService = homeOriginationService;
    }
}

