/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.CalculatedSalaryFoundationTrackerOverride;
import org.kuali.kfs.module.bc.document.service.CalculatedSalaryFoundationTrackerOverrideService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;

public class CalculatedSalaryFoundationTrackerOverrideRule
extends MaintenanceDocumentRuleBase {
    protected CalculatedSalaryFoundationTrackerOverride oldCalculatedSalaryFoundationTrackerOverride;
    protected CalculatedSalaryFoundationTrackerOverride newCalculatedSalaryFoundationTrackerOverride;
    protected CalculatedSalaryFoundationTrackerOverrideService calculatedSalaryFoundationTrackerOverrideService;

    public CalculatedSalaryFoundationTrackerOverrideRule() {
        this.setCalculatedSalaryFoundationTrackerOverrideService((CalculatedSalaryFoundationTrackerOverrideService)SpringContext.getBean(CalculatedSalaryFoundationTrackerOverrideService.class));
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        this.setupConvenienceObjects(document);
        success &= this.checkFiscalYearIsCurrent(document);
        success &= this.checkAppointmentIsValid();
        return success &= this.checkPositionIsValid();
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        this.setupConvenienceObjects(document);
        this.checkFiscalYearIsCurrent(document);
        this.checkAppointmentIsValid();
        this.checkPositionIsValid();
        return success;
    }

    protected void setupConvenienceObjects(MaintenanceDocument document) {
        this.oldCalculatedSalaryFoundationTrackerOverride = (CalculatedSalaryFoundationTrackerOverride)((Object)super.getOldBo());
        this.newCalculatedSalaryFoundationTrackerOverride = (CalculatedSalaryFoundationTrackerOverride)((Object)super.getNewBo());
    }

    protected boolean checkFiscalYearIsCurrent(MaintenanceDocument document) {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)this.newCalculatedSalaryFoundationTrackerOverride.getUniversityFiscalYear()) && document.isNew()) {
            Integer currentFiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
            Integer universityFiscalYear = this.newCalculatedSalaryFoundationTrackerOverride.getUniversityFiscalYear();
            if (!universityFiscalYear.equals(currentFiscalYear)) {
                this.putFieldError("universityFiscalYear", "error.fiscalYear.notCurrentFiscalYear", "Fiscal Year");
                success &= false;
            }
        }
        return success;
    }

    protected boolean checkAppointmentIsValid() {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)this.newCalculatedSalaryFoundationTrackerOverride.getEmplid()) && ObjectUtils.isNotNull((Object)this.newCalculatedSalaryFoundationTrackerOverride.getPositionNumber()) && ObjectUtils.isNotNull((Object)this.newCalculatedSalaryFoundationTrackerOverride.getUniversityFiscalYear())) {
            String emplid = this.newCalculatedSalaryFoundationTrackerOverride.getEmplid();
            String positionNumber = this.newCalculatedSalaryFoundationTrackerOverride.getPositionNumber();
            Integer universityFiscalYear = this.newCalculatedSalaryFoundationTrackerOverride.getUniversityFiscalYear();
            boolean result = this.calculatedSalaryFoundationTrackerOverrideService.isValidAppointment(universityFiscalYear, positionNumber, emplid);
            if (!result) {
                this.putFieldError("emplid", "error.invalid.appointment", "Employee Id");
                success &= false;
            }
        } else {
            this.putFieldError("emplid", "error.invalid.appointment", "Employee Id");
            success &= false;
        }
        return success;
    }

    protected boolean checkPositionIsValid() {
        boolean success = true;
        if (ObjectUtils.isNotNull((Object)this.newCalculatedSalaryFoundationTrackerOverride.getPositionNumber()) && ObjectUtils.isNotNull((Object)this.newCalculatedSalaryFoundationTrackerOverride.getUniversityFiscalYear())) {
            String emplid = this.newCalculatedSalaryFoundationTrackerOverride.getEmplid();
            String positionNumber = this.newCalculatedSalaryFoundationTrackerOverride.getPositionNumber();
            Integer universityFiscalYear = this.newCalculatedSalaryFoundationTrackerOverride.getUniversityFiscalYear();
            boolean result = this.calculatedSalaryFoundationTrackerOverrideService.isValidAppointment(universityFiscalYear, positionNumber, emplid);
            if (!result) {
                this.putFieldError("positionNumber", "error.invalid.position", "Position Number");
                success &= false;
            }
        } else {
            this.putFieldError("positionNumber", "error.invalid.position", "Position Number");
            success &= false;
        }
        return success;
    }

    public void setCalculatedSalaryFoundationTrackerOverrideService(CalculatedSalaryFoundationTrackerOverrideService calculatedSalaryFoundationTrackerOverrideService) {
        this.calculatedSalaryFoundationTrackerOverrideService = calculatedSalaryFoundationTrackerOverrideService;
    }
}

