/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.SessionDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BCKeyLabelPair;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAuthorizationStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionMonthlyBudgetsCreateDeleteService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.validation.event.AddPendingBudgetGeneralLedgerLineEvent;
import org.kuali.kfs.module.bc.document.validation.event.DeletePendingBudgetGeneralLedgerLineEvent;
import org.kuali.kfs.module.bc.document.web.struts.BudgetConstructionForm;
import org.kuali.kfs.module.bc.exception.BudgetConstructionDocumentAuthorizationException;
import org.kuali.kfs.module.bc.identity.BudgetConstructionNoAccessMessageSetting;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.framework.role.RoleTypeService;

public class BudgetConstructionAction
extends KualiTransactionalDocumentActionBase {
    protected static final Logger LOG = Logger.getLogger(BudgetConstructionAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        if (budgetConstructionForm.getBudgetConstructionDocument().isCleanupModeActionForceCheck()) {
            budgetConstructionForm.getBudgetConstructionDocument().setCleanupModeActionForceCheck(Boolean.FALSE);
        }
        ActionForward forward = null;
        try {
            forward = super.execute(mapping, form, request, response);
        }
        catch (AuthorizationException e) {
            forward = mapping.findForward("basic");
            String docId = budgetConstructionForm.getDocId();
            Document doc = null;
            doc = this.getDocumentService().getByDocumentHeaderId(docId);
            if (doc == null) {
                throw new UnknownDocumentIdException("Document no longer exists.  It may have been cancelled before being saved.");
            }
            WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
            if (workflowDocument != doc.getDocumentHeader().getWorkflowDocument()) {
                LOG.warn((Object)"Workflow document changed via canOpen check");
                doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
            }
            budgetConstructionForm.setDocument(doc);
            WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
            budgetConstructionForm.setDocTypeName(workflowDoc.getDocumentTypeName());
            ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDoc);
            budgetConstructionForm.setSecurityNoAccess(true);
            this.setBudgetDocumentNoAccessMessage(budgetConstructionForm);
            budgetConstructionForm.getDocumentActions().put("canClose", Boolean.TRUE);
        }
        if (budgetConstructionForm.getMethodToCall().equals("docHandler") || budgetConstructionForm.getMethodToCall().equals("performAccountPullup") || budgetConstructionForm.getMethodToCall().equals("performAccountPushdown")) {
            if (budgetConstructionForm.getMethodToCall().equals("docHandler")) {
                budgetConstructionForm.setAccountOrgHierLevels(((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).getPushPullLevelList(budgetConstructionForm.getBudgetConstructionDocument(), GlobalVariables.getUserSession().getPerson()));
            }
            if (budgetConstructionForm.isSystemViewOnly()) {
                KNSGlobalVariables.getMessageList().add("message.budget.systemViewOnly", new String[0]);
            }
            if (!budgetConstructionForm.isEditAllowed()) {
                KNSGlobalVariables.getMessageList().add("message.budget.viewOnly", new String[0]);
            }
            if (budgetConstructionForm.isEditAllowed()) {
                if (budgetConstructionForm.isSystemViewOnly()) {
                    KNSGlobalVariables.getMessageList().add("message.budget.viewOnly", new String[0]);
                } else {
                    budgetConstructionForm.getBudgetConstructionDocument().setBudgetableDocument(((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).isBudgetableDocumentNoWagesCheck(budgetConstructionForm.getBudgetConstructionDocument()));
                    if (!budgetConstructionForm.isBudgetableDocument()) {
                        KNSGlobalVariables.getMessageList().add("message.budget.documentNotBudgetable", new String[0]);
                    }
                    KNSGlobalVariables.getMessageList().add("message.budget.editAccess", new String[0]);
                }
                if (!budgetConstructionForm.isSystemViewOnly()) {
                    BudgetConstructionLockStatus bcLockStatus;
                    LockService lockService = (LockService)SpringContext.getBean(LockService.class);
                    HashMap<String, String> primaryKey = new HashMap<String, String>();
                    primaryKey.put("documentNumber", budgetConstructionForm.getDocument().getDocumentNumber());
                    BudgetConstructionHeader budgetConstructionHeader = (BudgetConstructionHeader)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionHeader.class, primaryKey);
                    if (budgetConstructionHeader != null) {
                        bcLockStatus = lockService.lockAccountAndCommit(budgetConstructionHeader, GlobalVariables.getUserSession().getPerson().getPrincipalId());
                        if (bcLockStatus.getLockStatus() != BCConstants.LockStatus.SUCCESS) {
                            if (bcLockStatus.getLockStatus() == BCConstants.LockStatus.BY_OTHER) {
                                Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(bcLockStatus.getAccountLockOwner());
                                String lockerName = principal.getPrincipalName();
                                this.cleanupForLockError(budgetConstructionForm);
                                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.documentLocked", new String[]{lockerName});
                                return forward;
                            }
                            if (bcLockStatus.getLockStatus() == BCConstants.LockStatus.FLOCK_FOUND) {
                                this.cleanupForLockError(budgetConstructionForm);
                                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.fundingLocked", new String[0]);
                                return forward;
                            }
                            this.cleanupForLockError(budgetConstructionForm);
                            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.documentOther", new String[0]);
                            return forward;
                        }
                    } else {
                        throw new BudgetConstructionDocumentAuthorizationException(GlobalVariables.getUserSession().getPerson().getName(), "open", budgetConstructionForm.getDocument().getDocumentHeader().getDocumentNumber(), "(can't find document for locking)", budgetConstructionForm.isPickListMode());
                    }
                    budgetConstructionForm.getBudgetConstructionDocument().setVersionNumber(bcLockStatus.getBudgetConstructionHeader().getVersionNumber());
                    budgetConstructionForm.getBudgetConstructionDocument().setBudgetLockUserIdentifier(bcLockStatus.getBudgetConstructionHeader().getBudgetLockUserIdentifier());
                    if (budgetConstructionForm.isCheckTwoPlugAdjustment() && budgetConstructionForm.getBudgetConstructionDocument().isContainsTwoPlug() && !budgetConstructionForm.getBudgetConstructionDocument().isSalarySettingOnly()) {
                        budgetConstructionForm.setCheckTwoPlugAdjustment(false);
                        this.adjustForSalarySettingChanges(budgetConstructionForm);
                    }
                }
                if (budgetConstructionForm.getBudgetConstructionDocument().getOrganizationLevelCode() != 0) {
                    if (!budgetConstructionForm.getAccountOrgHierLevels().isEmpty()) {
                        budgetConstructionForm.populatePushPullLevelKeyLabels(budgetConstructionForm.getBudgetConstructionDocument(), budgetConstructionForm.getAccountOrgHierLevels(), false);
                    }
                } else {
                    budgetConstructionForm.setPushdownLevelKeyLabels(new ArrayList<BCKeyLabelPair>());
                }
            }
            if (!budgetConstructionForm.getAccountOrgHierLevels().isEmpty()) {
                budgetConstructionForm.populatePushPullLevelKeyLabels(budgetConstructionForm.getBudgetConstructionDocument(), budgetConstructionForm.getAccountOrgHierLevels(), true);
            }
        }
        if (budgetConstructionForm.isClosingDocument()) {
            GlobalVariables.getUserSession().removeObject("BcDocEditStatus");
        }
        return forward;
    }

    protected void setBudgetDocumentNoAccessMessage(BudgetConstructionForm budgetConstructionForm) {
        Role roleInfo = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName("KFS-BC", "Document Viewer");
        KimType typeInfo = KimApiServiceLocator.getKimTypeInfoService().getKimType(roleInfo.getKimTypeId());
        if (StringUtils.isNotBlank((String)typeInfo.getServiceName())) {
            RoleTypeService roleTypeService;
            String svcName = typeInfo.getServiceName();
            String[] svcNameParts = svcName.split("\\{|\\}");
            if (svcNameParts.length == 3) {
                String nameSpaceURI = svcNameParts[1];
                String remoteServiceName = svcNameParts[2];
                roleTypeService = (RoleTypeService)GlobalResourceLoader.getService((QName)new QName(nameSpaceURI, remoteServiceName));
            } else {
                roleTypeService = (RoleTypeService)SpringContext.getService((String)typeInfo.getServiceName());
            }
            if (roleTypeService instanceof BudgetConstructionNoAccessMessageSetting) {
                ((BudgetConstructionNoAccessMessageSetting)roleTypeService).setNoAccessMessage(budgetConstructionForm.getBudgetConstructionDocument(), GlobalVariables.getUserSession().getPerson(), GlobalVariables.getMessageMap());
            } else {
                LOG.warn((Object)String.format("typeInfo.getServiceName() = %s is not an instance of BudgetConstructionNoAccessMessageSetting for role %s/%s", typeInfo.getServiceName(), "KFS-BC", "Document Viewer"));
            }
        } else {
            LOG.warn((Object)String.format("typeInfo.getServiceName() returned a blank service name for role %s/%s", "KFS-BC", "Document Viewer"));
        }
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        this.loadDocument((KualiDocumentFormBase)budgetConstructionForm);
        budgetConstructionForm.setCheckTwoPlugAdjustment(true);
        this.initAuthorization(budgetConstructionForm);
        return mapping.findForward("basic");
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        BudgetConstructionHeader budgetConstructionHeader;
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)kualiDocumentFormBase;
        if (budgetConstructionForm.getDocId() != null) {
            HashMap<String, String> primaryKey = new HashMap<String, String>();
            primaryKey.put("documentNumber", budgetConstructionForm.getDocId());
            budgetConstructionHeader = (BudgetConstructionHeader)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionHeader.class, primaryKey);
            if (budgetConstructionForm.getMethodToCall().equalsIgnoreCase("docHandler")) {
                budgetConstructionForm.setChartOfAccountsCode(budgetConstructionHeader.getChartOfAccountsCode());
                budgetConstructionForm.setAccountNumber(budgetConstructionHeader.getAccountNumber());
                budgetConstructionForm.setSubAccountNumber(budgetConstructionHeader.getSubAccountNumber());
                budgetConstructionForm.setUniversityFiscalYear(budgetConstructionHeader.getUniversityFiscalYear());
                budgetConstructionForm.setPickListMode(Boolean.TRUE);
            }
        } else {
            String chartOfAccountsCode = budgetConstructionForm.getChartOfAccountsCode();
            String accountNumber = budgetConstructionForm.getAccountNumber();
            String subAccountNumber = budgetConstructionForm.getSubAccountNumber();
            Integer universityFiscalYear = budgetConstructionForm.getUniversityFiscalYear();
            budgetConstructionHeader = ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).getByCandidateKey(chartOfAccountsCode, accountNumber, subAccountNumber, universityFiscalYear);
        }
        kualiDocumentFormBase.setDocId(budgetConstructionHeader.getDocumentNumber());
        super.loadDocument(kualiDocumentFormBase);
        BudgetConstructionDocument budgetConstructionDocument = (BudgetConstructionDocument)kualiDocumentFormBase.getDocument();
        budgetConstructionDocument.setBenefitsCalcNeeded(false);
        budgetConstructionDocument.setMonthlyBenefitsCalcNeeded(false);
        budgetConstructionForm.initNewLine(budgetConstructionForm.getNewRevenueLine(), true);
        budgetConstructionForm.initNewLine(budgetConstructionForm.getNewExpenditureLine(), false);
        budgetConstructionForm.populatePBGLLines();
        budgetConstructionForm.initializePersistedRequestAmounts();
    }

    protected void cleanupForLockError(BudgetConstructionForm budgetConstructionForm) {
        budgetConstructionForm.setSecurityNoAccess(true);
        budgetConstructionForm.getDocumentActions().remove("canEdit");
        budgetConstructionForm.getDocumentActions().remove("canSave");
        KNSGlobalVariables.getMessageList().remove((Object)"message.budget.editAccess");
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        BudgetConstructionAuthorizationStatus authorizationStatus = (BudgetConstructionAuthorizationStatus)GlobalVariables.getUserSession().retrieveObject("BcDocEditStatus");
        if (authorizationStatus == null) {
            return;
        }
        formBase.setDocumentActions(authorizationStatus.getDocumentActions());
        formBase.setEditingMode(authorizationStatus.getEditingMode());
    }

    protected void initAuthorization(BudgetConstructionForm budgetConstructionForm) {
        super.populateAuthorizationFields((KualiDocumentFormBase)budgetConstructionForm);
        BudgetConstructionAuthorizationStatus editStatus = new BudgetConstructionAuthorizationStatus();
        editStatus.setDocumentActions(budgetConstructionForm.getDocumentActions());
        editStatus.setEditingMode(budgetConstructionForm.getEditingMode());
        GlobalVariables.getUserSession().addObject("BcDocEditStatus", (Object)editStatus);
    }

    protected void adjustForSalarySettingChanges(BudgetConstructionForm bcForm) {
        BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
        BudgetConstructionDocument bcDoc = (BudgetConstructionDocument)bcForm.getDocument();
        KualiInteger oldRequestAmount = bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal();
        budgetDocumentService.calculateBenefits(bcDoc);
        KualiInteger newRquestAmount = bcForm.getBudgetConstructionDocument().getExpenditureAccountLineAnnualBalanceAmountTotal();
        PendingBudgetConstructionGeneralLedger twoPlugRow = budgetDocumentService.updatePendingBudgetGeneralLedgerPlug(bcDoc, newRquestAmount.subtract(oldRequestAmount));
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object bcDoc;
        BudgetConstructionForm docForm = (BudgetConstructionForm)form;
        if (docForm.getDocumentActions().keySet().contains("canSave")) {
            String question = request.getParameter("questionIndex");
            ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                bcDoc = (BudgetConstructionDocument)docForm.getDocument();
                if (!bcDoc.isBudgetableDocument()) {
                    bcDoc.setCleanupModeActionForceCheck(Boolean.TRUE);
                }
                BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
                budgetDocumentService.saveDocument((BudgetConstructionDocument)((Object)bcDoc));
                docForm.initializePersistedRequestAmounts();
                if (bcDoc.isBenefitsCalcNeeded() || bcDoc.isMonthlyBenefitsCalcNeeded()) {
                    budgetDocumentService.calculateBenefitsIfNeeded((BudgetConstructionDocument)((Object)bcDoc));
                    KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
                    return mapping.findForward("basic");
                }
            }
        }
        if (docForm.isEditAllowed() && !docForm.isSystemViewOnly()) {
            LockService lockService = (LockService)SpringContext.getBean(LockService.class);
            HashMap<String, String> primaryKey = new HashMap<String, String>();
            primaryKey.put("documentNumber", docForm.getDocument().getDocumentNumber());
            BudgetConstructionHeader budgetConstructionHeader = (BudgetConstructionHeader)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionHeader.class, primaryKey);
            if (budgetConstructionHeader != null) {
                bcDoc = lockService.unlockAccount(budgetConstructionHeader);
            }
        }
        docForm.setClosingDocument(Boolean.TRUE);
        if (docForm.isPickListMode()) {
            KNSGlobalVariables.getMessageList().add("message.budget.successfulClose", new String[0]);
            docForm.setPickListClose(true);
            UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
            String docFormKey = docForm.getFormKey();
            ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).purgeDocumentForm(docForm.getDocument().getDocumentNumber(), docFormKey, userSession, request.getRemoteAddr());
            return mapping.findForward("basic");
        }
        if (docForm.getReturnFormKey() == null) {
            return this.returnToSender(request, mapping, (KualiDocumentFormBase)docForm);
        }
        Properties parameters = new Properties();
        parameters.put("methodToCall", "refresh");
        parameters.put("docFormKey", docForm.getReturnFormKey());
        parameters.put("anchor", docForm.getReturnAnchor());
        parameters.put("refreshCaller", "BudgetConstruction");
        String lookupUrl = UrlFactory.parameterizeUrl((String)"/budgetBudgetConstructionSelection.do", (Properties)parameters);
        UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
        String docFormKey = docForm.getFormKey();
        ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).purgeDocumentForm(docForm.getDocument().getDocumentNumber(), docFormKey, userSession, request.getRemoteAddr());
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = (BudgetConstructionDocument)budgetConstructionForm.getDocument();
        BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
        if (!bcDocument.isBudgetableDocument()) {
            bcDocument.setCleanupModeActionForceCheck(Boolean.TRUE);
        }
        budgetDocumentService.saveDocument(bcDocument);
        budgetConstructionForm.initializePersistedRequestAmounts();
        budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
        KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
        budgetConstructionForm.setAnnotation("");
        return mapping.findForward("basic");
    }

    public ActionForward performShowBenefits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument tDoc = tForm.getBudgetConstructionDocument();
        int selectIndex = this.getSelectedLine(request);
        PendingBudgetConstructionGeneralLedger expLine = tDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines().get(selectIndex);
        tForm.registerEditableProperty("methodToCall");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        if (StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            parameters.put("returnAnchor", ((KualiForm)form).getAnchor());
        }
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            tForm.setBalanceInquiryReturnAnchor(((KualiForm)form).getAnchor());
        }
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        parameters.put("businessObjectClassName", "org.kuali.kfs.module.bc.businessobject.RequestBenefits");
        parameters.put("hideReturnLink", "true");
        parameters.put("suppressActions", "true");
        parameters.put("showInitialResults", "true");
        parameters.put("tempListLookupMode", Integer.toString(12));
        parameters.put("universityFiscalYear", expLine.getUniversityFiscalYear().toString());
        parameters.put("chartOfAccountsCode", expLine.getChartOfAccountsCode());
        parameters.put("financialObjectCode", expLine.getFinancialObjectCode());
        parameters.put("accountLineAnnualBalanceAmount", expLine.getAccountLineAnnualBalanceAmount().toString());
        parameters.put("accountNumber", expLine.getAccountNumber());
        parameters.put("readOnlyFields", "universityFiscalYear,chartOfAccountsCode,financialObjectCode,accountLineAnnualBalanceAmount");
        String url = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetTempListLookup.do"), (Properties)parameters);
        this.setupDocumentExit();
        return new ActionForward(url, true);
    }

    public ActionForward performBalanceInquiryForRevenueLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performBalanceInquiry(true, mapping, form, request, response);
    }

    public ActionForward performBalanceInquiryForExpenditureLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performBalanceInquiry(false, mapping, form, request, response);
    }

    public ActionForward performBalanceInquiry(boolean isRevenue, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = (BudgetConstructionDocument)budgetConstructionForm.getDocument();
        budgetConstructionForm.registerEditableProperty("methodToCall");
        PendingBudgetConstructionGeneralLedger pbglLine = isRevenue ? bcDocument.getPendingBudgetConstructionGeneralLedgerRevenueLines().get(this.getSelectedLine(request)) : bcDocument.getPendingBudgetConstructionGeneralLedgerExpenditureLines().get(this.getSelectedLine(request));
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            budgetConstructionForm.setBalanceInquiryReturnAnchor(((KualiForm)form).getAnchor());
        }
        String callerDocFormKey = GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("balanceInquiryReportMenuCallerDocFormKey", callerDocFormKey);
        parameters.put("docFormKey", callerDocFormKey);
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            parameters.put("returnAnchor", ((KualiForm)form).getAnchor());
        }
        if (StringUtils.isNotBlank((String)pbglLine.getChartOfAccountsCode())) {
            parameters.put("chartOfAccountsCode", pbglLine.getChartOfAccountsCode());
        }
        if (StringUtils.isNotBlank((String)pbglLine.getAccountNumber())) {
            parameters.put("accountNumber", pbglLine.getAccountNumber());
        }
        if (StringUtils.isNotBlank((String)pbglLine.getFinancialObjectCode())) {
            parameters.put("financialObjectCode", pbglLine.getFinancialObjectCode());
        }
        if (StringUtils.isNotBlank((String)pbglLine.getSubAccountNumber())) {
            parameters.put("subAccountNumber", pbglLine.getSubAccountNumber());
        }
        if (StringUtils.isNotBlank((String)pbglLine.getFinancialSubObjectCode())) {
            parameters.put("financialSubObjectCode", pbglLine.getFinancialSubObjectCode());
        }
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "balanceInquiryReportMenu.do"), (Properties)parameters);
        this.setupDocumentExit();
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward performMonthlyRevenueBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performMonthlyBudget(true, mapping, form, request, response);
    }

    public ActionForward performMonthlyExpenditureBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performMonthlyBudget(false, mapping, form, request, response);
    }

    public ActionForward performMonthlyBudget(boolean isRevenue, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = (BudgetConstructionDocument)budgetConstructionForm.getDocument();
        PendingBudgetConstructionGeneralLedger pbglLine = isRevenue ? bcDocument.getPendingBudgetConstructionGeneralLedgerRevenueLines().get(this.getSelectedLine(request)) : bcDocument.getPendingBudgetConstructionGeneralLedgerExpenditureLines().get(this.getSelectedLine(request));
        budgetConstructionForm.registerEditableProperty("methodToCall");
        if (budgetConstructionForm.isEditAllowed() && !budgetConstructionForm.isSystemViewOnly()) {
            BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
            if (!isRevenue && bcDocument.isContainsTwoPlug()) {
                if (pbglLine.getLaborObject() != null && pbglLine.getLaborObject().isDetailPositionRequiredIndicator()) {
                    budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.EXPENDITURE, false);
                } else {
                    budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.EXPENDITURE, true);
                }
            } else {
                budgetDocumentService.saveDocumentNoWorkflow(bcDocument);
            }
            budgetConstructionForm.initializePersistedRequestAmounts();
            budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
        }
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "loadExpansionScreen");
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        parameters.put("documentNumber", pbglLine.getDocumentNumber());
        parameters.put("universityFiscalYear", pbglLine.getUniversityFiscalYear().toString());
        parameters.put("chartOfAccountsCode", pbglLine.getChartOfAccountsCode());
        parameters.put("accountNumber", pbglLine.getAccountNumber());
        parameters.put("subAccountNumber", pbglLine.getSubAccountNumber());
        parameters.put("financialObjectCode", pbglLine.getFinancialObjectCode());
        parameters.put("financialSubObjectCode", pbglLine.getFinancialSubObjectCode());
        parameters.put("financialBalanceTypeCode", pbglLine.getFinancialBalanceTypeCode());
        parameters.put("financialObjectTypeCode", pbglLine.getFinancialObjectTypeCode());
        parameters.put("revenue", isRevenue ? "true" : "false");
        parameters.put("mainWindow", budgetConstructionForm.isMainWindow() ? "true" : "false");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            parameters.put("returnAnchor", ((KualiForm)form).getAnchor());
        }
        parameters.put("returnFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetMonthlyBudget.do"), (Properties)parameters);
        this.setupDocumentExit();
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward performSalarySetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = (BudgetConstructionDocument)budgetConstructionForm.getDocument();
        budgetConstructionForm.registerEditableProperty("methodToCall");
        if (budgetConstructionForm.isEditAllowed() && !budgetConstructionForm.isSystemViewOnly()) {
            BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
            budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.EXPENDITURE, false);
            budgetConstructionForm.initializePersistedRequestAmounts(true);
            budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
        }
        PendingBudgetConstructionGeneralLedger pbglLine = bcDocument.getPendingBudgetConstructionGeneralLedgerExpenditureLines().get(this.getSelectedLine(request));
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "loadExpansionScreen");
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        parameters.put("documentNumber", pbglLine.getDocumentNumber());
        parameters.put("universityFiscalYear", pbglLine.getUniversityFiscalYear().toString());
        parameters.put("chartOfAccountsCode", pbglLine.getChartOfAccountsCode());
        parameters.put("accountNumber", pbglLine.getAccountNumber());
        parameters.put("subAccountNumber", pbglLine.getSubAccountNumber());
        parameters.put("financialObjectCode", pbglLine.getFinancialObjectCode());
        parameters.put("financialSubObjectCode", pbglLine.getFinancialSubObjectCode());
        parameters.put("financialBalanceTypeCode", pbglLine.getFinancialBalanceTypeCode());
        parameters.put("financialObjectTypeCode", pbglLine.getFinancialObjectTypeCode());
        parameters.put("mainWindow", budgetConstructionForm.isMainWindow() ? "true" : "false");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            parameters.put("returnAnchor", ((KualiForm)form).getAnchor());
        }
        parameters.put("returnFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetQuickSalarySetting.do"), (Properties)parameters);
        this.setupDocumentExit();
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward insertRevenueLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        PendingBudgetConstructionGeneralLedger line = budgetConstructionForm.getNewRevenueLine();
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddPendingBudgetGeneralLedgerLineEvent("newRevenueLine", budgetConstructionForm.getDocument(), line, true))) {
            this.insertPBGLLine(true, budgetConstructionForm, line);
            budgetConstructionForm.setNewRevenueLine(new PendingBudgetConstructionGeneralLedger());
            budgetConstructionForm.initNewLine(budgetConstructionForm.getNewRevenueLine(), true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward insertExpenditureLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        PendingBudgetConstructionGeneralLedger line = budgetConstructionForm.getNewExpenditureLine();
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddPendingBudgetGeneralLedgerLineEvent("newExpenditureLine", budgetConstructionForm.getDocument(), line, false))) {
            this.insertPBGLLine(false, budgetConstructionForm, line);
            budgetConstructionForm.setNewExpenditureLine(new PendingBudgetConstructionGeneralLedger());
            budgetConstructionForm.initNewLine(budgetConstructionForm.getNewExpenditureLine(), false);
        }
        return mapping.findForward("basic");
    }

    protected void insertPBGLLine(boolean isRevenue, BudgetConstructionForm budgetConstructionForm, PendingBudgetConstructionGeneralLedger line) {
        BudgetConstructionDocument bcDoc = (BudgetConstructionDocument)budgetConstructionForm.getDocument();
        line.setFinancialObjectTypeCode(line.getFinancialObject().getFinancialObjectTypeCode());
        if (StringUtils.isBlank((String)line.getFinancialSubObjectCode())) {
            line.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        }
        boolean isReinstated = false;
        HashMap<String, Object> primaryKey = new HashMap<String, Object>();
        primaryKey.put("documentNumber", line.getDocumentNumber());
        primaryKey.put("universityFiscalYear", line.getUniversityFiscalYear());
        primaryKey.put("chartOfAccountsCode", line.getChartOfAccountsCode());
        primaryKey.put("accountNumber", line.getAccountNumber());
        primaryKey.put("subAccountNumber", line.getSubAccountNumber());
        primaryKey.put("financialBalanceTypeCode", line.getFinancialBalanceTypeCode());
        primaryKey.put("financialObjectTypeCode", line.getFinancialObjectTypeCode());
        primaryKey.put("financialObjectCode", line.getFinancialObjectCode());
        primaryKey.put("financialSubObjectCode", line.getFinancialSubObjectCode());
        PendingBudgetConstructionGeneralLedger dbLine = (PendingBudgetConstructionGeneralLedger)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(PendingBudgetConstructionGeneralLedger.class, primaryKey);
        if (dbLine != null) {
            line = dbLine;
            ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).populatePBGLLine(line);
            isReinstated = true;
        }
        int insertPoint = bcDoc.addPBGLLine(line, isRevenue);
        if (isReinstated) {
            String errorKey = isRevenue ? "document.pendingBudgetConstructionGeneralLedgerRevenueLines[" + insertPoint + "]." + "accountLineAnnualBalanceAmount" : "document.pendingBudgetConstructionGeneralLedgerExpenditureLines[" + insertPoint + "]." + "accountLineAnnualBalanceAmount";
            GlobalVariables.getMessageMap().putError(errorKey, "error.budget.lineReinstated", new String[]{dbLine.getFinancialObjectCode() + "," + dbLine.getFinancialSubObjectCode()});
        }
        if (line.getAccountLineAnnualBalanceAmount() != null && line.getAccountLineAnnualBalanceAmount() != KualiInteger.ZERO) {
            if (isRevenue) {
                bcDoc.setRevenueAccountLineAnnualBalanceAmountTotal(bcDoc.getRevenueAccountLineAnnualBalanceAmountTotal().add(line.getAccountLineAnnualBalanceAmount()));
            } else {
                bcDoc.setExpenditureAccountLineAnnualBalanceAmountTotal(bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal().add(line.getAccountLineAnnualBalanceAmount()));
            }
        }
        if (line.getFinancialBeginningBalanceLineAmount() != null && line.getFinancialBeginningBalanceLineAmount() != KualiInteger.ZERO) {
            if (isRevenue) {
                bcDoc.setRevenueFinancialBeginningBalanceLineAmountTotal(bcDoc.getRevenueFinancialBeginningBalanceLineAmountTotal().add(line.getFinancialBeginningBalanceLineAmount()));
            } else {
                bcDoc.setExpenditureFinancialBeginningBalanceLineAmountTotal(bcDoc.getExpenditureFinancialBeginningBalanceLineAmountTotal().add(line.getFinancialBeginningBalanceLineAmount()));
            }
        }
    }

    public ActionForward deleteRevenueLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument tDoc = tForm.getBudgetConstructionDocument();
        boolean rulePassed = true;
        int deleteIndex = this.getLineToDelete(request);
        PendingBudgetConstructionGeneralLedger revLine = tDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines().get(deleteIndex);
        if (revLine.getPersistedAccountLineAnnualBalanceAmount() == null) {
            rulePassed = true;
        } else {
            String errorPath = "document.pendingBudgetConstructionGeneralLedgerRevenueLines[" + deleteIndex + "]";
            rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new DeletePendingBudgetGeneralLedgerLineEvent(errorPath, (Document)tDoc, revLine, true));
        }
        if (rulePassed) {
            this.deletePBGLLine(true, tForm, deleteIndex, revLine);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteExpenditureLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument tDoc = tForm.getBudgetConstructionDocument();
        boolean rulePassed = true;
        int deleteIndex = this.getLineToDelete(request);
        PendingBudgetConstructionGeneralLedger expLine = tDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines().get(deleteIndex);
        if (expLine.getPersistedAccountLineAnnualBalanceAmount() == null) {
            rulePassed = true;
        } else {
            String errorPath = "document.pendingBudgetConstructionGeneralLedgerExpenditureLines[" + deleteIndex + "]";
            rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new DeletePendingBudgetGeneralLedgerLineEvent(errorPath, (Document)tDoc, expLine, false));
        }
        if (rulePassed) {
            if (expLine.getFinancialObjectCode().equalsIgnoreCase("2PLG")) {
                ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).validateDocument((Document)tDoc);
            }
            this.deletePBGLLine(false, tForm, deleteIndex, expLine);
        }
        return mapping.findForward("basic");
    }

    protected void deletePBGLLine(boolean isRevenue, BudgetConstructionForm budgetConstructionForm, int deleteIndex, PendingBudgetConstructionGeneralLedger line) {
        BudgetConstructionDocument bcDoc = budgetConstructionForm.getBudgetConstructionDocument();
        if (line.getAccountLineAnnualBalanceAmount() != null && line.getAccountLineAnnualBalanceAmount() != KualiInteger.ZERO) {
            if (isRevenue) {
                bcDoc.setRevenueAccountLineAnnualBalanceAmountTotal(bcDoc.getRevenueAccountLineAnnualBalanceAmountTotal().subtract(line.getAccountLineAnnualBalanceAmount()));
            } else {
                bcDoc.setExpenditureAccountLineAnnualBalanceAmountTotal(bcDoc.getExpenditureAccountLineAnnualBalanceAmountTotal().subtract(line.getAccountLineAnnualBalanceAmount()));
            }
        }
        if (line.getFinancialBeginningBalanceLineAmount() != null && line.getFinancialBeginningBalanceLineAmount() != KualiInteger.ZERO) {
            if (isRevenue) {
                bcDoc.setRevenueFinancialBeginningBalanceLineAmountTotal(bcDoc.getRevenueFinancialBeginningBalanceLineAmountTotal().subtract(line.getFinancialBeginningBalanceLineAmount()));
            } else {
                bcDoc.setExpenditureFinancialBeginningBalanceLineAmountTotal(bcDoc.getExpenditureFinancialBeginningBalanceLineAmountTotal().subtract(line.getFinancialBeginningBalanceLineAmount()));
            }
        }
        if (isRevenue) {
            bcDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines().remove(deleteIndex);
        } else {
            if (line.getFinancialObjectCode().equalsIgnoreCase("2PLG")) {
                bcDoc.setContainsTwoPlug(false);
            }
            bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines().remove(deleteIndex);
        }
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetDocumentService budgetDocumentService;
        BudgetConstructionForm budgetConstructionForm = (BudgetConstructionForm)form;
        budgetConstructionForm.setDerivedValuesOnForm(request);
        String refreshCaller = request.getParameter("refreshCaller");
        if (refreshCaller != null && refreshCaller.endsWith("MonthlyBudgetAction")) {
            budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
            budgetDocumentService.calculateBenefitsIfNeeded(budgetConstructionForm.getBudgetConstructionDocument());
        }
        if (refreshCaller != null && refreshCaller.endsWith("QuickSalarySettingAction")) {
            budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
            boolean diffFound = false;
            if (budgetConstructionForm.isEditAllowed() && !budgetConstructionForm.isSystemViewOnly()) {
                BudgetConstructionDocument currentBCDoc = budgetConstructionForm.getBudgetConstructionDocument();
                List<PendingBudgetConstructionGeneralLedger> dbSalarySettingRows = budgetDocumentService.getPBGLSalarySettingRows(currentBCDoc);
                for (PendingBudgetConstructionGeneralLedger dbSalarySettingRow : dbSalarySettingRows) {
                    if (budgetConstructionForm.getPreSalarySettingRows().containsKey(dbSalarySettingRow.getFinancialObjectCode() + dbSalarySettingRow.getFinancialSubObjectCode())) {
                        Long preReqVersionNumber;
                        KualiInteger dbReqAmount = dbSalarySettingRow.getAccountLineAnnualBalanceAmount();
                        KualiInteger preReqAmount = budgetConstructionForm.getPreSalarySettingRows().get(dbSalarySettingRow.getFinancialObjectCode() + dbSalarySettingRow.getFinancialSubObjectCode()).getAccountLineAnnualBalanceAmount();
                        Long dbVersionNumber = dbSalarySettingRow.getVersionNumber();
                        if (dbVersionNumber.compareTo(preReqVersionNumber = budgetConstructionForm.getPreSalarySettingRows().get(dbSalarySettingRow.getFinancialObjectCode() + dbSalarySettingRow.getFinancialSubObjectCode()).getVersionNumber()) == 0 && dbReqAmount.compareTo(preReqAmount) == 0) continue;
                        budgetDocumentService.addOrUpdatePBGLRow(currentBCDoc, dbSalarySettingRow, Boolean.FALSE);
                        if (dbReqAmount.compareTo(preReqAmount) == 0) continue;
                        diffFound = true;
                        continue;
                    }
                    budgetDocumentService.addOrUpdatePBGLRow(currentBCDoc, dbSalarySettingRow, Boolean.FALSE);
                    diffFound = true;
                }
                if (diffFound) {
                    this.adjustForSalarySettingChanges(budgetConstructionForm);
                }
            }
        }
        if (refreshCaller != null && refreshCaller.endsWith("Lookupable")) {
            this.checkAndFixReturnedLookupValues(budgetConstructionForm.getNewRevenueLine(), budgetConstructionForm.getBudgetConstructionDocument());
            this.checkAndFixReturnedLookupValues(budgetConstructionForm.getNewExpenditureLine(), budgetConstructionForm.getBudgetConstructionDocument());
            List<String> REFRESH_FIELDS = Collections.unmodifiableList(Arrays.asList("financialObject", "financialSubObject"));
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)budgetConstructionForm.getNewRevenueLine(), REFRESH_FIELDS);
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)budgetConstructionForm.getNewExpenditureLine(), REFRESH_FIELDS);
        }
        if (budgetConstructionForm.getBalanceInquiryReturnAnchor() != null) {
            budgetConstructionForm.setAnchor(budgetConstructionForm.getBalanceInquiryReturnAnchor());
            budgetConstructionForm.setBalanceInquiryReturnAnchor(null);
        }
        return mapping.findForward("basic");
    }

    protected void checkAndFixReturnedLookupValues(PendingBudgetConstructionGeneralLedger newLine, BudgetConstructionDocument bcDoc) {
        if (!newLine.getUniversityFiscalYear().equals(bcDoc.getUniversityFiscalYear())) {
            newLine.setUniversityFiscalYear(bcDoc.getUniversityFiscalYear());
        }
        if (!newLine.getChartOfAccountsCode().equals(bcDoc.getChartOfAccountsCode())) {
            newLine.setChartOfAccountsCode(bcDoc.getChartOfAccountsCode());
        }
        if (!newLine.getAccountNumber().equals(bcDoc.getAccountNumber())) {
            newLine.setAccountNumber(bcDoc.getAccountNumber());
        }
    }

    public ActionForward showDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        tForm.setHideDetails(false);
        return mapping.findForward("basic");
    }

    public ActionForward hideDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        tForm.setHideDetails(true);
        return mapping.findForward("basic");
    }

    public ActionForward toggleAdjustmentMeasurement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm docForm;
        boolean currentStatus = (docForm = (BudgetConstructionForm)form).isHideAdjustmentMeasurement();
        docForm.setHideAdjustmentMeasurement(!currentStatus);
        return mapping.findForward("basic");
    }

    public ActionForward adjustRevenueLinePercent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm docForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDoc = docForm.getBudgetConstructionDocument();
        PendingBudgetConstructionGeneralLedger revLine = bcDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines().get(this.getSelectedLine(request));
        if (revLine.getAdjustmentAmount() != null) {
            this.adjustRequest(revLine);
            docForm.populatePBGLLines();
        }
        return mapping.findForward("basic");
    }

    public ActionForward adjustExpenditureLinePercent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm docForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDoc = docForm.getBudgetConstructionDocument();
        PendingBudgetConstructionGeneralLedger expLine = bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines().get(this.getSelectedLine(request));
        if (expLine.getAdjustmentAmount() != null) {
            this.adjustRequest(expLine);
            docForm.populatePBGLLines();
        }
        return mapping.findForward("basic");
    }

    public ActionForward adjustAllRevenueLinesPercent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm docForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDoc = docForm.getBudgetConstructionDocument();
        List<PendingBudgetConstructionGeneralLedger> revenueLines = bcDoc.getPendingBudgetConstructionGeneralLedgerRevenueLines();
        KualiDecimal adjustmentAmount = docForm.getRevenueAdjustmentAmount();
        if (adjustmentAmount != null) {
            boolean isEditable = docForm.isEditAllowed() && !docForm.isSystemViewOnly();
            for (PendingBudgetConstructionGeneralLedger revenueLine : revenueLines) {
                if (!isEditable) continue;
                revenueLine.setAdjustmentAmount(adjustmentAmount);
                this.adjustRequest(revenueLine);
            }
            if (isEditable) {
                docForm.populatePBGLLines();
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward adjustAllExpenditureLinesPercent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm docForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDoc = docForm.getBudgetConstructionDocument();
        List<PendingBudgetConstructionGeneralLedger> expenditureLines = bcDoc.getPendingBudgetConstructionGeneralLedgerExpenditureLines();
        KualiDecimal adjustmentAmount = docForm.getExpenditureAdjustmentAmount();
        if (adjustmentAmount != null) {
            boolean isEditable = docForm.isEditAllowed() && !docForm.isSystemViewOnly();
            for (PendingBudgetConstructionGeneralLedger expenditureLine : expenditureLines) {
                boolean isLineEditable = isEditable && (docForm.isBenefitsCalculationDisabled() || expenditureLine.getLaborObject() == null || !expenditureLine.getLaborObject().getFinancialObjectFringeOrSalaryCode().equalsIgnoreCase("F"));
                if (!isLineEditable) continue;
                expenditureLine.setAdjustmentAmount(adjustmentAmount);
                this.adjustRequest(expenditureLine);
            }
            if (isEditable) {
                docForm.populatePBGLLines();
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward performAccountPullup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean prePullReadOnlyAccess;
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        boolean doAllowPullup = false;
        boolean lockNeeded = false;
        BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
        if (!tForm.isEditAllowed() || tForm.isSystemViewOnly()) {
            prePullReadOnlyAccess = true;
            this.loadDocument((KualiDocumentFormBase)tForm);
            this.initAuthorization(tForm);
            if (tForm.getBudgetConstructionDocument().getOrganizationLevelCode() < Integer.parseInt(tForm.getPullupKeyCode())) {
                doAllowPullup = true;
                if (!tForm.isSystemViewOnly()) {
                    lockNeeded = true;
                }
            } else {
                doAllowPullup = false;
                lockNeeded = false;
                if (tForm.getBudgetConstructionDocument().getOrganizationLevelCode() > Integer.parseInt(tForm.getPullupKeyCode())) {
                    GlobalVariables.getMessageMap().putError("GlobalMessages", "error.budget.pullup.document", new String[]{"Document has already been moved above the selected level."});
                }
            }
        } else {
            prePullReadOnlyAccess = false;
            doAllowPullup = true;
        }
        if (lockNeeded || doAllowPullup) {
            HashMap<String, String> primaryKey = new HashMap<String, String>();
            primaryKey.put("documentNumber", tForm.getDocument().getDocumentNumber());
            BudgetConstructionHeader budgetConstructionHeader = (BudgetConstructionHeader)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionHeader.class, primaryKey);
            if (budgetConstructionHeader == null) {
                GlobalVariables.getMessageMap().putError("accountOrgHierLevels*", "error.budget.pullup.document", new String[]{"Fatal, Document not found."});
                return mapping.findForward("basic");
            }
            if (lockNeeded) {
                doAllowPullup = false;
                LockService lockService = (LockService)SpringContext.getBean(LockService.class);
                BudgetConstructionLockStatus bcLockStatus = lockService.lockAccount(budgetConstructionHeader, GlobalVariables.getUserSession().getPerson().getPrincipalId());
                BCConstants.LockStatus lockStatus = bcLockStatus.getLockStatus();
                switch (lockStatus) {
                    case SUCCESS: {
                        doAllowPullup = true;
                        break;
                    }
                    case BY_OTHER: {
                        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(bcLockStatus.getAccountLockOwner());
                        String lockerName = principal.getPrincipalName();
                        GlobalVariables.getMessageMap().putError("accountOrgHierLevels*", "error.budget.pullup.document", new String[]{"Locked by " + lockerName});
                        break;
                    }
                    case FLOCK_FOUND: {
                        GlobalVariables.getMessageMap().putError("accountOrgHierLevels*", "error.budget.pullup.document", new String[]{"Funding lock found."});
                        break;
                    }
                    default: {
                        GlobalVariables.getMessageMap().putError("accountOrgHierLevels*", "error.budget.pullup.document", new String[]{"Optimistic lock or other failure during lock attempt."});
                    }
                }
            }
            if (doAllowPullup) {
                budgetConstructionHeader.setOrganizationLevelCode(Integer.parseInt(tForm.getPullupKeyCode()));
                budgetConstructionHeader.setOrganizationLevelChartOfAccountsCode(tForm.getAccountOrgHierLevels().get(Integer.parseInt(tForm.getPullupKeyCode())).getOrganizationChartOfAccountsCode());
                budgetConstructionHeader.setOrganizationLevelOrganizationCode(tForm.getAccountOrgHierLevels().get(Integer.parseInt(tForm.getPullupKeyCode())).getOrganizationCode());
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)budgetConstructionHeader);
                tForm.getBudgetConstructionDocument().setVersionNumber(budgetConstructionHeader.getVersionNumber());
                tForm.getBudgetConstructionDocument().setOrganizationLevelCode(budgetConstructionHeader.getOrganizationLevelCode());
                tForm.getBudgetConstructionDocument().setOrganizationLevelChartOfAccountsCode(budgetConstructionHeader.getOrganizationLevelChartOfAccountsCode());
                tForm.getBudgetConstructionDocument().setOrganizationLevelOrganizationCode(budgetConstructionHeader.getOrganizationLevelOrganizationCode());
                tForm.getBudgetConstructionDocument().setBudgetLockUserIdentifier(budgetConstructionHeader.getBudgetLockUserIdentifier());
                tForm.getBudgetConstructionDocument().refreshReferenceObject("organizationLevelOrganization");
                this.initAuthorization(tForm);
                if (tForm.isEditAllowed() && !prePullReadOnlyAccess && tForm.isSystemViewOnly()) {
                    tForm.getEditingMode().remove("systemViewOnly");
                }
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward performAccountPushdown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean prePushSystemViewOnly;
        boolean doAllowPushdown = false;
        boolean unlockNeeded = false;
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = tForm.getBudgetConstructionDocument();
        BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
        if (!tForm.isSystemViewOnly()) {
            prePushSystemViewOnly = false;
            if (!this.hasEditPermission(bcDocument, tForm.getPushdownKeyCode(), GlobalVariables.getUserSession().getPerson())) {
                budgetDocumentService.saveDocumentNoWorkflow(bcDocument);
                tForm.initializePersistedRequestAmounts();
                budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
                unlockNeeded = true;
            }
            doAllowPushdown = true;
        } else {
            prePushSystemViewOnly = true;
            this.loadDocument((KualiDocumentFormBase)tForm);
            this.initAuthorization(tForm);
            if (tForm.isEditAllowed()) {
                doAllowPushdown = true;
            } else {
                GlobalVariables.getMessageMap().putError("GlobalMessages", "error.budget.pushdown.document", new String[]{"Full Access Control Lost."});
            }
        }
        if (doAllowPushdown) {
            HashMap<String, String> primaryKey = new HashMap<String, String>();
            primaryKey.put("documentNumber", tForm.getDocument().getDocumentNumber());
            BudgetConstructionHeader budgetConstructionHeader = (BudgetConstructionHeader)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionHeader.class, primaryKey);
            if (budgetConstructionHeader != null) {
                budgetConstructionHeader.setOrganizationLevelCode(Integer.parseInt(tForm.getPushdownKeyCode()));
                if (Integer.parseInt(tForm.getPushdownKeyCode()) == 0) {
                    budgetConstructionHeader.setOrganizationLevelChartOfAccountsCode(null);
                    budgetConstructionHeader.setOrganizationLevelOrganizationCode(null);
                } else {
                    budgetConstructionHeader.setOrganizationLevelChartOfAccountsCode(tForm.getAccountOrgHierLevels().get(Integer.parseInt(tForm.getPushdownKeyCode())).getOrganizationChartOfAccountsCode());
                    budgetConstructionHeader.setOrganizationLevelOrganizationCode(tForm.getAccountOrgHierLevels().get(Integer.parseInt(tForm.getPushdownKeyCode())).getOrganizationCode());
                }
            }
            if (unlockNeeded) {
                LockService lockService = (LockService)SpringContext.getBean(LockService.class);
                lockService.unlockAccount(budgetConstructionHeader);
            } else {
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)budgetConstructionHeader);
            }
            tForm.getBudgetConstructionDocument().setVersionNumber(budgetConstructionHeader.getVersionNumber());
            tForm.getBudgetConstructionDocument().setOrganizationLevelCode(budgetConstructionHeader.getOrganizationLevelCode());
            tForm.getBudgetConstructionDocument().setOrganizationLevelChartOfAccountsCode(budgetConstructionHeader.getOrganizationLevelChartOfAccountsCode());
            tForm.getBudgetConstructionDocument().setOrganizationLevelOrganizationCode(budgetConstructionHeader.getOrganizationLevelOrganizationCode());
            tForm.getBudgetConstructionDocument().setBudgetLockUserIdentifier(budgetConstructionHeader.getBudgetLockUserIdentifier());
            tForm.getBudgetConstructionDocument().refreshReferenceObject("organizationLevelOrganization");
            this.initAuthorization(tForm);
            if (tForm.isEditAllowed() && tForm.isSystemViewOnly() && !prePushSystemViewOnly) {
                tForm.getEditingMode().remove("systemViewOnly");
            }
        }
        return mapping.findForward("basic");
    }

    protected boolean hasEditPermission(BudgetConstructionDocument document, String orgLevelCode, Person user) {
        TransactionalDocumentAuthorizer documentAuthorizer = (TransactionalDocumentAuthorizer)((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)document);
        HashMap<String, String> roleQualifiers = new HashMap<String, String>();
        roleQualifiers.put("organizationLevelCode", orgLevelCode);
        List<BudgetConstructionAccountOrganizationHierarchy> accountOrganizationHierarchy = ((BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class)).retrieveOrBuildAccountOrganizationHierarchy(document.getUniversityFiscalYear(), document.getChartOfAccountsCode(), document.getAccountNumber());
        for (BudgetConstructionAccountOrganizationHierarchy accountOrganization : accountOrganizationHierarchy) {
            if (accountOrganization.getOrganizationLevelCode() != Integer.parseInt(orgLevelCode)) continue;
            roleQualifiers.put("organizationChartOfAccountsCode", accountOrganization.getOrganizationChartOfAccountsCode());
            roleQualifiers.put("organizationCode", accountOrganization.getOrganizationCode());
        }
        return documentAuthorizer.isAuthorizedByTemplate((Object)document, "KR-NS", "Edit Document", user.getPrincipalId(), null, roleQualifiers);
    }

    public ActionForward performReportDump(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = tForm.getBudgetConstructionDocument();
        tForm.registerEditableProperty("methodToCall");
        if (tForm.isEditAllowed() && !tForm.isSystemViewOnly()) {
            BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
            budgetDocumentService.saveDocumentNoWorkflow(bcDocument);
            budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
            tForm.initializePersistedRequestAmounts();
        }
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "loadExpansionScreen");
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        parameters.put("documentNumber", tForm.getDocument().getDocumentNumber());
        parameters.put("universityFiscalYear", tForm.getUniversityFiscalYear().toString());
        parameters.put("chartOfAccountsCode", tForm.getChartOfAccountsCode());
        parameters.put("accountNumber", tForm.getAccountNumber());
        parameters.put("subAccountNumber", tForm.getSubAccountNumber());
        parameters.put("mainWindow", tForm.isMainWindow() ? "true" : "false");
        if (form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getAnchor())) {
            parameters.put("returnAnchor", ((KualiForm)form).getAnchor());
        }
        parameters.put("returnFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetReportRunner.do"), (Properties)parameters);
        this.setupDocumentExit();
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward performPercentChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        GlobalVariables.getMessageMap().putError("GlobalMessages", "error.unimplemented", new String[]{"Percent Change"});
        return mapping.findForward("basic");
    }

    public ActionForward performRevMonthSpread(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performMonthSpread(mapping, form, request, response, true);
    }

    public ActionForward performExpMonthSpread(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performMonthSpread(mapping, form, request, response, false);
    }

    public ActionForward performMonthSpread(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean isRevenue) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = tForm.getBudgetConstructionDocument();
        BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
        if (isRevenue) {
            budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.REVENUE, false);
        } else {
            budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.EXPENDITURE, false);
        }
        tForm.initializePersistedRequestAmounts();
        BudgetConstructionMonthlyBudgetsCreateDeleteService monthlyBudgetService = (BudgetConstructionMonthlyBudgetsCreateDeleteService)SpringContext.getBean(BudgetConstructionMonthlyBudgetsCreateDeleteService.class);
        if (isRevenue) {
            monthlyBudgetService.spreadBudgetConstructionMonthlyBudgetsRevenue(bcDocument.getDocumentNumber(), bcDocument.getUniversityFiscalYear(), bcDocument.getChartOfAccountsCode(), bcDocument.getAccountNumber(), bcDocument.getSubAccountNumber());
        } else if (monthlyBudgetService.spreadBudgetConstructionMonthlyBudgetsExpenditure(bcDocument.getDocumentNumber(), bcDocument.getUniversityFiscalYear(), bcDocument.getChartOfAccountsCode(), bcDocument.getAccountNumber(), bcDocument.getSubAccountNumber())) {
            bcDocument.setMonthlyBenefitsCalcNeeded(true);
        }
        budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
        tForm.populatePBGLLines();
        return mapping.findForward("basic");
    }

    public ActionForward performRevMonthDelete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performMonthDelete(mapping, form, request, response, true);
    }

    public ActionForward performExpMonthDelete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performMonthDelete(mapping, form, request, response, false);
    }

    public ActionForward performMonthDelete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean isRevenue) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = tForm.getBudgetConstructionDocument();
        BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
        if (isRevenue) {
            budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.REVENUE, false);
        } else {
            budgetDocumentService.saveDocumentNoWorkFlow(bcDocument, BCConstants.MonthSpreadDeleteType.EXPENDITURE, false);
        }
        tForm.initializePersistedRequestAmounts();
        BudgetConstructionMonthlyBudgetsCreateDeleteService monthlyBudgetService = (BudgetConstructionMonthlyBudgetsCreateDeleteService)SpringContext.getBean(BudgetConstructionMonthlyBudgetsCreateDeleteService.class);
        if (isRevenue) {
            monthlyBudgetService.deleteBudgetConstructionMonthlyBudgetsRevenue(bcDocument.getDocumentNumber(), bcDocument.getUniversityFiscalYear(), bcDocument.getChartOfAccountsCode(), bcDocument.getAccountNumber(), bcDocument.getSubAccountNumber());
        } else {
            monthlyBudgetService.deleteBudgetConstructionMonthlyBudgetsExpenditure(bcDocument.getDocumentNumber(), bcDocument.getUniversityFiscalYear(), bcDocument.getChartOfAccountsCode(), bcDocument.getAccountNumber(), bcDocument.getSubAccountNumber());
        }
        budgetDocumentService.calculateBenefitsIfNeeded(bcDocument);
        tForm.populatePBGLLines();
        return mapping.findForward("basic");
    }

    public ActionForward performCalculateBenefits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetConstructionForm tForm = (BudgetConstructionForm)form;
        BudgetConstructionDocument bcDocument = (BudgetConstructionDocument)tForm.getDocument();
        if (!tForm.isBenefitsCalculationDisabled() && !bcDocument.isSalarySettingOnly()) {
            BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
            budgetDocumentService.saveDocumentNoWorkflow(bcDocument);
            tForm.initializePersistedRequestAmounts();
            budgetDocumentService.calculateBenefits(bcDocument);
        }
        return mapping.findForward("basic");
    }

    protected void adjustRequest(PendingBudgetConstructionGeneralLedger pbglLine) {
        KualiInteger baseAmount = pbglLine.getFinancialBeginningBalanceLineAmount();
        if (baseAmount.isNonZero()) {
            KualiDecimal percent = pbglLine.getAdjustmentAmount();
            BigDecimal adjustedAmount = baseAmount.multiply(percent).divide(KFSConstants.ONE_HUNDRED);
            KualiInteger requestAmount = new KualiInteger(adjustedAmount).add(baseAmount);
            pbglLine.setAccountLineAnnualBalanceAmount(requestAmount);
        }
    }
}

