/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service;

import java.util.HashMap;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.document.service.BudgetOrganizationTreeService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class BudgetOrganizationTreeServiceTest
extends KualiTestBase {
    private BudgetOrganizationTreeService budgetOrganizationTreeService;
    private BusinessObjectService businessObjectService;
    private String principalId = "1111111111";
    private String chartOfAccountsCode = "UA";
    private String organizationCode = "UA";

    private boolean runTests() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.budgetOrganizationTreeService = (BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    @ConfigureContext(shouldCommitTransactions=true)
    public void testBuildPullupSql() throws Exception {
        if (!this.runTests()) {
            return;
        }
        this.budgetOrganizationTreeService.buildPullupSql(this.principalId, this.chartOfAccountsCode, this.organizationCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("principalId", this.principalId);
        map.put("chartOfAccountsCode", this.chartOfAccountsCode);
        map.put("organizationCode", this.organizationCode);
        BudgetConstructionPullup bcPullup = (BudgetConstructionPullup)this.businessObjectService.findByPrimaryKey(BudgetConstructionPullup.class, map);
        BudgetOrganizationTreeServiceTest.assertTrue((boolean)bcPullup.getChartOfAccountsCode().equalsIgnoreCase(this.chartOfAccountsCode));
        BudgetOrganizationTreeServiceTest.assertTrue((boolean)bcPullup.getOrganizationCode().equalsIgnoreCase(this.organizationCode));
        BudgetOrganizationTreeServiceTest.assertTrue((boolean)bcPullup.getPrincipalId().equalsIgnoreCase(this.principalId));
        this.budgetOrganizationTreeService.cleanPullup(this.principalId);
        bcPullup = (BudgetConstructionPullup)this.businessObjectService.findByPrimaryKey(BudgetConstructionPullup.class, map);
        BudgetOrganizationTreeServiceTest.assertTrue((bcPullup == null ? 1 : 0) != 0);
    }
}

