/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionProcessorService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BudgetConstructionProcessorServiceImpl
implements BudgetConstructionProcessorService {
    private static final Logger LOG = Logger.getLogger(BudgetConstructionProcessorServiceImpl.class);
    protected OrganizationService organizationService;

    @Override
    public List<Organization> getProcessorOrgs(Person person) {
        ArrayList<Organization> processorOrgs = new ArrayList<Organization>();
        HashMap qualification = new HashMap();
        List allQualifications = this.getRoleService().getNestedRoleQualifersForPrincipalByNamespaceAndRolename(person.getPrincipalId(), "KFS-BC", "Processor", qualification);
        for (Map attributeSet : allQualifications) {
            Organization org;
            String chartOfAccountsCode = (String)attributeSet.get("chartOfAccountsCode");
            String organizationCode = (String)attributeSet.get("organizationCode");
            if (!StringUtils.isNotBlank((String)chartOfAccountsCode) || !StringUtils.isNotBlank((String)organizationCode) || (org = this.organizationService.getByPrimaryId(chartOfAccountsCode, organizationCode)) == null || processorOrgs.contains(org)) continue;
            processorOrgs.add(org);
        }
        return processorOrgs;
    }

    @Override
    public boolean isOrgProcessor(String chartOfAccountsCode, String organizationCode, Person person) {
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("chartOfAccountsCode", chartOfAccountsCode);
        qualification.put("organizationCode", organizationCode);
        return this.getRoleService().principalHasRole(person.getPrincipalId(), this.getBudgetProcessorRoleIds(), qualification);
    }

    @Override
    public boolean isOrgProcessor(Organization organization, Person person) {
        try {
            return this.isOrgProcessor(organization.getChartOfAccountsCode(), organization.getOrganizationCode(), person);
        }
        catch (Exception e) {
            String errorMessage = String.format("Fail to determine if %s is an approver for %s. ", person, organization);
            LOG.info((Object)errorMessage, (Throwable)e);
            return false;
        }
    }

    protected List<String> getBudgetProcessorRoleIds() {
        return Collections.singletonList(this.getRoleService().getRoleIdByNamespaceCodeAndName("KFS-BC", "Processor"));
    }

    protected RoleService getRoleService() {
        return KimApiServiceLocator.getRoleService();
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }
}

