/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountSummary;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgAccountSummaryReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgAccountSummaryReportTotal;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionAccountSummaryReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.kfs.module.bc.util.BudgetConstructionUtils;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionAccountSummaryReportServiceImpl
implements BudgetConstructionAccountSummaryReportService {
    protected BudgetConstructionAccountSummaryReportDao budgetConstructionAccountSummaryReportDao;
    protected ConfigurationService kualiConfigurationService;
    protected BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper;
    protected boolean trExist = false;

    @Override
    public void updateReportsAccountSummaryTable(String principalName) {
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        String revenueINList = BudgetConstructionUtils.getRevenueINList();
        this.budgetConstructionAccountSummaryReportDao.cleanReportsAccountSummaryTable(principalName);
        this.budgetConstructionAccountSummaryReportDao.updateReportsAccountSummaryTable(principalName, revenueINList, expenditureINList);
    }

    @Override
    public void updateReportsAccountSummaryTableWithConsolidation(String principalName) {
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        String revenueINList = BudgetConstructionUtils.getRevenueINList();
        this.budgetConstructionAccountSummaryReportDao.cleanReportsAccountSummaryTable(principalName);
        this.budgetConstructionAccountSummaryReportDao.updateReportsAccountSummaryTableWithConsolidation(principalName, revenueINList, expenditureINList);
    }

    @Override
    public void updateReportsAccountSummaryTable(String principalName, boolean consolidated) {
        if (consolidated) {
            this.updateReportsAccountSummaryTableWithConsolidation(principalName);
        } else {
            this.updateReportsAccountSummaryTable(principalName);
        }
    }

    public void setBudgetConstructionAccountSummaryReportDao(BudgetConstructionAccountSummaryReportDao budgetConstructionAccountSummaryReportDao) {
        this.budgetConstructionAccountSummaryReportDao = budgetConstructionAccountSummaryReportDao;
    }

    @Override
    public Collection<BudgetConstructionOrgAccountSummaryReport> buildReports(Integer universityFiscalYear, String principalName, boolean consolidated) {
        ArrayList<BudgetConstructionOrgAccountSummaryReport> reportSet = new ArrayList<BudgetConstructionOrgAccountSummaryReport>();
        Collection accountSummaryList = this.budgetConstructionReportsServiceHelper.getDataForBuildingReports(BudgetConstructionAccountSummary.class, principalName, this.buildOrderByList());
        List totalList = BudgetConstructionReportHelper.deleteDuplicated((List)accountSummaryList, this.fieldsForTotal());
        List orgAccountSummaryReportTotalList = this.calculateTotal((List)accountSummaryList, totalList);
        for (BudgetConstructionAccountSummary accountSummaryEntry : accountSummaryList) {
            BudgetConstructionOrgAccountSummaryReport orgAccountSummaryReportEntry = new BudgetConstructionOrgAccountSummaryReport();
            this.buildReportsHeader(universityFiscalYear, orgAccountSummaryReportEntry, accountSummaryEntry, consolidated);
            this.buildReportsBody(orgAccountSummaryReportEntry, accountSummaryEntry);
            this.buildReportsTotal(orgAccountSummaryReportEntry, accountSummaryEntry, orgAccountSummaryReportTotalList);
            reportSet.add(orgAccountSummaryReportEntry);
        }
        return reportSet;
    }

    protected void buildReportsHeader(Integer universityFiscalYear, BudgetConstructionOrgAccountSummaryReport orgAccountSummaryReportEntry, BudgetConstructionAccountSummary accountSummary, boolean consolidated) {
        String orgChartDesc = accountSummary.getOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        String chartDesc = accountSummary.getChartOfAccounts().getFinChartOfAccountDescription();
        String orgName = accountSummary.getOrganization().getOrganizationName();
        String reportChartDesc = accountSummary.getChartOfAccounts().getReportsToChartOfAccounts().getFinChartOfAccountDescription();
        String subFundGroupName = accountSummary.getFundGroup().getName();
        String subFundGroupDes = accountSummary.getSubFundGroup().getSubFundGroupDescription();
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgAccountSummaryReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgAccountSummaryReportEntry.setOrgChartOfAccountsCode(accountSummary.getOrganizationChartOfAccountsCode());
        if (orgChartDesc == null) {
            orgAccountSummaryReportEntry.setOrgChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgAccountSummaryReportEntry.setOrgChartOfAccountDescription(orgChartDesc);
        }
        orgAccountSummaryReportEntry.setOrganizationCode(accountSummary.getOrganizationCode());
        if (orgName == null) {
            orgAccountSummaryReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgAccountSummaryReportEntry.setOrganizationName(orgName);
        }
        orgAccountSummaryReportEntry.setChartOfAccountsCode(accountSummary.getChartOfAccountsCode());
        if (chartDesc == null) {
            orgAccountSummaryReportEntry.setChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgAccountSummaryReportEntry.setChartOfAccountDescription(chartDesc);
        }
        orgAccountSummaryReportEntry.setFundGroupCode(accountSummary.getFundGroupCode());
        if (subFundGroupName == null) {
            orgAccountSummaryReportEntry.setFundGroupName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingFundGroupName"));
        } else {
            orgAccountSummaryReportEntry.setFundGroupName(subFundGroupName);
        }
        orgAccountSummaryReportEntry.setSubFundGroupCode(accountSummary.getSubFundGroupCode());
        if (subFundGroupName == null) {
            orgAccountSummaryReportEntry.setSubFundGroupDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubFundGroupDescription"));
        } else {
            orgAccountSummaryReportEntry.setSubFundGroupDescription(subFundGroupDes);
        }
        Integer prevPrevFiscalyear = prevFiscalyear - 1;
        orgAccountSummaryReportEntry.setBaseFy(prevPrevFiscalyear.toString() + "-" + prevFiscalyear.toString().substring(2, 4));
        orgAccountSummaryReportEntry.setReqFy(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgAccountSummaryReportEntry.setHeader1(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.accountSub"));
        orgAccountSummaryReportEntry.setHeader2(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.accountSubName"));
        orgAccountSummaryReportEntry.setHeader3(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.baseAmount"));
        orgAccountSummaryReportEntry.setHeader4(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.reqAmount"));
        orgAccountSummaryReportEntry.setHeader5(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.change"));
        orgAccountSummaryReportEntry.setHeader6(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.change"));
        if (consolidated) {
            orgAccountSummaryReportEntry.setConsHdr("Consolidated");
        } else {
            orgAccountSummaryReportEntry.setConsHdr("");
        }
    }

    protected void buildReportsBody(BudgetConstructionOrgAccountSummaryReport orgAccountSummaryReportEntry, BudgetConstructionAccountSummary accountSummary) {
        orgAccountSummaryReportEntry.setAccountNumber(accountSummary.getAccountNumber());
        orgAccountSummaryReportEntry.setSubAccountNumber(accountSummary.getSubAccountNumber());
        if (accountSummary.getSubAccountNumber().equals(KFSConstants.getDashSubAccountNumber())) {
            if (accountSummary.getAccount().getAccountName() == null) {
                orgAccountSummaryReportEntry.setAccountNameAndSubAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingAccountDescription"));
            } else {
                orgAccountSummaryReportEntry.setAccountNameAndSubAccountName(accountSummary.getAccount().getAccountName());
            }
        } else {
            try {
                if (accountSummary.getSubAccount().getSubAccountName() == null) {
                    orgAccountSummaryReportEntry.setAccountNameAndSubAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubAccountDescription"));
                } else {
                    orgAccountSummaryReportEntry.setAccountNameAndSubAccountName(accountSummary.getSubAccount().getSubAccountName());
                }
            }
            catch (PersistenceBrokerException e) {
                orgAccountSummaryReportEntry.setAccountNameAndSubAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubAccountDescription"));
            }
        }
        if (accountSummary.getIncomeExpenseCode().equals("A")) {
            orgAccountSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescRevenue"));
        } else if (accountSummary.getIncomeExpenseCode().equals("E")) {
            orgAccountSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpGross"));
        } else if (accountSummary.getIncomeExpenseCode().equals("T")) {
            this.trExist = true;
            orgAccountSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescTrnfrIn"));
        } else if (this.trExist) {
            this.trExist = false;
            orgAccountSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpNetTrnfr"));
        } else {
            orgAccountSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpenditure"));
        }
        KualiInteger beginingBalanceLineAmt = KualiInteger.ZERO;
        KualiInteger accountLineAnnualBalAmt = KualiInteger.ZERO;
        if (accountSummary.getFinancialBeginningBalanceLineAmount() != null) {
            beginingBalanceLineAmt = accountSummary.getFinancialBeginningBalanceLineAmount();
        }
        if (accountSummary.getFinancialBeginningBalanceLineAmount() != null) {
            accountLineAnnualBalAmt = accountSummary.getAccountLineAnnualBalanceAmount();
        }
        orgAccountSummaryReportEntry.setBaseAmount(beginingBalanceLineAmt);
        orgAccountSummaryReportEntry.setReqAmount(accountLineAnnualBalAmt);
        orgAccountSummaryReportEntry.setAmountChange(accountLineAnnualBalAmt.subtract(beginingBalanceLineAmt));
        orgAccountSummaryReportEntry.setPercentChange(BudgetConstructionReportHelper.calculatePercent(orgAccountSummaryReportEntry.getAmountChange(), beginingBalanceLineAmt));
    }

    protected void buildReportsTotal(BudgetConstructionOrgAccountSummaryReport orgAccountSummaryReportEntry, BudgetConstructionAccountSummary accountSummary, List reportTotalList) {
        for (BudgetConstructionOrgAccountSummaryReportTotal bcasTotalEntry : reportTotalList) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)accountSummary, (BusinessObject)bcasTotalEntry.getBcas(), this.fieldsForTotal())) continue;
            BigDecimal percentChange = BigDecimal.ZERO;
            orgAccountSummaryReportEntry.setTotalRevenueBaseAmount(bcasTotalEntry.getTotalRevenueBaseAmount());
            orgAccountSummaryReportEntry.setTotalGrossBaseAmount(bcasTotalEntry.getTotalGrossBaseAmount());
            orgAccountSummaryReportEntry.setTotalTransferInBaseAmount(bcasTotalEntry.getTotalTransferInBaseAmount());
            orgAccountSummaryReportEntry.setTotalNetTransferBaseAmount(bcasTotalEntry.getTotalNetTransferBaseAmount());
            orgAccountSummaryReportEntry.setTotalRevenueReqAmount(bcasTotalEntry.getTotalRevenueReqAmount());
            orgAccountSummaryReportEntry.setTotalGrossReqAmount(bcasTotalEntry.getTotalGrossReqAmount());
            orgAccountSummaryReportEntry.setTotalTransferInReqAmount(bcasTotalEntry.getTotalTransferInReqAmount());
            orgAccountSummaryReportEntry.setTotalNetTransferReqAmount(bcasTotalEntry.getTotalNetTransferReqAmount());
            orgAccountSummaryReportEntry.setTotalRevenueAmountChange(orgAccountSummaryReportEntry.getTotalRevenueReqAmount().subtract(orgAccountSummaryReportEntry.getTotalRevenueBaseAmount()));
            percentChange = BudgetConstructionReportHelper.calculatePercent(orgAccountSummaryReportEntry.getTotalRevenueAmountChange(), orgAccountSummaryReportEntry.getTotalRevenueBaseAmount());
            orgAccountSummaryReportEntry.setTotalRevenuePercentChange(percentChange);
            orgAccountSummaryReportEntry.setTotalGrossAmountChange(orgAccountSummaryReportEntry.getTotalGrossReqAmount().subtract(orgAccountSummaryReportEntry.getTotalGrossBaseAmount()));
            percentChange = BudgetConstructionReportHelper.calculatePercent(orgAccountSummaryReportEntry.getTotalGrossAmountChange(), orgAccountSummaryReportEntry.getTotalGrossBaseAmount());
            orgAccountSummaryReportEntry.setTotalGrossPercentChange(percentChange);
            orgAccountSummaryReportEntry.setTotalTransferAmountChange(orgAccountSummaryReportEntry.getTotalTransferInReqAmount().subtract(orgAccountSummaryReportEntry.getTotalTransferInBaseAmount()));
            percentChange = BudgetConstructionReportHelper.calculatePercent(orgAccountSummaryReportEntry.getTotalTransferAmountChange(), orgAccountSummaryReportEntry.getTotalTransferInBaseAmount());
            orgAccountSummaryReportEntry.setTotalTransferInPercentChange(percentChange);
            orgAccountSummaryReportEntry.setTotalNetTransferAmountChange(orgAccountSummaryReportEntry.getTotalNetTransferReqAmount().subtract(orgAccountSummaryReportEntry.getTotalNetTransferBaseAmount()));
            percentChange = BudgetConstructionReportHelper.calculatePercent(orgAccountSummaryReportEntry.getTotalNetTransferAmountChange(), orgAccountSummaryReportEntry.getTotalNetTransferBaseAmount());
            orgAccountSummaryReportEntry.setTotalNetTransferPercentChange(percentChange);
            orgAccountSummaryReportEntry.setRevExpDifferenceBaseAmount(orgAccountSummaryReportEntry.getTotalRevenueBaseAmount().subtract(orgAccountSummaryReportEntry.getTotalNetTransferBaseAmount()));
            orgAccountSummaryReportEntry.setRevExpDifferenceReqAmount(orgAccountSummaryReportEntry.getTotalRevenueReqAmount().subtract(orgAccountSummaryReportEntry.getTotalNetTransferReqAmount()));
            orgAccountSummaryReportEntry.setRevExpDifferenceAmountChange(orgAccountSummaryReportEntry.getRevExpDifferenceReqAmount().subtract(orgAccountSummaryReportEntry.getRevExpDifferenceBaseAmount()));
            percentChange = BudgetConstructionReportHelper.calculatePercent(orgAccountSummaryReportEntry.getRevExpDifferenceAmountChange(), orgAccountSummaryReportEntry.getRevExpDifferenceBaseAmount());
            orgAccountSummaryReportEntry.setRevExpDifferencePercentChange(percentChange);
        }
    }

    protected List calculateTotal(List bcasList, List simpleList) {
        KualiInteger totalRevenueBaseAmount = KualiInteger.ZERO;
        KualiInteger totalGrossBaseAmount = KualiInteger.ZERO;
        KualiInteger totalTransferInBaseAmount = KualiInteger.ZERO;
        KualiInteger totalNetTransferBaseAmount = KualiInteger.ZERO;
        KualiInteger totalRevenueReqAmount = KualiInteger.ZERO;
        KualiInteger totalGrossReqAmount = KualiInteger.ZERO;
        KualiInteger totalTransferInReqAmount = KualiInteger.ZERO;
        KualiInteger totalNetTransferReqAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgAccountSummaryReportTotal> returnList = new ArrayList<BudgetConstructionOrgAccountSummaryReportTotal>();
        Iterator simpleListIterator = simpleList.iterator();
        boolean prev = false;
        while (simpleListIterator.hasNext()) {
            BudgetConstructionAccountSummary simpleBcasEntry = (BudgetConstructionAccountSummary)((Object)simpleListIterator.next());
            for (BudgetConstructionAccountSummary bcasListEntry : bcasList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcasEntry, (BusinessObject)bcasListEntry, this.fieldsForTotal())) continue;
                if (bcasListEntry.getIncomeExpenseCode().equals("A")) {
                    prev = false;
                    totalRevenueBaseAmount = totalRevenueBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    totalRevenueReqAmount = totalRevenueReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (bcasListEntry.getIncomeExpenseCode().equals("E")) {
                    prev = false;
                    totalGrossBaseAmount = totalGrossBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    totalGrossReqAmount = totalGrossReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (bcasListEntry.getIncomeExpenseCode().equals("T")) {
                    prev = true;
                    totalTransferInBaseAmount = totalTransferInBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    totalTransferInReqAmount = totalTransferInReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (!bcasListEntry.getIncomeExpenseCode().equals("X")) continue;
                totalNetTransferBaseAmount = totalNetTransferBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                totalNetTransferReqAmount = totalNetTransferReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                if (prev) continue;
                prev = false;
                totalGrossBaseAmount = totalGrossBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                totalGrossReqAmount = totalGrossReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
            }
            BudgetConstructionOrgAccountSummaryReportTotal bcoasrTotal = new BudgetConstructionOrgAccountSummaryReportTotal();
            bcoasrTotal.setBcas(simpleBcasEntry);
            bcoasrTotal.setTotalGrossBaseAmount(totalGrossBaseAmount);
            bcoasrTotal.setTotalGrossReqAmount(totalGrossReqAmount);
            bcoasrTotal.setTotalNetTransferBaseAmount(totalNetTransferBaseAmount);
            bcoasrTotal.setTotalNetTransferReqAmount(totalNetTransferReqAmount);
            bcoasrTotal.setTotalRevenueBaseAmount(totalRevenueBaseAmount);
            bcoasrTotal.setTotalRevenueReqAmount(totalRevenueReqAmount);
            bcoasrTotal.setTotalTransferInBaseAmount(totalTransferInBaseAmount);
            bcoasrTotal.setTotalTransferInReqAmount(totalTransferInReqAmount);
            returnList.add(bcoasrTotal);
            totalGrossBaseAmount = KualiInteger.ZERO;
            totalGrossReqAmount = KualiInteger.ZERO;
            totalNetTransferBaseAmount = KualiInteger.ZERO;
            totalNetTransferReqAmount = KualiInteger.ZERO;
            totalRevenueBaseAmount = KualiInteger.ZERO;
            totalRevenueReqAmount = KualiInteger.ZERO;
            totalTransferInBaseAmount = KualiInteger.ZERO;
            totalTransferInReqAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    protected List<String> fieldsForTotal() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("organizationChartOfAccountsCode");
        fieldList.add("organizationCode");
        fieldList.add("chartOfAccountsCode");
        fieldList.add("subFundGroupCode");
        return fieldList;
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("organizationChartOfAccountsCode");
        returnList.add("organizationCode");
        returnList.add("chartOfAccountsCode");
        returnList.add("subFundSortCode");
        returnList.add("fundGroupCode");
        returnList.add("subFundGroupCode");
        returnList.add("accountNumber");
        returnList.add("subAccountNumber");
        returnList.add("incomeExpenseCode");
        return returnList;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBudgetConstructionReportsServiceHelper(BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper) {
        this.budgetConstructionReportsServiceHelper = budgetConstructionReportsServiceHelper;
    }
}

