/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.batch.dataaccess.impl;

import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.batch.dataaccess.GeneralLedgerBudgetLoadDao;
import org.kuali.kfs.module.bc.batch.dataaccess.impl.BudgetConstructionBatchHelperDaoOjb;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionMonthly;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class GeneralLedgerBudgetLoadDaoOjb
extends BudgetConstructionBatchHelperDaoOjb
implements GeneralLedgerBudgetLoadDao {
    private static Logger LOG = Logger.getLogger(GeneralLedgerBudgetLoadDaoOjb.class);

    @Override
    public void loadGeneralLedgerFromBudget(Integer fiscalYear, Date currentSqlDate, String financialSystemOriginationCode) {
        DaoGlobalVariables daoGlobalVariables = new DaoGlobalVariables(fiscalYear, currentSqlDate, financialSystemOriginationCode);
        DiagnosticCounters diagnosticCounters = new DiagnosticCounters();
        this.openAllAccountingPeriods(fiscalYear);
        this.loadPendingBudgetConstructionGeneralLedger(daoGlobalVariables, diagnosticCounters);
        this.loadBudgetConstructionMonthlyBudget(daoGlobalVariables, diagnosticCounters);
        diagnosticCounters.writeDiagnosticCounters();
    }

    protected HashMap<String, Integer> entrySequenceNumber(Integer requestYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)requestYear);
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(BudgetConstructionHeader.class, criteriaID);
        queryID.setAttributes(new String[]{"documentNumber"});
        HashMap<String, Integer> nextEntrySequenceNumber = new HashMap<String, Integer>(this.hashCapacity(queryID));
        Iterator documentNumbersToLoad = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (documentNumbersToLoad.hasNext()) {
            Object[] resultRow = (Object[])documentNumbersToLoad.next();
            nextEntrySequenceNumber.put((String)resultRow[0], new Integer(0));
        }
        return nextEntrySequenceNumber;
    }

    protected GeneralLedgerPendingEntry getNewPendingEntryWithDefaults(DaoGlobalVariables daoGlobalVariables) {
        GeneralLedgerPendingEntry newRow = new GeneralLedgerPendingEntry();
        newRow.setUniversityFiscalYear(daoGlobalVariables.getRequestYear());
        newRow.setTransactionLedgerEntryDescription("Beginning Budget Load");
        newRow.setFinancialDocumentTypeCode("BCBB");
        newRow.setFinancialDocumentApprovedCode("A");
        newRow.setTransactionDate(daoGlobalVariables.getTransactionDate());
        newRow.setTransactionEntryOffsetIndicator(false);
        newRow.setFinancialSystemOriginationCode(daoGlobalVariables.getFinancialSystemOriginationcode());
        newRow.setOrganizationDocumentNumber(null);
        newRow.setProjectCode(null);
        newRow.setOrganizationReferenceId(null);
        newRow.setReferenceFinancialDocumentTypeCode(null);
        newRow.setReferenceOriginationCode(null);
        newRow.setReferenceFinancialDocumentNumber(null);
        newRow.setFinancialDocumentReversalDate(null);
        newRow.setTransactionEncumbranceUpdateCode(null);
        newRow.setAcctSufficientFundsFinObjCd(null);
        newRow.setTransactionDebitCreditCode(null);
        newRow.setTransactionEntryProcessedTs(null);
        return newRow;
    }

    protected void loadBudgetConstructionMonthlyBudget(DaoGlobalVariables daoGlobalVariables, DiagnosticCounters diagnosticCounters) {
        QueryByCriteria queryID = this.queryForBudgetConstructionMonthly(daoGlobalVariables.getRequestYear());
        Iterator monthlyBudgetRows = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (monthlyBudgetRows.hasNext()) {
            BudgetConstructionMonthly monthlyBudgetIn = (BudgetConstructionMonthly)((Object)monthlyBudgetRows.next());
            diagnosticCounters.increaseBudgetConstructionMonthlyBudgetRead();
            if (daoGlobalVariables.shouldThisAccountLoad(monthlyBudgetIn.getAccountNumber() + monthlyBudgetIn.getChartOfAccountsCode())) {
                GeneralLedgerPendingEntry newRow = this.getNewPendingEntryWithDefaults(daoGlobalVariables);
                this.writeGeneralLedgerPendingEntryFromMonthly(newRow, monthlyBudgetIn, daoGlobalVariables, diagnosticCounters);
                continue;
            }
            diagnosticCounters.increaseBudgetConstructionMonthlyBudgetSkipped();
        }
    }

    protected void loadPendingBudgetConstructionGeneralLedger(DaoGlobalVariables daoGlobalVariables, DiagnosticCounters diagnosticCounters) {
        QueryByCriteria queryID = this.queryForPendingBudgetConstructionGeneralLedger(daoGlobalVariables.getRequestYear());
        Iterator pbglRows = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        while (pbglRows.hasNext()) {
            PendingBudgetConstructionGeneralLedger pbglIn = (PendingBudgetConstructionGeneralLedger)((Object)pbglRows.next());
            diagnosticCounters.increaseBudgetConstructionPendingGeneralLedgerRead();
            if (daoGlobalVariables.shouldThisAccountLoad(pbglIn.getAccountNumber() + pbglIn.getChartOfAccountsCode())) {
                GeneralLedgerPendingEntry newRow = this.getNewPendingEntryWithDefaults(daoGlobalVariables);
                this.writeGeneralLedgerPendingEntryFromAnnual(newRow, pbglIn, daoGlobalVariables, diagnosticCounters);
                continue;
            }
            diagnosticCounters.increaseBudgetConstructionPendingGeneralLedgerSkipped();
        }
    }

    protected QueryByCriteria queryForBudgetConstructionMonthly(Integer fiscalYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        Criteria orCriteriaID = new Criteria();
        Iterator<String[]> monthlyPeriods = BCConstants.BC_MONTHLY_AMOUNTS.iterator();
        while (monthlyPeriods.hasNext()) {
            String monthlyAmountName = monthlyPeriods.next()[0];
            Criteria amountCriteria = new Criteria();
            amountCriteria.addNotEqualTo((Object)monthlyAmountName, (Object)new KualiInteger(0L));
            orCriteriaID.addOrCriteria(amountCriteria);
        }
        criteriaID.addAndCriteria(orCriteriaID);
        QueryByCriteria queryID = new QueryByCriteria(BudgetConstructionMonthly.class, criteriaID);
        return queryID;
    }

    protected QueryByCriteria queryForPendingBudgetConstructionGeneralLedger(Integer fiscalYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        criteriaID.addNotEqualTo((Object)"accountLineAnnualBalanceAmount", (Object)new KualiInteger(0L));
        QueryByCriteria queryID = new QueryByCriteria(PendingBudgetConstructionGeneralLedger.class, criteriaID);
        return queryID;
    }

    protected void writeGeneralLedgerPendingEntryFromAnnual(GeneralLedgerPendingEntry newRow, PendingBudgetConstructionGeneralLedger pbgl, DaoGlobalVariables daoGlobalVariables, DiagnosticCounters diagnosticCounters) {
        String incomingDocumentNumber = pbgl.getDocumentNumber();
        newRow.setFinancialBalanceTypeCode("BB");
        newRow.setUniversityFiscalPeriodCode("BB");
        newRow.setTransactionLedgerEntrySequenceNumber(daoGlobalVariables.getNextSequenceNumber(incomingDocumentNumber));
        newRow.setDocumentNumber(incomingDocumentNumber);
        newRow.setChartOfAccountsCode(pbgl.getChartOfAccountsCode());
        newRow.setAccountNumber(pbgl.getAccountNumber());
        newRow.setSubAccountNumber(pbgl.getSubAccountNumber());
        newRow.setFinancialObjectCode(pbgl.getFinancialObjectCode());
        newRow.setFinancialSubObjectCode(pbgl.getFinancialSubObjectCode());
        newRow.setFinancialObjectTypeCode(pbgl.getFinancialObjectTypeCode());
        newRow.setTransactionLedgerEntryAmount(pbgl.getAccountLineAnnualBalanceAmount().kualiDecimalValue());
        this.getPersistenceBrokerTemplate().store((Object)newRow);
        diagnosticCounters.increaseGeneralLedgerBaseBudgetWritten();
        newRow.setFinancialBalanceTypeCode("CB");
        newRow.setTransactionLedgerEntrySequenceNumber(daoGlobalVariables.getNextSequenceNumber(incomingDocumentNumber));
        this.getPersistenceBrokerTemplate().store((Object)newRow);
        diagnosticCounters.increasGenneralLedgerCurrentBudgetWritten();
    }

    protected void writeGeneralLedgerPendingEntryFromMonthly(GeneralLedgerPendingEntry newRow, BudgetConstructionMonthly pbglMonthly, DaoGlobalVariables daoGlobalVariables, DiagnosticCounters diagnosticCounters) {
        String incomingDocumentNumber = pbglMonthly.getDocumentNumber();
        newRow.setFinancialBalanceTypeCode("MB");
        newRow.setDocumentNumber(incomingDocumentNumber);
        newRow.setChartOfAccountsCode(pbglMonthly.getChartOfAccountsCode());
        newRow.setAccountNumber(pbglMonthly.getAccountNumber());
        newRow.setSubAccountNumber(pbglMonthly.getSubAccountNumber());
        newRow.setFinancialObjectCode(pbglMonthly.getFinancialObjectCode());
        newRow.setFinancialSubObjectCode(pbglMonthly.getFinancialSubObjectCode());
        newRow.setFinancialObjectTypeCode(pbglMonthly.getFinancialObjectTypeCode());
        for (String[] monthlyPeriodProperties : BCConstants.BC_MONTHLY_AMOUNTS) {
            KualiInteger monthlyAmount;
            try {
                monthlyAmount = (KualiInteger)PropertyUtils.getSimpleProperty((Object)((Object)pbglMonthly), (String)monthlyPeriodProperties[0]);
            }
            catch (IllegalAccessException ex) {
                LOG.error((Object)String.format("\nunable to use get method to access value of %s in %s\n", monthlyPeriodProperties[0], BudgetConstructionMonthly.class.getName()), (Throwable)ex);
                diagnosticCounters.writeDiagnosticCounters();
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                LOG.error((Object)String.format("\nunable to invoke get method for %s in %s\n", monthlyPeriodProperties[0], BudgetConstructionMonthly.class.getName()), (Throwable)ex);
                diagnosticCounters.writeDiagnosticCounters();
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                LOG.error((Object)String.format("\nNO get method found for %s in %s ???\n", monthlyPeriodProperties[0], BudgetConstructionMonthly.class.getName()), (Throwable)ex);
                diagnosticCounters.writeDiagnosticCounters();
                throw new RuntimeException(ex);
            }
            if (monthlyAmount.isZero()) continue;
            newRow.setTransactionLedgerEntrySequenceNumber(daoGlobalVariables.getNextSequenceNumber(incomingDocumentNumber));
            newRow.setUniversityFiscalPeriodCode(monthlyPeriodProperties[1]);
            newRow.setTransactionLedgerEntryAmount(monthlyAmount.kualiDecimalValue());
            this.getPersistenceBrokerTemplate().store((Object)newRow);
            diagnosticCounters.increaseBudgetConstructionMonthlyBudgetWritten();
        }
    }

    protected HashSet<String> getAccountsNotToBeLoaded() {
        HashSet<String> bannedSubFunds = this.getSubFundsNotToBeLoaded();
        ReportQueryByCriteria queryID = new ReportQueryByCriteria(Account.class, ReportQueryByCriteria.CRITERIA_SELECT_ALL);
        queryID.setAttributes(new String[]{"accountNumber", "chartOfAccountsCode", "subFundGroupCode"});
        HashSet<String> bannedAccounts = new HashSet<String>(this.hashCapacity(queryID));
        Iterator accountProperties = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
        while (accountProperties.hasNext()) {
            Object[] selectListValues = (Object[])accountProperties.next();
            if (!bannedSubFunds.contains((String)selectListValues[2])) continue;
            bannedAccounts.add((String)selectListValues[0] + (String)selectListValues[1]);
        }
        return bannedAccounts;
    }

    protected HashSet<String> getSubFundsNotToBeLoaded() {
        HashSet<String> bannedSubFunds;
        if (BCConstants.NO_BC_GL_LOAD_FUND_GROUPS.size() != 0) {
            Criteria criteriaID = new Criteria();
            criteriaID.addIn("fundGroupCode", BCConstants.NO_BC_GL_LOAD_FUND_GROUPS);
            ReportQueryByCriteria queryID = new ReportQueryByCriteria(SubFundGroup.class, criteriaID);
            queryID.setAttributes(new String[]{"subFundGroupCode"});
            bannedSubFunds = new HashSet(this.hashCapacity(queryID) + BCConstants.NO_BC_GL_LOAD_SUBFUND_GROUPS.size());
            Iterator subfundsForBannedFunds = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)queryID);
            while (subfundsForBannedFunds.hasNext()) {
                bannedSubFunds.add((String)((Object[])subfundsForBannedFunds.next())[0]);
            }
        } else {
            bannedSubFunds = new HashSet<String>(BCConstants.NO_BC_GL_LOAD_SUBFUND_GROUPS.size() + 1);
        }
        Iterator<String> additionalBannedSubFunds = BCConstants.NO_BC_GL_LOAD_SUBFUND_GROUPS.iterator();
        while (additionalBannedSubFunds.hasNext()) {
            bannedSubFunds.add(additionalBannedSubFunds.next());
        }
        return bannedSubFunds;
    }

    protected void openAllAccountingPeriods(Integer requestYear) {
        Criteria criteriaID = new Criteria();
        criteriaID.addEqualTo("universityFiscalYear", (Object)requestYear);
        criteriaID.addNotEqualTo((Object)"active", (Object)"Y");
        QueryByCriteria queryID = new QueryByCriteria(AccountingPeriod.class, criteriaID);
        Iterator unopenPeriods = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)queryID);
        int periodsOpened = 0;
        while (unopenPeriods.hasNext()) {
            AccountingPeriod periodToOpen = (AccountingPeriod)unopenPeriods.next();
            periodToOpen.setActive(true);
            this.getPersistenceBrokerTemplate().store((Object)periodToOpen);
            ++periodsOpened;
        }
        LOG.warn((Object)String.format("\n\naccounting periods for %d changed to open status: %d", requestYear, new Integer(periodsOpened)));
    }

    protected class DaoGlobalVariables {
        private Integer requestYear;
        private HashMap<String, Integer> entrySequenceNumber;
        private Date transactionDate;
        private String financialSystemOriginationCode;
        private HashSet<String> accountsNotToBeLoaded;

        public DaoGlobalVariables(Integer requestYear, Date currentSqlDate, String financialSystemOriginationCode) {
            this.requestYear = requestYear;
            this.entrySequenceNumber = GeneralLedgerBudgetLoadDaoOjb.this.entrySequenceNumber(requestYear);
            this.transactionDate = currentSqlDate;
            this.financialSystemOriginationCode = financialSystemOriginationCode;
            this.accountsNotToBeLoaded = GeneralLedgerBudgetLoadDaoOjb.this.getAccountsNotToBeLoaded();
        }

        public Integer getRequestYear() {
            return this.requestYear;
        }

        public Integer getNextSequenceNumber(String seqKey) {
            Integer newSeqNumber = this.entrySequenceNumber.get(seqKey);
            this.entrySequenceNumber.put(seqKey, new Integer(newSeqNumber + 1));
            return newSeqNumber;
        }

        public Date getTransactionDate() {
            return this.transactionDate;
        }

        public String getFinancialSystemOriginationcode() {
            return this.financialSystemOriginationCode;
        }

        public boolean shouldThisAccountLoad(String accountAndChart) {
            return !this.accountsNotToBeLoaded.contains(accountAndChart);
        }
    }

    protected class DiagnosticCounters {
        long budgetConstructionPendingGeneralLedgerRead = 0L;
        long budgetConstructionPendingGeneralLedgerSkipped = 0L;
        long generalLedgerBaseBudgetWritten = 0L;
        long generalLedgerCurrentBudgetWritten = 0L;
        long budgetConstructionMonthlyBudgetRead = 0L;
        long budgetConstructionMonthlyBudgetSkipped = 0L;
        long budgetConstructionMonthlyBudgetWritten = 0L;

        protected DiagnosticCounters() {
        }

        public void increaseBudgetConstructionPendingGeneralLedgerRead() {
            ++this.budgetConstructionPendingGeneralLedgerRead;
        }

        public void increaseBudgetConstructionPendingGeneralLedgerSkipped() {
            ++this.budgetConstructionPendingGeneralLedgerSkipped;
        }

        public void increaseGeneralLedgerBaseBudgetWritten() {
            ++this.generalLedgerBaseBudgetWritten;
        }

        public void increasGenneralLedgerCurrentBudgetWritten() {
            ++this.generalLedgerCurrentBudgetWritten;
        }

        public void increaseBudgetConstructionMonthlyBudgetRead() {
            ++this.budgetConstructionMonthlyBudgetRead;
        }

        public void increaseBudgetConstructionMonthlyBudgetSkipped() {
            ++this.budgetConstructionMonthlyBudgetSkipped;
        }

        public void increaseBudgetConstructionMonthlyBudgetWritten() {
            ++this.budgetConstructionMonthlyBudgetWritten;
        }

        public void writeDiagnosticCounters() {
            LOG.warn((Object)String.format("\n\nPending Budget Construction General Ledger Load\n", new Object[0]));
            LOG.warn((Object)String.format("\n  pending budget construction GL rows read:        %,d", this.budgetConstructionPendingGeneralLedgerRead));
            LOG.warn((Object)String.format("\n  pending budget construction GL rows skipped:     %,d", this.budgetConstructionPendingGeneralLedgerSkipped));
            LOG.warn((Object)String.format("\n\n  base budget rows written:                        %,d", this.generalLedgerBaseBudgetWritten));
            LOG.warn((Object)String.format("\n  current budget rows written:                     %,d", this.generalLedgerCurrentBudgetWritten));
            LOG.warn((Object)String.format("\n\n  pending budget construction monthly rows read:   %,d", this.budgetConstructionMonthlyBudgetRead));
            LOG.warn((Object)String.format("\n  pending budget construction monthly rows skipped: %,d", this.budgetConstructionMonthlyBudgetSkipped));
            LOG.warn((Object)String.format("\n  pending budget construction monthly rows written: %,d", this.budgetConstructionMonthlyBudgetWritten));
        }
    }
}

