/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.service.FiscalYearFunctionControlService;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.document.service.PayrateExportService;
import org.kuali.kfs.module.bc.document.service.PayrateImportService;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.document.web.struts.PayrateImportExportForm;
import org.kuali.kfs.module.bc.service.HumanResourcesPayrollService;
import org.kuali.kfs.module.bc.util.ExternalizedMessageWrapper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;

public class PayrateImportExportAction
extends BudgetExpansionAction {
    public ActionForward performImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PayrateImportExportForm payrateImportExportForm = (PayrateImportExportForm)form;
        PayrateImportService payrateImportService = (PayrateImportService)SpringContext.getBean(PayrateImportService.class);
        ArrayList<ExternalizedMessageWrapper> messageList = new ArrayList<ExternalizedMessageWrapper>();
        Integer budgetYear = payrateImportExportForm.getUniversityFiscalYear();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy ' ' HH:mm:ss", Locale.US);
        boolean isValid = this.validateImportFormData(payrateImportExportForm);
        if (!isValid) {
            return mapping.findForward("basic");
        }
        Date startTime = new Date();
        messageList.add(new ExternalizedMessageWrapper("message.budget.payrate.headerLine", dateFormatter.format(startTime)));
        if (!payrateImportService.importFile(payrateImportExportForm.getFile().getInputStream(), messageList, principalId)) {
            payrateImportService.generatePdf(messageList, baos);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)"payrate_import_log.pdf");
            return null;
        }
        messageList.add(new ExternalizedMessageWrapper("message.budget.payrate.importComplete", new String[0]));
        Person user = GlobalVariables.getUserSession().getPerson();
        payrateImportService.update(budgetYear, user, messageList, principalId);
        messageList.add(new ExternalizedMessageWrapper("message.budget.payrate.footerLine", dateFormatter.format(new Date())));
        payrateImportService.generatePdf(messageList, baos);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)"payrate_import_log.pdf");
        return null;
    }

    public ActionForward performExport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PayrateImportExportForm payrateImportExportForm = (PayrateImportExportForm)form;
        PayrateExportService payrateExportService = (PayrateExportService)SpringContext.getBean(PayrateExportService.class);
        HumanResourcesPayrollService payrollPerimeterService = (HumanResourcesPayrollService)SpringContext.getBean(HumanResourcesPayrollService.class);
        Integer budgetYear = payrateImportExportForm.getUniversityFiscalYear();
        String positionUnionCode = payrateImportExportForm.getPositionUnionCode();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        boolean isValidPositionUnionCode = this.validateExportFormData(payrateImportExportForm);
        if (!isValidPositionUnionCode) {
            return mapping.findForward("basic");
        }
        isValidPositionUnionCode = payrollPerimeterService.validatePositionUnionCode(positionUnionCode);
        if (!isValidPositionUnionCode) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.payrate.export.invalidPositionUnionCode", new String[]{positionUnionCode});
            return mapping.findForward("basic");
        }
        StringBuilder fileContents = payrateExportService.buildExportFile(budgetYear, positionUnionCode, payrateImportExportForm.getCsfFreezeDateFormattedForExportFile(), principalId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(fileContents.toString().getBytes());
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"text/plain", (ByteArrayOutputStream)baos, (String)"payrate_export.txt");
        return null;
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public boolean validateImportFormData(PayrateImportExportForm form) {
        boolean isValid = true;
        PayrateImportExportForm importForm = form;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        FiscalYearFunctionControlService fiscalYearFunctionControlService = (FiscalYearFunctionControlService)SpringContext.getBean(FiscalYearFunctionControlService.class);
        boolean budgetUpdatesAllowed = fiscalYearFunctionControlService.isBudgetUpdateAllowed(form.getUniversityFiscalYear());
        if (importForm.getFile() == null || importForm.getFile().getFileSize() == 0) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.missingFile", new String[0]);
            isValid = false;
        }
        if (importForm.getFile() != null && importForm.getFile().getFileSize() == 0) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.emptyFile", new String[0]);
            isValid = false;
        }
        if (importForm.getFile() != null && StringUtils.isBlank((String)importForm.getFile().getFileName())) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.requestImport.missingFileName", new String[0]);
            isValid = false;
        }
        if (!budgetUpdatesAllowed) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.payrateImportExport.updatesNotAllowed", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    public boolean validateExportFormData(PayrateImportExportForm form) {
        boolean isValid = true;
        PayrateImportExportForm importForm = form;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        PayrateExportService payrateExportService = (PayrateExportService)SpringContext.getBean(PayrateExportService.class);
        if (ObjectUtils.isNull((Object)importForm.getPositionUnionCode()) || StringUtils.isBlank((String)importForm.getPositionUnionCode())) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.payrate.export.positionUnionCodeRequired", new String[0]);
            isValid = false;
        } else if (!payrateExportService.isValidPositionUnionCode(form.getPositionUnionCode())) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.payrate.export.invalidPositionUnionCode", new String[]{form.getPositionUnionCode()});
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)importForm.getCsfFreezeDate()) || StringUtils.isBlank((String)importForm.getCsfFreezeDate())) {
            errorMap.putError("GLOBAL_ERRORS", "error.budget.payrate.export.CsfFreezeDateRequired", new String[0]);
            isValid = false;
        } else {
            SimpleDateFormat validDateFormatter = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            SimpleDateFormat exportFileFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
            try {
                Date validDate = validDateFormatter.parse(form.getCsfFreezeDate());
                importForm.setCsfFreezeDateFormattedForExportFile(exportFileFormat.format(validDate));
            }
            catch (ParseException e) {
                errorMap.putError("GLOBAL_ERRORS", "error.budget.payrate.export.CsfFreezeDateIncorrectFormat", new String[0]);
                isValid = false;
            }
        }
        return isValid;
    }
}

