/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.report;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;

public class ReportControlListBuildHelper
implements Serializable {
    private BuildState currentState;
    private BuildState requestedState;
    private boolean forceRebuild = false;

    public boolean isBuildNeeded() {
        boolean buildNeeded = false;
        if (this.isForceRebuild()) {
            buildNeeded = true;
        } else if (this.getCurrentState() == null && this.getRequestedState() != null) {
            buildNeeded = true;
        } else if (this.getRequestedState() != null && !this.getCurrentState().equals(this.getRequestedState())) {
            buildNeeded = true;
        }
        return buildNeeded;
    }

    public void addBuildRequest(String pointOfView, Collection<BudgetConstructionPullup> selectedOrganizations, BCConstants.Report.BuildMode buildMode) {
        this.setRequestedState(new BuildState(pointOfView, selectedOrganizations, buildMode));
    }

    public void requestBuildComplete() {
        if (this.getRequestedState() != null) {
            if (this.getCurrentState() == null) {
                this.setCurrentState(new BuildState());
            }
        } else {
            throw new RuntimeException("Requested state does not exist. Control list build state has been lost.");
        }
        this.getCurrentState().setPointOfView(this.getRequestedState().getPointOfView());
        this.getCurrentState().setSelectedOrganizations(this.getRequestedState().getSelectedOrganizations());
        this.getCurrentState().setBuildMode(this.getRequestedState().getBuildMode());
        this.setRequestedState(null);
        this.setForceRebuild(false);
    }

    public BuildState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(BuildState currentState) {
        this.currentState = currentState;
    }

    public BuildState getRequestedState() {
        return this.requestedState;
    }

    public void setRequestedState(BuildState requestedState) {
        this.requestedState = requestedState;
    }

    public boolean isForceRebuild() {
        return this.forceRebuild;
    }

    public void setForceRebuild(boolean forceRebuild) {
        this.forceRebuild = forceRebuild;
    }

    public class BuildState
    implements Serializable {
        private String pointOfView;
        private Collection<BudgetConstructionPullup> selectedOrganizations;
        private BCConstants.Report.BuildMode buildMode;

        public BuildState() {
        }

        public BuildState(String pointOfView, Collection<BudgetConstructionPullup> selectedOrganizations, BCConstants.Report.BuildMode buildMode) {
            this.pointOfView = pointOfView;
            this.selectedOrganizations = selectedOrganizations;
            this.buildMode = buildMode;
        }

        public BCConstants.Report.BuildMode getBuildMode() {
            return this.buildMode;
        }

        public void setBuildMode(BCConstants.Report.BuildMode buildMode) {
            this.buildMode = buildMode;
        }

        public String getPointOfView() {
            return this.pointOfView;
        }

        public void setPointOfView(String pointOfView) {
            this.pointOfView = pointOfView;
        }

        public Collection<BudgetConstructionPullup> getSelectedOrganizations() {
            return this.selectedOrganizations;
        }

        public void setSelectedOrganizations(Collection<BudgetConstructionPullup> selectedOrganizations) {
            this.selectedOrganizations = selectedOrganizations;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BuildState) {
                boolean isEqual = true;
                if (obj == null) {
                    isEqual = false;
                } else {
                    BuildState compareState = (BuildState)obj;
                    if (!this.getPointOfView().equals(compareState.getPointOfView())) {
                        isEqual = false;
                    }
                    if (!this.compareOrganizations(this.getSelectedOrganizations(), compareState.getSelectedOrganizations())) {
                        isEqual = false;
                    }
                    if (!this.getBuildMode().equals((Object)compareState.getBuildMode())) {
                        isEqual = false;
                    }
                }
                return isEqual;
            }
            return super.equals(obj);
        }

        private boolean compareOrganizations(Collection<BudgetConstructionPullup> currentOrgs, Collection<BudgetConstructionPullup> requestedOrgs) {
            HashSet<String> currentOrgSet = new HashSet<String>();
            for (BudgetConstructionPullup pullup : currentOrgs) {
                currentOrgSet.add(pullup.getChartOfAccountsCode() + pullup.getOrganizationCode());
            }
            for (BudgetConstructionPullup pullup : requestedOrgs) {
                if (!currentOrgSet.contains(pullup.getChartOfAccountsCode() + pullup.getOrganizationCode())) {
                    return false;
                }
                currentOrgSet.remove(pullup.getChartOfAccountsCode() + pullup.getOrganizationCode());
            }
            return currentOrgSet.isEmpty();
        }
    }
}

