/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject;

import java.sql.Date;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class BudgetConstructionAccountSelect
extends PersistableBusinessObjectBase {
    private String principalId;
    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String documentNumber;
    private Integer organizationLevelCode;
    private String organizationChartOfAccountsCode;
    private String organizationCode;
    private String financialDocumentStatusCode;
    private String financialDocumentInitiatorIdentifier;
    private Date financialDocumentCreateDate;
    private BudgetConstructionHeader budgetConstructionHeader;
    private Account account;
    private Chart chartOfAccounts;
    private Chart organizationChartOfAccounts;
    private SubAccount subAccount;
    private Organization organization;

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getOrganizationLevelCode() {
        return this.organizationLevelCode;
    }

    public void setOrganizationLevelCode(Integer organizationLevelCode) {
        this.organizationLevelCode = organizationLevelCode;
    }

    public String getOrganizationChartOfAccountsCode() {
        return this.organizationChartOfAccountsCode;
    }

    public void setOrganizationChartOfAccountsCode(String organizationChartOfAccountsCode) {
        this.organizationChartOfAccountsCode = organizationChartOfAccountsCode;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getFinancialDocumentStatusCode() {
        return this.financialDocumentStatusCode;
    }

    public void setFinancialDocumentStatusCode(String financialDocumentStatusCode) {
        this.financialDocumentStatusCode = financialDocumentStatusCode;
    }

    public String getFinancialDocumentInitiatorIdentifier() {
        if (this.financialDocumentInitiatorIdentifier == null) {
            try {
                WorkflowDocumentService workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
                List actionsTaken = workflowDocumentService.getAllActionsTaken(this.getDocumentNumber());
                SortedSet<ActionTaken> sortedActionsTaken = this.getSortedActionsTaken(actionsTaken);
                if (sortedActionsTaken.size() > 0) {
                    Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(sortedActionsTaken.last().getPrincipalId());
                    this.financialDocumentInitiatorIdentifier = principal.getPrincipalName();
                    this.financialDocumentCreateDate = new Date(sortedActionsTaken.last().getActionDate().toDate().getTime());
                } else {
                    this.financialDocumentInitiatorIdentifier = "NotFound";
                }
            }
            catch (Exception e) {
                this.financialDocumentInitiatorIdentifier = "LookupError";
            }
        }
        return this.financialDocumentInitiatorIdentifier;
    }

    public void setFinancialDocumentInitiatorIdentifier(String financialDocumentInitiatorIdentifier) {
        this.financialDocumentInitiatorIdentifier = financialDocumentInitiatorIdentifier;
    }

    public Date getFinancialDocumentCreateDate() {
        if (this.financialDocumentCreateDate == null) {
            try {
                WorkflowDocumentService workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
                List actionsTaken = workflowDocumentService.getAllActionsTaken(this.getDocumentNumber());
                SortedSet<ActionTaken> sortedActionsTaken = this.getSortedActionsTaken(actionsTaken);
                if (sortedActionsTaken.size() > 0) {
                    Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(sortedActionsTaken.last().getPrincipalId());
                    this.financialDocumentInitiatorIdentifier = principal.getPrincipalName();
                    this.financialDocumentCreateDate = new Date(sortedActionsTaken.last().getActionDate().toDate().getTime());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.financialDocumentCreateDate;
    }

    public void setFinancialDocumentCreateDate(Date financialDocumentCreateDate) {
        this.financialDocumentCreateDate = financialDocumentCreateDate;
    }

    public BudgetConstructionHeader getBudgetConstructionHeader() {
        return this.budgetConstructionHeader;
    }

    public void setBudgetConstructionHeader(BudgetConstructionHeader budgetConstructionHeader) {
        this.budgetConstructionHeader = budgetConstructionHeader;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Chart getOrganizationChartOfAccounts() {
        return this.organizationChartOfAccounts;
    }

    public void setOrganizationChartOfAccounts(Chart organizationChartOfAccounts) {
        this.organizationChartOfAccounts = organizationChartOfAccounts;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    protected SortedSet<ActionTaken> getSortedActionsTaken(List<ActionTaken> actionsTaken) {
        TreeSet<ActionTaken> sortedActionsTaken = new TreeSet<ActionTaken>(new Comparator<ActionTaken>(){

            @Override
            public int compare(ActionTaken aTaken, ActionTaken bTaken) {
                DateTime aActionDate = aTaken.getActionDate();
                DateTime bActionDate = bTaken.getActionDate();
                return aActionDate.compareTo((ReadableInstant)bActionDate);
            }
        });
        sortedActionsTaken.addAll(actionsTaken);
        return sortedActionsTaken;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("principalId", this.principalId);
        if (this.universityFiscalYear != null) {
            m.put("universityFiscalYear", this.universityFiscalYear.toString());
        }
        m.put("chartOfAccountsCode", this.chartOfAccountsCode);
        m.put("accountNumber", this.accountNumber);
        m.put("subAccountNumber", this.subAccountNumber);
        m.put("documentNumber", this.documentNumber);
        return m;
    }
}

