/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;

public class BudgetConstructionRuleUtil {
    public static boolean hasExistingPBGLLine(List<PendingBudgetConstructionGeneralLedger> existingLines, PendingBudgetConstructionGeneralLedger newLine) {
        boolean isFound = false;
        ArrayList<String> comparableFields = new ArrayList<String>();
        comparableFields.add("financialObjectCode");
        comparableFields.add("financialSubObjectCode");
        if (newLine.getFinancialSubObjectCode() == null) {
            newLine.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        }
        for (PendingBudgetConstructionGeneralLedger line : existingLines) {
            if (!ObjectUtil.equals((Object)((Object)line), (Object)((Object)newLine), comparableFields)) continue;
            isFound = true;
            break;
        }
        if (newLine.getFinancialSubObjectCode().equalsIgnoreCase(KFSConstants.getDashFinancialSubObjectCode())) {
            newLine.setFinancialSubObjectCode(null);
        }
        return isFound;
    }

    public static Calendar getNoBudgetAllowedExpireDate(Integer activeBCFiscalYear) {
        AccountingPeriod accountingPeriod = ((AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class)).getByPeriod("06", Integer.valueOf(activeBCFiscalYear - BCConstants.NO_BUDGET_ALLOWED_FY_OFFSET));
        Date date = accountingPeriod.getUniversityFiscalPeriodEndDate();
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTime(date);
        gcal.add(5, 1);
        return gcal;
    }

    public static Calendar getAccountExpiredWarningExpireDate(Integer activeBCFiscalYear) {
        AccountingPeriod accountingPeriod = ((AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class)).getByPeriod("12", Integer.valueOf(activeBCFiscalYear - BCConstants.ACCOUNT_EXPIRE_WARNING_FY_OFFSET));
        Date date = accountingPeriod.getUniversityFiscalPeriodEndDate();
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTime(date);
        gcal.add(5, 1);
        return gcal;
    }
}

