/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountSummary;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgSubFundSummaryReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgSubFundSummaryReportTotal;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionAccountSummaryReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionSubFundSummaryReportService;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.kfs.module.bc.util.BudgetConstructionUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionSubFundSummaryReportServiceImpl
implements BudgetConstructionSubFundSummaryReportService {
    protected BudgetConstructionAccountSummaryReportDao budgetConstructionAccountSummaryReportDao;
    protected ConfigurationService kualiConfigurationService;
    protected BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper;
    protected boolean trExist = false;

    @Override
    public void updateSubFundSummaryReport(String principalName) {
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        String revenueINList = BudgetConstructionUtils.getRevenueINList();
        this.budgetConstructionAccountSummaryReportDao.cleanReportsAccountSummaryTable(principalName);
        this.budgetConstructionAccountSummaryReportDao.updateSubFundSummaryReport(principalName, revenueINList, expenditureINList);
    }

    @Override
    public Collection<BudgetConstructionOrgSubFundSummaryReport> buildReports(Integer universityFiscalYear, String principalName) {
        ArrayList<BudgetConstructionOrgSubFundSummaryReport> reportSet = new ArrayList<BudgetConstructionOrgSubFundSummaryReport>();
        Collection subFundSummaryList = this.budgetConstructionReportsServiceHelper.getDataForBuildingReports(BudgetConstructionAccountSummary.class, principalName, this.buildOrderByList());
        List subTotalList = BudgetConstructionReportHelper.deleteDuplicated((List)subFundSummaryList, this.fieldsForSubTotal());
        List totalList = BudgetConstructionReportHelper.deleteDuplicated((List)subFundSummaryList, this.fieldsForTotal());
        List orgSubFundSummaryReportSubTotalList = this.calculateSubTotal((List)subFundSummaryList, subTotalList);
        List orgSubFundSummaryReportTotalList = this.calculateTotal((List)subFundSummaryList, totalList);
        for (BudgetConstructionAccountSummary subFundSummaryEntry : subFundSummaryList) {
            BudgetConstructionOrgSubFundSummaryReport orgSubFundSummaryReportEntry = new BudgetConstructionOrgSubFundSummaryReport();
            this.buildReportsHeader(universityFiscalYear, orgSubFundSummaryReportEntry, subFundSummaryEntry);
            this.buildReportsBody(orgSubFundSummaryReportEntry, subFundSummaryEntry);
            this.buildReportsTotal(orgSubFundSummaryReportEntry, subFundSummaryEntry, orgSubFundSummaryReportSubTotalList, orgSubFundSummaryReportTotalList);
            reportSet.add(orgSubFundSummaryReportEntry);
        }
        return reportSet;
    }

    public void buildReportsHeader(Integer universityFiscalYear, BudgetConstructionOrgSubFundSummaryReport orgSubFundSummaryReportEntry, BudgetConstructionAccountSummary subFundSummaryList) {
        String orgChartDesc = subFundSummaryList.getOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        String chartDesc = subFundSummaryList.getChartOfAccounts().getFinChartOfAccountDescription();
        String orgName = subFundSummaryList.getOrganization().getOrganizationName();
        String reportChartDesc = subFundSummaryList.getChartOfAccounts().getReportsToChartOfAccounts().getFinChartOfAccountDescription();
        String subFundGroupName = subFundSummaryList.getFundGroup().getName();
        String subFundGroupDes = subFundSummaryList.getSubFundGroup().getSubFundGroupDescription();
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgSubFundSummaryReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgSubFundSummaryReportEntry.setOrgChartOfAccountsCode(subFundSummaryList.getOrganizationChartOfAccountsCode());
        if (orgChartDesc == null) {
            orgSubFundSummaryReportEntry.setOrgChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgSubFundSummaryReportEntry.setOrgChartOfAccountDescription(orgChartDesc);
        }
        orgSubFundSummaryReportEntry.setOrganizationCode(subFundSummaryList.getOrganizationCode());
        if (orgName == null) {
            orgSubFundSummaryReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgSubFundSummaryReportEntry.setOrganizationName(orgName);
        }
        orgSubFundSummaryReportEntry.setChartOfAccountsCode(subFundSummaryList.getChartOfAccountsCode());
        if (chartDesc == null) {
            orgSubFundSummaryReportEntry.setChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgSubFundSummaryReportEntry.setChartOfAccountDescription(chartDesc);
        }
        orgSubFundSummaryReportEntry.setFundGroupCode(subFundSummaryList.getFundGroupCode());
        if (subFundGroupName == null) {
            orgSubFundSummaryReportEntry.setFundGroupName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingFundGroupName"));
        } else {
            orgSubFundSummaryReportEntry.setFundGroupName(subFundGroupName);
        }
        orgSubFundSummaryReportEntry.setSubFundGroupCode(subFundSummaryList.getSubFundGroupCode());
        if (subFundGroupName == null) {
            orgSubFundSummaryReportEntry.setSubFundGroupDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubFundGroupDescription"));
        } else {
            orgSubFundSummaryReportEntry.setSubFundGroupDescription(subFundGroupDes);
        }
        Integer prevPrevFiscalyear = prevFiscalyear - 1;
        orgSubFundSummaryReportEntry.setBaseFy(prevPrevFiscalyear.toString() + "-" + prevFiscalyear.toString().substring(2, 4));
        orgSubFundSummaryReportEntry.setReqFy(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgSubFundSummaryReportEntry.setHeader1(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.subFund"));
        orgSubFundSummaryReportEntry.setHeader2(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.subFundDescription"));
        orgSubFundSummaryReportEntry.setHeader3(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.baseAmount"));
        orgSubFundSummaryReportEntry.setHeader4(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.reqAmount"));
        orgSubFundSummaryReportEntry.setHeader5(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.change"));
        orgSubFundSummaryReportEntry.setHeader6(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.header.change"));
        orgSubFundSummaryReportEntry.setConsHdr("");
    }

    public void buildReportsBody(BudgetConstructionOrgSubFundSummaryReport orgSubFundSummaryReportEntry, BudgetConstructionAccountSummary subFundSummary) {
        if (subFundSummary.getIncomeExpenseCode().equals("A")) {
            orgSubFundSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescRevenue"));
        } else if (subFundSummary.getIncomeExpenseCode().equals("E")) {
            orgSubFundSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpGross"));
        } else if (subFundSummary.getIncomeExpenseCode().equals("T")) {
            this.trExist = true;
            orgSubFundSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescTrnfrIn"));
        } else if (this.trExist) {
            this.trExist = false;
            orgSubFundSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpNetTrnfr"));
        } else {
            orgSubFundSummaryReportEntry.setIncExpDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpenditure"));
        }
        orgSubFundSummaryReportEntry.setBaseAmount(subFundSummary.getFinancialBeginningBalanceLineAmount());
        orgSubFundSummaryReportEntry.setReqAmount(subFundSummary.getAccountLineAnnualBalanceAmount());
        orgSubFundSummaryReportEntry.setAmountChange(orgSubFundSummaryReportEntry.getReqAmount().subtract(orgSubFundSummaryReportEntry.getBaseAmount()));
        orgSubFundSummaryReportEntry.setPercentChange(BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getAmountChange(), orgSubFundSummaryReportEntry.getBaseAmount()));
    }

    public void buildReportsTotal(BudgetConstructionOrgSubFundSummaryReport orgSubFundSummaryReportEntry, BudgetConstructionAccountSummary subFundSummaryList, List<BudgetConstructionOrgSubFundSummaryReportTotal> reportSubTotalList, List<BudgetConstructionOrgSubFundSummaryReportTotal> reportTotalList) {
        for (BudgetConstructionOrgSubFundSummaryReportTotal subTotalEntry : reportSubTotalList) {
            if (BudgetConstructionReportHelper.isSameEntry((BusinessObject)subFundSummaryList, (BusinessObject)subTotalEntry.getBcas(), this.fieldsForSubTotal())) {
                orgSubFundSummaryReportEntry.setSubFundTotalRevenueBaseAmount(subTotalEntry.getSubFundTotalRevenueBaseAmount());
                orgSubFundSummaryReportEntry.setSubFundTotalRevenueReqAmount(subTotalEntry.getSubFundTotalRevenueReqAmount());
                orgSubFundSummaryReportEntry.setSubFundTotalRevenueAmountChange(subTotalEntry.getSubFundTotalRevenueReqAmount().subtract(subTotalEntry.getSubFundTotalRevenueBaseAmount()));
                BigDecimal percentChange = BigDecimal.ZERO;
                percentChange = BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getSubFundTotalRevenueAmountChange(), orgSubFundSummaryReportEntry.getSubFundTotalRevenueBaseAmount());
                orgSubFundSummaryReportEntry.setSubFundTotalRevenuePercentChange(percentChange);
            }
            for (BudgetConstructionOrgSubFundSummaryReportTotal totalEntry : reportTotalList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)subFundSummaryList, (BusinessObject)totalEntry.getBcas(), this.fieldsForTotal())) continue;
                BigDecimal percentChange = BigDecimal.ZERO;
                orgSubFundSummaryReportEntry.setTotalRevenueBaseAmount(totalEntry.getTotalRevenueBaseAmount());
                orgSubFundSummaryReportEntry.setTotalGrossBaseAmount(totalEntry.getTotalGrossBaseAmount());
                orgSubFundSummaryReportEntry.setTotalTransferInBaseAmount(totalEntry.getTotalTransferInBaseAmount());
                orgSubFundSummaryReportEntry.setTotalNetTransferBaseAmount(totalEntry.getTotalNetTransferBaseAmount());
                orgSubFundSummaryReportEntry.setTotalRevenueReqAmount(totalEntry.getTotalRevenueReqAmount());
                orgSubFundSummaryReportEntry.setTotalGrossReqAmount(totalEntry.getTotalGrossReqAmount());
                orgSubFundSummaryReportEntry.setTotalTransferInReqAmount(totalEntry.getTotalTransferInReqAmount());
                orgSubFundSummaryReportEntry.setTotalNetTransferReqAmount(totalEntry.getTotalNetTransferReqAmount());
                orgSubFundSummaryReportEntry.setTotalRevenueAmountChange(orgSubFundSummaryReportEntry.getTotalRevenueReqAmount().subtract(orgSubFundSummaryReportEntry.getTotalRevenueBaseAmount()));
                percentChange = BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getTotalRevenueAmountChange(), orgSubFundSummaryReportEntry.getTotalRevenueBaseAmount());
                orgSubFundSummaryReportEntry.setTotalRevenuePercentChange(percentChange);
                orgSubFundSummaryReportEntry.setTotalGrossAmountChange(orgSubFundSummaryReportEntry.getTotalGrossReqAmount().subtract(orgSubFundSummaryReportEntry.getTotalGrossBaseAmount()));
                percentChange = BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getTotalGrossAmountChange(), orgSubFundSummaryReportEntry.getTotalGrossBaseAmount());
                orgSubFundSummaryReportEntry.setTotalGrossPercentChange(percentChange);
                orgSubFundSummaryReportEntry.setTotalTransferAmountChange(orgSubFundSummaryReportEntry.getTotalTransferInReqAmount().subtract(orgSubFundSummaryReportEntry.getTotalTransferInBaseAmount()));
                percentChange = BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getTotalTransferAmountChange(), orgSubFundSummaryReportEntry.getTotalTransferInBaseAmount());
                orgSubFundSummaryReportEntry.setTotalTransferInPercentChange(percentChange);
                orgSubFundSummaryReportEntry.setTotalNetTransferAmountChange(orgSubFundSummaryReportEntry.getTotalNetTransferReqAmount().subtract(orgSubFundSummaryReportEntry.getTotalNetTransferBaseAmount()));
                percentChange = BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getTotalNetTransferAmountChange(), orgSubFundSummaryReportEntry.getTotalNetTransferBaseAmount());
                orgSubFundSummaryReportEntry.setTotalNetTransferPercentChange(percentChange);
                orgSubFundSummaryReportEntry.setRevExpDifferenceBaseAmount(orgSubFundSummaryReportEntry.getTotalRevenueBaseAmount().subtract(orgSubFundSummaryReportEntry.getTotalNetTransferBaseAmount()));
                orgSubFundSummaryReportEntry.setRevExpDifferenceReqAmount(orgSubFundSummaryReportEntry.getTotalRevenueReqAmount().subtract(orgSubFundSummaryReportEntry.getTotalNetTransferReqAmount()));
                orgSubFundSummaryReportEntry.setRevExpDifferenceAmountChange(orgSubFundSummaryReportEntry.getRevExpDifferenceReqAmount().subtract(orgSubFundSummaryReportEntry.getRevExpDifferenceBaseAmount()));
                percentChange = BudgetConstructionReportHelper.calculatePercent(orgSubFundSummaryReportEntry.getRevExpDifferenceAmountChange(), orgSubFundSummaryReportEntry.getRevExpDifferenceBaseAmount());
                orgSubFundSummaryReportEntry.setRevExpDifferencePercentChange(percentChange);
            }
        }
    }

    public List calculateSubTotal(List<BudgetConstructionAccountSummary> bcasList, List<BudgetConstructionAccountSummary> subTotalList) {
        KualiInteger subFundTotalRevenueBaseAmount = KualiInteger.ZERO;
        KualiInteger subFundTotalRevenueReqAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgSubFundSummaryReportTotal> returnList = new ArrayList<BudgetConstructionOrgSubFundSummaryReportTotal>();
        for (BudgetConstructionAccountSummary simpleBcasEntry : subTotalList) {
            BudgetConstructionOrgSubFundSummaryReportTotal bcSubFundTotal = new BudgetConstructionOrgSubFundSummaryReportTotal();
            for (BudgetConstructionAccountSummary bcasListEntry : bcasList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcasEntry, (BusinessObject)bcasListEntry, this.fieldsForSubTotal())) continue;
                if (bcasListEntry.getIncomeExpenseCode().equals("A")) {
                    subFundTotalRevenueBaseAmount = subFundTotalRevenueBaseAmount.subtract(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    subFundTotalRevenueReqAmount = subFundTotalRevenueReqAmount.subtract(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (!bcasListEntry.getIncomeExpenseCode().equals("X")) continue;
                subFundTotalRevenueBaseAmount = subFundTotalRevenueBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                subFundTotalRevenueReqAmount = subFundTotalRevenueReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
            }
            bcSubFundTotal.setBcas(simpleBcasEntry);
            bcSubFundTotal.setSubFundTotalRevenueBaseAmount(subFundTotalRevenueBaseAmount);
            bcSubFundTotal.setSubFundTotalRevenueReqAmount(subFundTotalRevenueReqAmount);
            subFundTotalRevenueBaseAmount = KualiInteger.ZERO;
            subFundTotalRevenueReqAmount = KualiInteger.ZERO;
            returnList.add(bcSubFundTotal);
        }
        return returnList;
    }

    public List calculateTotal(List<BudgetConstructionAccountSummary> bcasList, List<BudgetConstructionAccountSummary> totalList) {
        KualiInteger totalRevenueBaseAmount = KualiInteger.ZERO;
        KualiInteger totalGrossBaseAmount = KualiInteger.ZERO;
        KualiInteger totalTransferInBaseAmount = KualiInteger.ZERO;
        KualiInteger totalNetTransferBaseAmount = KualiInteger.ZERO;
        KualiInteger totalRevenueReqAmount = KualiInteger.ZERO;
        KualiInteger totalGrossReqAmount = KualiInteger.ZERO;
        KualiInteger totalTransferInReqAmount = KualiInteger.ZERO;
        KualiInteger totalNetTransferReqAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgSubFundSummaryReportTotal> returnList = new ArrayList<BudgetConstructionOrgSubFundSummaryReportTotal>();
        for (BudgetConstructionAccountSummary simpleBcasEntry : totalList) {
            BudgetConstructionOrgSubFundSummaryReportTotal bcSubFundTotal = new BudgetConstructionOrgSubFundSummaryReportTotal();
            for (BudgetConstructionAccountSummary bcasListEntry : bcasList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcasEntry, (BusinessObject)bcasListEntry, this.fieldsForTotal())) continue;
                if (bcasListEntry.getIncomeExpenseCode().equals("A")) {
                    totalRevenueBaseAmount = totalRevenueBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    totalRevenueReqAmount = totalRevenueReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (bcasListEntry.getIncomeExpenseCode().equals("E")) {
                    totalGrossBaseAmount = totalGrossBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    totalGrossReqAmount = totalGrossReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (bcasListEntry.getIncomeExpenseCode().equals("T")) {
                    totalTransferInBaseAmount = totalTransferInBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                    totalTransferInReqAmount = totalTransferInReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
                    continue;
                }
                if (!bcasListEntry.getIncomeExpenseCode().equals("X")) continue;
                totalNetTransferBaseAmount = totalNetTransferBaseAmount.add(bcasListEntry.getFinancialBeginningBalanceLineAmount());
                totalNetTransferReqAmount = totalNetTransferReqAmount.add(bcasListEntry.getAccountLineAnnualBalanceAmount());
            }
            bcSubFundTotal.setBcas(simpleBcasEntry);
            bcSubFundTotal.setTotalGrossBaseAmount(totalGrossBaseAmount);
            bcSubFundTotal.setTotalGrossReqAmount(totalGrossReqAmount);
            bcSubFundTotal.setTotalNetTransferBaseAmount(totalNetTransferBaseAmount);
            bcSubFundTotal.setTotalNetTransferReqAmount(totalNetTransferReqAmount);
            bcSubFundTotal.setTotalRevenueBaseAmount(totalRevenueBaseAmount);
            bcSubFundTotal.setTotalRevenueReqAmount(totalRevenueReqAmount);
            bcSubFundTotal.setTotalTransferInBaseAmount(totalTransferInBaseAmount);
            bcSubFundTotal.setTotalTransferInReqAmount(totalTransferInReqAmount);
            returnList.add(bcSubFundTotal);
            totalGrossBaseAmount = KualiInteger.ZERO;
            totalGrossReqAmount = KualiInteger.ZERO;
            totalNetTransferBaseAmount = KualiInteger.ZERO;
            totalNetTransferReqAmount = KualiInteger.ZERO;
            totalRevenueBaseAmount = KualiInteger.ZERO;
            totalRevenueReqAmount = KualiInteger.ZERO;
            totalTransferInBaseAmount = KualiInteger.ZERO;
            totalTransferInReqAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    protected List<String> fieldsForSubTotal() {
        List<String> fieldList = this.fieldsForTotal();
        fieldList.add("subFundGroupCode");
        return fieldList;
    }

    protected List<String> fieldsForTotal() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("organizationChartOfAccountsCode");
        fieldList.add("organizationCode");
        fieldList.add("chartOfAccountsCode");
        fieldList.add("fundGroupCode");
        return fieldList;
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("organizationChartOfAccountsCode");
        returnList.add("organizationCode");
        returnList.add("chartOfAccountsCode");
        returnList.add("subFundSortCode");
        returnList.add("fundGroupCode");
        returnList.add("subFundGroupCode");
        returnList.add("accountNumber");
        returnList.add("subAccountNumber");
        returnList.add("incomeExpenseCode");
        return returnList;
    }

    public void setBudgetConstructionAccountSummaryReportDao(BudgetConstructionAccountSummaryReportDao budgetConstructionAccountSummaryReportDao) {
        this.budgetConstructionAccountSummaryReportDao = budgetConstructionAccountSummaryReportDao;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBudgetConstructionReportsServiceHelper(BudgetConstructionReportsServiceHelper budgetConstructionReportsServiceHelper) {
        this.budgetConstructionReportsServiceHelper = budgetConstructionReportsServiceHelper;
    }
}

