/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockStatus;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.web.struts.DetailSalarySettingAction;
import org.kuali.kfs.module.bc.document.web.struts.PositionSalarySettingForm;
import org.kuali.kfs.module.bc.service.BudgetConstructionPositionService;
import org.kuali.kfs.sys.context.SpringContext;

public class PositionSalarySettingAction
extends DetailSalarySettingAction {
    private static final Logger LOG = Logger.getLogger(PositionSalarySettingAction.class);
    private SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    private BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    private BudgetConstructionPositionService budgetConstructionPositionService = (BudgetConstructionPositionService)SpringContext.getBean(BudgetConstructionPositionService.class);

    @Override
    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PositionSalarySettingForm positionSalarySettingForm = (PositionSalarySettingForm)form;
        MessageMap errorMap = positionSalarySettingForm.isBudgetByAccountMode() ? positionSalarySettingForm.getCallBackErrors() : GlobalVariables.getMessageMap();
        ActionForward resyncAction = this.resyncPositionBeforeSalarySetting(mapping, form, request, response);
        if (resyncAction != null) {
            return resyncAction;
        }
        Map<String, Object> fieldValues = positionSalarySettingForm.getKeyMapOfSalarySettingItem();
        BudgetConstructionPosition budgetConstructionPosition = (BudgetConstructionPosition)this.businessObjectService.findByPrimaryKey(BudgetConstructionPosition.class, fieldValues);
        if (budgetConstructionPosition == null) {
            String positionNumber = (String)fieldValues.get("positionNumber");
            String fiscalYear = (String)fieldValues.get("universityFiscalYear");
            errorMap.putError("GlobalMessages", "error.budget.positionNotFound", new String[]{positionNumber, fiscalYear});
            if (positionSalarySettingForm.isBudgetByAccountMode()) {
                return this.returnToCaller(mapping, form, request, response);
            }
            this.cleanupAnySessionForm(mapping, request);
            return mapping.findForward("organizationSalarySettingReturning");
        }
        if (!positionSalarySettingForm.isViewOnlyEntry()) {
            Integer universityFiscalYear = budgetConstructionPosition.getUniversityFiscalYear();
            String positionNumber = budgetConstructionPosition.getPositionNumber();
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            BudgetConstructionLockStatus bcLockStatus = ((LockService)SpringContext.getBean(LockService.class)).lockPosition(positionNumber, universityFiscalYear, principalId);
            if (!bcLockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) {
                errorMap.putError("GLOBAL_ERRORS", "error.budget.failToLockPosition", new String[]{"Position Number:" + budgetConstructionPosition.getPositionNumber() + ", Fiscal Year:" + budgetConstructionPosition.getUniversityFiscalYear().toString() + ", Desc:" + budgetConstructionPosition.getPositionDescription() + ", Locked By:" + budgetConstructionPosition.getPositionLockUser().getPrincipalName()});
                if (positionSalarySettingForm.isBudgetByAccountMode()) {
                    return this.returnToCaller(mapping, form, request, response);
                }
                this.cleanupAnySessionForm(mapping, request);
                return mapping.findForward("organizationSalarySettingReturning");
            }
        }
        positionSalarySettingForm.setBudgetConstructionPosition(budgetConstructionPosition);
        if (positionSalarySettingForm.isSingleAccountMode()) {
            positionSalarySettingForm.pickAppointmentFundingsForSingleAccount();
        }
        if (!positionSalarySettingForm.isViewOnlyEntry()) {
            positionSalarySettingForm.postProcessBCAFLines();
            positionSalarySettingForm.setNewBCAFLine(positionSalarySettingForm.createNewAppointmentFundingLine());
            boolean accessModeUpdated = positionSalarySettingForm.updateAccessMode(errorMap);
            if (!accessModeUpdated) {
                this.unlockPositionOnly(positionSalarySettingForm);
                if (positionSalarySettingForm.isBudgetByAccountMode()) {
                    return this.returnToCaller(mapping, form, request, response);
                }
                this.cleanupAnySessionForm(mapping, request);
                return mapping.findForward("organizationSalarySettingReturning");
            }
            boolean gotLocks = positionSalarySettingForm.acquirePositionAndFundingLocks(errorMap);
            if (!gotLocks) {
                this.unlockPositionOnly(positionSalarySettingForm);
                if (positionSalarySettingForm.isBudgetByAccountMode()) {
                    return this.returnToCaller(mapping, form, request, response);
                }
                this.cleanupAnySessionForm(mapping, request);
                return mapping.findForward("organizationSalarySettingReturning");
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward saveAction = super.save(mapping, form, request, response);
        PositionSalarySettingForm positionSalarySettingForm = (PositionSalarySettingForm)form;
        this.sendWarnings(positionSalarySettingForm, KNSGlobalVariables.getMessageList());
        return saveAction;
    }

    public void sendWarnings(PositionSalarySettingForm positionSalarySettingForm, MessageList warnings) {
        List<PendingBudgetConstructionAppointmentFunding> activeAppointmentFundings = positionSalarySettingForm.getActiveFundingLines();
        if (activeAppointmentFundings == null || activeAppointmentFundings.isEmpty()) {
            return;
        }
        boolean hasFundingLineInvolveLeave = this.hasFundingLineInvolvedLeave(activeAppointmentFundings);
        BudgetConstructionPosition budgetConstructionPosition = positionSalarySettingForm.getBudgetConstructionPosition();
        BigDecimal positionFte = budgetConstructionPosition.getPositionFullTimeEquivalency().setScale(2, 4);
        BigDecimal requestedFteQuantityTotal = positionSalarySettingForm.getAppointmentRequestedFteQuantityTotal().setScale(2, 4);
        if (!hasFundingLineInvolveLeave && requestedFteQuantityTotal.compareTo(positionFte) != 0) {
            warnings.add("warning.budget.fteNotEqual", new String[0]);
        }
        BigDecimal positionStandardHours = budgetConstructionPosition.getPositionStandardHoursDefault().setScale(2, 4);
        BigDecimal requestedStandardHoursTotal = positionSalarySettingForm.getAppointmentRequestedStandardHoursTotal().setScale(2, 4);
        if (!hasFundingLineInvolveLeave && requestedStandardHoursTotal.compareTo(positionStandardHours) != 0) {
            warnings.add("warning.budget.workingHourNotEqual", new String[0]);
        }
        if (positionSalarySettingForm.isPendingPositionSalaryChange()) {
            warnings.add("warning.budget.recalculateNeeded", new String[0]);
        }
    }

    public ActionForward recalculateAllSalarySettingLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PositionSalarySettingForm positionSalarySettingForm = (PositionSalarySettingForm)form;
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = positionSalarySettingForm.getActiveFundingLines();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            if (appointmentFunding.isDisplayOnlyMode()) continue;
            this.recalculateSalarySettingLine(appointmentFunding);
        }
        return mapping.findForward("basic");
    }

    public ActionForward recalculateSalarySettingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PositionSalarySettingForm positionSalarySettingForm = (PositionSalarySettingForm)form;
        PendingBudgetConstructionAppointmentFunding appointmentFunding = this.getSelectedFundingLine(request, positionSalarySettingForm);
        this.recalculateSalarySettingLine(appointmentFunding);
        return mapping.findForward("basic");
    }

    protected void recalculateSalarySettingLine(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        if (appointmentFunding.isPositionSalaryChangeIndicator()) {
            appointmentFunding.setPositionSalaryChangeIndicator(Boolean.FALSE);
            if (appointmentFunding.getAppointmentFundingDurationCode().equals(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode) && !appointmentFunding.getAppointmentFundingMonth().equals(appointmentFunding.getBudgetConstructionPosition().getIuNormalWorkMonths())) {
                appointmentFunding.setAppointmentFundingMonth(appointmentFunding.getBudgetConstructionPosition().getIuNormalWorkMonths());
            }
            this.salarySettingService.recalculateDerivedInformation(appointmentFunding);
        }
        if (appointmentFunding.isPositionObjectChangeIndicator()) {
            appointmentFunding.setPositionObjectChangeIndicator(Boolean.FALSE);
        }
    }

    @Override
    protected String getFundingAwareObjectName() {
        return "budgetConstructionPosition";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionForward resyncPositionBeforeSalarySetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BCConstants.LockStatus lockStatus;
        PositionSalarySettingForm positionSalarySettingForm = (PositionSalarySettingForm)form;
        if (!positionSalarySettingForm.isRefreshPositionBeforeSalarySetting()) {
            return null;
        }
        Integer universityFiscalYear = positionSalarySettingForm.getUniversityFiscalYear();
        String positionNumber = positionSalarySettingForm.getPositionNumber();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        BudgetConstructionLockStatus bcLockStatus = ((LockService)SpringContext.getBean(LockService.class)).lockPositionAndActiveFunding(universityFiscalYear, positionNumber, principalId);
        if (!bcLockStatus.getLockStatus().equals((Object)BCConstants.LockStatus.SUCCESS)) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.positionLockNotObtained", new String[]{universityFiscalYear.toString(), positionNumber});
            return this.returnToCaller(mapping, form, request, response);
        }
        try {
            this.budgetConstructionPositionService.refreshPositionFromExternal(universityFiscalYear, positionNumber);
            lockStatus = ((LockService)SpringContext.getBean(LockService.class)).unlockPositionAndActiveFunding(universityFiscalYear, positionNumber, principalId);
        }
        catch (Throwable throwable) {
            BCConstants.LockStatus lockStatus2 = ((LockService)SpringContext.getBean(LockService.class)).unlockPositionAndActiveFunding(universityFiscalYear, positionNumber, principalId);
            if (!lockStatus2.equals((Object)BCConstants.LockStatus.SUCCESS)) {
                LOG.error((Object)String.format("unable to unlock position and active funding records: %s, %s, %s", universityFiscalYear, positionNumber, principalId));
                throw new RuntimeException(String.format("unable to unlock position and active funding records: %s, %s, %s", universityFiscalYear, positionNumber, principalId));
            }
            throw throwable;
        }
        if (!lockStatus.equals((Object)BCConstants.LockStatus.SUCCESS)) {
            LOG.error((Object)String.format("unable to unlock position and active funding records: %s, %s, %s", universityFiscalYear, positionNumber, principalId));
            throw new RuntimeException(String.format("unable to unlock position and active funding records: %s, %s, %s", universityFiscalYear, positionNumber, principalId));
        }
        return null;
    }

    @Override
    public BCConstants.SynchronizationCheckType getSynchronizationCheckType() {
        return BCConstants.SynchronizationCheckType.EID;
    }
}

