/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountReports;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.service.BudgetParameterService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class BudgetConstructionDocument
extends FinancialSystemTransactionalDocumentBase {
    protected static final Logger LOG = Logger.getLogger(BudgetConstructionDocument.class);
    protected Integer universityFiscalYear;
    protected String chartOfAccountsCode;
    protected String accountNumber;
    protected String subAccountNumber;
    protected Integer organizationLevelCode;
    protected String organizationLevelChartOfAccountsCode;
    protected String organizationLevelOrganizationCode;
    protected String budgetLockUserIdentifier;
    protected String budgetTransactionLockUserIdentifier;
    protected Chart chartOfAccounts;
    protected Account account;
    protected SubAccount subAccount;
    protected Person budgetLockUser;
    protected Person budgetTransactionLockUser;
    protected Organization organizationLevelOrganization;
    protected BudgetConstructionAccountReports budgetConstructionAccountReports;
    protected List pendingBudgetConstructionGeneralLedgerRevenueLines;
    protected List pendingBudgetConstructionGeneralLedgerExpenditureLines;
    protected Integer previousUniversityFiscalYear;
    protected KualiInteger revenueAccountLineAnnualBalanceAmountTotal;
    protected KualiInteger revenueFinancialBeginningBalanceLineAmountTotal;
    protected KualiDecimal revenuePercentChangeTotal;
    protected KualiInteger expenditureAccountLineAnnualBalanceAmountTotal;
    protected KualiInteger expenditureFinancialBeginningBalanceLineAmountTotal;
    protected KualiDecimal expenditurePercentChangeTotal;
    protected boolean isBenefitsCalcNeeded;
    protected boolean isMonthlyBenefitsCalcNeeded;
    protected boolean isSalarySettingOnly;
    protected BCConstants.AccountSalarySettingOnlyCause accountSalarySettingOnlyCause;
    protected boolean containsTwoPlug = false;
    protected boolean budgetableDocument = false;
    protected boolean cleanupModeActionForceCheck = false;

    public BudgetConstructionDocument() {
        this.setPendingBudgetConstructionGeneralLedgerExpenditureLines(new ArrayList());
        this.setPendingBudgetConstructionGeneralLedgerRevenueLines(new ArrayList());
        this.zeroTotals();
    }

    public void zeroTotals() {
        this.revenueAccountLineAnnualBalanceAmountTotal = new KualiInteger(BigDecimal.ZERO);
        this.revenueFinancialBeginningBalanceLineAmountTotal = new KualiInteger(BigDecimal.ZERO);
        this.revenuePercentChangeTotal = new KualiDecimal(0);
        this.expenditureAccountLineAnnualBalanceAmountTotal = new KualiInteger(BigDecimal.ZERO);
        this.expenditureFinancialBeginningBalanceLineAmountTotal = new KualiInteger(BigDecimal.ZERO);
        this.expenditurePercentChangeTotal = new KualiDecimal(0);
    }

    public void initiateDocument() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("UNIV_FISCAL_YR", this.getUniversityFiscalYear());
        fieldValues.put("FIN_COA_CD", this.getChartOfAccountsCode());
        fieldValues.put("ACCOUNT_NBR", this.getAccountNumber());
        fieldValues.put("SUB_ACCT_NBR", this.getSubAccountNumber());
        fieldValues.put("FIN_OBJ_TYP_CD", "IN");
        this.pendingBudgetConstructionGeneralLedgerRevenueLines = (ArrayList)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatchingOrderBy(PendingBudgetConstructionGeneralLedger.class, fieldValues, "FIN_OBJECT_CD", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pendingBudgetConstructionGeneralLedgerRevenue is: " + this.pendingBudgetConstructionGeneralLedgerRevenueLines));
        }
        fieldValues.remove("FIN_OBJ_TYP_CD");
        fieldValues.put("FIN_OBJ_TYP_CD", "EX");
        this.pendingBudgetConstructionGeneralLedgerExpenditureLines = (ArrayList)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatchingOrderBy(PendingBudgetConstructionGeneralLedger.class, fieldValues, "FIN_OBJECT_CD", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pendingBudgetConstructionGeneralLedgerExpenditure is: " + this.pendingBudgetConstructionGeneralLedgerExpenditureLines));
        }
    }

    public int addPBGLLine(PendingBudgetConstructionGeneralLedger line, boolean isRevenue) {
        int insertPoint = 0;
        ListIterator<PendingBudgetConstructionGeneralLedger> pbglLines = isRevenue ? this.getPendingBudgetConstructionGeneralLedgerRevenueLines().listIterator() : this.getPendingBudgetConstructionGeneralLedgerExpenditureLines().listIterator();
        while (pbglLines.hasNext()) {
            PendingBudgetConstructionGeneralLedger pbglLine = pbglLines.next();
            if (pbglLine.getFinancialObjectCode().compareToIgnoreCase(line.getFinancialObjectCode()) < 0) {
                ++insertPoint;
                continue;
            }
            if (pbglLine.getFinancialObjectCode().compareToIgnoreCase(line.getFinancialObjectCode()) > 0 || pbglLine.getFinancialObjectCode().compareToIgnoreCase(line.getFinancialObjectCode()) != 0 || pbglLine.getFinancialSubObjectCode().compareToIgnoreCase(line.getFinancialSubObjectCode()) >= 0) break;
            ++insertPoint;
        }
        if (isRevenue) {
            this.pendingBudgetConstructionGeneralLedgerRevenueLines.add(insertPoint, line);
        } else {
            this.pendingBudgetConstructionGeneralLedgerExpenditureLines.add(insertPoint, line);
        }
        return insertPoint;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
        this.setPreviousUniversityFiscalYear(universityFiscalYear - 1);
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        Account account;
        this.accountNumber = accountNumber;
        AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
        if (!accountService.accountsCanCrossCharts() && ObjectUtils.isNotNull((Object)(account = accountService.getUniqueAccountForAccountNumber(accountNumber)))) {
            this.setChartOfAccountsCode(account.getChartOfAccountsCode());
        }
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public Integer getOrganizationLevelCode() {
        return this.organizationLevelCode;
    }

    public void setOrganizationLevelCode(Integer organizationLevelCode) {
        this.organizationLevelCode = organizationLevelCode;
    }

    public String getOrganizationLevelChartOfAccountsCode() {
        return this.organizationLevelChartOfAccountsCode;
    }

    public void setOrganizationLevelChartOfAccountsCode(String organizationLevelChartOfAccountsCode) {
        this.organizationLevelChartOfAccountsCode = organizationLevelChartOfAccountsCode;
    }

    public String getOrganizationLevelOrganizationCode() {
        return this.organizationLevelOrganizationCode;
    }

    public void setOrganizationLevelOrganizationCode(String organizationLevelOrganizationCode) {
        this.organizationLevelOrganizationCode = organizationLevelOrganizationCode;
    }

    public String getBudgetLockUserIdentifier() {
        return this.budgetLockUserIdentifier;
    }

    public void setBudgetLockUserIdentifier(String budgetLockUserIdentifier) {
        this.budgetLockUserIdentifier = budgetLockUserIdentifier;
    }

    public String getBudgetTransactionLockUserIdentifier() {
        return this.budgetTransactionLockUserIdentifier;
    }

    public void setBudgetTransactionLockUserIdentifier(String budgetTransactionLockUserIdentifier) {
        this.budgetTransactionLockUserIdentifier = budgetTransactionLockUserIdentifier;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Account getAccount() {
        return this.account;
    }

    @Deprecated
    public void setAccount(Account account) {
        this.account = account;
    }

    public Person getBudgetLockUser() {
        this.budgetLockUser = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.budgetLockUserIdentifier, this.budgetLockUser);
        return this.budgetLockUser;
    }

    @Deprecated
    public void setBudgetLockUser(Person budgetLockUser) {
        this.budgetLockUser = budgetLockUser;
    }

    public Person getBudgetTransactionLockUser() {
        this.budgetTransactionLockUser = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.budgetTransactionLockUserIdentifier, this.budgetTransactionLockUser);
        return this.budgetTransactionLockUser;
    }

    @Deprecated
    public void setBudgetTransactionLockUser(Person budgetTransactionLockUser) {
        this.budgetTransactionLockUser = budgetTransactionLockUser;
    }

    public Organization getOrganizationLevelOrganization() {
        return this.organizationLevelOrganization;
    }

    @Deprecated
    public void setOrganizationLevelOrganization(Organization organizationLevelOrganization) {
        this.organizationLevelOrganization = organizationLevelOrganization;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public Integer getPreviousUniversityFiscalYear() {
        if (this.previousUniversityFiscalYear == null) {
            this.previousUniversityFiscalYear = this.getUniversityFiscalYear() - 1;
        }
        return this.previousUniversityFiscalYear;
    }

    public void setPreviousUniversityFiscalYear(Integer previousUniversityFiscalYear) {
        this.previousUniversityFiscalYear = previousUniversityFiscalYear;
    }

    public BudgetConstructionAccountReports getBudgetConstructionAccountReports() {
        return this.budgetConstructionAccountReports;
    }

    @Deprecated
    public void setBudgetConstructionAccountReports(BudgetConstructionAccountReports budgetConstructionAccountReports) {
        this.budgetConstructionAccountReports = budgetConstructionAccountReports;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getPendingBudgetConstructionGeneralLedgerRevenueLines());
        managedLists.add(this.getPendingBudgetConstructionGeneralLedgerExpenditureLines());
        return managedLists;
    }

    public List<PendingBudgetConstructionGeneralLedger> getPendingBudgetConstructionGeneralLedgerRevenueLines() {
        return this.pendingBudgetConstructionGeneralLedgerRevenueLines;
    }

    public void setPendingBudgetConstructionGeneralLedgerRevenueLines(List pendingBudgetConstructionGeneralLedgerRevenueLines) {
        this.pendingBudgetConstructionGeneralLedgerRevenueLines = pendingBudgetConstructionGeneralLedgerRevenueLines;
    }

    public List<PendingBudgetConstructionGeneralLedger> getPendingBudgetConstructionGeneralLedgerExpenditureLines() {
        return this.pendingBudgetConstructionGeneralLedgerExpenditureLines;
    }

    public void setPendingBudgetConstructionGeneralLedgerExpenditureLines(List pendingBudgetConstructionGeneralLedgerExpenditureLines) {
        this.pendingBudgetConstructionGeneralLedgerExpenditureLines = pendingBudgetConstructionGeneralLedgerExpenditureLines;
    }

    public KualiInteger getExpenditureAccountLineAnnualBalanceAmountTotal() {
        return this.expenditureAccountLineAnnualBalanceAmountTotal;
    }

    public void setExpenditureAccountLineAnnualBalanceAmountTotal(KualiInteger expenditureAccountLineAnnualBalanceAmountTotal) {
        this.expenditureAccountLineAnnualBalanceAmountTotal = expenditureAccountLineAnnualBalanceAmountTotal;
    }

    public KualiInteger getExpenditureFinancialBeginningBalanceLineAmountTotal() {
        return this.expenditureFinancialBeginningBalanceLineAmountTotal;
    }

    public void setExpenditureFinancialBeginningBalanceLineAmountTotal(KualiInteger expenditureFinancialBeginningBalanceLineAmountTotal) {
        this.expenditureFinancialBeginningBalanceLineAmountTotal = expenditureFinancialBeginningBalanceLineAmountTotal;
    }

    public KualiInteger getRevenueAccountLineAnnualBalanceAmountTotal() {
        return this.revenueAccountLineAnnualBalanceAmountTotal;
    }

    public void setRevenueAccountLineAnnualBalanceAmountTotal(KualiInteger revenueAccountLineAnnualBalanceAmountTotal) {
        this.revenueAccountLineAnnualBalanceAmountTotal = revenueAccountLineAnnualBalanceAmountTotal;
    }

    public KualiInteger getRevenueFinancialBeginningBalanceLineAmountTotal() {
        return this.revenueFinancialBeginningBalanceLineAmountTotal;
    }

    public void setRevenueFinancialBeginningBalanceLineAmountTotal(KualiInteger revenueFinancialBeginningBalanceLineAmountTotal) {
        this.revenueFinancialBeginningBalanceLineAmountTotal = revenueFinancialBeginningBalanceLineAmountTotal;
    }

    public KualiDecimal getExpenditurePercentChangeTotal() {
        if (this.expenditureFinancialBeginningBalanceLineAmountTotal == null || this.expenditureFinancialBeginningBalanceLineAmountTotal.isZero()) {
            this.expenditurePercentChangeTotal = null;
        } else {
            BigDecimal diffRslt = this.expenditureAccountLineAnnualBalanceAmountTotal.bigDecimalValue().setScale(4).subtract(this.expenditureFinancialBeginningBalanceLineAmountTotal.bigDecimalValue().setScale(4));
            BigDecimal divRslt = diffRslt.divide(this.expenditureFinancialBeginningBalanceLineAmountTotal.bigDecimalValue().setScale(4), 4);
            this.expenditurePercentChangeTotal = new KualiDecimal(divRslt.multiply(BigDecimal.valueOf(100L)).setScale(2));
        }
        return this.expenditurePercentChangeTotal;
    }

    public void setExpenditurePercentChangeTotal(KualiDecimal expenditurePercentChangeTotal) {
        this.expenditurePercentChangeTotal = expenditurePercentChangeTotal;
    }

    public KualiDecimal getRevenuePercentChangeTotal() {
        if (this.revenueFinancialBeginningBalanceLineAmountTotal == null || this.revenueFinancialBeginningBalanceLineAmountTotal.isZero()) {
            this.revenuePercentChangeTotal = null;
        } else {
            BigDecimal diffRslt = this.revenueAccountLineAnnualBalanceAmountTotal.bigDecimalValue().setScale(4).subtract(this.revenueFinancialBeginningBalanceLineAmountTotal.bigDecimalValue().setScale(4));
            BigDecimal divRslt = diffRslt.divide(this.revenueFinancialBeginningBalanceLineAmountTotal.bigDecimalValue().setScale(4), 4);
            this.revenuePercentChangeTotal = new KualiDecimal(divRslt.multiply(BigDecimal.valueOf(100L)).setScale(2));
        }
        return this.revenuePercentChangeTotal;
    }

    public void setRevenuePercentChangeTotal(KualiDecimal revenuePercentChangeTotal) {
        this.revenuePercentChangeTotal = revenuePercentChangeTotal;
    }

    public boolean isBenefitsCalcNeeded() {
        return this.isBenefitsCalcNeeded;
    }

    public void setBenefitsCalcNeeded(boolean isBenefitsCalcNeeded) {
        this.isBenefitsCalcNeeded = isBenefitsCalcNeeded;
    }

    public boolean isMonthlyBenefitsCalcNeeded() {
        return this.isMonthlyBenefitsCalcNeeded;
    }

    public void setMonthlyBenefitsCalcNeeded(boolean isMonthlyBenefitsCalcNeeded) {
        this.isMonthlyBenefitsCalcNeeded = isMonthlyBenefitsCalcNeeded;
    }

    public boolean isSalarySettingOnly() {
        this.isSalarySettingOnly = this.getAccountSalarySettingOnlyCause() != BCConstants.AccountSalarySettingOnlyCause.MISSING_PARAM && this.getAccountSalarySettingOnlyCause() != BCConstants.AccountSalarySettingOnlyCause.NONE;
        return this.isSalarySettingOnly;
    }

    public void setSalarySettingOnly(boolean isSalarySettingOnly) {
        this.isSalarySettingOnly = isSalarySettingOnly;
    }

    public BCConstants.AccountSalarySettingOnlyCause getAccountSalarySettingOnlyCause() {
        if (this.accountSalarySettingOnlyCause == null) {
            this.accountSalarySettingOnlyCause = ((BudgetParameterService)SpringContext.getBean(BudgetParameterService.class)).isSalarySettingOnlyAccount(this);
        }
        return this.accountSalarySettingOnlyCause;
    }

    public void setAccountSalarySettingOnlyCause(BCConstants.AccountSalarySettingOnlyCause accountSalarySettingOnlyCause) {
        this.accountSalarySettingOnlyCause = accountSalarySettingOnlyCause;
    }

    public boolean isContainsTwoPlug() {
        return this.containsTwoPlug;
    }

    public void setContainsTwoPlug(boolean containsTwoPlug) {
        this.containsTwoPlug = containsTwoPlug;
    }

    public boolean isBudgetableDocument() {
        return this.budgetableDocument;
    }

    public void setBudgetableDocument(boolean budgetableDocument) {
        this.budgetableDocument = budgetableDocument;
    }

    public boolean isCleanupModeActionForceCheck() {
        return this.cleanupModeActionForceCheck;
    }

    public void setCleanupModeActionForceCheck(boolean cleanupModeActionForceCheck) {
        this.cleanupModeActionForceCheck = cleanupModeActionForceCheck;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        if (this.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("R");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("$");
        }
        LOG.info((Object)("Status is: " + this.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode()));
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        if (this.universityFiscalYear != null) {
            m.put("universityFiscalYear", this.universityFiscalYear.toString());
        }
        m.put("chartOfAccountsCode", this.chartOfAccountsCode);
        m.put("accountNumber", this.accountNumber);
        m.put("subAccountNumber", this.subAccountNumber);
        return m;
    }
}

