/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPayRateHolding;
import org.kuali.kfs.module.bc.document.dataaccess.PayrateExportDao;
import org.kuali.kfs.module.bc.document.service.PayrateExportService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class PayrateExportServiceImpl
implements PayrateExportService {
    protected BusinessObjectService businessObjectService;
    protected PayrateExportDao payrateExportDao;
    protected int exportCount;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public StringBuilder buildExportFile(Integer budgetYear, String positionUnionCode, String csfFreezeDate, String principalId) {
        this.exportCount = 0;
        HashMap<String, String> payRateHoldingPersonUniversalIdentifierKey = new HashMap<String, String>();
        payRateHoldingPersonUniversalIdentifierKey.put("principalId", principalId);
        this.businessObjectService.deleteMatching(BudgetConstructionPayRateHolding.class, payRateHoldingPersonUniversalIdentifierKey);
        StringBuilder results = new StringBuilder();
        this.payrateExportDao.buildPayRateHoldingRows(budgetYear, positionUnionCode, principalId);
        List holdingRecords = (List)this.businessObjectService.findMatching(BudgetConstructionPayRateHolding.class, payRateHoldingPersonUniversalIdentifierKey);
        for (BudgetConstructionPayRateHolding record : holdingRecords) {
            results.append((CharSequence)this.buildExportLine(record, csfFreezeDate));
            ++this.exportCount;
        }
        results.append("\r\n");
        results.append("\r\n");
        results.append("Export complete. Export Count: " + this.exportCount + "\r\n");
        return results;
    }

    @Override
    @Transactional
    public boolean isValidPositionUnionCode(String positionUnionCode) {
        return this.payrateExportDao.isValidPositionUnionCode(positionUnionCode);
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setPayrateExportDao(PayrateExportDao payrateExportDao) {
        this.payrateExportDao = payrateExportDao;
    }

    @NonTransactional
    protected StringBuilder buildExportLine(BudgetConstructionPayRateHolding holdingRecord, String csfFreezeDate) {
        StringBuilder line = new StringBuilder();
        String emplid = this.padString(holdingRecord.getEmplid(), 11, true);
        String positionNumber = this.padString(holdingRecord.getPositionNumber(), 8, true);
        String name = this.padString(holdingRecord.getName(), 50, true);
        String setIdSalary = this.padString(holdingRecord.getSetidSalary(), 5, true);
        String salAdminPlan = this.padString(holdingRecord.getSalaryAdministrationPlan(), 4, true);
        String grade = this.padString(holdingRecord.getGrade(), 3, true);
        String unionCode = this.padString(holdingRecord.getUnionCode(), 3, true);
        String payRate = this.padString(String.valueOf(holdingRecord.getAppointmentRequestedPayRate().multiply(new BigDecimal(100)).intValue()), 10, false);
        csfFreezeDate = this.padString(csfFreezeDate, 8, true);
        line.append(emplid);
        line.append(positionNumber);
        line.append(name);
        line.append(setIdSalary);
        line.append(salAdminPlan);
        line.append(grade);
        line.append(unionCode);
        line.append(payRate);
        line.append(csfFreezeDate);
        line.append("\r\n");
        return line;
    }

    @NonTransactional
    protected String padString(String stringToPad, int fieldSize, boolean leftJustifiy) {
        if (stringToPad.length() < fieldSize) {
            if (leftJustifiy) {
                return StringUtils.rightPad((String)stringToPad, (int)fieldSize);
            }
            return StringUtils.leftPad((String)stringToPad, (int)fieldSize);
        }
        if (stringToPad.length() > fieldSize) {
            return stringToPad.substring(0, fieldSize - 1);
        }
        return stringToPad;
    }
}

